

/*********************************************************************
*
* Name        : glob.h
*
* Version     : 1.1
*
* Description : This is an include file for jigsaw program, to be included
*               in all the programs: generate, jigsaw, jumble and solve.
*
* Written  by : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
* Rev History : 
*                 
************************************************************************/

/* Currently set for ONE K TILE size. Remove this comment for 4K
#define FOUR_K_TILE  */

typedef struct  set
{
  int  n1;
  int  n2;
} SET;

typedef SET  *SET_PTR;

/* Note: add fillers in the structure TILE to increase the memory
   occupied by each tile. Distribution comes with 1024 bytes/tile */

typedef struct filler100  /* 100 bytes filler */
{
  double dummy0, dummy1, dummy2, dummy3, dummy4,
  dummy5,dummy6, dummy7, dummy8, dummy9, dummy10,
  dummy11;
  long dummy13;
} FILLER100;

typedef struct filler80 /* 80 bytes filler */
{
  double dummy0, dummy1, dummy2, dummy3, dummy4,
  dummy5,dummy6, dummy7, dummy8, dummy9;

} FILLER80;

typedef struct filler24 /* 24 bytes filler */
{
  double dummy0, dummy1, dummy2;
} FILLER24;



typedef struct filler900 /* 900 bytes filler */
{
  struct filler100 f0, f1, f2, f3, f4, f5, f6, f7, f8;
} FILLER900;

typedef struct thousand_bytes /* 1000 bytes filler */
{
  struct filler900 one_of_900_bytes;
  struct filler100 one_of_100_bytes;
} Thousand_Bytes;

typedef struct page /* one page filler */
{
  struct thousand_bytes one_of_1k;
  struct filler24 one_of_24bytes;
} PAGE;

/* Note: Add fillers in the structure below to increase tile size */

typedef struct tile 
{
  long north, south, west, east;
  long identity, match_north, match_south, match_west, match_east;
  int count;
 struct filler900 one; 
 struct filler80 one_80; 
#ifdef FOUR_K_TILE
  struct page page_1, page_2, page_3; 
#endif
  struct tile *next;

} TILE;

typedef TILE  *TILE_PTR;





