#ifndef	_exec_user_
#define	_exec_user_

/* Module exec */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>

/* Routine exec_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t exec_exec
#if	defined(LINTLIBRARY)
    (execserver, file, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtableCnt, portarray, portarrayCnt, intarray, intarrayCnt)
	mach_port_t execserver;
	mach_port_t file;
	mach_port_t oldtask;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t dtable;
	mach_msg_type_number_t dtableCnt;
	portarray_t portarray;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
{ return exec_exec(execserver, file, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtableCnt, portarray, portarrayCnt, intarray, intarrayCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t execserver,
	mach_port_t file,
	mach_port_t oldtask,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t dtable,
	mach_msg_type_number_t dtableCnt,
	portarray_t portarray,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt
);
#else
    ();
#endif
#endif

/* Routine exec_startup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t exec_startup
#if	defined(LINTLIBRARY)
    (execserver, flags, argv, argvCnt, envp, envpCnt, dtable, dtableCnt, portarray, portarrayCnt, intarray, intarrayCnt)
	mach_port_t execserver;
	int *flags;
	data_t *argv;
	mach_msg_type_number_t *argvCnt;
	data_t *envp;
	mach_msg_type_number_t *envpCnt;
	portarray_t *dtable;
	mach_msg_type_number_t *dtableCnt;
	portarray_t *portarray;
	mach_msg_type_number_t *portarrayCnt;
	intarray_t *intarray;
	mach_msg_type_number_t *intarrayCnt;
{ return exec_startup(execserver, flags, argv, argvCnt, envp, envpCnt, dtable, dtableCnt, portarray, portarrayCnt, intarray, intarrayCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t execserver,
	int *flags,
	data_t *argv,
	mach_msg_type_number_t *argvCnt,
	data_t *envp,
	mach_msg_type_number_t *envpCnt,
	portarray_t *dtable,
	mach_msg_type_number_t *dtableCnt,
	portarray_t *portarray,
	mach_msg_type_number_t *portarrayCnt,
	intarray_t *intarray,
	mach_msg_type_number_t *intarrayCnt
);
#else
    ();
#endif
#endif

/* Routine exec_boot_init */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t exec_boot_init
#if	defined(LINTLIBRARY)
    (execserver, init)
	mach_port_t execserver;
	startup_t init;
{ return exec_boot_init(execserver, init); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t execserver,
	startup_t init
);
#else
    ();
#endif
#endif

#endif	_exec_user_
