/* Generic stuff
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

/* Fake error numbers for special actions */

#define NORMRETURN	0	/* return normal return values */
#define JUSTRETURN	-1	/* just jump back to caller */
#define RESTART		-2	/* restart system call */
#define SIGSUSPEND	-3	/* sigsuspend mask weirdness */

struct sigstate
{
  thread_t thread;
  struct sigstate *next;
  struct mutex lock;
  int nextsig;			/* pending signal to be immediately taken */
  int mask;			/* signal mask */
  int pending;			/* signals pending */
  struct sigaction actions[NSIG]; /* signal actions */
  struct sigstack sigstack;	/* signal stack and stack state */
  struct condition arrived;
  int omask, useomask;
};

/* Signal thread */
thread_t alix_sigthread;
mach_port_t sigthread_port;

int beingtraced;

/* Miscellaneous limits on some syscall args */

/* Miscellaneous functions */
#define alloca __builtin_alloca

int h2ae (error_t);
int copyinstr (char *, char *);
int copyout (void *, void *, int);
int copyin (void *, void *, int);
void post_sigsys (void);
void check_sigs (int *);
int rpc_check_sigs (void);
void internal_sig_post (thread_t, int);
struct sigstate *thread_to_sigstate (thread_t);
void abort_rpcs (int);
