static char *RCSid = "$Header: signals.c,v 1.7 90/03/20 11:27:16 mr-frog Exp $";

/*
 * signals.c
 *
 * Deals with fatal signals
 *
 * Dave Pare, 1986
 */

#include "proto.h"
#include "misc.h"

#include <stdio.h>
#include <signal.h>

/*
 * gencore lets the player know empire puked, then drops a core
 * in the empire home directory.
 *
 * I won't natter about how this should never happen...
 */
gencore(sig)
	int	sig;
{
	(void) signal(SIGILL, SIG_DFL);
	(void) signal(SIGIOT, SIG_DFL);
	pr("\n");
	outid(C_EXIT);
	pr(fmt("Empire died on signal %d!\n", sig));
	(void) fflush(stdout);
	_cleanup();
	abort();
}

sigsetup()
{
	(void) signal(SIGPIPE, SIG_IGN);
	(void) signal(SIGFPE, gencore);
	(void) signal(SIGILL, gencore);
#ifndef linux
	(void) signal(SIGBUS, gencore);
#endif
	(void) signal(SIGSEGV, gencore);
	(void) signal(SIGQUIT, gencore);
}
