/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;

public class ClassElementValue
extends ElementValue {
    public static final String ENTRY_NAME = "ClassElement";
    private static final int LENGTH = 2;
    private int classInfoIndex;

    protected ClassElementValue() {
        super(99);
    }

    public int getClassInfoIndex() {
        return this.classInfoIndex;
    }

    public void setClassInfoIndex(int n) {
        this.classInfoIndex = n;
    }

    protected int getSpecificLength() {
        return 2;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.classInfoIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.classInfoIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "ClassElementValue with class_info_index " + this.classInfoIndex);
    }

    public String getEntryName() {
        return ENTRY_NAME;
    }
}

