# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, Mapping, Optional, TYPE_CHECKING, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AzureOpenAIDeployment(_model_base.Model):
    """Azure OpenAI Deployment Information.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The deployment name.
    :vartype name: str
    :ivar model_name: The name of the model to deploy.
    :vartype model_name: str
    :ivar model_version: The model version to deploy.
    :vartype model_version: str
    :ivar connection_name: The name of the connection to deploy to.
    :vartype connection_name: str
    :ivar target_url: The target URL of the AOAI resource for the deployment.
    :vartype target_url: str
    :ivar id: The ARM resource id of the deployment.
    :vartype id: str
    :ivar properties: Properties of the deployment.
    :vartype properties: dict[str, str]
    :ivar tags: Tags of the deployment.
    :vartype tags: dict[str, str]
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The deployment name."""
    model_name: Optional[str] = rest_field(visibility=["read"])
    """The name of the model to deploy."""
    model_version: Optional[str] = rest_field(visibility=["read"])
    """The model version to deploy."""
    connection_name: Optional[str] = rest_field(visibility=["read"])
    """The name of the connection to deploy to."""
    target_url: Optional[str] = rest_field(visibility=["read"])
    """The target URL of the AOAI resource for the deployment."""
    id: Optional[str] = rest_field(visibility=["read"])
    """The ARM resource id of the deployment."""


class MarketplacePlan(_model_base.Model):
    """Marketplace Subscription Definition.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher_id: The id of the publisher.
    :vartype publisher_id: str
    :ivar offer_id: The id of the offering associated with the plan.
    :vartype offer_id: str
    :ivar plan_id: The id of the plan.
    :vartype plan_id: str
    :ivar term_id: The term id.
    :vartype term_id: str
    """

    publisher_id: Optional[str] = rest_field(visibility=["read"])
    """The id of the publisher."""
    offer_id: Optional[str] = rest_field(visibility=["read"])
    """The id of the offering associated with the plan."""
    plan_id: Optional[str] = rest_field(visibility=["read"])
    """The id of the plan."""
    term_id: Optional[str] = rest_field(visibility=["read"])
    """The term id."""


class MarketplaceSubscription(_model_base.Model):
    """Marketplace Subscription Definition.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The marketplace subscription name. Required.
    :vartype name: str
    :ivar model_id: Model id for which to create marketplace subscription. Required.
    :vartype model_id: str
    :ivar marketplace_plan: The plan associated with the marketplace subscription.
    :vartype marketplace_plan: ~azure.ai.ml.entities.models.MarketplacePlan
    :ivar status: Status of the marketplace subscription. Possible values are:
     "pending_fulfillment_start", "subscribed", "unsubscribed", "suspended".
    :vartype status: str
    :ivar provisioning_state: Provisioning state of the marketplace subscription. Possible values
     are: "creating", "deleting", "succeeded", "failed", "updating", and "canceled".
    :vartype provisioning_state: str
    :ivar id: ARM resource id of the marketplace subscription.
    :vartype id: str
    """

    name: str = rest_field()
    """The marketplace subscription name. Required."""
    model_id: str = rest_field()
    """Model id for which to create marketplace subscription. Required."""
    marketplace_plan: Optional["_models.MarketplacePlan"] = rest_field(visibility=["read"])
    """The plan associated with the marketplace subscription."""
    status: Optional[str] = rest_field(visibility=["read"])
    """Status of the marketplace subscription. Possible values are: \"pending_fulfillment_start\",
     \"subscribed\", \"unsubscribed\", \"suspended\"."""
    provisioning_state: Optional[str] = rest_field(visibility=["read"])
    """Provisioning state of the marketplace subscription. Possible values are: \"creating\",
     \"deleting\", \"succeeded\", \"failed\", \"updating\", and \"canceled\"."""
    id: Optional[str] = rest_field(visibility=["read"])
    """ARM resource id of the marketplace subscription."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        model_id: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ServerlessEndpoint(_model_base.Model):
    """Serverless Endpoint Definition.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The deployment name. Required.
    :vartype name: str
    :ivar auth_mode: Authentication mode of the endpoint.
    :vartype auth_mode: str
    :ivar model_id: The id of the model to deploy. Required.
    :vartype model_id: str
    :ivar location: Location in which to create endpoint.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the endpoint. Possible values are: "creating",
     "deleting", "succeeded", "failed", "updating", and "canceled".
    :vartype provisioning_state: str
    :ivar tags: Tags for the endpoint.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the endpoint.
    :vartype properties: dict[str, str]
    :ivar description: Descripton of the endpoint.
    :vartype description: str
    :ivar scoring_uri: Scoring uri of the endpoint.
    :vartype scoring_uri: str
    :ivar id: ARM resource id of the endpoint.
    :vartype id: str
    :ivar headers: Headers required to hit the endpoint.
    :vartype id: dict[str, str]
    """

    name: str = rest_field()
    """The deployment name. Required."""
    auth_mode: Optional[str] = rest_field()
    """Authentication mode of the endpoint. Possible values are: \"key\", \"aad\".
    Defaults to \"key\" if not given."""
    model_id: str = rest_field()
    """The id of the model to deploy. Required."""
    location: Optional[str] = rest_field(visibility=["read"])
    """Location in which to create endpoint."""
    provisioning_state: Optional[str] = rest_field(visibility=["read"])
    """Provisioning state of the endpoint. Possible values are: \"creating\", \"deleting\",
     \"succeeded\", \"failed\", \"updating\", and \"canceled\"."""
    tags: Optional[Dict[str, str]] = rest_field()
    """Tags for the endpoint."""
    properties: Optional[Dict[str, str]] = rest_field()
    """Properties of the endpoint."""
    description: Optional[str] = rest_field()
    """Descripton of the endpoint."""
    scoring_uri: Optional[str] = rest_field(visibility=["read"])
    """Scoring uri of the endpoint."""
    id: Optional[str] = rest_field(visibility=["read"])
    """ARM resource id of the endpoint."""
    headers: Optional[Dict[str, str]] = rest_field(visibility=["read"])
    """Headers required to hit the endpoint."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        model_id: str,
        auth_mode: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
