/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DNSName;

public class DNSNameParser
implements NameParser {
    public Name parse(String name) throws InvalidNameException {
        boolean lastTokenWasDilim = false;
        DNSName dnsName = new DNSName();
        if (name == null) {
            throw new InvalidNameException(Messages.getString("jndi.2E"));
        }
        if (name.length() > 255) {
            throw new InvalidNameException(Messages.getString("jndi.54"));
        }
        StringTokenizer st = new StringTokenizer(name, ".", true);
        while (st.hasMoreTokens()) {
            String comp = st.nextToken();
            if (comp.equals(".")) {
                if (lastTokenWasDilim) {
                    throw new InvalidNameException(Messages.getString("jndi.55"));
                }
                lastTokenWasDilim = true;
                if (dnsName.size() != 0 || !st.hasMoreTokens()) continue;
                throw new InvalidNameException(Messages.getString("jndi.56"));
            }
            if (comp.length() > 63) {
                throw new InvalidNameException(Messages.getString("jndi.57", comp));
            }
            dnsName.add(0, comp);
            lastTokenWasDilim = false;
        }
        if (lastTokenWasDilim) {
            dnsName.add(0, "");
        }
        return dnsName;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof DNSNameParser;
    }
}

