# Changelog


## v9.2.2

### Fixed

- fix #1231: don't warn about `tool.setuptools.dynamic.version` when only using file finder.
  The warning about combining version guessing with setuptools dynamic versions should only
  be issued when setuptools-scm is performing version inference, not when it's only being
  used for its file finder functionality.


## v9.2.1

### Fixed

- fix #1216: accept and create a warning for usages of `version = attr:` in setuptools config.
  unfortunately dozens of projects cargo-culted that antipattern


## v9.2.0

### Added

- add simplified activation via `setuptools-scm[simple]` extra

  A new streamlined way to enable version inference without requiring a `[tool.setuptools_scm]` section.
  When `setuptools-scm[simple]` is in `build-system.requires` and `version` is in `project.dynamic`,
  version inference is automatically enabled with default settings.


### Removed

- unchecked simplified activation - too many projects use setups where it would fail

### Changed

- refine activation logic and add unittest for the relevant cases instead of trying to speedrun setuptools

## v9.1.1 (yanked)

### Fixed

- fix #1194: correctly handle version keyword when pyproject metadata is missing


## v9.1.0 (yanked)

### Fixed

- complete reiteration of the decision logic for enabling version inference on setuptools_scm

  - shared logic for the important parts
  - proper deferring based in precedence of finalize options vs version keyword
  - unittestable for the parsing parts and the decision steps



## v9.0.3 (yanked)

### Fixed

- fix #1184: verify version is dynamic if the dependency is used as indicator for enabling

## v9.0.2 (yanked)

### Fixed

- fix #1184: in case setuptools-scm is a indirect dependency and no pyproject.toml section exists - don't infer the version


## v9.0.1 (yanked)

### Fixed

- fix #1180: ensure version dumping works when no scm_version is given (problems in downstreams)
- fix #1181: config - reintroduce control over when we expect a section to be present
             as it turns out there's valid use cases where setuptools_scm is not direct part of the dependencies
- add codespell pre-commit hook

## v9.0.0 (yanked)

### Breaking

- fix #1019: pass python version build tags from scm version to results properly

### Added

- add `setuptools-scm` console_scripts entry point to make the CLI directly executable
- make Mercurial command configurable by environment variable `SETUPTOOLS_SCM_HG_COMMAND`
- fix #1099 use file modification times for dirty working directory timestamps instead of current time
- fix #1059: add `SETUPTOOLS_SCM_PRETEND_METADATA` environment variable to override individual ScmVersion fields
- add `scm` parameter support to `get_version()` function for nested SCM configuration
- fix #987: expand documentation on git archival files and add cli tools for good defaults
- fix #311: document github/gitlab ci pipelines that enable auto-upload to test-pypi/pypi
- fix #1022: allow `version_keyword` to override `infer_version` when configuration differs
- fix #554: document `fallback_root` parameter in programmatic usage and configuration


### Changed

- add `pip` to test optional dependencies for improved uv venv compatibility
- migrate to selectable entrypoints for better extensibility
- improve typing for entry_points
- refactor file modification time logic into shared helper function for better maintainability
- reduce complexity of HgWorkdir.get_meta method by extracting focused helper methods
- fix #1150: enable setuptools-scm when we are a build requirement
- feature #1154: add the commit id the the default version file template
- drop scriv
- fix #921: document setuptools version requirements more consistently - 61 as minimum asn 8 as recommended minimum

### Fixed

- fix #1145: ensure GitWorkdir.get_head_date returns consistent UTC dates regardless of local timezone
- fix #687: ensure calendar versioning tests use consistent time context to prevent failures around midnight in non-UTC timezones
- reintroduce Python 3.9 entrypoints shim for compatibility
- fix #1136: update customizing.md to fix missing import
- fix #1001: document the missing version schemes and add examples in the docs
- fix #1115: explicitly document file finder behaviour
- fix #879: add test that validates case different behavior on windows
- migrate git describe command to new scm config
- add support for failing on missing submodules
- fix #279: expand errors when scm can be found upwards and relative_to wasn't used
- fix #577: introduce explicit scmversion node and short node
- fix #1100: add workaround for readthedocs worktress to the docs
- fix #790: document shallow fail for rtd
- fix #474: expand version not found error message to provide clearer guidance about SETUPTOOLS_SCM_PRETEND_VERSION_FOR_* environment variables
- fix #324: document/recommend the v tag prefix
- fix #501: add py.typed
- fix #804: git - use fallback version instead of 0.0 when no version is found at all
- fix #1139: use logging.lastResort instead of a own replica to avoid polluting logging._handlerList
- fix #873: don't infer version in cli if --no-version is given
- fix #535: accept tags from a release action in the gh ui
- fix #1073: explain namespaces for release-branch-semver
- fix #1052: use consistent node hash length across all SCM backends
- fix #1045: reindent the `__all__` in the version template for better readability
- fix #968: harden environment override finding with better normalization and typo suggestions
- fix #846: add support for failing on missing submodules

## v8.3.1

### Fixed

- fixed #1131: allow self-build without importlib_metadata available on python3.9

## v8.3.0

### Fixed

- fix #1013: use modern importlib_metadata in all cases to dedup distribution objects that must shadow based on pythonpath priority
  starting with python 3.10 this is part of python itself

## v8.2.1 (yanked due to legacy python issues)

### Fixed

- fix #1119: also include pre/post release details in version_tuple
- fix #1112: unpin setuptools for own dependencies due to ubuntu lts bugs
- add python 3.13 to the support matrix

## v8.2.0

### Added

- fix #960: add a ``--force-write-version-files`` flag for the cli

### Changed

- fix #950: ensure to pass encodings to io usage
- fix #957: add subprocess timeout control env var
- add sp-repo-review pre-commit hook

### Fixed

- fix #1018: allow non-normalized versions for semver
- fix #1103: respect GIT_CEILING_DIRECTORIES when trying to find git toplevels
- fix #1081: add name normalized pipx entrypoint
- fix #1080: clean pdm from PYTHONPATH to protect mercurial

## v8.1.0

### Changed

- inclusion of `__all__` in autogenerated `version.py` files to aid IDE autoimports

## v8.0.4

### Changed

- introduce scriv for changelog management
- reconfigure local build backend to use an attribute instead of star imports from setuptools
- introduce ruff as a linter
- ensure the setuptools version keyword correctly load pyproject.toml configuration
- add build and wheel to the test requirements for regression testing
- move internal toml handling to own module

### Fixed

- fix #925: allow `write_to` to be an absolute path when it's a subdirectory of the root
- fix #932: ensure type annotations in version file don't cause linter issues
- fix #930: temporary restore `DEFAULT_VERSION_SCHEME` and `DEFAULT_LOCAL_SCHEME` on the `setuptools-scm` package


## v8.0.3

### Fixed

- fix #918 for good - remove external importlib-metadata to avoid source only loop
- fix #926: ensure mypy on python3.8 works with the version file

## v8.0.2

### Fixed

- fix #919: restore legacy version-file behaviour for external callers + add Deprecation warning
- fix #918: use packaging from setuptools for self-build
- fix #914: ignore the deprecated git archival plugin as its integrated now
- fix #912: ensure mypy safety of the version template + regression test
- fix #913: use 240s timeout instead of 20 for `git unshallow`
  to account for large repos or slow connections


## v8.0.1

### Fixed

- update version file template to work on older python versions by using type comments
- ensure tag regex from setup.py is parsed into regex

## v8.0.0

### breaking

- remove legacy version parser api - config arg always required
- turn Configuration into a dataclass
- require configuration to always pass into helpers
- hide file-finders implementation in private module
- renamed setuptools_scm.hacks to setuptools_scm.fallbacks and drop support for pip-egg-info
- remove trace function and use logging instead
- unify `distance=None` and `distance=0` they should mean the same andwhere hiding dirty states that are now explicitly dirty
- depend on later importlib for the full selectable api
- move setuptools integration code to private sub-package
- use normalized dist names for the `SETUPTOOLS_SCM_PRETEND_VERSION_FOR_${DIST_NAME}` env var
- drop support for python 3.7
- introduce `version_file` as replacement for `write_to`
- renamed the project from `setuptools_scm` to `setuptools-scm`

### Added

- created a directory for the vcs-versioning package and added it to pypi
- git: expect main as possible default branch
- drop version_from_scm helper
- trim down exposed public api
- no longer self-call twice in setuptools
- add support for version schemes by import
- chores

    - migrate own metadata to pyproject.toml
    - consolidate version schemes
    - stricter tag typing
    - pre-compiled regex
    - move helpers to private modules

- support passing log levels to SETUPTOOLS_SCM_DEBUG
- support using rich.logging as console log handler if installed
- fix #527: type annotation in default version template
- fix #549: use fallbacks when scm search raises CommandNotFoundError

### Fixed

- fix #883: use HeadersParser to ensure only mime metadata in headers is used
- fix #884: parse calver dates from versions with the v prefix
- don't use a C locale without UTF-8 support, when running commands.

## v7.1.0

- \#748: use `tomllib` from stdlib
- fix #762: handle non-ascii in setup.cfg
- \#752: implement fallback file finders for archives
- \#765: removed coding header in python template
- declared Python 3.11 support
- fix #759: update .git_archival.txt templates match git-describe invocation
- fix #772: fix handling of .git-archival.txt from tagged commit

## v7.0.5

- fixes #742, #745: correctly handle accidentally released archival files

## v7.0.4

- fix #727: correctly handle incomplete archival from setuptools_scm_git_archival
- fix #691: correctly handle specifying root in pyproject.toml
- correct root override check condition (to ensure absolute path matching)
- allow root by the cli to be considered relative to the cli (using abspath)

## v7.0.3

- fix mercurial usage when pip primes a isolated environment
- fix regression for branch names on git + add a test

## v7.0.2

- fix #723 and #722: remove bootstrap dependencies
- ensure we read the distribution name from `setup.cfg` if needed even for `pyproject.toml`

## v7.0.1

- fix #718: Avoid `ModuleNotFoundError` by requiring `importlib_metadata` in `python<3.8`

## v7.0.0

- drop python 3.6 support
- include git archival support
- fix #707: support git version detection even when git protects against mismatched owners
  (common with misconfigured containers, thanks @chrisburr )
- fix #548: correctly handle parsing the commit timestamp of HEAD when `log.showSignature` is set

## v6.4.2

- fix #671: `NoReturn` is not available in painfully dead python 3.6

## v6.4.1

-   fix regression #669: restore get_version signature
-   fix #668: harden the self-test for distribution extras

## 6.4.0

- compatibility adjustments for setuptools \>58
- only put minimal setuptools version into toml extra to warn people with old strict pins
- correctly handle hg-git self-use
- better mercurial detection
- modernize packaging setup
- python 3.10 support
- better handling of setuptools install command deprecation
- consider `pyproject.tomls` when running as command
- use list in git describe command to avoid shell expansions while supporting both windows and posix
- add `--strip-dev` flag to `python -m setuptools_scm` to print the next guessed version cleanly
- ensure no-guess-dev will fail on bad tags instead of generating invalid versions
- ensure we use utc everywhere to avoid confusion

## v6.3.2

- fix #629: correctly convert Version data in tags_to_version parser to avoid errors

## v6.3.1

- fix #625: restore tomli in install_requires after the regression changes in took it out
  and some users never added it even tho they have pyproject.toml files

## v6.3.0

### warning

This release explicitly warns on unsupported setuptools. This
unfortunately has to happen as the legacy `setup_requires` mechanism
incorrectly configures the setuptools working-set when a more recent
setuptools version than available is required.

As all releases of setuptools are affected as the historic mechanism for
ensuring a working setuptools setup was shipping a `ez_setup` file next
to `setup.py`, which would install the required version of setuptools.

This mechanism has long since been deprecated and removed as most people
haven\'t been using it

### Fixed

- fix #612: depend on packaging to ensure version parsing parts
- fix #611: correct the typo that hid away the toml extra and add it in `setup.py` as well
- fix #615: restore support for the git_archive plugin which doesn't pass over the config
- restore the ability to run on old setuptools while to avoid breaking pipelines

## v6.2.0

-   fix #608: resolve tomli dependency issue by making it a hard
    dependency as all intended/supported install options use pip/wheel
    this is only a feature release
-   ensure python 3.10 works

## v6.1.1

-   fix #605: completely disallow bdist_egg - modern enough
    setuptools\>=45 uses pip
-   fix #606: re-integrate and harden toml parsing
-   fix #597: harden and expand support for figuring the current
    distribution name from [pyproject.toml]{.title-ref}
    ([project.name]{.title-ref} or
    [tool.setuptools_scm.dist_name]{.title-ref}) section or
    [setup.cfg]{.title-ref} ([metadata.name]{.title-ref})

## v6.1.0

-   fix #587: don\'t fail file finders when distribution is not given
-   fix #524: new parameters `normalize` and `version_cls` to customize
    the version normalization class.
-   fix #585: switch from toml to tomli for toml 1.0 support
-   fix #591: allow to opt in for searching parent directories in the
    api
-   fix #589: handle yaml encoding using the expected defaults
-   fix #575: recommend storing the version_module inside of
    `mypkg/_version.py`
-   fix #571: accept branches starting with `v` as release branches
-   fix #557: Use `packaging.version` for `version_tuple`
-   fix #544: enhance errors on unsupported python/setuptools versions

## v6.0.1

-   fix #537: drop node_date on old git to avoid errors on missing %cI

## v6.0.0

-   fix #517: drop dead python support \>3.6 required
-   drop dead setuptools support \> 45 required (can install wheels)
-   drop egg building (use wheels)
-   add git node_date metadata to get the commit time-stamp of HEAD
-   allow version schemes to be priority ordered lists of version
    schemes
-   support for calendar versioning (calver) by date

## v5.0.2

-   fix #415: use git for matching prefixes to support the windows
    situation

## v5.0.1

- fix #509: support `SETUPTOOLS_SCM_PRETEND_VERSION_FOR_${DISTRIBUTION_NAME}` for `pyproject.toml`

## v5.0.0

### Breaking changes

-   fix #339: strict errors on missing scm when parsing a scm dir to
    avoid false version lookups
-   fix #337: if relative_to is a directory instead of a file, consider
    it as direct target instead of the containing folder and print a
    warning

### Fixed

-   fix #352: add support for generally ignoring specific vcs roots
-   fix #471: better error for version bump failing on complex but
    accepted tag
-   fix #479: raise indicative error when tags carry non-parsable
    information
-   Add `no-guess-dev` which does no next version guessing,
    just adds `.post1.devN` in case there are new commits after the tag
-   add python3.9
-   enhance documentation
-   consider SOURCE_DATE_EPOCH for versioning
-   add a version_tuple to write_to templates
-   fix #321: add support for the
    `SETUPTOOLS_SCM_PRETEND_VERSION_FOR_${DISTRIBUTION_NAME}` env var to
    target the pretend key
-   fix #142: clearly list supported scm
-   fix #213: better error message for non-zero dev numbers in tags
-   fix #356: add git branch to version on describe failure

## v4.1.2

-   disallow git tags without dots by default again - #449

## v4.1.1

-   drop jaraco.windows from pyproject.toml, allows for wheel builds on
    python2

## v4.1.0

-   include python 3.9 via the deadsnakes action
-   return release_branch_semver scheme (it got dropped in a bad rebase)
-   undo the devendoring of the samefile backport for python2.7 on
    windows
-   re-enable the building of universal wheels
-   fix handling of missing git/hg on python2.7 (python 3 exceptions
    where used)
-   correct the tox flake8 invocation
-   trigger builds on tags again

## v4.0.0

-   Add `parentdir_prefix_version` to support installs from GitHub
    release tarballs.
-   use Coordinated Universal Time (UTC)
-   switch to github actions for ci
-   fix documentation for `tag_regex` and add support for single digit
    versions
-   document handling of enterprise distros with unsupported setuptools
    versions #312
-   switch to declarative metadata
-   drop the internal copy of samefile and use a dependency on
    jaraco.windows on legacy systems
-   select git tags based on the presence of numbers instead of dots
-   enable getting a version form a parent folder prefix
-   add release-branch-semver version scheme
-   make global configuration available to version metadata
-   drop official support for python 3.4

## v3.5.0

-   add `no-local-version` local scheme and improve documentation for
    schemes

## v3.4.4

-   fix #403: also sort out resource warnings when dealing with git file
    finding

## v3.4.3

-   fix #399: ensure the git file finder terminates subprocess after
    reading archive

## v3.4.2

-   fix #395: correctly transfer tag regex in the Configuration
    constructor
-   rollback \--first-parent for git describe as it turns out to be a
    regression for some users

## v3.4.1

-   pull in #377 to fix #374: correctly set up the default version
    scheme for pyproject usage. this bugfix got missed when rushing the
    release.

## v3.4.0

-   fix #181 - add support for projects built under setuptools
    declarative config by way of the
    setuptools.finalize_distribution_options hook in Setuptools 42.
-   fix #305 - ensure the git file finder closes file descriptors even
    when errors happen
-   fix #381 - clean out env vars from the git hook system to ensure
    correct function from within
-   modernize docs wrt importlib.metadata

*edited*

-   use \--first-parent for git describe

## v3.3.3

-   add eggs for python3.7 and 3.8 to the deploy

## v3.3.2

-   fix #335 - fix python3.8 support and add builds for up to python3.8

## v3.3.1

-   fix #333 (regression from #198) - use a specific fallback root when
    calling fallbacks. Remove old hack that resets the root when
    fallback entrypoints are present.

## v3.3.0

-   fix #198 by adding the `fallback_version` option, which sets the
    version to be used when everything else fails.

## v3.2.0

\* fix #303 and #283 by adding the option `git_describe_command` to
allow the user to control the way that [git describe]{.title-ref} is
called.

## v3.1.0

-   fix #297 - correct the invocation in version_from_scm and deprecate
    it as its exposed by accident
-   fix #298 - handle git file listing on empty repositories
-   fix #268 - deprecate ScmVersion.extra

## v3.0.6

-   fix #295 - correctly handle self install from tarballs

## v3.0.5

-   fix #292 - match leading `V` character as well

    <https://www.python.org/dev/peps/pep-0440/#preceding-v-character>

## v3.0.4

-   re-release of 3.0.3 after fixing the release process

v3.0.3 (pulled from pypi due to a packaging issue) ======

-   fix #286 - duo an oversight a helper function was returning a
    generator instead of a list

## v3.0.2

-   fix a regression from tag parsing - support for multi-dashed
    prefixes - #284

## v3.0.1

-   fix a regression in setuptools_scm.git.parse - reorder arguments so
    the positional invocation from before works as expected #281

## v3.0.0

-   introduce pre-commit and use black
-   print the origin module to help testing
-   switch to src layout (breaking change)
-   no longer alias tag and parsed_version in order to support
    understanding a version parse failure
-   require parse results to be ScmVersion or None (breaking change)
-   fix #266 by requiring the prefix word to be a word again (breaking
    change as the bug allowed arbitrary prefixes while the original
    feature only allowed words\")
-   introduce an internal config object to allow the configuration for
    tag parsing and prefixes (thanks to \@punkadiddle for introducing it
    and passing it through)

## v2.1.0

-   enhance docs for sphinx usage
-   add symlink support to file finder for git #247 (thanks Stéphane
    Bidoul)
-   enhance tests handling win32 (thanks Stéphane Bidoul)

## v2.0.0

-   fix #237 - correct imports in code examples
-   improve mercurial commit detection (thanks Aaron)
-   breaking change: remove support for setuptools before parsed
    versions
-   reintroduce manifest as the travis deploy can\'t use the file finder
-   reconfigure flake8 for future compatibility with black
-   introduce support for branch name in version metadata and support a
    opt-in simplified semver version scheme

## v1.17.0

-   fix regression in git support - use a function to ensure it works in
    egg installed mode

-   actually fail if file finding fails in order to see broken setups
    instead of generating broken dists

    (thanks Mehdi ABAAKOUK for both)

## v1.16.2

-   fix regression in handling git export ignores (thanks Mehdi
    ABAAKOUK)

## v1.16.1

-   fix regression in support for old setuptools versions (thanks Marco
    Clemencic)

## v1.16.0

-   drop support for eol python versions
-   #214 - fix misuse in surrogate-escape api
-   add the node-and-timestamp local version scheme
-   respect git export ignores
-   avoid shlex.split on windows
-   fix #218 - better handling of mercurial edge-cases with tag commits
    being considered as the tagged commit
-   fix #223 - remove the dependency on the internal `SetuptoolsVersion`
    as it was removed after long-standing deprecation

## v1.15.7

-   Fix #174 with #207: Reuse samefile backport as developed in
    jaraco.windows, and only use the backport where samefile is not
    available.

## v1.15.6

-   fix #171 by unpinning the py version to allow a fixed one to get
    installed

## v1.15.5

-   fix #167 by correctly respecting preformatted version metadata from
    PKG-INFO/EGG-INFO

## v1.15.4

-   fix issue #164: iterate all found entry points to avoid errors when
    pip remakes egg-info
-   enhance self-use to enable pip install from github again

## v1.15.3

-   bring back correctly getting our version in the own sdist, finalizes
    #114
-   fix issue #150: strip local components of tags

## v1.15.2

-   fix issue #128: return None when a scm specific parse fails in a
    worktree to ease parse reuse

## v1.15.1

-   fix issue #126: the local part of any tags is discarded when
    guessing new versions
-   minor performance optimization by doing fewer git calls in the usual
    cases

## v1.15.0

-   more sophisticated ignoring of mercurial tag commits when
    considering distance in commits (thanks Petre Mierlutiu)
-   fix issue #114: stop trying to be smart for the sdist and ensure it's
    always correctly using itself
-   update trove classifiers
-   fix issue #84: document using the installed package metadata for
    sphinx
-   fix issue #81: fail more gracious when git/hg are missing
-   address issue #93: provide an experimental api to customize
    behavior on shallow git repos a custom parse function may pick pre
    parse actions to do when using git

## v1.14.1

- fix #109: when detecting a dirty git workdir

  don't consider untracked file (this was a regression due to #86 in v1.13.1)
- consider the distance 0 when the git node is unknown (happens when you haven't committed anything)

## v1.14.0

-   publish bdist_egg for python 2.6, 2.7 and 3.3-3.5
-   fix issue #107 - dont use node if it is None

## v1.13.1

-   fix issue #86 - detect dirty git workdir without tags

## v1.13.0

-   fix regression caused by the fix of #101
    -   assert types for version dumping
    -   strictly pass all versions through parsed version metadata

## v1.12.0

-   fix issue #97 - add support for mercurial plugins
-   fix issue #101 - write version cache even for pretend version
    (thanks anarcat for reporting and fixing)

## v1.11.1

-   fix issue #88 - better docs for sphinx usage (thanks Jason)
-   fix issue #89 - use normpath to deal with windows (thanks Te-jé
    Rodgers for reporting and fixing)

## v1.11.0

-   always run tag_to_version so in order to handle prefixes on old
    setuptools (thanks to Brian May)
-   drop support for python 3.2
-   extend the error message on missing scm metadata (thanks Markus
    Unterwaditzer)
-   fix bug when using callable version_scheme (thanks Esben Haabendal)

## v1.10.1

-   fix issue #73 - in hg pre commit merge, consider parent1 instead of
    failing

## v1.10.0

-   add support for overriding the version number via the environment
    variable SETUPTOOLS_SCM_PRETEND_VERSION

-   fix issue #63 by adding the `--match` parameter to the git describe
    call and prepare the possibility of passing more options to scm
    backends

-   fix issue #70 and #71 by introducing the parse keyword to specify
    custom scm parsing, it's an expert feature, use with caution

    this change also introduces the setuptools_scm.parse_scm_fallback
    entrypoint which can be used to register custom archive fallbacks

## v1.9.0

- Add `relative_to` parameter to `get_version` function, fixes #44 per #45.

## v1.8.0

- fix issue with setuptools wrong version warnings being printed to standard out. User is informed now by distutils-warnings.
- restructure root finding, we now reliably ignore outer scm and prefer PKG-INFO over scm, fixes #43 and #45

## v1.7.0

- correct the url to github thanks David Szotten
- enhance scm not found errors with a note on git tarballs thanks Markus
- add support for `write_to_template`

## v1.6.0

- bail out early if the scm is missing

  this brings issues with git tarballs and older devpi-client releases
  to light, before we would let the setup stay at version 0.0, now
  there is a ValueError

- properly raise errors on write_to misuse (thanks Te-jé Rodgers)

## v1.5.5

- Fix bug on Python 2 on Windows when environment has unicode fields.

## v1.5.4

- Fix bug on Python 2 when version is loaded from existing metadata.

## v1.5.3

- #28: Fix decoding error when PKG-INFO contains non-ASCII.

## v1.5.2

- add zip_safe flag

## v1.5.1

- fix file access bug I missed in 1.5

## v1.5.0

- moved setuptools integration related code to own file
- support storing version strings into a module/text file using the `write_to` configuration parameter

## v1.4.0

- proper handling for sdist
- fix file-finder failure from windows
- reshuffle docs

## v1.3.0

- support setuptools easy_install egg creation details by hardwire-ing the version in the sdist

## v1.2.0

- enhance self-use

## v1.1.0

- enable self-use

## v1.0.0

- documentation enhancements

## v0.26

- rename to setuptools_scm
- split into package, add lots of entry points for extension
- pluggable version schemes

## v0.25

- fix pep440 support this reshuffles the complete code for version guessing

## v0.24

- don't drop dirty flag on node finding
- fix distance for dirty flagged versions
- use dashes for time again, its normalisation with setuptools
- remove the own version attribute, it was too fragile to test for
- include file finding
- handle edge cases around dirty tagged versions

## v0.23

- windows compatibility fix (thanks stefan) drop samefile since it`s missing in some python2 versions on windows
- add tests to the source tarballs

## v0.22

- windows compatibility fix (thanks stefan) use samefile since it does path normalisation

## v0.21

- fix the own version attribute (thanks stefan)

## v0.20

- fix issue 11: always take git describe long format to avoid the source of the ambiguity
- fix issue 12: add a `__version__` attribute via pkginfo

## v0.19

- configurable next version guessing
- fix distance guessing (thanks stefan)
