# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._data_box_management_client_enums import *


class AccountCredentialDetails(msrest.serialization.Model):
    """Credential details of the account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_name: Name of the account.
    :vartype account_name: str
    :ivar data_destination_type: Data Destination Type. Possible values include: "StorageAccount",
     "ManagedDisk".
    :vartype data_destination_type: str or ~azure.mgmt.databox.models.DataDestinationType
    :ivar account_connection_string: Connection string of the account endpoint to use the account
     as a storage endpoint on the device.
    :vartype account_connection_string: str
    :ivar share_credential_details: Per share level unencrypted access credentials.
    :vartype share_credential_details: list[~azure.mgmt.databox.models.ShareCredentialDetails]
    """

    _validation = {
        'account_name': {'readonly': True},
        'data_destination_type': {'readonly': True},
        'account_connection_string': {'readonly': True},
        'share_credential_details': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'data_destination_type': {'key': 'dataDestinationType', 'type': 'str'},
        'account_connection_string': {'key': 'accountConnectionString', 'type': 'str'},
        'share_credential_details': {'key': 'shareCredentialDetails', 'type': '[ShareCredentialDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountCredentialDetails, self).__init__(**kwargs)
        self.account_name = None
        self.data_destination_type = None
        self.account_connection_string = None
        self.share_credential_details = None


class AddressValidationOutput(msrest.serialization.Model):
    """Output of the address validation api.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param validation_type: Identifies the type of validation response.Constant filled by server.
     Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar validation_status: The address validation status. Possible values include: "Valid",
     "Invalid", "Ambiguous".
    :vartype validation_status: str or ~azure.mgmt.databox.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.models.ShippingAddress]
    """

    _validation = {
        'error': {'readonly': True},
        'validation_status': {'readonly': True},
        'alternate_addresses': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'properties.validationType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'Error'},
        'validation_status': {'key': 'properties.validationStatus', 'type': 'str'},
        'alternate_addresses': {'key': 'properties.alternateAddresses', 'type': '[ShippingAddress]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressValidationOutput, self).__init__(**kwargs)
        self.validation_type = None  # type: Optional[str]
        self.error = None
        self.validation_status = None
        self.alternate_addresses = None


class ValidationInputResponse(msrest.serialization.Model):
    """Minimum properties that should be present in each individual validation response.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddressValidationProperties, CreateOrderLimitForSubscriptionValidationResponseProperties, DataDestinationDetailsValidationResponseProperties, PreferencesValidationResponseProperties, SkuAvailabilityValidationResponseProperties, SubscriptionIsAllowedToCreateJobValidationResponseProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    _subtype_map = {
        'validation_type': {'ValidateAddress': 'AddressValidationProperties', 'ValidateCreateOrderLimit': 'CreateOrderLimitForSubscriptionValidationResponseProperties', 'ValidateDataDestinationDetails': 'DataDestinationDetailsValidationResponseProperties', 'ValidatePreferences': 'PreferencesValidationResponseProperties', 'ValidateSkuAvailability': 'SkuAvailabilityValidationResponseProperties', 'ValidateSubscriptionIsAllowedToCreateJob': 'SubscriptionIsAllowedToCreateJobValidationResponseProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationInputResponse, self).__init__(**kwargs)
        self.validation_type = None  # type: Optional[str]
        self.error = None


class AddressValidationProperties(ValidationInputResponse):
    """The address validation output.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar validation_status: The address validation status. Possible values include: "Valid",
     "Invalid", "Ambiguous".
    :vartype validation_status: str or ~azure.mgmt.databox.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.models.ShippingAddress]
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'validation_status': {'readonly': True},
        'alternate_addresses': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'validation_status': {'key': 'validationStatus', 'type': 'str'},
        'alternate_addresses': {'key': 'alternateAddresses', 'type': '[ShippingAddress]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressValidationProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateAddress'  # type: str
        self.validation_status = None
        self.alternate_addresses = None


class ApplianceNetworkConfiguration(msrest.serialization.Model):
    """The Network Adapter configuration of a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the network.
    :vartype name: str
    :ivar mac_address: Mac Address.
    :vartype mac_address: str
    """

    _validation = {
        'name': {'readonly': True},
        'mac_address': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplianceNetworkConfiguration, self).__init__(**kwargs)
        self.name = None
        self.mac_address = None


class ArmBaseObject(msrest.serialization.Model):
    """Base class for all objects under resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmBaseObject, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None


class AvailableSkuRequest(msrest.serialization.Model):
    """The filters for showing the available skus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar transfer_type: Required. Type of the transfer. Default value: "ImportToAzure".
    :vartype transfer_type: str
    :param country: Required. ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements.
    :type country: str
    :param location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type location: str
    :param sku_names: Sku Names to filter for available skus.
    :type sku_names: list[str or ~azure.mgmt.databox.models.SkuName]
    """

    _validation = {
        'transfer_type': {'required': True, 'constant': True},
        'country': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'transfer_type': {'key': 'transferType', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku_names': {'key': 'skuNames', 'type': '[str]'},
    }

    transfer_type = "ImportToAzure"

    def __init__(
        self,
        *,
        country: str,
        location: str,
        sku_names: Optional[List[Union[str, "SkuName"]]] = None,
        **kwargs
    ):
        super(AvailableSkuRequest, self).__init__(**kwargs)
        self.country = country
        self.location = location
        self.sku_names = sku_names


class AvailableSkusResult(msrest.serialization.Model):
    """The available skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of available skus.
    :vartype value: list[~azure.mgmt.databox.models.SkuInformation]
    :param next_link: Link for the next set of skus.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInformation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AvailableSkusResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CancellationReason(msrest.serialization.Model):
    """Reason for cancellation.

    All required parameters must be populated in order to send to Azure.

    :param reason: Required. Reason for cancellation.
    :type reason: str
    """

    _validation = {
        'reason': {'required': True},
    }

    _attribute_map = {
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: str,
        **kwargs
    ):
        super(CancellationReason, self).__init__(**kwargs)
        self.reason = reason


class CloudError(msrest.serialization.Model):
    """The error information object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code string.
    :vartype code: str
    :ivar message: Descriptive error information.
    :vartype message: str
    :param target: Error target.
    :type target: str
    :param details: More detailed error information.
    :type details: list[~azure.mgmt.databox.models.CloudError]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudError]'},
    }

    def __init__(
        self,
        *,
        target: Optional[str] = None,
        details: Optional[List["CloudError"]] = None,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = target
        self.details = details


class ContactDetails(msrest.serialization.Model):
    """Contact Details.

    All required parameters must be populated in order to send to Azure.

    :param contact_name: Required. Contact name of the person.
    :type contact_name: str
    :param phone: Required. Phone number of the contact person.
    :type phone: str
    :param phone_extension: Phone extension number of the contact person.
    :type phone_extension: str
    :param mobile: Mobile number of the contact person.
    :type mobile: str
    :param email_list: Required. List of Email-ids to be notified about job progress.
    :type email_list: list[str]
    :param notification_preference: Notification preference for a job stage.
    :type notification_preference: list[~azure.mgmt.databox.models.NotificationPreference]
    """

    _validation = {
        'contact_name': {'required': True},
        'phone': {'required': True},
        'email_list': {'required': True},
    }

    _attribute_map = {
        'contact_name': {'key': 'contactName', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'phone_extension': {'key': 'phoneExtension', 'type': 'str'},
        'mobile': {'key': 'mobile', 'type': 'str'},
        'email_list': {'key': 'emailList', 'type': '[str]'},
        'notification_preference': {'key': 'notificationPreference', 'type': '[NotificationPreference]'},
    }

    def __init__(
        self,
        *,
        contact_name: str,
        phone: str,
        email_list: List[str],
        phone_extension: Optional[str] = None,
        mobile: Optional[str] = None,
        notification_preference: Optional[List["NotificationPreference"]] = None,
        **kwargs
    ):
        super(ContactDetails, self).__init__(**kwargs)
        self.contact_name = contact_name
        self.phone = phone
        self.phone_extension = phone_extension
        self.mobile = mobile
        self.email_list = email_list
        self.notification_preference = notification_preference


class CopyLogDetails(msrest.serialization.Model):
    """Details for log generated during copy.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataBoxAccountCopyLogDetails, DataBoxDiskCopyLogDetails, DataBoxHeavyAccountCopyLogDetails.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    """

    _validation = {
        'copy_log_details_type': {'required': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
    }

    _subtype_map = {
        'copy_log_details_type': {'DataBox': 'DataBoxAccountCopyLogDetails', 'DataBoxDisk': 'DataBoxDiskCopyLogDetails', 'DataBoxHeavy': 'DataBoxHeavyAccountCopyLogDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = None  # type: Optional[str]


class CopyProgress(msrest.serialization.Model):
    """Copy progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account where the data needs to be uploaded.
    :vartype storage_account_name: str
    :ivar data_destination_type: Data Destination Type. Possible values include: "StorageAccount",
     "ManagedDisk".
    :vartype data_destination_type: str or ~azure.mgmt.databox.models.DataDestinationType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_sent_to_cloud: Amount of data uploaded by the job as of now.
    :vartype bytes_sent_to_cloud: long
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: long
    :ivar files_processed: Number of files processed by the job as of now.
    :vartype files_processed: long
    :ivar total_files_to_process: Total number of files to be processed by the job.
    :vartype total_files_to_process: long
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: long
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: long
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: long
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: long
    """

    _validation = {
        'storage_account_name': {'readonly': True},
        'data_destination_type': {'readonly': True},
        'account_id': {'readonly': True},
        'bytes_sent_to_cloud': {'readonly': True},
        'total_bytes_to_process': {'readonly': True},
        'files_processed': {'readonly': True},
        'total_files_to_process': {'readonly': True},
        'invalid_files_processed': {'readonly': True},
        'invalid_file_bytes_uploaded': {'readonly': True},
        'renamed_container_count': {'readonly': True},
        'files_errored_out': {'readonly': True},
    }

    _attribute_map = {
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'data_destination_type': {'key': 'dataDestinationType', 'type': 'str'},
        'account_id': {'key': 'accountId', 'type': 'str'},
        'bytes_sent_to_cloud': {'key': 'bytesSentToCloud', 'type': 'long'},
        'total_bytes_to_process': {'key': 'totalBytesToProcess', 'type': 'long'},
        'files_processed': {'key': 'filesProcessed', 'type': 'long'},
        'total_files_to_process': {'key': 'totalFilesToProcess', 'type': 'long'},
        'invalid_files_processed': {'key': 'invalidFilesProcessed', 'type': 'long'},
        'invalid_file_bytes_uploaded': {'key': 'invalidFileBytesUploaded', 'type': 'long'},
        'renamed_container_count': {'key': 'renamedContainerCount', 'type': 'long'},
        'files_errored_out': {'key': 'filesErroredOut', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyProgress, self).__init__(**kwargs)
        self.storage_account_name = None
        self.data_destination_type = None
        self.account_id = None
        self.bytes_sent_to_cloud = None
        self.total_bytes_to_process = None
        self.files_processed = None
        self.total_files_to_process = None
        self.invalid_files_processed = None
        self.invalid_file_bytes_uploaded = None
        self.renamed_container_count = None
        self.files_errored_out = None


class ValidationRequest(msrest.serialization.Model):
    """Input request for all pre job creation validation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CreateJobValidations.

    All required parameters must be populated in order to send to Azure.

    :param individual_request_details: Required. List of request details contain validationType and
     its request as key and value respectively.
    :type individual_request_details: list[~azure.mgmt.databox.models.ValidationInputRequest]
    :param validation_category: Required. Identify the nature of validation.Constant filled by
     server.
    :type validation_category: str
    """

    _validation = {
        'individual_request_details': {'required': True},
        'validation_category': {'required': True},
    }

    _attribute_map = {
        'individual_request_details': {'key': 'individualRequestDetails', 'type': '[ValidationInputRequest]'},
        'validation_category': {'key': 'validationCategory', 'type': 'str'},
    }

    _subtype_map = {
        'validation_category': {'JobCreationValidation': 'CreateJobValidations'}
    }

    def __init__(
        self,
        *,
        individual_request_details: List["ValidationInputRequest"],
        **kwargs
    ):
        super(ValidationRequest, self).__init__(**kwargs)
        self.individual_request_details = individual_request_details
        self.validation_category = None  # type: Optional[str]


class CreateJobValidations(ValidationRequest):
    """It does all pre-job creation validations.

    All required parameters must be populated in order to send to Azure.

    :param individual_request_details: Required. List of request details contain validationType and
     its request as key and value respectively.
    :type individual_request_details: list[~azure.mgmt.databox.models.ValidationInputRequest]
    :param validation_category: Required. Identify the nature of validation.Constant filled by
     server.
    :type validation_category: str
    """

    _validation = {
        'individual_request_details': {'required': True},
        'validation_category': {'required': True},
    }

    _attribute_map = {
        'individual_request_details': {'key': 'individualRequestDetails', 'type': '[ValidationInputRequest]'},
        'validation_category': {'key': 'validationCategory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        individual_request_details: List["ValidationInputRequest"],
        **kwargs
    ):
        super(CreateJobValidations, self).__init__(individual_request_details=individual_request_details, **kwargs)
        self.validation_category = 'JobCreationValidation'  # type: str


class ValidationInputRequest(msrest.serialization.Model):
    """Minimum fields that must be present in any type of validation request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ValidateAddress, CreateOrderLimitForSubscriptionValidationRequest, DataDestinationDetailsValidationRequest, PreferencesValidationRequest, SkuAvailabilityValidationRequest, SubscriptionIsAllowedToCreateJobValidationRequest.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    """

    _validation = {
        'validation_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
    }

    _subtype_map = {
        'validation_type': {'ValidateAddress': 'ValidateAddress', 'ValidateCreateOrderLimit': 'CreateOrderLimitForSubscriptionValidationRequest', 'ValidateDataDestinationDetails': 'DataDestinationDetailsValidationRequest', 'ValidatePreferences': 'PreferencesValidationRequest', 'ValidateSkuAvailability': 'SkuAvailabilityValidationRequest', 'ValidateSubscriptionIsAllowedToCreateJob': 'SubscriptionIsAllowedToCreateJobValidationRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationInputRequest, self).__init__(**kwargs)
        self.validation_type = None  # type: Optional[str]


class CreateOrderLimitForSubscriptionValidationRequest(ValidationInputRequest):
    """Request to validate create order limit for current subscription.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_type: Union[str, "SkuName"],
        **kwargs
    ):
        super(CreateOrderLimitForSubscriptionValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateCreateOrderLimit'  # type: str
        self.device_type = device_type


class CreateOrderLimitForSubscriptionValidationResponseProperties(ValidationInputResponse):
    """Properties of create order limit for subscription validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar status: Create order limit validation status. Possible values include: "Valid",
     "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrderLimitForSubscriptionValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateCreateOrderLimit'  # type: str
        self.status = None


class DataBoxAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account of a DataBox job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar account_name: Destination account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: str
    """

    _validation = {
        'copy_log_details_type': {'required': True},
        'account_name': {'readonly': True},
        'copy_log_link': {'readonly': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'copy_log_link': {'key': 'copyLogLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxAccountCopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = 'DataBox'  # type: str
        self.account_name = None
        self.copy_log_link = None


class DataBoxDiskCopyLogDetails(CopyLogDetails):
    """Copy Log Details for a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar disk_serial_number: Disk Serial Number.
    :vartype disk_serial_number: str
    :ivar error_log_link: Link for copy error logs.
    :vartype error_log_link: str
    :ivar verbose_log_link: Link for copy verbose logs.
    :vartype verbose_log_link: str
    """

    _validation = {
        'copy_log_details_type': {'required': True},
        'disk_serial_number': {'readonly': True},
        'error_log_link': {'readonly': True},
        'verbose_log_link': {'readonly': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
        'disk_serial_number': {'key': 'diskSerialNumber', 'type': 'str'},
        'error_log_link': {'key': 'errorLogLink', 'type': 'str'},
        'verbose_log_link': {'key': 'verboseLogLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxDiskCopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = 'DataBoxDisk'  # type: str
        self.disk_serial_number = None
        self.error_log_link = None
        self.verbose_log_link = None


class DataBoxDiskCopyProgress(msrest.serialization.Model):
    """DataBox Disk Copy Progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar serial_number: The serial number of the disk.
    :vartype serial_number: str
    :ivar bytes_copied: Bytes copied during the copy of disk.
    :vartype bytes_copied: long
    :ivar percent_complete: Indicates the percentage completed for the copy of the disk.
    :vartype percent_complete: int
    :ivar status: The Status of the copy. Possible values include: "NotStarted", "InProgress",
     "Completed", "CompletedWithErrors", "Failed", "NotReturned", "HardwareError",
     "DeviceFormatted", "DeviceMetadataModified", "StorageAccountNotAccessible", "UnsupportedData".
    :vartype status: str or ~azure.mgmt.databox.models.CopyStatus
    """

    _validation = {
        'serial_number': {'readonly': True},
        'bytes_copied': {'readonly': True},
        'percent_complete': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'bytes_copied': {'key': 'bytesCopied', 'type': 'long'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxDiskCopyProgress, self).__init__(**kwargs)
        self.serial_number = None
        self.bytes_copied = None
        self.percent_complete = None
        self.status = None


class JobDetails(msrest.serialization.Model):
    """Job details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataBoxJobDetails, DataBoxDiskJobDetails, DataBoxHeavyJobDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Required. Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param destination_account_details: Required. Destination account details.
    :type destination_account_details: list[~azure.mgmt.databox.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.models.JobErrorDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'shipping_address': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'destination_account_details': {'required': True},
        'error_details': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
    }

    _attribute_map = {
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'destination_account_details': {'key': 'destinationAccountDetails', 'type': '[DestinationAccountDetails]'},
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
    }

    _subtype_map = {
        'job_details_type': {'DataBox': 'DataBoxJobDetails', 'DataBoxDisk': 'DataBoxDiskJobDetails', 'DataBoxHeavy': 'DataBoxHeavyJobDetails'}
    }

    def __init__(
        self,
        *,
        contact_details: "ContactDetails",
        shipping_address: "ShippingAddress",
        destination_account_details: List["DestinationAccountDetails"],
        expected_data_size_in_terabytes: Optional[int] = None,
        preferences: Optional["Preferences"] = None,
        **kwargs
    ):
        super(JobDetails, self).__init__(**kwargs)
        self.expected_data_size_in_terabytes = expected_data_size_in_terabytes
        self.job_stages = None
        self.contact_details = contact_details
        self.shipping_address = shipping_address
        self.delivery_package = None
        self.return_package = None
        self.destination_account_details = destination_account_details
        self.error_details = None
        self.job_details_type = None  # type: Optional[str]
        self.preferences = preferences
        self.copy_log_details = None
        self.reverse_shipment_label_sas_key = None
        self.chain_of_custody_sas_key = None


class DataBoxDiskJobDetails(JobDetails):
    """DataBox Disk Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Required. Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param destination_account_details: Required. Destination account details.
    :type destination_account_details: list[~azure.mgmt.databox.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.models.JobErrorDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :param preferred_disks: User preference on what size disks are needed for the job. The map is
     from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but
     will be checked against an int.
    :type preferred_disks: dict[str, int]
    :ivar copy_progress: Copy progress per disk.
    :vartype copy_progress: list[~azure.mgmt.databox.models.DataBoxDiskCopyProgress]
    :ivar disks_and_size_details: Contains the map of disk serial number to the disk size being
     used for the job. Is returned only after the disks are shipped to the customer.
    :vartype disks_and_size_details: dict[str, int]
    :param passkey: User entered passkey for DataBox Disk job.
    :type passkey: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'shipping_address': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'destination_account_details': {'required': True},
        'error_details': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'copy_progress': {'readonly': True},
        'disks_and_size_details': {'readonly': True},
    }

    _attribute_map = {
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'destination_account_details': {'key': 'destinationAccountDetails', 'type': '[DestinationAccountDetails]'},
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'preferred_disks': {'key': 'preferredDisks', 'type': '{int}'},
        'copy_progress': {'key': 'copyProgress', 'type': '[DataBoxDiskCopyProgress]'},
        'disks_and_size_details': {'key': 'disksAndSizeDetails', 'type': '{int}'},
        'passkey': {'key': 'passkey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        contact_details: "ContactDetails",
        shipping_address: "ShippingAddress",
        destination_account_details: List["DestinationAccountDetails"],
        expected_data_size_in_terabytes: Optional[int] = None,
        preferences: Optional["Preferences"] = None,
        preferred_disks: Optional[Dict[str, int]] = None,
        passkey: Optional[str] = None,
        **kwargs
    ):
        super(DataBoxDiskJobDetails, self).__init__(expected_data_size_in_terabytes=expected_data_size_in_terabytes, contact_details=contact_details, shipping_address=shipping_address, destination_account_details=destination_account_details, preferences=preferences, **kwargs)
        self.job_details_type = 'DataBoxDisk'  # type: str
        self.preferred_disks = preferred_disks
        self.copy_progress = None
        self.disks_and_size_details = None
        self.passkey = passkey


class JobSecrets(msrest.serialization.Model):
    """The base class for the secrets.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataboxJobSecrets, DataBoxDiskJobSecrets, DataBoxHeavyJobSecrets.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :type dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    """

    _validation = {
        'job_secrets_type': {'required': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
    }

    _subtype_map = {
        'job_secrets_type': {'DataBox': 'DataboxJobSecrets', 'DataBoxDisk': 'DataBoxDiskJobSecrets', 'DataBoxHeavy': 'DataBoxHeavyJobSecrets'}
    }

    def __init__(
        self,
        *,
        dc_access_security_code: Optional["DcAccessSecurityCode"] = None,
        **kwargs
    ):
        super(JobSecrets, self).__init__(**kwargs)
        self.job_secrets_type = None  # type: Optional[str]
        self.dc_access_security_code = dc_access_security_code


class DataBoxDiskJobSecrets(JobSecrets):
    """The secrets related to disk job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :type dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :ivar disk_secrets: Contains the list of secrets object for that device.
    :vartype disk_secrets: list[~azure.mgmt.databox.models.DiskSecret]
    :ivar pass_key: PassKey for the disk Job.
    :vartype pass_key: str
    :ivar is_passkey_user_defined: Whether passkey was provided by user.
    :vartype is_passkey_user_defined: bool
    """

    _validation = {
        'job_secrets_type': {'required': True},
        'disk_secrets': {'readonly': True},
        'pass_key': {'readonly': True},
        'is_passkey_user_defined': {'readonly': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'disk_secrets': {'key': 'diskSecrets', 'type': '[DiskSecret]'},
        'pass_key': {'key': 'passKey', 'type': 'str'},
        'is_passkey_user_defined': {'key': 'isPasskeyUserDefined', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        dc_access_security_code: Optional["DcAccessSecurityCode"] = None,
        **kwargs
    ):
        super(DataBoxDiskJobSecrets, self).__init__(dc_access_security_code=dc_access_security_code, **kwargs)
        self.job_secrets_type = 'DataBoxDisk'  # type: str
        self.disk_secrets = None
        self.pass_key = None
        self.is_passkey_user_defined = None


class DataBoxHeavyAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account for Databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param copy_log_details_type: Required. Indicates the type of job details.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type copy_log_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :ivar account_name: Destination account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: list[str]
    """

    _validation = {
        'copy_log_details_type': {'required': True},
        'account_name': {'readonly': True},
        'copy_log_link': {'readonly': True},
    }

    _attribute_map = {
        'copy_log_details_type': {'key': 'copyLogDetailsType', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'copy_log_link': {'key': 'copyLogLink', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxHeavyAccountCopyLogDetails, self).__init__(**kwargs)
        self.copy_log_details_type = 'DataBoxHeavy'  # type: str
        self.account_name = None
        self.copy_log_link = None


class DataBoxHeavyJobDetails(JobDetails):
    """Databox Heavy Device Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Required. Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param destination_account_details: Required. Destination account details.
    :type destination_account_details: list[~azure.mgmt.databox.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.models.JobErrorDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar copy_progress: Copy progress per account.
    :vartype copy_progress: list[~azure.mgmt.databox.models.CopyProgress]
    :param device_password: Set Device password for unlocking Databox Heavy.
    :type device_password: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'shipping_address': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'destination_account_details': {'required': True},
        'error_details': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'copy_progress': {'readonly': True},
    }

    _attribute_map = {
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'destination_account_details': {'key': 'destinationAccountDetails', 'type': '[DestinationAccountDetails]'},
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'copy_progress': {'key': 'copyProgress', 'type': '[CopyProgress]'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        contact_details: "ContactDetails",
        shipping_address: "ShippingAddress",
        destination_account_details: List["DestinationAccountDetails"],
        expected_data_size_in_terabytes: Optional[int] = None,
        preferences: Optional["Preferences"] = None,
        device_password: Optional[str] = None,
        **kwargs
    ):
        super(DataBoxHeavyJobDetails, self).__init__(expected_data_size_in_terabytes=expected_data_size_in_terabytes, contact_details=contact_details, shipping_address=shipping_address, destination_account_details=destination_account_details, preferences=preferences, **kwargs)
        self.job_details_type = 'DataBoxHeavy'  # type: str
        self.copy_progress = None
        self.device_password = device_password


class DataBoxHeavyJobSecrets(JobSecrets):
    """The secrets related to a databox heavy job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :type dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :ivar cabinet_pod_secrets: Contains the list of secret objects for a databox heavy job.
    :vartype cabinet_pod_secrets: list[~azure.mgmt.databox.models.DataBoxHeavySecret]
    """

    _validation = {
        'job_secrets_type': {'required': True},
        'cabinet_pod_secrets': {'readonly': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'cabinet_pod_secrets': {'key': 'cabinetPodSecrets', 'type': '[DataBoxHeavySecret]'},
    }

    def __init__(
        self,
        *,
        dc_access_security_code: Optional["DcAccessSecurityCode"] = None,
        **kwargs
    ):
        super(DataBoxHeavyJobSecrets, self).__init__(dc_access_security_code=dc_access_security_code, **kwargs)
        self.job_secrets_type = 'DataBoxHeavy'  # type: str
        self.cabinet_pod_secrets = None


class DataBoxHeavySecret(msrest.serialization.Model):
    """The secrets related to a databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations: list[~azure.mgmt.databox.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details: list[~azure.mgmt.databox.models.AccountCredentialDetails]
    """

    _validation = {
        'device_serial_number': {'readonly': True},
        'device_password': {'readonly': True},
        'network_configurations': {'readonly': True},
        'encoded_validation_cert_pub_key': {'readonly': True},
        'account_credential_details': {'readonly': True},
    }

    _attribute_map = {
        'device_serial_number': {'key': 'deviceSerialNumber', 'type': 'str'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
        'network_configurations': {'key': 'networkConfigurations', 'type': '[ApplianceNetworkConfiguration]'},
        'encoded_validation_cert_pub_key': {'key': 'encodedValidationCertPubKey', 'type': 'str'},
        'account_credential_details': {'key': 'accountCredentialDetails', 'type': '[AccountCredentialDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxHeavySecret, self).__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataBoxJobDetails(JobDetails):
    """Databox Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param expected_data_size_in_terabytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.models.JobStages]
    :param contact_details: Required. Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Required. Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.models.PackageShippingDetails
    :param destination_account_details: Required. Destination account details.
    :type destination_account_details: list[~azure.mgmt.databox.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.models.JobErrorDetails]
    :param job_details_type: Required. Indicates the type of job details.Constant filled by server.
     Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_details_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param preferences: Preferences for the order.
    :type preferences: ~azure.mgmt.databox.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar copy_progress: Copy progress per storage account.
    :vartype copy_progress: list[~azure.mgmt.databox.models.CopyProgress]
    :param device_password: Set Device password for unlocking Databox.
    :type device_password: str
    """

    _validation = {
        'job_stages': {'readonly': True},
        'contact_details': {'required': True},
        'shipping_address': {'required': True},
        'delivery_package': {'readonly': True},
        'return_package': {'readonly': True},
        'destination_account_details': {'required': True},
        'error_details': {'readonly': True},
        'job_details_type': {'required': True},
        'copy_log_details': {'readonly': True},
        'reverse_shipment_label_sas_key': {'readonly': True},
        'chain_of_custody_sas_key': {'readonly': True},
        'copy_progress': {'readonly': True},
    }

    _attribute_map = {
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
        'job_stages': {'key': 'jobStages', 'type': '[JobStages]'},
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'delivery_package': {'key': 'deliveryPackage', 'type': 'PackageShippingDetails'},
        'return_package': {'key': 'returnPackage', 'type': 'PackageShippingDetails'},
        'destination_account_details': {'key': 'destinationAccountDetails', 'type': '[DestinationAccountDetails]'},
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorDetails]'},
        'job_details_type': {'key': 'jobDetailsType', 'type': 'str'},
        'preferences': {'key': 'preferences', 'type': 'Preferences'},
        'copy_log_details': {'key': 'copyLogDetails', 'type': '[CopyLogDetails]'},
        'reverse_shipment_label_sas_key': {'key': 'reverseShipmentLabelSasKey', 'type': 'str'},
        'chain_of_custody_sas_key': {'key': 'chainOfCustodySasKey', 'type': 'str'},
        'copy_progress': {'key': 'copyProgress', 'type': '[CopyProgress]'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        contact_details: "ContactDetails",
        shipping_address: "ShippingAddress",
        destination_account_details: List["DestinationAccountDetails"],
        expected_data_size_in_terabytes: Optional[int] = None,
        preferences: Optional["Preferences"] = None,
        device_password: Optional[str] = None,
        **kwargs
    ):
        super(DataBoxJobDetails, self).__init__(expected_data_size_in_terabytes=expected_data_size_in_terabytes, contact_details=contact_details, shipping_address=shipping_address, destination_account_details=destination_account_details, preferences=preferences, **kwargs)
        self.job_details_type = 'DataBox'  # type: str
        self.copy_progress = None
        self.device_password = device_password


class DataboxJobSecrets(JobSecrets):
    """The secrets related to a databox job.

    All required parameters must be populated in order to send to Azure.

    :param job_secrets_type: Required. Used to indicate what type of job secrets object.Constant
     filled by server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type job_secrets_type: str or ~azure.mgmt.databox.models.ClassDiscriminator
    :param dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :type dc_access_security_code: ~azure.mgmt.databox.models.DcAccessSecurityCode
    :param pod_secrets: Contains the list of secret objects for a job.
    :type pod_secrets: list[~azure.mgmt.databox.models.DataBoxSecret]
    """

    _validation = {
        'job_secrets_type': {'required': True},
    }

    _attribute_map = {
        'job_secrets_type': {'key': 'jobSecretsType', 'type': 'str'},
        'dc_access_security_code': {'key': 'dcAccessSecurityCode', 'type': 'DcAccessSecurityCode'},
        'pod_secrets': {'key': 'podSecrets', 'type': '[DataBoxSecret]'},
    }

    def __init__(
        self,
        *,
        dc_access_security_code: Optional["DcAccessSecurityCode"] = None,
        pod_secrets: Optional[List["DataBoxSecret"]] = None,
        **kwargs
    ):
        super(DataboxJobSecrets, self).__init__(dc_access_security_code=dc_access_security_code, **kwargs)
        self.job_secrets_type = 'DataBox'  # type: str
        self.pod_secrets = pod_secrets


class ScheduleAvailabilityRequest(msrest.serialization.Model):
    """Request body to get the availability for scheduling orders.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataBoxScheduleAvailabilityRequest, DiskScheduleAvailabilityRequest, HeavyScheduleAvailabilityRequest.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer.
     For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-
     version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
    }

    _subtype_map = {
        'sku_name': {'DataBox': 'DataBoxScheduleAvailabilityRequest', 'DataBoxDisk': 'DiskScheduleAvailabilityRequest', 'DataBoxHeavy': 'HeavyScheduleAvailabilityRequest'}
    }

    def __init__(
        self,
        *,
        storage_location: str,
        **kwargs
    ):
        super(ScheduleAvailabilityRequest, self).__init__(**kwargs)
        self.storage_location = storage_location
        self.sku_name = None  # type: Optional[str]


class DataBoxScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling data box orders orders.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer.
     For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-
     version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_location: str,
        **kwargs
    ):
        super(DataBoxScheduleAvailabilityRequest, self).__init__(storage_location=storage_location, **kwargs)
        self.sku_name = 'DataBox'  # type: str


class DataBoxSecret(msrest.serialization.Model):
    """The secrets related to a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations: list[~azure.mgmt.databox.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details: list[~azure.mgmt.databox.models.AccountCredentialDetails]
    """

    _validation = {
        'device_serial_number': {'readonly': True},
        'device_password': {'readonly': True},
        'network_configurations': {'readonly': True},
        'encoded_validation_cert_pub_key': {'readonly': True},
        'account_credential_details': {'readonly': True},
    }

    _attribute_map = {
        'device_serial_number': {'key': 'deviceSerialNumber', 'type': 'str'},
        'device_password': {'key': 'devicePassword', 'type': 'str'},
        'network_configurations': {'key': 'networkConfigurations', 'type': '[ApplianceNetworkConfiguration]'},
        'encoded_validation_cert_pub_key': {'key': 'encodedValidationCertPubKey', 'type': 'str'},
        'account_credential_details': {'key': 'accountCredentialDetails', 'type': '[AccountCredentialDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxSecret, self).__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataDestinationDetailsValidationRequest(ValidationInputRequest):
    """Request to validate data destination details.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param destination_account_details: Required. Destination account details list.
    :type destination_account_details: list[~azure.mgmt.databox.models.DestinationAccountDetails]
    :param location: Required. Location of stamp or geo.
    :type location: str
    """

    _validation = {
        'validation_type': {'required': True},
        'destination_account_details': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'destination_account_details': {'key': 'destinationAccountDetails', 'type': '[DestinationAccountDetails]'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        destination_account_details: List["DestinationAccountDetails"],
        location: str,
        **kwargs
    ):
        super(DataDestinationDetailsValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateDataDestinationDetails'  # type: str
        self.destination_account_details = destination_account_details
        self.location = location


class DataDestinationDetailsValidationResponseProperties(ValidationInputResponse):
    """Properties of data destination details validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar status: Data destination details validation status. Possible values include: "Valid",
     "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDestinationDetailsValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateDataDestinationDetails'  # type: str
        self.status = None


class DcAccessSecurityCode(msrest.serialization.Model):
    """Dc Access Security code for device.

    :param forward_dc_access_code: Dc Access Code for dispatching from DC.
    :type forward_dc_access_code: str
    :param reverse_dc_access_code: Dc Access code for dropping off at DC.
    :type reverse_dc_access_code: str
    """

    _attribute_map = {
        'forward_dc_access_code': {'key': 'forwardDcAccessCode', 'type': 'str'},
        'reverse_dc_access_code': {'key': 'reverseDcAccessCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        forward_dc_access_code: Optional[str] = None,
        reverse_dc_access_code: Optional[str] = None,
        **kwargs
    ):
        super(DcAccessSecurityCode, self).__init__(**kwargs)
        self.forward_dc_access_code = forward_dc_access_code
        self.reverse_dc_access_code = reverse_dc_access_code


class DestinationAccountDetails(msrest.serialization.Model):
    """Details of the destination storage accounts.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DestinationManagedDiskDetails, DestinationStorageAccountDetails.

    All required parameters must be populated in order to send to Azure.

    :param data_destination_type: Required. Data Destination Type.Constant filled by server.
     Possible values include: "StorageAccount", "ManagedDisk".
    :type data_destination_type: str or ~azure.mgmt.databox.models.DataDestinationType
    :param account_id: Arm Id of the destination where the data has to be moved.
    :type account_id: str
    :param share_password: Share password to be shared by all shares in SA.
    :type share_password: str
    """

    _validation = {
        'data_destination_type': {'required': True},
    }

    _attribute_map = {
        'data_destination_type': {'key': 'dataDestinationType', 'type': 'str'},
        'account_id': {'key': 'accountId', 'type': 'str'},
        'share_password': {'key': 'sharePassword', 'type': 'str'},
    }

    _subtype_map = {
        'data_destination_type': {'ManagedDisk': 'DestinationManagedDiskDetails', 'StorageAccount': 'DestinationStorageAccountDetails'}
    }

    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        share_password: Optional[str] = None,
        **kwargs
    ):
        super(DestinationAccountDetails, self).__init__(**kwargs)
        self.data_destination_type = None  # type: Optional[str]
        self.account_id = account_id
        self.share_password = share_password


class DestinationManagedDiskDetails(DestinationAccountDetails):
    """Details for the destination compute disks.

    All required parameters must be populated in order to send to Azure.

    :param data_destination_type: Required. Data Destination Type.Constant filled by server.
     Possible values include: "StorageAccount", "ManagedDisk".
    :type data_destination_type: str or ~azure.mgmt.databox.models.DataDestinationType
    :param account_id: Arm Id of the destination where the data has to be moved.
    :type account_id: str
    :param share_password: Share password to be shared by all shares in SA.
    :type share_password: str
    :param resource_group_id: Required. Destination Resource Group Id where the Compute disks
     should be created.
    :type resource_group_id: str
    :param staging_storage_account_id: Required. Arm Id of the storage account that can be used to
     copy the vhd for staging.
    :type staging_storage_account_id: str
    """

    _validation = {
        'data_destination_type': {'required': True},
        'resource_group_id': {'required': True},
        'staging_storage_account_id': {'required': True},
    }

    _attribute_map = {
        'data_destination_type': {'key': 'dataDestinationType', 'type': 'str'},
        'account_id': {'key': 'accountId', 'type': 'str'},
        'share_password': {'key': 'sharePassword', 'type': 'str'},
        'resource_group_id': {'key': 'resourceGroupId', 'type': 'str'},
        'staging_storage_account_id': {'key': 'stagingStorageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_group_id: str,
        staging_storage_account_id: str,
        account_id: Optional[str] = None,
        share_password: Optional[str] = None,
        **kwargs
    ):
        super(DestinationManagedDiskDetails, self).__init__(account_id=account_id, share_password=share_password, **kwargs)
        self.data_destination_type = 'ManagedDisk'  # type: str
        self.resource_group_id = resource_group_id
        self.staging_storage_account_id = staging_storage_account_id


class DestinationStorageAccountDetails(DestinationAccountDetails):
    """Details for the destination storage account.

    All required parameters must be populated in order to send to Azure.

    :param data_destination_type: Required. Data Destination Type.Constant filled by server.
     Possible values include: "StorageAccount", "ManagedDisk".
    :type data_destination_type: str or ~azure.mgmt.databox.models.DataDestinationType
    :param account_id: Arm Id of the destination where the data has to be moved.
    :type account_id: str
    :param share_password: Share password to be shared by all shares in SA.
    :type share_password: str
    :param storage_account_id: Required. Destination Storage Account Arm Id.
    :type storage_account_id: str
    """

    _validation = {
        'data_destination_type': {'required': True},
        'storage_account_id': {'required': True},
    }

    _attribute_map = {
        'data_destination_type': {'key': 'dataDestinationType', 'type': 'str'},
        'account_id': {'key': 'accountId', 'type': 'str'},
        'share_password': {'key': 'sharePassword', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_id: str,
        account_id: Optional[str] = None,
        share_password: Optional[str] = None,
        **kwargs
    ):
        super(DestinationStorageAccountDetails, self).__init__(account_id=account_id, share_password=share_password, **kwargs)
        self.data_destination_type = 'StorageAccount'  # type: str
        self.storage_account_id = storage_account_id


class DestinationToServiceLocationMap(msrest.serialization.Model):
    """Map of destination location to service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar destination_location: Location of the destination.
    :vartype destination_location: str
    :ivar service_location: Location of the service.
    :vartype service_location: str
    """

    _validation = {
        'destination_location': {'readonly': True},
        'service_location': {'readonly': True},
    }

    _attribute_map = {
        'destination_location': {'key': 'destinationLocation', 'type': 'str'},
        'service_location': {'key': 'serviceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DestinationToServiceLocationMap, self).__init__(**kwargs)
        self.destination_location = None
        self.service_location = None


class DiskScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling disk orders.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer.
     For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-
     version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    :param expected_data_size_in_terabytes: Required. The expected size of the data, which needs to
     be transferred in this job, in terabytes.
    :type expected_data_size_in_terabytes: int
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
        'expected_data_size_in_terabytes': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
        'expected_data_size_in_terabytes': {'key': 'expectedDataSizeInTerabytes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        storage_location: str,
        expected_data_size_in_terabytes: int,
        **kwargs
    ):
        super(DiskScheduleAvailabilityRequest, self).__init__(storage_location=storage_location, **kwargs)
        self.sku_name = 'DataBoxDisk'  # type: str
        self.expected_data_size_in_terabytes = expected_data_size_in_terabytes


class DiskSecret(msrest.serialization.Model):
    """Contains all the secrets of a Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_serial_number: Serial number of the assigned disk.
    :vartype disk_serial_number: str
    :ivar bit_locker_key: Bit Locker key of the disk which can be used to unlock the disk to copy
     data.
    :vartype bit_locker_key: str
    """

    _validation = {
        'disk_serial_number': {'readonly': True},
        'bit_locker_key': {'readonly': True},
    }

    _attribute_map = {
        'disk_serial_number': {'key': 'diskSerialNumber', 'type': 'str'},
        'bit_locker_key': {'key': 'bitLockerKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiskSecret, self).__init__(**kwargs)
        self.disk_serial_number = None
        self.bit_locker_key = None


class Error(msrest.serialization.Model):
    """Top level error for the job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code that can be used to programmatically identify the error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging information.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = None
        self.message = None


class HeavyScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling heavy orders.

    All required parameters must be populated in order to send to Azure.

    :param storage_location: Required. Location for data transfer.
     For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-
     version=2018-01-01.
    :type storage_location: str
    :param sku_name: Required. Sku Name for which the order is to be scheduled.Constant filled by
     server.  Possible values include: "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'storage_location': {'required': True},
        'sku_name': {'required': True},
    }

    _attribute_map = {
        'storage_location': {'key': 'storageLocation', 'type': 'str'},
        'sku_name': {'key': 'skuName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_location: str,
        **kwargs
    ):
        super(HeavyScheduleAvailabilityRequest, self).__init__(storage_location=storage_location, **kwargs)
        self.sku_name = 'DataBoxHeavy'  # type: str


class JobDeliveryInfo(msrest.serialization.Model):
    """Additional delivery info.

    :param scheduled_date_time: Scheduled date time.
    :type scheduled_date_time: ~datetime.datetime
    """

    _attribute_map = {
        'scheduled_date_time': {'key': 'scheduledDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        scheduled_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(JobDeliveryInfo, self).__init__(**kwargs)
        self.scheduled_date_time = scheduled_date_time


class JobErrorDetails(msrest.serialization.Model):
    """Job Error Details for providing the information and recommended action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_message: Message for the error.
    :vartype error_message: str
    :ivar error_code: Code for the error.
    :vartype error_code: int
    :ivar recommended_action: Recommended action for the error.
    :vartype recommended_action: str
    :ivar exception_message: Contains the non localized exception message.
    :vartype exception_message: str
    """

    _validation = {
        'error_message': {'readonly': True},
        'error_code': {'readonly': True},
        'recommended_action': {'readonly': True},
        'exception_message': {'readonly': True},
    }

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'exception_message': {'key': 'exceptionMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobErrorDetails, self).__init__(**kwargs)
        self.error_message = None
        self.error_code = None
        self.recommended_action = None
        self.exception_message = None


class Resource(msrest.serialization.Model):
    """Model of the Resource.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource. This will be one of the supported and
     registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
     resource cannot be changed once it is created, but if an identical region is specified on
     update the request will succeed.
    :type location: str
    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param sku: Required. The sku type.
    :type sku: ~azure.mgmt.databox.models.Sku
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku


class JobResource(Resource):
    """Job Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location of the resource. This will be one of the supported and
     registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
     resource cannot be changed once it is created, but if an identical region is specified on
     update the request will succeed.
    :type location: str
    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param sku: Required. The sku type.
    :type sku: ~azure.mgmt.databox.models.Sku
    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    :ivar is_cancellable: Describes whether the job is cancellable or not.
    :vartype is_cancellable: bool
    :ivar is_deletable: Describes whether the job is deletable or not.
    :vartype is_deletable: bool
    :ivar is_shipping_address_editable: Describes whether the shipping address is editable or not.
    :vartype is_shipping_address_editable: bool
    :ivar status: Name of the stage which is in progress. Possible values include: "DeviceOrdered",
     "DevicePrepared", "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", "ReadyToReceiveAtAzureDC".
    :vartype status: str or ~azure.mgmt.databox.models.StageName
    :ivar start_time: Time at which the job was started in UTC ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar error: Top level error for the job.
    :vartype error: ~azure.mgmt.databox.models.Error
    :param details: Details of a job run. This field will only be sent for expand details filter.
    :type details: ~azure.mgmt.databox.models.JobDetails
    :ivar cancellation_reason: Reason for cancellation.
    :vartype cancellation_reason: str
    :param delivery_type: Delivery type of Job. Possible values include: "NonScheduled",
     "Scheduled".
    :type delivery_type: str or ~azure.mgmt.databox.models.JobDeliveryType
    :param delivery_info: Delivery Info of Job.
    :type delivery_info: ~azure.mgmt.databox.models.JobDeliveryInfo
    :ivar is_cancellable_without_fee: Flag to indicate cancellation of scheduled job.
    :vartype is_cancellable_without_fee: bool
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'is_cancellable': {'readonly': True},
        'is_deletable': {'readonly': True},
        'is_shipping_address_editable': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'error': {'readonly': True},
        'cancellation_reason': {'readonly': True},
        'is_cancellable_without_fee': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
        'is_deletable': {'key': 'properties.isDeletable', 'type': 'bool'},
        'is_shipping_address_editable': {'key': 'properties.isShippingAddressEditable', 'type': 'bool'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'error': {'key': 'properties.error', 'type': 'Error'},
        'details': {'key': 'properties.details', 'type': 'JobDetails'},
        'cancellation_reason': {'key': 'properties.cancellationReason', 'type': 'str'},
        'delivery_type': {'key': 'properties.deliveryType', 'type': 'str'},
        'delivery_info': {'key': 'properties.deliveryInfo', 'type': 'JobDeliveryInfo'},
        'is_cancellable_without_fee': {'key': 'properties.isCancellableWithoutFee', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        details: Optional["JobDetails"] = None,
        delivery_type: Optional[Union[str, "JobDeliveryType"]] = None,
        delivery_info: Optional["JobDeliveryInfo"] = None,
        **kwargs
    ):
        super(JobResource, self).__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.is_cancellable = None
        self.is_deletable = None
        self.is_shipping_address_editable = None
        self.status = None
        self.start_time = None
        self.error = None
        self.details = details
        self.cancellation_reason = None
        self.delivery_type = delivery_type
        self.delivery_info = delivery_info
        self.is_cancellable_without_fee = None


class JobResourceList(msrest.serialization.Model):
    """Job Resource Collection.

    :param value: List of job resources.
    :type value: list[~azure.mgmt.databox.models.JobResource]
    :param next_link: Link for the next set of job resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobResourceUpdateParameter(msrest.serialization.Model):
    """The JobResourceUpdateParameter.

    :param tags: A set of tags. The list of key value pairs that describe the resource. These tags
     can be used in viewing and grouping this resource (across resource groups).
    :type tags: dict[str, str]
    :param details: Details of a job to be updated.
    :type details: ~azure.mgmt.databox.models.UpdateJobDetails
    :param destination_account_details: Destination account details.
    :type destination_account_details: list[~azure.mgmt.databox.models.DestinationAccountDetails]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'details': {'key': 'properties.details', 'type': 'UpdateJobDetails'},
        'destination_account_details': {'key': 'properties.destinationAccountDetails', 'type': '[DestinationAccountDetails]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        details: Optional["UpdateJobDetails"] = None,
        destination_account_details: Optional[List["DestinationAccountDetails"]] = None,
        **kwargs
    ):
        super(JobResourceUpdateParameter, self).__init__(**kwargs)
        self.tags = tags
        self.details = details
        self.destination_account_details = destination_account_details


class JobStages(msrest.serialization.Model):
    """Job stages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar stage_name: Name of the job stage. Possible values include: "DeviceOrdered",
     "DevicePrepared", "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", "ReadyToReceiveAtAzureDC".
    :vartype stage_name: str or ~azure.mgmt.databox.models.StageName
    :ivar display_name: Display name of the job stage.
    :vartype display_name: str
    :ivar stage_status: Status of the job stage. Possible values include: "None", "InProgress",
     "Succeeded", "Failed", "Cancelled", "Cancelling", "SucceededWithErrors".
    :vartype stage_status: str or ~azure.mgmt.databox.models.StageStatus
    :ivar stage_time: Time for the job stage in UTC ISO 8601 format.
    :vartype stage_time: ~datetime.datetime
    :ivar job_stage_details: Job Stage Details.
    :vartype job_stage_details: object
    :ivar error_details: Error details for the stage.
    :vartype error_details: list[~azure.mgmt.databox.models.JobErrorDetails]
    """

    _validation = {
        'stage_name': {'readonly': True},
        'display_name': {'readonly': True},
        'stage_status': {'readonly': True},
        'stage_time': {'readonly': True},
        'job_stage_details': {'readonly': True},
        'error_details': {'readonly': True},
    }

    _attribute_map = {
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'stage_status': {'key': 'stageStatus', 'type': 'str'},
        'stage_time': {'key': 'stageTime', 'type': 'iso-8601'},
        'job_stage_details': {'key': 'jobStageDetails', 'type': 'object'},
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobStages, self).__init__(**kwargs)
        self.stage_name = None
        self.display_name = None
        self.stage_status = None
        self.stage_time = None
        self.job_stage_details = None
        self.error_details = None


class NotificationPreference(msrest.serialization.Model):
    """Notification preference for a job stage.

    All required parameters must be populated in order to send to Azure.

    :param stage_name: Required. Name of the stage. Possible values include: "DevicePrepared",
     "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy".
    :type stage_name: str or ~azure.mgmt.databox.models.NotificationStageName
    :param send_notification: Required. Notification is required or not.
    :type send_notification: bool
    """

    _validation = {
        'stage_name': {'required': True},
        'send_notification': {'required': True},
    }

    _attribute_map = {
        'stage_name': {'key': 'stageName', 'type': 'str'},
        'send_notification': {'key': 'sendNotification', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        stage_name: Union[str, "NotificationStageName"],
        send_notification: bool,
        **kwargs
    ):
        super(NotificationPreference, self).__init__(**kwargs)
        self.stage_name = stage_name
        self.send_notification = send_notification


class Operation(msrest.serialization.Model):
    """Operation entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation. Format:
     {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}.
    :vartype name: str
    :ivar display: Operation display values.
    :vartype display: ~azure.mgmt.databox.models.OperationDisplay
    :ivar properties: Operation properties.
    :vartype properties: object
    :ivar origin: Origin of the operation. Can be : user|system|user,system.
    :vartype origin: str
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'properties': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'object'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.properties = None
        self.origin = None


class OperationDisplay(msrest.serialization.Model):
    """Operation display.

    :param provider: Provider name.
    :type provider: str
    :param resource: Resource name.
    :type resource: str
    :param operation: Localized name of the operation for display purpose.
    :type operation: str
    :param description: Localized description of the operation for display purpose.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(msrest.serialization.Model):
    """Operation Collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations.
    :vartype value: list[~azure.mgmt.databox.models.Operation]
    :param next_link: Link for the next set of operations.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class PackageShippingDetails(msrest.serialization.Model):
    """Shipping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking Id of shipment.
    :vartype tracking_id: str
    :ivar tracking_url: Url where shipment can be tracked.
    :vartype tracking_url: str
    """

    _validation = {
        'carrier_name': {'readonly': True},
        'tracking_id': {'readonly': True},
        'tracking_url': {'readonly': True},
    }

    _attribute_map = {
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PackageShippingDetails, self).__init__(**kwargs)
        self.carrier_name = None
        self.tracking_id = None
        self.tracking_url = None


class Preferences(msrest.serialization.Model):
    """Preferences related to the order.

    :param preferred_data_center_region: Preferred Data Center Region.
    :type preferred_data_center_region: list[str]
    :param transport_preferences: Preferences related to the shipment logistics of the sku.
    :type transport_preferences: ~azure.mgmt.databox.models.TransportPreferences
    """

    _attribute_map = {
        'preferred_data_center_region': {'key': 'preferredDataCenterRegion', 'type': '[str]'},
        'transport_preferences': {'key': 'transportPreferences', 'type': 'TransportPreferences'},
    }

    def __init__(
        self,
        *,
        preferred_data_center_region: Optional[List[str]] = None,
        transport_preferences: Optional["TransportPreferences"] = None,
        **kwargs
    ):
        super(Preferences, self).__init__(**kwargs)
        self.preferred_data_center_region = preferred_data_center_region
        self.transport_preferences = transport_preferences


class PreferencesValidationRequest(ValidationInputRequest):
    """Request to validate preference of transport and data center.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param preference: Preference requested with respect to transport type and data center.
    :type preference: ~azure.mgmt.databox.models.Preferences
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'preference': {'key': 'preference', 'type': 'Preferences'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_type: Union[str, "SkuName"],
        preference: Optional["Preferences"] = None,
        **kwargs
    ):
        super(PreferencesValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidatePreferences'  # type: str
        self.preference = preference
        self.device_type = device_type


class PreferencesValidationResponseProperties(ValidationInputResponse):
    """Properties of data center and transport preference validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar status: Validation status of requested data center and transport. Possible values
     include: "Valid", "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PreferencesValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidatePreferences'  # type: str
        self.status = None


class RegionConfigurationRequest(msrest.serialization.Model):
    """Request body to get the configuration for the region.

    :param schedule_availability_request: Request body to get the availability for scheduling
     orders.
    :type schedule_availability_request: ~azure.mgmt.databox.models.ScheduleAvailabilityRequest
    :param transport_availability_request: Request body to get the transport availability for given
     sku.
    :type transport_availability_request: ~azure.mgmt.databox.models.TransportAvailabilityRequest
    """

    _attribute_map = {
        'schedule_availability_request': {'key': 'scheduleAvailabilityRequest', 'type': 'ScheduleAvailabilityRequest'},
        'transport_availability_request': {'key': 'transportAvailabilityRequest', 'type': 'TransportAvailabilityRequest'},
    }

    def __init__(
        self,
        *,
        schedule_availability_request: Optional["ScheduleAvailabilityRequest"] = None,
        transport_availability_request: Optional["TransportAvailabilityRequest"] = None,
        **kwargs
    ):
        super(RegionConfigurationRequest, self).__init__(**kwargs)
        self.schedule_availability_request = schedule_availability_request
        self.transport_availability_request = transport_availability_request


class RegionConfigurationResponse(msrest.serialization.Model):
    """Configuration response specific to a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schedule_availability_response: Schedule availability for given sku in a region.
    :vartype schedule_availability_response:
     ~azure.mgmt.databox.models.ScheduleAvailabilityResponse
    :ivar transport_availability_response: Transport options available for given sku in a region.
    :vartype transport_availability_response:
     ~azure.mgmt.databox.models.TransportAvailabilityResponse
    """

    _validation = {
        'schedule_availability_response': {'readonly': True},
        'transport_availability_response': {'readonly': True},
    }

    _attribute_map = {
        'schedule_availability_response': {'key': 'scheduleAvailabilityResponse', 'type': 'ScheduleAvailabilityResponse'},
        'transport_availability_response': {'key': 'transportAvailabilityResponse', 'type': 'TransportAvailabilityResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionConfigurationResponse, self).__init__(**kwargs)
        self.schedule_availability_response = None
        self.transport_availability_response = None


class ScheduleAvailabilityResponse(msrest.serialization.Model):
    """Schedule availability response for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar available_dates: List of dates available to schedule.
    :vartype available_dates: list[~datetime.datetime]
    """

    _validation = {
        'available_dates': {'readonly': True},
    }

    _attribute_map = {
        'available_dates': {'key': 'availableDates', 'type': '[iso-8601]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduleAvailabilityResponse, self).__init__(**kwargs)
        self.available_dates = None


class ShareCredentialDetails(msrest.serialization.Model):
    """Credential details of the shares in account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar share_name: Name of the share.
    :vartype share_name: str
    :ivar share_type: Type of the share. Possible values include: "UnknownType", "HCS",
     "BlockBlob", "PageBlob", "AzureFile", "ManagedDisk".
    :vartype share_type: str or ~azure.mgmt.databox.models.ShareDestinationFormatType
    :ivar user_name: User name for the share.
    :vartype user_name: str
    :ivar password: Password for the share.
    :vartype password: str
    :ivar supported_access_protocols: Access protocols supported on the device.
    :vartype supported_access_protocols: list[str or ~azure.mgmt.databox.models.AccessProtocol]
    """

    _validation = {
        'share_name': {'readonly': True},
        'share_type': {'readonly': True},
        'user_name': {'readonly': True},
        'password': {'readonly': True},
        'supported_access_protocols': {'readonly': True},
    }

    _attribute_map = {
        'share_name': {'key': 'shareName', 'type': 'str'},
        'share_type': {'key': 'shareType', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'supported_access_protocols': {'key': 'supportedAccessProtocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShareCredentialDetails, self).__init__(**kwargs)
        self.share_name = None
        self.share_type = None
        self.user_name = None
        self.password = None
        self.supported_access_protocols = None


class ShipmentPickUpRequest(msrest.serialization.Model):
    """Shipment pick up request details.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. Minimum date after which the pick up should commence, this must be
     in local time of pick up area.
    :type start_time: ~datetime.datetime
    :param end_time: Required. Maximum date before which the pick up should commence, this must be
     in local time of pick up area.
    :type end_time: ~datetime.datetime
    :param shipment_location: Required. Shipment Location in the pickup place. Eg.front desk.
    :type shipment_location: str
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
        'shipment_location': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'shipment_location': {'key': 'shipmentLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        shipment_location: str,
        **kwargs
    ):
        super(ShipmentPickUpRequest, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.shipment_location = shipment_location


class ShipmentPickUpResponse(msrest.serialization.Model):
    """Shipment pick up response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confirmation_number: Confirmation number for the pick up request.
    :vartype confirmation_number: str
    :ivar ready_by_time: Time by which shipment should be ready for pick up, this is in local time
     of pick up area.
    :vartype ready_by_time: ~datetime.datetime
    """

    _validation = {
        'confirmation_number': {'readonly': True},
        'ready_by_time': {'readonly': True},
    }

    _attribute_map = {
        'confirmation_number': {'key': 'confirmationNumber', 'type': 'str'},
        'ready_by_time': {'key': 'readyByTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShipmentPickUpResponse, self).__init__(**kwargs)
        self.confirmation_number = None
        self.ready_by_time = None


class ShippingAddress(msrest.serialization.Model):
    """Shipping address where customer wishes to receive the device.

    All required parameters must be populated in order to send to Azure.

    :param street_address1: Required. Street Address line 1.
    :type street_address1: str
    :param street_address2: Street Address line 2.
    :type street_address2: str
    :param street_address3: Street Address line 3.
    :type street_address3: str
    :param city: Name of the City.
    :type city: str
    :param state_or_province: Name of the State or Province.
    :type state_or_province: str
    :param country: Required. Name of the Country.
    :type country: str
    :param postal_code: Required. Postal code.
    :type postal_code: str
    :param zip_extended_code: Extended Zip Code.
    :type zip_extended_code: str
    :param company_name: Name of the company.
    :type company_name: str
    :param address_type: Type of address. Possible values include: "None", "Residential",
     "Commercial".
    :type address_type: str or ~azure.mgmt.databox.models.AddressType
    """

    _validation = {
        'street_address1': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
    }

    _attribute_map = {
        'street_address1': {'key': 'streetAddress1', 'type': 'str'},
        'street_address2': {'key': 'streetAddress2', 'type': 'str'},
        'street_address3': {'key': 'streetAddress3', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state_or_province': {'key': 'stateOrProvince', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'zip_extended_code': {'key': 'zipExtendedCode', 'type': 'str'},
        'company_name': {'key': 'companyName', 'type': 'str'},
        'address_type': {'key': 'addressType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        street_address1: str,
        country: str,
        postal_code: str,
        street_address2: Optional[str] = None,
        street_address3: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        zip_extended_code: Optional[str] = None,
        company_name: Optional[str] = None,
        address_type: Optional[Union[str, "AddressType"]] = None,
        **kwargs
    ):
        super(ShippingAddress, self).__init__(**kwargs)
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.street_address3 = street_address3
        self.city = city
        self.state_or_province = state_or_province
        self.country = country
        self.postal_code = postal_code
        self.zip_extended_code = zip_extended_code
        self.company_name = company_name
        self.address_type = address_type


class Sku(msrest.serialization.Model):
    """The Sku.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The sku name. Possible values include: "DataBox", "DataBoxDisk",
     "DataBoxHeavy".
    :type name: str or ~azure.mgmt.databox.models.SkuName
    :param display_name: The display name of the sku.
    :type display_name: str
    :param family: The sku family.
    :type family: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        display_name: Optional[str] = None,
        family: Optional[str] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.family = family


class SkuAvailabilityValidationRequest(ValidationInputRequest):
    """Request to validate sku availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    :ivar transfer_type: Required. Type of the transfer. Default value: "ImportToAzure".
    :vartype transfer_type: str
    :param country: Required. ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements.
    :type country: str
    :param location: Required. Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
    :type location: str
    """

    _validation = {
        'validation_type': {'required': True},
        'device_type': {'required': True},
        'transfer_type': {'required': True, 'constant': True},
        'country': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'transfer_type': {'key': 'transferType', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    transfer_type = "ImportToAzure"

    def __init__(
        self,
        *,
        device_type: Union[str, "SkuName"],
        country: str,
        location: str,
        **kwargs
    ):
        super(SkuAvailabilityValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateSkuAvailability'  # type: str
        self.device_type = device_type
        self.country = country
        self.location = location


class SkuAvailabilityValidationResponseProperties(ValidationInputResponse):
    """Properties of sku availability validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar status: Sku availability validation status. Possible values include: "Valid", "Invalid",
     "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuAvailabilityValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateSkuAvailability'  # type: str
        self.status = None


class SkuCapacity(msrest.serialization.Model):
    """Capacity of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar usable: Usable capacity in TB.
    :vartype usable: str
    :ivar maximum: Maximum capacity in TB.
    :vartype maximum: str
    """

    _validation = {
        'usable': {'readonly': True},
        'maximum': {'readonly': True},
    }

    _attribute_map = {
        'usable': {'key': 'usable', 'type': 'str'},
        'maximum': {'key': 'maximum', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapacity, self).__init__(**kwargs)
        self.usable = None
        self.maximum = None


class SkuCost(msrest.serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Meter id of the Sku.
    :vartype meter_id: str
    :ivar meter_type: The type of the meter.
    :vartype meter_type: str
    """

    _validation = {
        'meter_id': {'readonly': True},
        'meter_type': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterId', 'type': 'str'},
        'meter_type': {'key': 'meterType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCost, self).__init__(**kwargs)
        self.meter_id = None
        self.meter_type = None


class SkuInformation(msrest.serialization.Model):
    """Information of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.databox.models.Sku
    :ivar enabled: The sku is enabled or not.
    :vartype enabled: bool
    :ivar destination_to_service_location_map: The map of destination location to service location.
    :vartype destination_to_service_location_map:
     list[~azure.mgmt.databox.models.DestinationToServiceLocationMap]
    :ivar capacity: Capacity of the Sku.
    :vartype capacity: ~azure.mgmt.databox.models.SkuCapacity
    :ivar costs: Cost of the Sku.
    :vartype costs: list[~azure.mgmt.databox.models.SkuCost]
    :ivar api_versions: Api versions that support this Sku.
    :vartype api_versions: list[str]
    :ivar disabled_reason: Reason why the Sku is disabled. Possible values include: "None",
     "Country", "Region", "Feature", "OfferType", "NoSubscriptionInfo".
    :vartype disabled_reason: str or ~azure.mgmt.databox.models.SkuDisabledReason
    :ivar disabled_reason_message: Message for why the Sku is disabled.
    :vartype disabled_reason_message: str
    :ivar required_feature: Required feature to access the sku.
    :vartype required_feature: str
    """

    _validation = {
        'sku': {'readonly': True},
        'enabled': {'readonly': True},
        'destination_to_service_location_map': {'readonly': True},
        'capacity': {'readonly': True},
        'costs': {'readonly': True},
        'api_versions': {'readonly': True},
        'disabled_reason': {'readonly': True},
        'disabled_reason_message': {'readonly': True},
        'required_feature': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'destination_to_service_location_map': {'key': 'properties.destinationToServiceLocationMap', 'type': '[DestinationToServiceLocationMap]'},
        'capacity': {'key': 'properties.capacity', 'type': 'SkuCapacity'},
        'costs': {'key': 'properties.costs', 'type': '[SkuCost]'},
        'api_versions': {'key': 'properties.apiVersions', 'type': '[str]'},
        'disabled_reason': {'key': 'properties.disabledReason', 'type': 'str'},
        'disabled_reason_message': {'key': 'properties.disabledReasonMessage', 'type': 'str'},
        'required_feature': {'key': 'properties.requiredFeature', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInformation, self).__init__(**kwargs)
        self.sku = None
        self.enabled = None
        self.destination_to_service_location_map = None
        self.capacity = None
        self.costs = None
        self.api_versions = None
        self.disabled_reason = None
        self.disabled_reason_message = None
        self.required_feature = None


class SubscriptionIsAllowedToCreateJobValidationRequest(ValidationInputRequest):
    """Request to validate subscription permission to create jobs.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    """

    _validation = {
        'validation_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionIsAllowedToCreateJobValidationRequest, self).__init__(**kwargs)
        self.validation_type = 'ValidateSubscriptionIsAllowedToCreateJob'  # type: str


class SubscriptionIsAllowedToCreateJobValidationResponseProperties(ValidationInputResponse):
    """Properties of subscription permission to create job validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation response.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.models.Error
    :ivar status: Validation status of subscription permission to create job. Possible values
     include: "Valid", "Invalid", "Skipped".
    :vartype status: str or ~azure.mgmt.databox.models.ValidationStatus
    """

    _validation = {
        'validation_type': {'required': True},
        'error': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionIsAllowedToCreateJobValidationResponseProperties, self).__init__(**kwargs)
        self.validation_type = 'ValidateSubscriptionIsAllowedToCreateJob'  # type: str
        self.status = None


class TransportAvailabilityDetails(msrest.serialization.Model):
    """Transport options availability details for given region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar shipment_type: Transport Shipment Type supported for given region. Possible values
     include: "CustomerManaged", "MicrosoftManaged".
    :vartype shipment_type: str or ~azure.mgmt.databox.models.TransportShipmentTypes
    """

    _validation = {
        'shipment_type': {'readonly': True},
    }

    _attribute_map = {
        'shipment_type': {'key': 'shipmentType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportAvailabilityDetails, self).__init__(**kwargs)
        self.shipment_type = None


class TransportAvailabilityRequest(msrest.serialization.Model):
    """Request body to get the transport availability for given sku.

    :param sku_name: Type of the device. Possible values include: "DataBox", "DataBoxDisk",
     "DataBoxHeavy".
    :type sku_name: str or ~azure.mgmt.databox.models.SkuName
    """

    _attribute_map = {
        'sku_name': {'key': 'skuName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku_name: Optional[Union[str, "SkuName"]] = None,
        **kwargs
    ):
        super(TransportAvailabilityRequest, self).__init__(**kwargs)
        self.sku_name = sku_name


class TransportAvailabilityResponse(msrest.serialization.Model):
    """Transport options available for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar transport_availability_details: List of transport availability details for given region.
    :vartype transport_availability_details:
     list[~azure.mgmt.databox.models.TransportAvailabilityDetails]
    """

    _validation = {
        'transport_availability_details': {'readonly': True},
    }

    _attribute_map = {
        'transport_availability_details': {'key': 'transportAvailabilityDetails', 'type': '[TransportAvailabilityDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransportAvailabilityResponse, self).__init__(**kwargs)
        self.transport_availability_details = None


class TransportPreferences(msrest.serialization.Model):
    """Preferences related to the shipment logistics of the sku.

    All required parameters must be populated in order to send to Azure.

    :param preferred_shipment_type: Required. Indicates Shipment Logistics type that the customer
     preferred. Possible values include: "CustomerManaged", "MicrosoftManaged".
    :type preferred_shipment_type: str or ~azure.mgmt.databox.models.TransportShipmentTypes
    """

    _validation = {
        'preferred_shipment_type': {'required': True},
    }

    _attribute_map = {
        'preferred_shipment_type': {'key': 'preferredShipmentType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        preferred_shipment_type: Union[str, "TransportShipmentTypes"],
        **kwargs
    ):
        super(TransportPreferences, self).__init__(**kwargs)
        self.preferred_shipment_type = preferred_shipment_type


class UnencryptedCredentials(msrest.serialization.Model):
    """Unencrypted credentials for accessing device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: Name of the job.
    :vartype job_name: str
    :ivar job_secrets: Secrets related to this job.
    :vartype job_secrets: ~azure.mgmt.databox.models.JobSecrets
    """

    _validation = {
        'job_name': {'readonly': True},
        'job_secrets': {'readonly': True},
    }

    _attribute_map = {
        'job_name': {'key': 'jobName', 'type': 'str'},
        'job_secrets': {'key': 'jobSecrets', 'type': 'JobSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnencryptedCredentials, self).__init__(**kwargs)
        self.job_name = None
        self.job_secrets = None


class UnencryptedCredentialsList(msrest.serialization.Model):
    """List of unencrypted credentials for accessing device.

    :param value: List of unencrypted credentials.
    :type value: list[~azure.mgmt.databox.models.UnencryptedCredentials]
    :param next_link: Link for the next set of unencrypted credentials.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UnencryptedCredentials]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UnencryptedCredentials"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UnencryptedCredentialsList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateJobDetails(msrest.serialization.Model):
    """Job details for update.

    :param contact_details: Contact details for notification and shipping.
    :type contact_details: ~azure.mgmt.databox.models.ContactDetails
    :param shipping_address: Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    """

    _attribute_map = {
        'contact_details': {'key': 'contactDetails', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
    }

    def __init__(
        self,
        *,
        contact_details: Optional["ContactDetails"] = None,
        shipping_address: Optional["ShippingAddress"] = None,
        **kwargs
    ):
        super(UpdateJobDetails, self).__init__(**kwargs)
        self.contact_details = contact_details
        self.shipping_address = shipping_address


class ValidateAddress(ValidationInputRequest):
    """The requirements to validate customer address where the device needs to be shipped.

    All required parameters must be populated in order to send to Azure.

    :param validation_type: Required. Identifies the type of validation request.Constant filled by
     server.  Possible values include: "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     "ValidateSkuAvailability".
    :type validation_type: str or ~azure.mgmt.databox.models.ValidationInputDiscriminator
    :param shipping_address: Required. Shipping address of the customer.
    :type shipping_address: ~azure.mgmt.databox.models.ShippingAddress
    :param device_type: Required. Device type to be used for the job. Possible values include:
     "DataBox", "DataBoxDisk", "DataBoxHeavy".
    :type device_type: str or ~azure.mgmt.databox.models.SkuName
    :param transport_preferences: Preferences related to the shipment logistics of the sku.
    :type transport_preferences: ~azure.mgmt.databox.models.TransportPreferences
    """

    _validation = {
        'validation_type': {'required': True},
        'shipping_address': {'required': True},
        'device_type': {'required': True},
    }

    _attribute_map = {
        'validation_type': {'key': 'validationType', 'type': 'str'},
        'shipping_address': {'key': 'shippingAddress', 'type': 'ShippingAddress'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'transport_preferences': {'key': 'transportPreferences', 'type': 'TransportPreferences'},
    }

    def __init__(
        self,
        *,
        shipping_address: "ShippingAddress",
        device_type: Union[str, "SkuName"],
        transport_preferences: Optional["TransportPreferences"] = None,
        **kwargs
    ):
        super(ValidateAddress, self).__init__(**kwargs)
        self.validation_type = 'ValidateAddress'  # type: str
        self.shipping_address = shipping_address
        self.device_type = device_type
        self.transport_preferences = transport_preferences


class ValidationResponse(msrest.serialization.Model):
    """Response of pre job creation validations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Overall validation status. Possible values include: "AllValidToProceed",
     "InputsRevisitRequired", "CertainInputValidationsSkipped".
    :vartype status: str or ~azure.mgmt.databox.models.OverallValidationStatus
    :ivar individual_response_details: List of response details contain validationType and its
     response as key and value respectively.
    :vartype individual_response_details: list[~azure.mgmt.databox.models.ValidationInputResponse]
    """

    _validation = {
        'status': {'readonly': True},
        'individual_response_details': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'properties.status', 'type': 'str'},
        'individual_response_details': {'key': 'properties.individualResponseDetails', 'type': '[ValidationInputResponse]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationResponse, self).__init__(**kwargs)
        self.status = None
        self.individual_response_details = None
