/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class SignatureAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "Signature";
    private static final int LENGTH = 2;
    private int signatureIndex;

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.signatureIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.signatureIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        return 2;
    }

    protected void debug(String string) {
        super.debug(string + "Signature attribute with signature index " + this.signatureIndex);
    }
}

