# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.standbypool import StandbyPoolMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStandbyPoolMgmtStandbyContainerGroupPoolsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StandbyPoolMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_standby_container_group_pools_get(self, resource_group):
        response = self.client.standby_container_group_pools.get(
            resource_group_name=resource_group.name,
            standby_container_group_pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_standby_container_group_pools_begin_create_or_update(self, resource_group):
        response = self.client.standby_container_group_pools.begin_create_or_update(
            resource_group_name=resource_group.name,
            standby_container_group_pool_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "containerGroupProperties": {
                        "containerGroupProfile": {"id": "str", "revision": 0},
                        "subnetIds": [{"id": "str"}],
                    },
                    "elasticityProfile": {"maxReadyCapacity": 0, "refillPolicy": "str"},
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_standby_container_group_pools_begin_delete(self, resource_group):
        response = self.client.standby_container_group_pools.begin_delete(
            resource_group_name=resource_group.name,
            standby_container_group_pool_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_standby_container_group_pools_update(self, resource_group):
        response = self.client.standby_container_group_pools.update(
            resource_group_name=resource_group.name,
            standby_container_group_pool_name="str",
            properties={
                "properties": {
                    "containerGroupProperties": {
                        "containerGroupProfile": {"id": "str", "revision": 0},
                        "subnetIds": [{"id": "str"}],
                    },
                    "elasticityProfile": {"maxReadyCapacity": 0, "refillPolicy": "str"},
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_standby_container_group_pools_list_by_resource_group(self, resource_group):
        response = self.client.standby_container_group_pools.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_standby_container_group_pools_list_by_subscription(self, resource_group):
        response = self.client.standby_container_group_pools.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
