# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MeterDetails(Model):
    """The properties of the meter detail.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar meter_name: The name of the meter, within the given meter category
    :vartype meter_name: str
    :ivar meter_category: The category of the meter, for example, 'Cloud
     services', 'Networking', etc..
    :vartype meter_category: str
    :ivar meter_sub_category: The subcategory of the meter, for example, 'A6
     Cloud services', 'ExpressRoute (IXP)', etc..
    :vartype meter_sub_category: str
    :ivar unit: The unit in which the meter consumption is charged, for
     example, 'Hours', 'GB', etc.
    :vartype unit: str
    :ivar meter_location: The location in which the Azure service is
     available.
    :vartype meter_location: str
    :ivar total_included_quantity: The total included quantity associated with
     the offer.
    :vartype total_included_quantity: decimal.Decimal
    :ivar pretax_standard_rate: The pretax listing price.
    :vartype pretax_standard_rate: decimal.Decimal
    :ivar service_name: The name of the service.
    :vartype service_name: str
    :ivar service_tier: The service tier.
    :vartype service_tier: str
    """

    _validation = {
        'meter_name': {'readonly': True},
        'meter_category': {'readonly': True},
        'meter_sub_category': {'readonly': True},
        'unit': {'readonly': True},
        'meter_location': {'readonly': True},
        'total_included_quantity': {'readonly': True},
        'pretax_standard_rate': {'readonly': True},
        'service_name': {'readonly': True},
        'service_tier': {'readonly': True},
    }

    _attribute_map = {
        'meter_name': {'key': 'meterName', 'type': 'str'},
        'meter_category': {'key': 'meterCategory', 'type': 'str'},
        'meter_sub_category': {'key': 'meterSubCategory', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'meter_location': {'key': 'meterLocation', 'type': 'str'},
        'total_included_quantity': {'key': 'totalIncludedQuantity', 'type': 'decimal'},
        'pretax_standard_rate': {'key': 'pretaxStandardRate', 'type': 'decimal'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'service_tier': {'key': 'serviceTier', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(MeterDetails, self).__init__(**kwargs)
        self.meter_name = None
        self.meter_category = None
        self.meter_sub_category = None
        self.unit = None
        self.meter_location = None
        self.total_included_quantity = None
        self.pretax_standard_rate = None
        self.service_name = None
        self.service_tier = None
