# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SourceControlSyncJobStream(Model):
    """Definition of the source control sync job stream.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :param source_control_sync_job_stream_id: The sync job stream id.
    :type source_control_sync_job_stream_id: str
    :param summary: The summary of the sync job stream.
    :type summary: str
    :ivar time: The time of the sync job stream.
    :vartype time: datetime
    :param stream_type: The type of the sync job stream. Possible values
     include: 'Error', 'Output'
    :type stream_type: str or ~azure.mgmt.automation.models.StreamType
    """

    _validation = {
        'id': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'source_control_sync_job_stream_id': {'key': 'properties.sourceControlSyncJobStreamId', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'stream_type': {'key': 'properties.streamType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SourceControlSyncJobStream, self).__init__(**kwargs)
        self.id = None
        self.source_control_sync_job_stream_id = kwargs.get('source_control_sync_job_stream_id', None)
        self.summary = kwargs.get('summary', None)
        self.time = None
        self.stream_type = kwargs.get('stream_type', None)
