/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class UntypedAtomicConverter
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private AtomicType requiredItemType;

    public UntypedAtomicConverter(Expression expression, AtomicType atomicType) {
        this.sequence = expression;
        this.requiredItemType = atomicType;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        ItemType itemType = this.sequence.getItemType();
        if (itemType instanceof NodeTest) {
            return this;
        }
        if (itemType == Type.ATOMIC_TYPE || itemType instanceof AnyItemType || itemType == Type.UNTYPED_ATOMIC_TYPE) {
            return this;
        }
        return this.sequence;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)item).convert(this.requiredItemType);
        }
        return item;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        if (item instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)item).convert(this.requiredItemType);
        }
        return item;
    }

    public ItemType getItemType() {
        return this.sequence.getItemType();
    }

    public int computeCardinality() {
        return this.sequence.getCardinality();
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "convert untyped atomic items to " + this.requiredItemType);
        this.sequence.display(n + 1, namePool);
    }
}

