/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class IntKeyHashtable
implements Cloneable {
    private transient Entry[] table_;
    private transient int count_;
    private int threshold_;
    private float loadFactor_;

    public IntKeyHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor_ = f;
        this.table_ = new Entry[n];
        this.threshold_ = (int)((float)n * this.loadFactor_);
    }

    public IntKeyHashtable(int n) {
        this(n, 0.75f);
    }

    public IntKeyHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count_;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table_;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table_;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table_.length;
        Entry[] entryArray = this.table_;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold_ = (int)((float)n2 * this.loadFactor_);
        this.table_ = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table_;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count_ >= this.threshold_) {
            this.rehash();
            return this.put(n, object);
        }
        entry = new Entry();
        entry.key = n;
        entry.value = object;
        entry.next = entryArray[n2];
        entryArray[n2] = entry;
        ++this.count_;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table_;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Object var5_5 = null;
        if (entry != null) {
            if (entry.key == n) {
                if (var5_5 != null) {
                    var5_5.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
            }
            --this.count_;
            return entry.value;
        }
        return null;
    }

    public void clear() {
        Entry[] entryArray = this.table_;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count_ = 0;
    }

    public Enumeration elements() {
        return new Enum(this.table_);
    }

    public int[] keys() {
        int[] nArray = new int[this.count_];
        Entry entry = null;
        int n = 0;
        int n2 = this.table_.length;
        while (n < this.count_) {
            if (entry == null) {
                while (n2-- > 0 && (entry = this.table_[n2]) == null) {
                }
            }
            nArray[n++] = entry.key;
            entry = entry.next;
        }
        return nArray;
    }

    public Object clone() {
        try {
            IntKeyHashtable intKeyHashtable = (IntKeyHashtable)super.clone();
            intKeyHashtable.table_ = new Entry[this.table_.length];
            int n = this.table_.length;
            while (n-- > 0) {
                intKeyHashtable.table_[n] = this.table_[n] != null ? (Entry)this.table_[n].clone() : null;
            }
            return intKeyHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static class Entry {
        int key;
        Object value;
        Entry next;

        private Entry() {
        }

        protected Object clone() {
            Entry entry = new Entry();
            entry.key = this.key;
            entry.value = this.value;
            entry.next = this.next != null ? (Entry)this.next.clone() : null;
            return entry;
        }
    }

    private static class Enum
    implements Enumeration {
        int index;
        Entry[] table;
        Entry entry;

        Enum(Entry[] entryArray) {
            this.table = entryArray;
            this.index = entryArray.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry entry = this.entry;
                this.entry = entry.next;
                return entry.value;
            }
            throw new NoSuchElementException("Enum");
        }
    }
}

