# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._container_registry_management_client_enums import *


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None


class AgentPool(Resource):
    """The agentpool that has the ARM resource and properties. 
The agentpool will have all information to create an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SystemData
    :ivar count: The count of agent machine.
    :vartype count: int
    :ivar tier: The Tier of agent machine.
    :vartype tier: str
    :ivar os: The OS of agent machine. Possible values include: "Windows", "Linux".
    :vartype os: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OS
    :ivar virtual_network_subnet_resource_id: The Virtual Network Subnet Resource Id of the agent
     machine.
    :vartype virtual_network_subnet_resource_id: str
    :ivar provisioning_state: The provisioning state of this agent pool. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'tier': {'key': 'properties.tier', 'type': 'str'},
        'os': {'key': 'properties.os', 'type': 'str'},
        'virtual_network_subnet_resource_id': {'key': 'properties.virtualNetworkSubnetResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        count: Optional[int] = None,
        tier: Optional[str] = None,
        os: Optional[Union[str, "OS"]] = None,
        virtual_network_subnet_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword count: The count of agent machine.
        :paramtype count: int
        :keyword tier: The Tier of agent machine.
        :paramtype tier: str
        :keyword os: The OS of agent machine. Possible values include: "Windows", "Linux".
        :paramtype os: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OS
        :keyword virtual_network_subnet_resource_id: The Virtual Network Subnet Resource Id of the
         agent machine.
        :paramtype virtual_network_subnet_resource_id: str
        """
        super(AgentPool, self).__init__(location=location, tags=tags, **kwargs)
        self.count = count
        self.tier = tier
        self.os = os
        self.virtual_network_subnet_resource_id = virtual_network_subnet_resource_id
        self.provisioning_state = None


class AgentPoolListResult(msrest.serialization.Model):
    """The collection of agent pools.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentPool]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AgentPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AgentPool"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentPool]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super(AgentPoolListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AgentPoolQueueStatus(msrest.serialization.Model):
    """The QueueStatus of Agent Pool.

    :ivar count: The number of pending runs in the queue.
    :vartype count: int
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword count: The number of pending runs in the queue.
        :paramtype count: int
        """
        super(AgentPoolQueueStatus, self).__init__(**kwargs)
        self.count = count


class AgentPoolUpdateParameters(msrest.serialization.Model):
    """The parameters for updating an agent pool.

    :ivar tags: A set of tags. The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar count: The count of agent machine.
    :vartype count: int
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'count': {'key': 'properties.count', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword count: The count of agent machine.
        :paramtype count: int
        """
        super(AgentPoolUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.count = count


class AgentProperties(msrest.serialization.Model):
    """The properties that determine the run agent configuration.

    :ivar cpu: The CPU configuration in terms of number of cores required for the run.
    :vartype cpu: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        cpu: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword cpu: The CPU configuration in terms of number of cores required for the run.
        :paramtype cpu: int
        """
        super(AgentProperties, self).__init__(**kwargs)
        self.cpu = cpu


class Argument(msrest.serialization.Model):
    """The properties of a run argument.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the argument.
    :vartype name: str
    :ivar value: Required. The value of the argument.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :vartype is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        is_secret: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the argument.
        :paramtype name: str
        :keyword value: Required. The value of the argument.
        :paramtype value: str
        :keyword is_secret: Flag to indicate whether the argument represents a secret and want to be
         removed from build logs.
        :paramtype is_secret: bool
        """
        super(Argument, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.is_secret = is_secret


class AuthInfo(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to Azure.

    :ivar token_type: Required. The type of Auth token. Possible values include: "PAT", "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TokenType
    :ivar token: Required. The access token used to access the source control provider.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    _validation = {
        'token_type': {'required': True},
        'token': {'required': True},
    }

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        token_type: Union[str, "TokenType"],
        token: str,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword token_type: Required. The type of Auth token. Possible values include: "PAT", "OAuth".
        :paramtype token_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TokenType
        :keyword token: Required. The access token used to access the source control provider.
        :paramtype token: str
        :keyword refresh_token: The refresh token used to refresh the access token.
        :paramtype refresh_token: str
        :keyword scope: The scope of the access token.
        :paramtype scope: str
        :keyword expires_in: Time in seconds that the token remains valid.
        :paramtype expires_in: int
        """
        super(AuthInfo, self).__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class AuthInfoUpdateParameters(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    :ivar token_type: The type of Auth token. Possible values include: "PAT", "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TokenType
    :ivar token: The access token used to access the source control provider.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        token_type: Optional[Union[str, "TokenType"]] = None,
        token: Optional[str] = None,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword token_type: The type of Auth token. Possible values include: "PAT", "OAuth".
        :paramtype token_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TokenType
        :keyword token: The access token used to access the source control provider.
        :paramtype token: str
        :keyword refresh_token: The refresh token used to refresh the access token.
        :paramtype refresh_token: str
        :keyword scope: The scope of the access token.
        :paramtype scope: str
        :keyword expires_in: Time in seconds that the token remains valid.
        :paramtype expires_in: int
        """
        super(AuthInfoUpdateParameters, self).__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class BaseImageDependency(msrest.serialization.Model):
    """Properties that describe a base image dependency.

    :ivar type: The type of the base image dependency. Possible values include: "BuildTime",
     "RunTime".
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageDependencyType
    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "BaseImageDependencyType"]] = None,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The type of the base image dependency. Possible values include: "BuildTime",
         "RunTime".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageDependencyType
        :keyword registry: The registry login server.
        :paramtype registry: str
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword digest: The sha256-based digest of the image manifest.
        :paramtype digest: str
        """
        super(BaseImageDependency, self).__init__(**kwargs)
        self.type = type
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class BaseImageTrigger(msrest.serialization.Model):
    """The trigger based on base image dependency.

    All required parameters must be populated in order to send to Azure.

    :ivar base_image_trigger_type: Required. The type of the auto trigger for base image dependency
     updates. Possible values include: "All", "Runtime".
    :vartype base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTriggerType
    :ivar update_trigger_endpoint: The endpoint URL for receiving update triggers.
    :vartype update_trigger_endpoint: str
    :ivar update_trigger_payload_type: Type of Payload body for Base image update triggers.
     Possible values include: "Default", "Token".
    :vartype update_trigger_payload_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.UpdateTriggerPayloadType
    :ivar status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
    :ivar name: Required. The name of the trigger.
    :vartype name: str
    """

    _validation = {
        'base_image_trigger_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'update_trigger_endpoint': {'key': 'updateTriggerEndpoint', 'type': 'str'},
        'update_trigger_payload_type': {'key': 'updateTriggerPayloadType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        base_image_trigger_type: Union[str, "BaseImageTriggerType"],
        name: str,
        update_trigger_endpoint: Optional[str] = None,
        update_trigger_payload_type: Optional[Union[str, "UpdateTriggerPayloadType"]] = None,
        status: Optional[Union[str, "TriggerStatus"]] = None,
        **kwargs
    ):
        """
        :keyword base_image_trigger_type: Required. The type of the auto trigger for base image
         dependency updates. Possible values include: "All", "Runtime".
        :paramtype base_image_trigger_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTriggerType
        :keyword update_trigger_endpoint: The endpoint URL for receiving update triggers.
        :paramtype update_trigger_endpoint: str
        :keyword update_trigger_payload_type: Type of Payload body for Base image update triggers.
         Possible values include: "Default", "Token".
        :paramtype update_trigger_payload_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.UpdateTriggerPayloadType
        :keyword status: The current status of trigger. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
        :keyword name: Required. The name of the trigger.
        :paramtype name: str
        """
        super(BaseImageTrigger, self).__init__(**kwargs)
        self.base_image_trigger_type = base_image_trigger_type
        self.update_trigger_endpoint = update_trigger_endpoint
        self.update_trigger_payload_type = update_trigger_payload_type
        self.status = status
        self.name = name


class BaseImageTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating base image dependency trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Possible values include: "All", "Runtime".
    :vartype base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTriggerType
    :ivar update_trigger_endpoint: The endpoint URL for receiving update triggers.
    :vartype update_trigger_endpoint: str
    :ivar update_trigger_payload_type: Type of Payload body for Base image update triggers.
     Possible values include: "Default", "Token".
    :vartype update_trigger_payload_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.UpdateTriggerPayloadType
    :ivar status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
    :ivar name: Required. The name of the trigger.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'update_trigger_endpoint': {'key': 'updateTriggerEndpoint', 'type': 'str'},
        'update_trigger_payload_type': {'key': 'updateTriggerPayloadType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        base_image_trigger_type: Optional[Union[str, "BaseImageTriggerType"]] = None,
        update_trigger_endpoint: Optional[str] = None,
        update_trigger_payload_type: Optional[Union[str, "UpdateTriggerPayloadType"]] = None,
        status: Optional[Union[str, "TriggerStatus"]] = None,
        **kwargs
    ):
        """
        :keyword base_image_trigger_type: The type of the auto trigger for base image dependency
         updates. Possible values include: "All", "Runtime".
        :paramtype base_image_trigger_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTriggerType
        :keyword update_trigger_endpoint: The endpoint URL for receiving update triggers.
        :paramtype update_trigger_endpoint: str
        :keyword update_trigger_payload_type: Type of Payload body for Base image update triggers.
         Possible values include: "Default", "Token".
        :paramtype update_trigger_payload_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.UpdateTriggerPayloadType
        :keyword status: The current status of trigger. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
        :keyword name: Required. The name of the trigger.
        :paramtype name: str
        """
        super(BaseImageTriggerUpdateParameters, self).__init__(**kwargs)
        self.base_image_trigger_type = base_image_trigger_type
        self.update_trigger_endpoint = update_trigger_endpoint
        self.update_trigger_payload_type = update_trigger_payload_type
        self.status = status
        self.name = name


class Credentials(msrest.serialization.Model):
    """The parameters that describes a set of credentials that will be used when a run is invoked.

    :ivar source_registry: Describes the credential parameters for accessing the source registry.
    :vartype source_registry:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceRegistryCredentials
    :ivar custom_registries: Describes the credential parameters for accessing other custom
     registries. The key
     for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the registry.
    :vartype custom_registries: dict[str,
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.CustomRegistryCredentials]
    """

    _attribute_map = {
        'source_registry': {'key': 'sourceRegistry', 'type': 'SourceRegistryCredentials'},
        'custom_registries': {'key': 'customRegistries', 'type': '{CustomRegistryCredentials}'},
    }

    def __init__(
        self,
        *,
        source_registry: Optional["SourceRegistryCredentials"] = None,
        custom_registries: Optional[Dict[str, "CustomRegistryCredentials"]] = None,
        **kwargs
    ):
        """
        :keyword source_registry: Describes the credential parameters for accessing the source
         registry.
        :paramtype source_registry:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceRegistryCredentials
        :keyword custom_registries: Describes the credential parameters for accessing other custom
         registries. The key
         for the dictionary item will be the registry login server (myregistry.azurecr.io) and
         the value of the item will be the registry credentials for accessing the registry.
        :paramtype custom_registries: dict[str,
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.CustomRegistryCredentials]
        """
        super(Credentials, self).__init__(**kwargs)
        self.source_registry = source_registry
        self.custom_registries = custom_registries


class CustomRegistryCredentials(msrest.serialization.Model):
    """Describes the credentials that will be used to access a custom registry during a run.

    :ivar user_name: The username for logging into the custom registry.
    :vartype user_name: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SecretObject
    :ivar password: The password for logging into the custom registry. The password is a secret
     object that allows multiple ways of providing the value for it.
    :vartype password: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SecretObject
    :ivar identity: Indicates the managed identity assigned to the custom credential. If a
     user-assigned identity
     this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
     the case of a system-assigned identity, the Client ID will be determined by the runner. This
     identity may be used to authenticate to key vault to retrieve credentials or it may be the
     only
     source of authentication used for accessing the registry.
    :vartype identity: str
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'SecretObject'},
        'password': {'key': 'password', 'type': 'SecretObject'},
        'identity': {'key': 'identity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_name: Optional["SecretObject"] = None,
        password: Optional["SecretObject"] = None,
        identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_name: The username for logging into the custom registry.
        :paramtype user_name: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SecretObject
        :keyword password: The password for logging into the custom registry. The password is a secret
         object that allows multiple ways of providing the value for it.
        :paramtype password: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SecretObject
        :keyword identity: Indicates the managed identity assigned to the custom credential. If a
         user-assigned identity
         this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
         the case of a system-assigned identity, the Client ID will be determined by the runner. This
         identity may be used to authenticate to key vault to retrieve credentials or it may be the
         only
         source of authentication used for accessing the registry.
        :paramtype identity: str
        """
        super(CustomRegistryCredentials, self).__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.identity = identity


class RunRequest(msrest.serialization.Model):
    """The request parameters for scheduling a run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildRequest, EncodedTaskRunRequest, FileTaskRunRequest, TaskRunRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'agent_pool_name': {'key': 'agentPoolName', 'type': 'str'},
        'log_template': {'key': 'logTemplate', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'DockerBuildRequest': 'DockerBuildRequest', 'EncodedTaskRunRequest': 'EncodedTaskRunRequest', 'FileTaskRunRequest': 'FileTaskRunRequest', 'TaskRunRequest': 'TaskRunRequest'}
    }

    def __init__(
        self,
        *,
        is_archive_enabled: Optional[bool] = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        """
        super(RunRequest, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.is_archive_enabled = is_archive_enabled
        self.agent_pool_name = agent_pool_name
        self.log_template = log_template


class DockerBuildRequest(RunRequest):
    """The parameters for a docker quick build.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: Required. The Docker file path relative to the source location.
    :vartype docker_file_path: str
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar arguments: The collection of override arguments to be used when executing the run.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: Required. The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
    """

    _validation = {
        'type': {'required': True},
        'docker_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'agent_pool_name': {'key': 'agentPoolName', 'type': 'str'},
        'log_template': {'key': 'logTemplate', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        *,
        docker_file_path: str,
        platform: "PlatformProperties",
        is_archive_enabled: Optional[bool] = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = True,
        no_cache: Optional[bool] = False,
        target: Optional[str] = None,
        arguments: Optional[List["Argument"]] = None,
        timeout: Optional[int] = 3600,
        agent_configuration: Optional["AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["Credentials"] = None,
        **kwargs
    ):
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: Required. The Docker file path relative to the source location.
        :paramtype docker_file_path: str
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        :keyword arguments: The collection of override arguments to be used when executing the run.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword platform: Required. The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
        :keyword source_location: The URL(absolute or relative) of the source context. It can be an URL
         to a tar or git repository.
         If it is relative URL, the relative path should be obtained from calling
         listBuildSourceUploadUrl API.
        :paramtype source_location: str
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
        """
        super(DockerBuildRequest, self).__init__(is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs)
        self.type = 'DockerBuildRequest'  # type: str
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.target = target
        self.arguments = arguments
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials


class TaskStepProperties(msrest.serialization.Model):
    """Base properties for any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStep, EncodedTaskStep, FileTaskStep.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    """

    _validation = {
        'type': {'required': True},
        'base_image_dependencies': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStep', 'EncodedTask': 'EncodedTaskStep', 'FileTask': 'FileTaskStep'}
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        """
        super(TaskStepProperties, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.base_image_dependencies = None
        self.context_path = context_path
        self.context_access_token = context_access_token


class DockerBuildStep(TaskStepProperties):
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: Required. The Docker file path relative to the source context.
    :vartype docker_file_path: str
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar arguments: The collection of override arguments to be used when executing this build
     step.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
    """

    _validation = {
        'type': {'required': True},
        'base_image_dependencies': {'readonly': True},
        'docker_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
    }

    def __init__(
        self,
        *,
        docker_file_path: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = True,
        no_cache: Optional[bool] = False,
        target: Optional[str] = None,
        arguments: Optional[List["Argument"]] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: Required. The Docker file path relative to the source context.
        :paramtype docker_file_path: str
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        :keyword arguments: The collection of override arguments to be used when executing this build
         step.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
        """
        super(DockerBuildStep, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type = 'Docker'  # type: str
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.target = target
        self.arguments = arguments


class TaskStepUpdateParameters(msrest.serialization.Model):
    """Base properties for updating any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStepUpdateParameters, EncodedTaskStepUpdateParameters, FileTaskStepUpdateParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStepUpdateParameters', 'EncodedTask': 'EncodedTaskStepUpdateParameters', 'FileTask': 'FileTaskStepUpdateParameters'}
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        """
        super(TaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.context_path = context_path
        self.context_access_token = context_access_token


class DockerBuildStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating a docker build step.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source context.
    :vartype docker_file_path: str
    :ivar arguments: The collection of override arguments to be used when executing this build
     step.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        image_names: Optional[List[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        docker_file_path: Optional[str] = None,
        arguments: Optional[List["Argument"]] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword image_names: The fully qualified image names including the repository and tag.
        :paramtype image_names: list[str]
        :keyword is_push_enabled: The value of this property indicates whether the image built should
         be pushed to the registry or not.
        :paramtype is_push_enabled: bool
        :keyword no_cache: The value of this property indicates whether the image cache is enabled or
         not.
        :paramtype no_cache: bool
        :keyword docker_file_path: The Docker file path relative to the source context.
        :paramtype docker_file_path: str
        :keyword arguments: The collection of override arguments to be used when executing this build
         step.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        """
        super(DockerBuildStepUpdateParameters, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type = 'Docker'  # type: str
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.arguments = arguments
        self.target = target


class EncodedTaskRunRequest(RunRequest):
    """The parameters for a quick task run request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar encoded_task_content: Required. Base64 encoded value of the template/definition file
     content.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: Required. The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
    """

    _validation = {
        'type': {'required': True},
        'encoded_task_content': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'agent_pool_name': {'key': 'agentPoolName', 'type': 'str'},
        'log_template': {'key': 'logTemplate', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        *,
        encoded_task_content: str,
        platform: "PlatformProperties",
        is_archive_enabled: Optional[bool] = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        timeout: Optional[int] = 3600,
        agent_configuration: Optional["AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["Credentials"] = None,
        **kwargs
    ):
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword encoded_task_content: Required. Base64 encoded value of the template/definition file
         content.
        :paramtype encoded_task_content: str
        :keyword encoded_values_content: Base64 encoded value of the parameters/values file content.
        :paramtype encoded_values_content: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword platform: Required. The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
        :keyword source_location: The URL(absolute or relative) of the source context. It can be an URL
         to a tar or git repository.
         If it is relative URL, the relative path should be obtained from calling
         listBuildSourceUploadUrl API.
        :paramtype source_location: str
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
        """
        super(EncodedTaskRunRequest, self).__init__(is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs)
        self.type = 'EncodedTaskRunRequest'  # type: str
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials


class EncodedTaskStep(TaskStepProperties):
    """The properties of a encoded task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar encoded_task_content: Required. Base64 encoded value of the template/definition file
     content.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
        'base_image_dependencies': {'readonly': True},
        'encoded_task_content': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        *,
        encoded_task_content: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword encoded_task_content: Required. Base64 encoded value of the template/definition file
         content.
        :paramtype encoded_task_content: str
        :keyword encoded_values_content: Base64 encoded value of the parameters/values file content.
        :paramtype encoded_values_content: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        """
        super(EncodedTaskStep, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type = 'EncodedTask'  # type: str
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values


class EncodedTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating encoded task step.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        encoded_task_content: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword encoded_task_content: Base64 encoded value of the template/definition file content.
        :paramtype encoded_task_content: str
        :keyword encoded_values_content: Base64 encoded value of the parameters/values file content.
        :paramtype encoded_values_content: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        """
        super(EncodedTaskStepUpdateParameters, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type = 'EncodedTask'  # type: str
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values


class ErrorResponse(msrest.serialization.Model):
    """An error response from the Azure Container Registry service.

    :ivar error: Azure container registry build API error body.
    :vartype error: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ErrorResponseBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBody'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponseBody"] = None,
        **kwargs
    ):
        """
        :keyword error: Azure container registry build API error body.
        :paramtype error: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ErrorResponseBody
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ErrorResponseBody(msrest.serialization.Model):
    """An error response from the Azure Container Registry service.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. error code.
    :vartype code: str
    :ivar message: Required. error message.
    :vartype message: str
    :ivar target: target of the particular error.
    :vartype target: str
    :ivar details: an array of additional nested error response info objects, as described by this
     contract.
    :vartype details:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.InnerErrorDescription]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[InnerErrorDescription]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["InnerErrorDescription"]] = None,
        **kwargs
    ):
        """
        :keyword code: Required. error code.
        :paramtype code: str
        :keyword message: Required. error message.
        :paramtype message: str
        :keyword target: target of the particular error.
        :paramtype target: str
        :keyword details: an array of additional nested error response info objects, as described by
         this contract.
        :paramtype details:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.InnerErrorDescription]
        """
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class FileTaskRunRequest(RunRequest):
    """The request parameters for a scheduling run against a task file.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar task_file_path: Required. The template/definition file path relative to the source.
    :vartype task_file_path: str
    :ivar values_file_path: The values/parameters file path relative to the source.
    :vartype values_file_path: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: Required. The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
    """

    _validation = {
        'type': {'required': True},
        'task_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'agent_pool_name': {'key': 'agentPoolName', 'type': 'str'},
        'log_template': {'key': 'logTemplate', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        *,
        task_file_path: str,
        platform: "PlatformProperties",
        is_archive_enabled: Optional[bool] = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        timeout: Optional[int] = 3600,
        agent_configuration: Optional["AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["Credentials"] = None,
        **kwargs
    ):
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword task_file_path: Required. The template/definition file path relative to the source.
        :paramtype task_file_path: str
        :keyword values_file_path: The values/parameters file path relative to the source.
        :paramtype values_file_path: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword platform: Required. The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
        :keyword source_location: The URL(absolute or relative) of the source context. It can be an URL
         to a tar or git repository.
         If it is relative URL, the relative path should be obtained from calling
         listBuildSourceUploadUrl API.
        :paramtype source_location: str
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
        """
        super(FileTaskRunRequest, self).__init__(is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs)
        self.type = 'FileTaskRunRequest'  # type: str
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials


class FileTaskStep(TaskStepProperties):
    """The properties of a task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar task_file_path: Required. The task template/definition file path relative to the source
     context.
    :vartype task_file_path: str
    :ivar values_file_path: The task values/parameters file path relative to the source context.
    :vartype values_file_path: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
        'base_image_dependencies': {'readonly': True},
        'task_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        *,
        task_file_path: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword task_file_path: Required. The task template/definition file path relative to the
         source context.
        :paramtype task_file_path: str
        :keyword values_file_path: The task values/parameters file path relative to the source context.
        :paramtype values_file_path: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        """
        super(FileTaskStep, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type = 'FileTask'  # type: str
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values


class FileTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties of updating a task step.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server. Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar task_file_path: The task template/definition file path relative to the source context.
    :vartype task_file_path: str
    :ivar values_file_path: The values/parameters file path relative to the source context.
    :vartype values_file_path: str
    :ivar values: The collection of overridable values that can be passed when running a task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        task_file_path: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        **kwargs
    ):
        """
        :keyword context_path: The URL(absolute or relative) of the source context for the task step.
        :paramtype context_path: str
        :keyword context_access_token: The token (git PAT or SAS token of storage account blob)
         associated with the context for a step.
        :paramtype context_access_token: str
        :keyword task_file_path: The task template/definition file path relative to the source context.
        :paramtype task_file_path: str
        :keyword values_file_path: The values/parameters file path relative to the source context.
        :paramtype values_file_path: str
        :keyword values: The collection of overridable values that can be passed when running a task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        """
        super(FileTaskStepUpdateParameters, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.type = 'FileTask'  # type: str
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values


class IdentityProperties(msrest.serialization.Model):
    """Managed identity for the resource.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Possible values include: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", "None".
    :vartype type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.UserIdentityProperties]
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserIdentityProperties"]] = None,
        **kwargs
    ):
        """
        :keyword principal_id: The principal ID of resource identity.
        :paramtype principal_id: str
        :keyword tenant_id: The tenant ID of resource.
        :paramtype tenant_id: str
        :keyword type: The identity type. Possible values include: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", "None".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity
         dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
             providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.UserIdentityProperties]
        """
        super(IdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ImageDescriptor(msrest.serialization.Model):
    """Properties for a registry image.

    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    _attribute_map = {
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword registry: The registry login server.
        :paramtype registry: str
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword digest: The sha256-based digest of the image manifest.
        :paramtype digest: str
        """
        super(ImageDescriptor, self).__init__(**kwargs)
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ImageUpdateTrigger(msrest.serialization.Model):
    """The image update trigger that caused a build.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar timestamp: The timestamp when the image update happened.
    :vartype timestamp: ~datetime.datetime
    :ivar images: The list of image updates that caused the build.
    :vartype images: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageDescriptor]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'images': {'key': 'images', 'type': '[ImageDescriptor]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        images: Optional[List["ImageDescriptor"]] = None,
        **kwargs
    ):
        """
        :keyword id: The unique ID of the trigger.
        :paramtype id: str
        :keyword timestamp: The timestamp when the image update happened.
        :paramtype timestamp: ~datetime.datetime
        :keyword images: The list of image updates that caused the build.
        :paramtype images:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageDescriptor]
        """
        super(ImageUpdateTrigger, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.images = images


class InnerErrorDescription(msrest.serialization.Model):
    """inner error.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. error code.
    :vartype code: str
    :ivar message: Required. error message.
    :vartype message: str
    :ivar target: target of the particular error.
    :vartype target: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Required. error code.
        :paramtype code: str
        :keyword message: Required. error message.
        :paramtype message: str
        :keyword target: target of the particular error.
        :paramtype target: str
        """
        super(InnerErrorDescription, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class OverrideTaskStepProperties(msrest.serialization.Model):
    """OverrideTaskStepProperties.

    :ivar context_path: The source context against which run has to be queued.
    :vartype context_path: str
    :ivar file: The file against which run has to be queued.
    :vartype file: str
    :ivar arguments: Gets or sets the collection of override arguments to be used when
     executing a build step.
    :vartype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar values: The collection of overridable values that can be passed when running a Task.
    :vartype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
    :ivar update_trigger_token: Base64 encoded update trigger token that will be attached with the
     base image trigger webhook.
    :vartype update_trigger_token: str
    """

    _attribute_map = {
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'target': {'key': 'target', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'update_trigger_token': {'key': 'updateTriggerToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        file: Optional[str] = None,
        arguments: Optional[List["Argument"]] = None,
        target: Optional[str] = None,
        values: Optional[List["SetValue"]] = None,
        update_trigger_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword context_path: The source context against which run has to be queued.
        :paramtype context_path: str
        :keyword file: The file against which run has to be queued.
        :paramtype file: str
        :keyword arguments: Gets or sets the collection of override arguments to be used when
         executing a build step.
        :paramtype arguments: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Argument]
        :keyword target: The name of the target build stage for the docker build.
        :paramtype target: str
        :keyword values: The collection of overridable values that can be passed when running a Task.
        :paramtype values: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SetValue]
        :keyword update_trigger_token: Base64 encoded update trigger token that will be attached with
         the base image trigger webhook.
        :paramtype update_trigger_token: str
        """
        super(OverrideTaskStepProperties, self).__init__(**kwargs)
        self.context_path = context_path
        self.file = file
        self.arguments = arguments
        self.target = target
        self.values = values
        self.update_trigger_token = update_trigger_token


class PlatformProperties(msrest.serialization.Model):
    """The platform properties against which the run has to happen.

    All required parameters must be populated in order to send to Azure.

    :ivar os: Required. The operating system type required for the run. Possible values include:
     "Windows", "Linux".
    :vartype os: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OS
    :ivar architecture: The OS architecture. Possible values include: "amd64", "x86", "386", "arm",
     "arm64".
    :vartype architecture: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Architecture
    :ivar variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
    :vartype variant: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Variant
    """

    _validation = {
        'os': {'required': True},
    }

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os: Union[str, "OS"],
        architecture: Optional[Union[str, "Architecture"]] = None,
        variant: Optional[Union[str, "Variant"]] = None,
        **kwargs
    ):
        """
        :keyword os: Required. The operating system type required for the run. Possible values include:
         "Windows", "Linux".
        :paramtype os: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OS
        :keyword architecture: The OS architecture. Possible values include: "amd64", "x86", "386",
         "arm", "arm64".
        :paramtype architecture: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Architecture
        :keyword variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
        :paramtype variant: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Variant
        """
        super(PlatformProperties, self).__init__(**kwargs)
        self.os = os
        self.architecture = architecture
        self.variant = variant


class PlatformUpdateParameters(msrest.serialization.Model):
    """The properties for updating the platform configuration.

    :ivar os: The operating system type required for the run. Possible values include: "Windows",
     "Linux".
    :vartype os: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OS
    :ivar architecture: The OS architecture. Possible values include: "amd64", "x86", "386", "arm",
     "arm64".
    :vartype architecture: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Architecture
    :ivar variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
    :vartype variant: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Variant
    """

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os: Optional[Union[str, "OS"]] = None,
        architecture: Optional[Union[str, "Architecture"]] = None,
        variant: Optional[Union[str, "Variant"]] = None,
        **kwargs
    ):
        """
        :keyword os: The operating system type required for the run. Possible values include:
         "Windows", "Linux".
        :paramtype os: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OS
        :keyword architecture: The OS architecture. Possible values include: "amd64", "x86", "386",
         "arm", "arm64".
        :paramtype architecture: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Architecture
        :keyword variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
        :paramtype variant: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Variant
        """
        super(PlatformUpdateParameters, self).__init__(**kwargs)
        self.os = os
        self.architecture = architecture
        self.variant = variant


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class Run(ProxyResource):
    """Run resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SystemData
    :ivar run_id: The unique identifier for the run.
    :vartype run_id: str
    :ivar status: The current status of the run. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunStatus
    :ivar last_updated_time: The last updated time for the run.
    :vartype last_updated_time: ~datetime.datetime
    :ivar run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
     "AutoBuild", "AutoRun".
    :vartype run_type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunType
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar create_time: The time the run was scheduled.
    :vartype create_time: ~datetime.datetime
    :ivar start_time: The time the run started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The time the run finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_images: The list of all images that were generated from the run. This is
     applicable if the run generates base image dependencies.
    :vartype output_images:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageDescriptor]
    :ivar task: The task against which run was scheduled.
    :vartype task: str
    :ivar image_update_trigger: The image update trigger that caused the run. This is applicable if
     the task has base image trigger configured.
    :vartype image_update_trigger:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageUpdateTrigger
    :ivar source_trigger: The source trigger that caused the run.
    :vartype source_trigger:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerDescriptor
    :ivar timer_trigger: The timer trigger that caused the run.
    :vartype timer_trigger:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TimerTriggerDescriptor
    :ivar platform: The platform properties against which the run will happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
    :ivar source_registry_auth: The scope of the credentials that were used to login to the source
     registry during this run.
    :vartype source_registry_auth: str
    :ivar custom_registries: The list of custom registries that were logged in during this run.
    :vartype custom_registries: list[str]
    :ivar run_error_message: The error message received from backend systems after the run is
     scheduled.
    :vartype run_error_message: str
    :ivar update_trigger_token: The update trigger token passed for the Run.
    :vartype update_trigger_token: str
    :ivar log_artifact: The image description for the log artifact.
    :vartype log_artifact: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageDescriptor
    :ivar provisioning_state: The provisioning state of a run. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ProvisioningState
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'run_error_message': {'readonly': True},
        'log_artifact': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'run_id': {'key': 'properties.runId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'run_type': {'key': 'properties.runType', 'type': 'str'},
        'agent_pool_name': {'key': 'properties.agentPoolName', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'properties.finishTime', 'type': 'iso-8601'},
        'output_images': {'key': 'properties.outputImages', 'type': '[ImageDescriptor]'},
        'task': {'key': 'properties.task', 'type': 'str'},
        'image_update_trigger': {'key': 'properties.imageUpdateTrigger', 'type': 'ImageUpdateTrigger'},
        'source_trigger': {'key': 'properties.sourceTrigger', 'type': 'SourceTriggerDescriptor'},
        'timer_trigger': {'key': 'properties.timerTrigger', 'type': 'TimerTriggerDescriptor'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'source_registry_auth': {'key': 'properties.sourceRegistryAuth', 'type': 'str'},
        'custom_registries': {'key': 'properties.customRegistries', 'type': '[str]'},
        'run_error_message': {'key': 'properties.runErrorMessage', 'type': 'str'},
        'update_trigger_token': {'key': 'properties.updateTriggerToken', 'type': 'str'},
        'log_artifact': {'key': 'properties.logArtifact', 'type': 'ImageDescriptor'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_archive_enabled': {'key': 'properties.isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        status: Optional[Union[str, "RunStatus"]] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        run_type: Optional[Union[str, "RunType"]] = None,
        agent_pool_name: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_images: Optional[List["ImageDescriptor"]] = None,
        task: Optional[str] = None,
        image_update_trigger: Optional["ImageUpdateTrigger"] = None,
        source_trigger: Optional["SourceTriggerDescriptor"] = None,
        timer_trigger: Optional["TimerTriggerDescriptor"] = None,
        platform: Optional["PlatformProperties"] = None,
        agent_configuration: Optional["AgentProperties"] = None,
        source_registry_auth: Optional[str] = None,
        custom_registries: Optional[List[str]] = None,
        update_trigger_token: Optional[str] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        is_archive_enabled: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword run_id: The unique identifier for the run.
        :paramtype run_id: str
        :keyword status: The current status of the run. Possible values include: "Queued", "Started",
         "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunStatus
        :keyword last_updated_time: The last updated time for the run.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
         "AutoBuild", "AutoRun".
        :paramtype run_type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunType
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword create_time: The time the run was scheduled.
        :paramtype create_time: ~datetime.datetime
        :keyword start_time: The time the run started.
        :paramtype start_time: ~datetime.datetime
        :keyword finish_time: The time the run finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword output_images: The list of all images that were generated from the run. This is
         applicable if the run generates base image dependencies.
        :paramtype output_images:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageDescriptor]
        :keyword task: The task against which run was scheduled.
        :paramtype task: str
        :keyword image_update_trigger: The image update trigger that caused the run. This is applicable
         if the task has base image trigger configured.
        :paramtype image_update_trigger:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ImageUpdateTrigger
        :keyword source_trigger: The source trigger that caused the run.
        :paramtype source_trigger:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerDescriptor
        :keyword timer_trigger: The timer trigger that caused the run.
        :paramtype timer_trigger:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TimerTriggerDescriptor
        :keyword platform: The platform properties against which the run will happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
        :keyword source_registry_auth: The scope of the credentials that were used to login to the
         source registry during this run.
        :paramtype source_registry_auth: str
        :keyword custom_registries: The list of custom registries that were logged in during this run.
        :paramtype custom_registries: list[str]
        :keyword update_trigger_token: The update trigger token passed for the Run.
        :paramtype update_trigger_token: str
        :keyword provisioning_state: The provisioning state of a run. Possible values include:
         "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ProvisioningState
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        """
        super(Run, self).__init__(**kwargs)
        self.run_id = run_id
        self.status = status
        self.last_updated_time = last_updated_time
        self.run_type = run_type
        self.agent_pool_name = agent_pool_name
        self.create_time = create_time
        self.start_time = start_time
        self.finish_time = finish_time
        self.output_images = output_images
        self.task = task
        self.image_update_trigger = image_update_trigger
        self.source_trigger = source_trigger
        self.timer_trigger = timer_trigger
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_registry_auth = source_registry_auth
        self.custom_registries = custom_registries
        self.run_error_message = None
        self.update_trigger_token = update_trigger_token
        self.log_artifact = None
        self.provisioning_state = provisioning_state
        self.is_archive_enabled = is_archive_enabled


class RunFilter(msrest.serialization.Model):
    """Properties that are enabled for Odata querying on runs.

    :ivar run_id: The unique identifier for the run.
    :vartype run_id: str
    :ivar run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
     "AutoBuild", "AutoRun".
    :vartype run_type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunType
    :ivar status: The current status of the run. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunStatus
    :ivar create_time: The create time for a run.
    :vartype create_time: ~datetime.datetime
    :ivar finish_time: The time the run finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_image_manifests: The list of comma-separated image manifests that were generated
     from the run. This is applicable if the run is of
     build type.
    :vartype output_image_manifests: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    :ivar task_name: The name of the task that the run corresponds to.
    :vartype task_name: str
    :ivar agent_pool_name: The name of the agent pool that the run corresponds to.
    :vartype agent_pool_name: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'output_image_manifests': {'key': 'outputImageManifests', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'agent_pool_name': {'key': 'agentPoolName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        run_type: Optional[Union[str, "RunType"]] = None,
        status: Optional[Union[str, "RunStatus"]] = None,
        create_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_image_manifests: Optional[str] = None,
        is_archive_enabled: Optional[bool] = None,
        task_name: Optional[str] = None,
        agent_pool_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword run_id: The unique identifier for the run.
        :paramtype run_id: str
        :keyword run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
         "AutoBuild", "AutoRun".
        :paramtype run_type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunType
        :keyword status: The current status of the run. Possible values include: "Queued", "Started",
         "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunStatus
        :keyword create_time: The create time for a run.
        :paramtype create_time: ~datetime.datetime
        :keyword finish_time: The time the run finished.
        :paramtype finish_time: ~datetime.datetime
        :keyword output_image_manifests: The list of comma-separated image manifests that were
         generated from the run. This is applicable if the run is of
         build type.
        :paramtype output_image_manifests: str
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        :keyword task_name: The name of the task that the run corresponds to.
        :paramtype task_name: str
        :keyword agent_pool_name: The name of the agent pool that the run corresponds to.
        :paramtype agent_pool_name: str
        """
        super(RunFilter, self).__init__(**kwargs)
        self.run_id = run_id
        self.run_type = run_type
        self.status = status
        self.create_time = create_time
        self.finish_time = finish_time
        self.output_image_manifests = output_image_manifests
        self.is_archive_enabled = is_archive_enabled
        self.task_name = task_name
        self.agent_pool_name = agent_pool_name


class RunGetLogResult(msrest.serialization.Model):
    """The result of get log link operation.

    :ivar log_link: The link to logs for a run on a azure container registry.
    :vartype log_link: str
    :ivar log_artifact_link: The link to logs in registry for a run on a azure container registry.
    :vartype log_artifact_link: str
    """

    _attribute_map = {
        'log_link': {'key': 'logLink', 'type': 'str'},
        'log_artifact_link': {'key': 'logArtifactLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        log_link: Optional[str] = None,
        log_artifact_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword log_link: The link to logs for a run on a azure container registry.
        :paramtype log_link: str
        :keyword log_artifact_link: The link to logs in registry for a run on a azure container
         registry.
        :paramtype log_artifact_link: str
        """
        super(RunGetLogResult, self).__init__(**kwargs)
        self.log_link = log_link
        self.log_artifact_link = log_artifact_link


class RunListResult(msrest.serialization.Model):
    """Collection of runs.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Run]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Run]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Run"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Run]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super(RunListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunUpdateParameters(msrest.serialization.Model):
    """The set of run properties that can be updated.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_archive_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :paramtype is_archive_enabled: bool
        """
        super(RunUpdateParameters, self).__init__(**kwargs)
        self.is_archive_enabled = is_archive_enabled


class SecretObject(msrest.serialization.Model):
    """Describes the properties of a secret object value.

    :ivar value: The value of the secret. The format of this value will be determined
     based on the type of the secret object. If the type is Opaque, the value will be
     used as is without any modification.
    :vartype value: str
    :ivar type: The type of the secret object which determines how the value of the secret object
     has to be
     interpreted. Possible values include: "Opaque", "Vaultsecret".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SecretObjectType
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        type: Optional[Union[str, "SecretObjectType"]] = None,
        **kwargs
    ):
        """
        :keyword value: The value of the secret. The format of this value will be determined
         based on the type of the secret object. If the type is Opaque, the value will be
         used as is without any modification.
        :paramtype value: str
        :keyword type: The type of the secret object which determines how the value of the secret
         object has to be
         interpreted. Possible values include: "Opaque", "Vaultsecret".
        :paramtype type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SecretObjectType
        """
        super(SecretObject, self).__init__(**kwargs)
        self.value = value
        self.type = type


class SetValue(msrest.serialization.Model):
    """The properties of a overridable value that can be passed to a task template.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the overridable value.
    :vartype name: str
    :ivar value: Required. The overridable value.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the value represents a secret or not.
    :vartype is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        is_secret: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the overridable value.
        :paramtype name: str
        :keyword value: Required. The overridable value.
        :paramtype value: str
        :keyword is_secret: Flag to indicate whether the value represents a secret or not.
        :paramtype is_secret: bool
        """
        super(SetValue, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.is_secret = is_secret


class SourceProperties(msrest.serialization.Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :ivar source_control_type: Required. The type of source control service. Possible values
     include: "Github", "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceControlType
    :ivar repository_url: Required. The full URL to the source code repository.
    :vartype repository_url: str
    :ivar branch: The branch name of the source code.
    :vartype branch: str
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AuthInfo
    """

    _validation = {
        'source_control_type': {'required': True},
        'repository_url': {'required': True},
    }

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfo'},
    }

    def __init__(
        self,
        *,
        source_control_type: Union[str, "SourceControlType"],
        repository_url: str,
        branch: Optional[str] = None,
        source_control_auth_properties: Optional["AuthInfo"] = None,
        **kwargs
    ):
        """
        :keyword source_control_type: Required. The type of source control service. Possible values
         include: "Github", "VisualStudioTeamService".
        :paramtype source_control_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceControlType
        :keyword repository_url: Required. The full URL to the source code repository.
        :paramtype repository_url: str
        :keyword branch: The branch name of the source code.
        :paramtype branch: str
        :keyword source_control_auth_properties: The authorization properties for accessing the source
         code repository and to set up
         webhooks for notifications.
        :paramtype source_control_auth_properties:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AuthInfo
        """
        super(SourceProperties, self).__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.branch = branch
        self.source_control_auth_properties = source_control_auth_properties


class SourceRegistryCredentials(msrest.serialization.Model):
    """Describes the credential parameters for accessing the source registry.

    :ivar login_mode: The authentication mode which determines the source registry login scope. The
     credentials for the source registry
     will be generated using the given scope. These credentials will be used to login to
     the source registry during the run. Possible values include: "None", "Default".
    :vartype login_mode: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceRegistryLoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        login_mode: Optional[Union[str, "SourceRegistryLoginMode"]] = None,
        **kwargs
    ):
        """
        :keyword login_mode: The authentication mode which determines the source registry login scope.
         The credentials for the source registry
         will be generated using the given scope. These credentials will be used to login to
         the source registry during the run. Possible values include: "None", "Default".
        :paramtype login_mode: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceRegistryLoginMode
        """
        super(SourceRegistryCredentials, self).__init__(**kwargs)
        self.login_mode = login_mode


class SourceTrigger(msrest.serialization.Model):
    """The properties of a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar source_repository: Required. The properties that describes the source(code) for the task.
    :vartype source_repository:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceProperties
    :ivar source_trigger_events: Required. The source event corresponding to the trigger.
    :vartype source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerEvent]
    :ivar status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
    :ivar name: Required. The name of the trigger.
    :vartype name: str
    """

    _validation = {
        'source_repository': {'required': True},
        'source_trigger_events': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceProperties'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_repository: "SourceProperties",
        source_trigger_events: List[Union[str, "SourceTriggerEvent"]],
        name: str,
        status: Optional[Union[str, "TriggerStatus"]] = None,
        **kwargs
    ):
        """
        :keyword source_repository: Required. The properties that describes the source(code) for the
         task.
        :paramtype source_repository:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceProperties
        :keyword source_trigger_events: Required. The source event corresponding to the trigger.
        :paramtype source_trigger_events: list[str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerEvent]
        :keyword status: The current status of trigger. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
        :keyword name: Required. The name of the trigger.
        :paramtype name: str
        """
        super(SourceTrigger, self).__init__(**kwargs)
        self.source_repository = source_repository
        self.source_trigger_events = source_trigger_events
        self.status = status
        self.name = name


class SourceTriggerDescriptor(msrest.serialization.Model):
    """The source trigger that caused a run.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar event_type: The event type of the trigger.
    :vartype event_type: str
    :ivar commit_id: The unique ID that identifies a commit.
    :vartype commit_id: str
    :ivar pull_request_id: The unique ID that identifies pull request.
    :vartype pull_request_id: str
    :ivar repository_url: The repository URL.
    :vartype repository_url: str
    :ivar branch_name: The branch name in the repository.
    :vartype branch_name: str
    :ivar provider_type: The source control provider type.
    :vartype provider_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'pull_request_id': {'key': 'pullRequestId', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch_name': {'key': 'branchName', 'type': 'str'},
        'provider_type': {'key': 'providerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        event_type: Optional[str] = None,
        commit_id: Optional[str] = None,
        pull_request_id: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch_name: Optional[str] = None,
        provider_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The unique ID of the trigger.
        :paramtype id: str
        :keyword event_type: The event type of the trigger.
        :paramtype event_type: str
        :keyword commit_id: The unique ID that identifies a commit.
        :paramtype commit_id: str
        :keyword pull_request_id: The unique ID that identifies pull request.
        :paramtype pull_request_id: str
        :keyword repository_url: The repository URL.
        :paramtype repository_url: str
        :keyword branch_name: The branch name in the repository.
        :paramtype branch_name: str
        :keyword provider_type: The source control provider type.
        :paramtype provider_type: str
        """
        super(SourceTriggerDescriptor, self).__init__(**kwargs)
        self.id = id
        self.event_type = event_type
        self.commit_id = commit_id
        self.pull_request_id = pull_request_id
        self.repository_url = repository_url
        self.branch_name = branch_name
        self.provider_type = provider_type


class SourceTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar source_repository: The properties that describes the source(code) for the task.
    :vartype source_repository:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceUpdateParameters
    :ivar source_trigger_events: The source event corresponding to the trigger.
    :vartype source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerEvent]
    :ivar status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
    :ivar name: Required. The name of the trigger.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceUpdateParameters'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        source_repository: Optional["SourceUpdateParameters"] = None,
        source_trigger_events: Optional[List[Union[str, "SourceTriggerEvent"]]] = None,
        status: Optional[Union[str, "TriggerStatus"]] = None,
        **kwargs
    ):
        """
        :keyword source_repository: The properties that describes the source(code) for the task.
        :paramtype source_repository:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceUpdateParameters
        :keyword source_trigger_events: The source event corresponding to the trigger.
        :paramtype source_trigger_events: list[str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerEvent]
        :keyword status: The current status of trigger. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
        :keyword name: Required. The name of the trigger.
        :paramtype name: str
        """
        super(SourceTriggerUpdateParameters, self).__init__(**kwargs)
        self.source_repository = source_repository
        self.source_trigger_events = source_trigger_events
        self.status = status
        self.name = name


class SourceUpdateParameters(msrest.serialization.Model):
    """The properties for updating the source code repository.

    :ivar source_control_type: The type of source control service. Possible values include:
     "Github", "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceControlType
    :ivar repository_url: The full URL to the source code repository.
    :vartype repository_url: str
    :ivar branch: The branch name of the source code.
    :vartype branch: str
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AuthInfoUpdateParameters
    """

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfoUpdateParameters'},
    }

    def __init__(
        self,
        *,
        source_control_type: Optional[Union[str, "SourceControlType"]] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        source_control_auth_properties: Optional["AuthInfoUpdateParameters"] = None,
        **kwargs
    ):
        """
        :keyword source_control_type: The type of source control service. Possible values include:
         "Github", "VisualStudioTeamService".
        :paramtype source_control_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceControlType
        :keyword repository_url: The full URL to the source code repository.
        :paramtype repository_url: str
        :keyword branch: The branch name of the source code.
        :paramtype branch: str
        :keyword source_control_auth_properties: The authorization properties for accessing the source
         code repository and to set up
         webhooks for notifications.
        :paramtype source_control_auth_properties:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AuthInfoUpdateParameters
        """
        super(SourceUpdateParameters, self).__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.branch = branch
        self.source_control_auth_properties = source_control_auth_properties


class SourceUploadDefinition(msrest.serialization.Model):
    """The properties of a response to source upload request.

    :ivar upload_url: The URL where the client can upload the source.
    :vartype upload_url: str
    :ivar relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :vartype relative_path: str
    """

    _attribute_map = {
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        upload_url: Optional[str] = None,
        relative_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword upload_url: The URL where the client can upload the source.
        :paramtype upload_url: str
        :keyword relative_path: The relative path to the source. This is used to submit the subsequent
         queue build request.
        :paramtype relative_path: str
        """
        super(SourceUploadDefinition, self).__init__(**kwargs)
        self.upload_url = upload_url
        self.relative_path = relative_path


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.LastModifiedByType
    :ivar last_modified_at: The timestamp of resource modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "LastModifiedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.LastModifiedByType
        :keyword last_modified_at: The timestamp of resource modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Task(Resource):
    """The task that has the ARM resource and task properties. 
The task will have all information to schedule a run against it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SystemData
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
    :ivar provisioning_state: The provisioning state of the task. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ProvisioningState
    :ivar creation_date: The creation date of task.
    :vartype creation_date: ~datetime.datetime
    :ivar status: The current status of task. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStatus
    :ivar platform: The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
    :ivar agent_pool_name: The dedicated agent pool for the task.
    :vartype agent_pool_name: str
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar step: The properties of a task step.
    :vartype step: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStepProperties
    :ivar trigger: The properties that describe all triggers for the task.
    :vartype trigger: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerProperties
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar is_system_task: The value of this property indicates whether the task resource is system
     task or not.
    :vartype is_system_task: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'creation_date': {'readonly': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'agent_pool_name': {'key': 'properties.agentPoolName', 'type': 'str'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepProperties'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
        'log_template': {'key': 'properties.logTemplate', 'type': 'str'},
        'is_system_task': {'key': 'properties.isSystemTask', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityProperties"] = None,
        status: Optional[Union[str, "TaskStatus"]] = None,
        platform: Optional["PlatformProperties"] = None,
        agent_configuration: Optional["AgentProperties"] = None,
        agent_pool_name: Optional[str] = None,
        timeout: Optional[int] = 3600,
        step: Optional["TaskStepProperties"] = None,
        trigger: Optional["TriggerProperties"] = None,
        credentials: Optional["Credentials"] = None,
        log_template: Optional[str] = None,
        is_system_task: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
        :keyword status: The current status of task. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStatus
        :keyword platform: The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformProperties
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
        :keyword agent_pool_name: The dedicated agent pool for the task.
        :paramtype agent_pool_name: str
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword step: The properties of a task step.
        :paramtype step: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStepProperties
        :keyword trigger: The properties that describe all triggers for the task.
        :paramtype trigger: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerProperties
        :keyword credentials: The properties that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword is_system_task: The value of this property indicates whether the task resource is
         system task or not.
        :paramtype is_system_task: bool
        """
        super(Task, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.creation_date = None
        self.status = status
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.agent_pool_name = agent_pool_name
        self.timeout = timeout
        self.step = step
        self.trigger = trigger
        self.credentials = credentials
        self.log_template = log_template
        self.is_system_task = is_system_task


class TaskListResult(msrest.serialization.Model):
    """The collection of tasks.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Task]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Task]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Task"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.Task]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super(TaskListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TaskRun(ProxyResource):
    """The task run that has the ARM resource and properties. 
The task run will have the information of request and result of a run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.SystemData
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of this task run. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.ProvisioningState
    :ivar run_request: The request (parameters) for the run.
    :vartype run_request: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunRequest
    :ivar run_result: The result of this task run.
    :vartype run_result: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Run
    :ivar force_update_tag: How the run should be forced to rerun even if the run request
     configuration has not changed.
    :vartype force_update_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'run_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'run_request': {'key': 'properties.runRequest', 'type': 'RunRequest'},
        'run_result': {'key': 'properties.runResult', 'type': 'Run'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["IdentityProperties"] = None,
        location: Optional[str] = None,
        run_request: Optional["RunRequest"] = None,
        force_update_tag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword run_request: The request (parameters) for the run.
        :paramtype run_request: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunRequest
        :keyword force_update_tag: How the run should be forced to rerun even if the run request
         configuration has not changed.
        :paramtype force_update_tag: str
        """
        super(TaskRun, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.provisioning_state = None
        self.run_request = run_request
        self.run_result = None
        self.force_update_tag = force_update_tag


class TaskRunListResult(msrest.serialization.Model):
    """The collection of task runs.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskRun]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TaskRun]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TaskRun"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskRun]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super(TaskRunListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TaskRunRequest(RunRequest):
    """The parameters for a task run request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar task_id: Required. The resource ID of task against which run has to be queued.
    :vartype task_id: str
    :ivar override_task_step_properties: Set of overridable parameters that can be passed when
     running a Task.
    :vartype override_task_step_properties:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OverrideTaskStepProperties
    """

    _validation = {
        'type': {'required': True},
        'task_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'agent_pool_name': {'key': 'agentPoolName', 'type': 'str'},
        'log_template': {'key': 'logTemplate', 'type': 'str'},
        'task_id': {'key': 'taskId', 'type': 'str'},
        'override_task_step_properties': {'key': 'overrideTaskStepProperties', 'type': 'OverrideTaskStepProperties'},
    }

    def __init__(
        self,
        *,
        task_id: str,
        is_archive_enabled: Optional[bool] = False,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        override_task_step_properties: Optional["OverrideTaskStepProperties"] = None,
        **kwargs
    ):
        """
        :keyword is_archive_enabled: The value that indicates whether archiving is enabled for the run
         or not.
        :paramtype is_archive_enabled: bool
        :keyword agent_pool_name: The dedicated agent pool for the run.
        :paramtype agent_pool_name: str
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        :keyword task_id: Required. The resource ID of task against which run has to be queued.
        :paramtype task_id: str
        :keyword override_task_step_properties: Set of overridable parameters that can be passed when
         running a Task.
        :paramtype override_task_step_properties:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.OverrideTaskStepProperties
        """
        super(TaskRunRequest, self).__init__(is_archive_enabled=is_archive_enabled, agent_pool_name=agent_pool_name, log_template=log_template, **kwargs)
        self.type = 'TaskRunRequest'  # type: str
        self.task_id = task_id
        self.override_task_step_properties = override_task_step_properties


class TaskRunUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a task run.

    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar run_request: The request (parameters) for the new run.
    :vartype run_request: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunRequest
    :ivar force_update_tag: How the run should be forced to rerun even if the run request
     configuration has not changed.
    :vartype force_update_tag: str
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'run_request': {'key': 'properties.runRequest', 'type': 'RunRequest'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["IdentityProperties"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        run_request: Optional["RunRequest"] = None,
        force_update_tag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword run_request: The request (parameters) for the new run.
        :paramtype run_request: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.RunRequest
        :keyword force_update_tag: How the run should be forced to rerun even if the run request
         configuration has not changed.
        :paramtype force_update_tag: str
        """
        super(TaskRunUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.run_request = run_request
        self.force_update_tag = force_update_tag


class TaskUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a task.

    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
    :ivar tags: A set of tags. The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar status: The current status of task. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStatus
    :ivar platform: The platform properties against which the run has to happen.
    :vartype platform:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformUpdateParameters
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
    :ivar agent_pool_name: The dedicated agent pool for the task.
    :vartype agent_pool_name: str
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar step: The properties for updating a task step.
    :vartype step:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStepUpdateParameters
    :ivar trigger: The properties for updating trigger properties.
    :vartype trigger:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerUpdateParameters
    :ivar credentials: The parameters that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformUpdateParameters'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'agent_pool_name': {'key': 'properties.agentPoolName', 'type': 'str'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepUpdateParameters'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerUpdateParameters'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
        'log_template': {'key': 'properties.logTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["IdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "TaskStatus"]] = None,
        platform: Optional["PlatformUpdateParameters"] = None,
        agent_configuration: Optional["AgentProperties"] = None,
        agent_pool_name: Optional[str] = None,
        timeout: Optional[int] = None,
        step: Optional["TaskStepUpdateParameters"] = None,
        trigger: Optional["TriggerUpdateParameters"] = None,
        credentials: Optional["Credentials"] = None,
        log_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identity: Identity for the resource.
        :paramtype identity:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.IdentityProperties
        :keyword tags: A set of tags. The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword status: The current status of task. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStatus
        :keyword platform: The platform properties against which the run has to happen.
        :paramtype platform:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.PlatformUpdateParameters
        :keyword agent_configuration: The machine configuration of the run agent.
        :paramtype agent_configuration:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.AgentProperties
        :keyword agent_pool_name: The dedicated agent pool for the task.
        :paramtype agent_pool_name: str
        :keyword timeout: Run timeout in seconds.
        :paramtype timeout: int
        :keyword step: The properties for updating a task step.
        :paramtype step:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TaskStepUpdateParameters
        :keyword trigger: The properties for updating trigger properties.
        :paramtype trigger:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerUpdateParameters
        :keyword credentials: The parameters that describes a set of credentials that will be used when
         this run is invoked.
        :paramtype credentials: ~azure.mgmt.containerregistry.v2019_06_01_preview.models.Credentials
        :keyword log_template: The template that describes the repository and tag information for run
         log artifact.
        :paramtype log_template: str
        """
        super(TaskUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.status = status
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.agent_pool_name = agent_pool_name
        self.timeout = timeout
        self.step = step
        self.trigger = trigger
        self.credentials = credentials
        self.log_template = log_template


class TimerTrigger(msrest.serialization.Model):
    """The properties of a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar schedule: Required. The CRON expression for the task schedule.
    :vartype schedule: str
    :ivar status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
    :ivar name: Required. The name of the trigger.
    :vartype name: str
    """

    _validation = {
        'schedule': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schedule: str,
        name: str,
        status: Optional[Union[str, "TriggerStatus"]] = None,
        **kwargs
    ):
        """
        :keyword schedule: Required. The CRON expression for the task schedule.
        :paramtype schedule: str
        :keyword status: The current status of trigger. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
        :keyword name: Required. The name of the trigger.
        :paramtype name: str
        """
        super(TimerTrigger, self).__init__(**kwargs)
        self.schedule = schedule
        self.status = status
        self.name = name


class TimerTriggerDescriptor(msrest.serialization.Model):
    """TimerTriggerDescriptor.

    :ivar timer_trigger_name: The timer trigger name that caused the run.
    :vartype timer_trigger_name: str
    :ivar schedule_occurrence: The occurrence that triggered the run.
    :vartype schedule_occurrence: str
    """

    _attribute_map = {
        'timer_trigger_name': {'key': 'timerTriggerName', 'type': 'str'},
        'schedule_occurrence': {'key': 'scheduleOccurrence', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        timer_trigger_name: Optional[str] = None,
        schedule_occurrence: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword timer_trigger_name: The timer trigger name that caused the run.
        :paramtype timer_trigger_name: str
        :keyword schedule_occurrence: The occurrence that triggered the run.
        :paramtype schedule_occurrence: str
        """
        super(TimerTriggerDescriptor, self).__init__(**kwargs)
        self.timer_trigger_name = timer_trigger_name
        self.schedule_occurrence = schedule_occurrence


class TimerTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :ivar schedule: The CRON expression for the task schedule.
    :vartype schedule: str
    :ivar status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
    :ivar name: Required. The name of the trigger.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        schedule: Optional[str] = None,
        status: Optional[Union[str, "TriggerStatus"]] = None,
        **kwargs
    ):
        """
        :keyword schedule: The CRON expression for the task schedule.
        :paramtype schedule: str
        :keyword status: The current status of trigger. Possible values include: "Disabled", "Enabled".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.TriggerStatus
        :keyword name: Required. The name of the trigger.
        :paramtype name: str
        """
        super(TimerTriggerUpdateParameters, self).__init__(**kwargs)
        self.schedule = schedule
        self.status = status
        self.name = name


class TriggerProperties(msrest.serialization.Model):
    """The properties of a trigger.

    :ivar timer_triggers: The collection of timer triggers.
    :vartype timer_triggers:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.TimerTrigger]
    :ivar source_triggers: The collection of triggers based on source code repository.
    :vartype source_triggers:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTrigger]
    :ivar base_image_trigger: The trigger based on base image dependencies.
    :vartype base_image_trigger:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTrigger
    """

    _attribute_map = {
        'timer_triggers': {'key': 'timerTriggers', 'type': '[TimerTrigger]'},
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTrigger]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTrigger'},
    }

    def __init__(
        self,
        *,
        timer_triggers: Optional[List["TimerTrigger"]] = None,
        source_triggers: Optional[List["SourceTrigger"]] = None,
        base_image_trigger: Optional["BaseImageTrigger"] = None,
        **kwargs
    ):
        """
        :keyword timer_triggers: The collection of timer triggers.
        :paramtype timer_triggers:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.TimerTrigger]
        :keyword source_triggers: The collection of triggers based on source code repository.
        :paramtype source_triggers:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTrigger]
        :keyword base_image_trigger: The trigger based on base image dependencies.
        :paramtype base_image_trigger:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTrigger
        """
        super(TriggerProperties, self).__init__(**kwargs)
        self.timer_triggers = timer_triggers
        self.source_triggers = source_triggers
        self.base_image_trigger = base_image_trigger


class TriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating triggers.

    :ivar timer_triggers: The collection of timer triggers.
    :vartype timer_triggers:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.TimerTriggerUpdateParameters]
    :ivar source_triggers: The collection of triggers based on source code repository.
    :vartype source_triggers:
     list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerUpdateParameters]
    :ivar base_image_trigger: The trigger based on base image dependencies.
    :vartype base_image_trigger:
     ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTriggerUpdateParameters
    """

    _attribute_map = {
        'timer_triggers': {'key': 'timerTriggers', 'type': '[TimerTriggerUpdateParameters]'},
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTriggerUpdateParameters]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTriggerUpdateParameters'},
    }

    def __init__(
        self,
        *,
        timer_triggers: Optional[List["TimerTriggerUpdateParameters"]] = None,
        source_triggers: Optional[List["SourceTriggerUpdateParameters"]] = None,
        base_image_trigger: Optional["BaseImageTriggerUpdateParameters"] = None,
        **kwargs
    ):
        """
        :keyword timer_triggers: The collection of timer triggers.
        :paramtype timer_triggers:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.TimerTriggerUpdateParameters]
        :keyword source_triggers: The collection of triggers based on source code repository.
        :paramtype source_triggers:
         list[~azure.mgmt.containerregistry.v2019_06_01_preview.models.SourceTriggerUpdateParameters]
        :keyword base_image_trigger: The trigger based on base image dependencies.
        :paramtype base_image_trigger:
         ~azure.mgmt.containerregistry.v2019_06_01_preview.models.BaseImageTriggerUpdateParameters
        """
        super(TriggerUpdateParameters, self).__init__(**kwargs)
        self.timer_triggers = timer_triggers
        self.source_triggers = source_triggers
        self.base_image_trigger = base_image_trigger


class UserIdentityProperties(msrest.serialization.Model):
    """UserIdentityProperties.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword principal_id: The principal id of user assigned identity.
        :paramtype principal_id: str
        :keyword client_id: The client id of user assigned identity.
        :paramtype client_id: str
        """
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.client_id = client_id
