# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActivatedResourceReference(_serialization.Model):
    """Reference to another resource along with its state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar is_active: Whether the resource is active or inactive.
    :vartype is_active: bool
    """

    _validation = {
        "is_active": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "is_active": {"key": "isActive", "type": "bool"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.is_active = None


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class AFDDomain(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar domain_validation_state: Provisioning substate shows the progress of custom HTTPS
     enabling/disabling process step by step. DCV stands for DomainControlValidation. Known values
     are: "Unknown", "Submitting", "Pending", "Rejected", "TimedOut", "PendingRevalidation",
     "Approved", "RefreshingValidationToken", and "InternalError".
    :vartype domain_validation_state: str or ~azure.mgmt.cdn.models.DomainValidationState
    :ivar host_name: The host name of the domain. Must be a domain name.
    :vartype host_name: str
    :ivar validation_properties: Values the customer needs to validate domain ownership.
    :vartype validation_properties: ~azure.mgmt.cdn.models.DomainValidationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "profile_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "domain_validation_state": {"readonly": True},
        "validation_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "tls_settings": {"key": "properties.tlsSettings", "type": "AFDDomainHttpsParameters"},
        "azure_dns_zone": {"key": "properties.azureDnsZone", "type": "ResourceReference"},
        "pre_validated_custom_domain_resource_id": {
            "key": "properties.preValidatedCustomDomainResourceId",
            "type": "ResourceReference",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
        "domain_validation_state": {"key": "properties.domainValidationState", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "validation_properties": {"key": "properties.validationProperties", "type": "DomainValidationProperties"},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["_models.AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["_models.ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["_models.ResourceReference"] = None,
        host_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The host name of the domain. Must be a domain name.
        :paramtype host_name: str
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id
        self.provisioning_state = None
        self.deployment_status = None
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None


class AFDDomainHttpsParameters(_serialization.Model):
    """The JSON object that contains the properties to secure a domain.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_type: Defines the source of the SSL certificate. Required. Known values are:
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype certificate_type: str or ~azure.mgmt.cdn.models.AfdCertificateType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Known values are:
     "TLS10" and "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.AfdMinimumTlsVersion
    :ivar secret: Resource reference to the secret. ie. subs/rg/profile/secret.
    :vartype secret: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        "certificate_type": {"required": True},
    }

    _attribute_map = {
        "certificate_type": {"key": "certificateType", "type": "str"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "secret": {"key": "secret", "type": "ResourceReference"},
    }

    def __init__(
        self,
        *,
        certificate_type: Union[str, "_models.AfdCertificateType"],
        minimum_tls_version: Optional[Union[str, "_models.AfdMinimumTlsVersion"]] = None,
        secret: Optional["_models.ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword certificate_type: Defines the source of the SSL certificate. Required. Known values
         are: "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
        :paramtype certificate_type: str or ~azure.mgmt.cdn.models.AfdCertificateType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Known values
         are: "TLS10" and "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.AfdMinimumTlsVersion
        :keyword secret: Resource reference to the secret. ie. subs/rg/profile/secret.
        :paramtype secret: ~azure.mgmt.cdn.models.ResourceReference
        """
        super().__init__(**kwargs)
        self.certificate_type = certificate_type
        self.minimum_tls_version = minimum_tls_version
        self.secret = secret


class AFDDomainListResult(_serialization.Model):
    """Result of the request to list domains. It contains a list of domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor domains within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.AFDDomain]
    :ivar next_link: URL to get the next set of domain objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AFDDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of domain objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDStateProperties(_serialization.Model):
    """The tracking states for afd resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None


class AFDDomainUpdatePropertiesParameters(_serialization.Model):
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "profile_name": {"key": "profileName", "type": "str"},
        "tls_settings": {"key": "tlsSettings", "type": "AFDDomainHttpsParameters"},
        "azure_dns_zone": {"key": "azureDnsZone", "type": "ResourceReference"},
        "pre_validated_custom_domain_resource_id": {
            "key": "preValidatedCustomDomainResourceId",
            "type": "ResourceReference",
        },
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["_models.AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["_models.ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["_models.ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id


class AFDDomainProperties(AFDDomainUpdatePropertiesParameters, AFDStateProperties):
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    :ivar domain_validation_state: Provisioning substate shows the progress of custom HTTPS
     enabling/disabling process step by step. DCV stands for DomainControlValidation. Known values
     are: "Unknown", "Submitting", "Pending", "Rejected", "TimedOut", "PendingRevalidation",
     "Approved", "RefreshingValidationToken", and "InternalError".
    :vartype domain_validation_state: str or ~azure.mgmt.cdn.models.DomainValidationState
    :ivar host_name: The host name of the domain. Must be a domain name. Required.
    :vartype host_name: str
    :ivar validation_properties: Values the customer needs to validate domain ownership.
    :vartype validation_properties: ~azure.mgmt.cdn.models.DomainValidationProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
        "domain_validation_state": {"readonly": True},
        "host_name": {"required": True},
        "validation_properties": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "profile_name": {"key": "profileName", "type": "str"},
        "tls_settings": {"key": "tlsSettings", "type": "AFDDomainHttpsParameters"},
        "azure_dns_zone": {"key": "azureDnsZone", "type": "ResourceReference"},
        "pre_validated_custom_domain_resource_id": {
            "key": "preValidatedCustomDomainResourceId",
            "type": "ResourceReference",
        },
        "domain_validation_state": {"key": "domainValidationState", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
        "validation_properties": {"key": "validationProperties", "type": "DomainValidationProperties"},
    }

    def __init__(
        self,
        *,
        host_name: str,
        tls_settings: Optional["_models.AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["_models.ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["_models.ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The host name of the domain. Must be a domain name. Required.
        :paramtype host_name: str
        """
        super().__init__(
            tls_settings=tls_settings,
            azure_dns_zone=azure_dns_zone,
            pre_validated_custom_domain_resource_id=pre_validated_custom_domain_resource_id,
            **kwargs
        )
        self.provisioning_state = None
        self.deployment_status = None
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id


class AFDDomainUpdateParameters(_serialization.Model):
    """The domain JSON object required for domain creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the domain.
    :vartype profile_name: str
    :ivar tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :vartype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :ivar azure_dns_zone: Resource reference to the Azure DNS zone.
    :vartype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar pre_validated_custom_domain_resource_id: Resource reference to the Azure resource where
     custom domain ownership was prevalidated.
    :vartype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "tls_settings": {"key": "properties.tlsSettings", "type": "AFDDomainHttpsParameters"},
        "azure_dns_zone": {"key": "properties.azureDnsZone", "type": "ResourceReference"},
        "pre_validated_custom_domain_resource_id": {
            "key": "properties.preValidatedCustomDomainResourceId",
            "type": "ResourceReference",
        },
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["_models.AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["_models.ResourceReference"] = None,
        pre_validated_custom_domain_resource_id: Optional["_models.ResourceReference"] = None,
        **kwargs
    ):
        """
        :keyword tls_settings: The configuration specifying how to enable HTTPS for the domain - using
         AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
         uses AzureFrontDoor managed certificate by default.
        :paramtype tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
        :keyword azure_dns_zone: Resource reference to the Azure DNS zone.
        :paramtype azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
        :keyword pre_validated_custom_domain_resource_id: Resource reference to the Azure resource
         where custom domain ownership was prevalidated.
        :paramtype pre_validated_custom_domain_resource_id: ~azure.mgmt.cdn.models.ResourceReference
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.pre_validated_custom_domain_resource_id = pre_validated_custom_domain_resource_id


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class AFDEndpoint(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
     default value is TenantReuse. Known values are: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "profile_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "host_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "enabled_state": {"key": "properties.enabledState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "auto_generated_domain_name_label_scope": {
            "key": "properties.autoGeneratedDomainNameLabelScope",
            "type": "str",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
         default value is TenantReuse. Known values are: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", and "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.profile_name = None
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None
        self.host_name = None
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class AFDEndpointListResult(_serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.AFDEndpoint]
    :ivar next_link: URL to get the next set of endpoint objects if there is any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AFDEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of endpoint objects if there is any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDEndpointPropertiesUpdateParameters(_serialization.Model):
    """The JSON object containing endpoint update parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "profile_name": {"key": "profileName", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
    }

    def __init__(self, *, enabled_state: Optional[Union[str, "_models.EnabledState"]] = None, **kwargs):
        """
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.enabled_state = enabled_state


class AFDEndpointProperties(AFDEndpointPropertiesUpdateParameters, AFDStateProperties):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
     default value is TenantReuse. Known values are: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
        "host_name": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "profile_name": {"key": "profileName", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
        "auto_generated_domain_name_label_scope": {"key": "autoGeneratedDomainNameLabelScope", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        **kwargs
    ):
        """
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
         default value is TenantReuse. Known values are: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", and "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
        """
        super().__init__(enabled_state=enabled_state, **kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.host_name = None
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.profile_name = None
        self.enabled_state = enabled_state


class AFDEndpointUpdateParameters(_serialization.Model):
    """Properties required to create or update an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Endpoint tags.
    :vartype tags: dict[str, str]
    :ivar profile_name: The name of the profile which holds the endpoint.
    :vartype profile_name: str
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "enabled_state": {"key": "properties.enabledState", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Endpoint tags.
        :paramtype tags: dict[str, str]
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.profile_name = None
        self.enabled_state = enabled_state


class AfdErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cdn.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cdn.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class AFDOrigin(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "origin_group_name": {"readonly": True},
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "origin_group_name": {"key": "properties.originGroupName", "type": "str"},
        "azure_origin": {"key": "properties.azureOrigin", "type": "ResourceReference"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "http_port": {"key": "properties.httpPort", "type": "int"},
        "https_port": {"key": "properties.httpsPort", "type": "int"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "shared_private_link_resource": {
            "key": "properties.sharedPrivateLinkResource",
            "type": "SharedPrivateLinkResourceProperties",
        },
        "enabled_state": {"key": "properties.enabledState", "type": "str"},
        "enforce_certificate_name_check": {"key": "properties.enforceCertificateNameCheck", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["_models.ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["_models.SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        enforce_certificate_name_check: bool = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super().__init__(**kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroup(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "profile_name": {"readonly": True},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "load_balancing_settings": {
            "key": "properties.loadBalancingSettings",
            "type": "LoadBalancingSettingsParameters",
        },
        "health_probe_settings": {"key": "properties.healthProbeSettings", "type": "HealthProbeParameters"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "session_affinity_state": {"key": "properties.sessionAffinityState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["_models.LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.session_affinity_state = session_affinity_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroupListResult(_serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.AFDOriginGroup]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AFDOriginGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDOriginGroupUpdatePropertiesParameters(_serialization.Model):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "profile_name": {"readonly": True},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "profile_name": {"key": "profileName", "type": "str"},
        "load_balancing_settings": {"key": "loadBalancingSettings", "type": "LoadBalancingSettingsParameters"},
        "health_probe_settings": {"key": "healthProbeSettings", "type": "HealthProbeParameters"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "session_affinity_state": {"key": "sessionAffinityState", "type": "str"},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["_models.LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.session_affinity_state = session_affinity_state


class AFDOriginGroupProperties(AFDOriginGroupUpdatePropertiesParameters, AFDStateProperties):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "profile_name": {"key": "profileName", "type": "str"},
        "load_balancing_settings": {"key": "loadBalancingSettings", "type": "LoadBalancingSettingsParameters"},
        "health_probe_settings": {"key": "healthProbeSettings", "type": "HealthProbeParameters"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "session_affinity_state": {"key": "sessionAffinityState", "type": "str"},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["_models.LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(
            load_balancing_settings=load_balancing_settings,
            health_probe_settings=health_probe_settings,
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes,
            session_affinity_state=session_affinity_state,
            **kwargs
        )
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.session_affinity_state = session_affinity_state


class AFDOriginGroupUpdateParameters(_serialization.Model):
    """AFDOrigin group properties needed for origin group creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_name: The name of the profile which holds the origin group.
    :vartype profile_name: str
    :ivar load_balancing_settings: Load balancing settings for a backend pool.
    :vartype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar session_affinity_state: Whether to allow session affinity on this host. Valid options are
     'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "profile_name": {"readonly": True},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "load_balancing_settings": {
            "key": "properties.loadBalancingSettings",
            "type": "LoadBalancingSettingsParameters",
        },
        "health_probe_settings": {"key": "properties.healthProbeSettings", "type": "HealthProbeParameters"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "session_affinity_state": {"key": "properties.sessionAffinityState", "type": "str"},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["_models.LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        session_affinity_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword load_balancing_settings: Load balancing settings for a backend pool.
        :paramtype load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword session_affinity_state: Whether to allow session affinity on this host. Valid options
         are 'Enabled' or 'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.session_affinity_state = session_affinity_state


class AFDOriginListResult(_serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.AFDOrigin]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AFDOrigin]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDOriginUpdatePropertiesParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    """

    _validation = {
        "origin_group_name": {"readonly": True},
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "origin_group_name": {"key": "originGroupName", "type": "str"},
        "azure_origin": {"key": "azureOrigin", "type": "ResourceReference"},
        "host_name": {"key": "hostName", "type": "str"},
        "http_port": {"key": "httpPort", "type": "int"},
        "https_port": {"key": "httpsPort", "type": "int"},
        "origin_host_header": {"key": "originHostHeader", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "weight": {"key": "weight", "type": "int"},
        "shared_private_link_resource": {
            "key": "sharedPrivateLinkResource",
            "type": "SharedPrivateLinkResourceProperties",
        },
        "enabled_state": {"key": "enabledState", "type": "str"},
        "enforce_certificate_name_check": {"key": "enforceCertificateNameCheck", "type": "bool"},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["_models.ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["_models.SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        enforce_certificate_name_check: bool = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super().__init__(**kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check


class AFDOriginProperties(
    AFDOriginUpdatePropertiesParameters, AFDStateProperties
):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "origin_group_name": {"readonly": True},
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "origin_group_name": {"key": "originGroupName", "type": "str"},
        "azure_origin": {"key": "azureOrigin", "type": "ResourceReference"},
        "host_name": {"key": "hostName", "type": "str"},
        "http_port": {"key": "httpPort", "type": "int"},
        "https_port": {"key": "httpsPort", "type": "int"},
        "origin_host_header": {"key": "originHostHeader", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "weight": {"key": "weight", "type": "int"},
        "shared_private_link_resource": {
            "key": "sharedPrivateLinkResource",
            "type": "SharedPrivateLinkResourceProperties",
        },
        "enabled_state": {"key": "enabledState", "type": "str"},
        "enforce_certificate_name_check": {"key": "enforceCertificateNameCheck", "type": "bool"},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["_models.ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["_models.SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        enforce_certificate_name_check: bool = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super().__init__(
            azure_origin=azure_origin,
            host_name=host_name,
            http_port=http_port,
            https_port=https_port,
            origin_host_header=origin_host_header,
            priority=priority,
            weight=weight,
            shared_private_link_resource=shared_private_link_resource,
            enabled_state=enabled_state,
            enforce_certificate_name_check=enforce_certificate_name_check,
            **kwargs
        )
        self.provisioning_state = None
        self.deployment_status = None
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check


class AFDOriginUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """AFDOrigin properties needed for origin update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin_group_name: The name of the origin group which contains this origin.
    :vartype origin_group_name: str
    :ivar azure_origin: Resource reference to the Azure origin resource.
    :vartype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar shared_private_link_resource: The properties of the private link resource for private
     origin.
    :vartype shared_private_link_resource:
     ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
    :ivar enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar enforce_certificate_name_check: Whether to enable certificate name check at origin level.
    :vartype enforce_certificate_name_check: bool
    """

    _validation = {
        "origin_group_name": {"readonly": True},
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "origin_group_name": {"key": "properties.originGroupName", "type": "str"},
        "azure_origin": {"key": "properties.azureOrigin", "type": "ResourceReference"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "http_port": {"key": "properties.httpPort", "type": "int"},
        "https_port": {"key": "properties.httpsPort", "type": "int"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "shared_private_link_resource": {
            "key": "properties.sharedPrivateLinkResource",
            "type": "SharedPrivateLinkResourceProperties",
        },
        "enabled_state": {"key": "properties.enabledState", "type": "str"},
        "enforce_certificate_name_check": {"key": "properties.enforceCertificateNameCheck", "type": "bool"},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["_models.ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional["_models.SharedPrivateLinkResourceProperties"] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        enforce_certificate_name_check: bool = True,
        **kwargs
    ):
        """
        :keyword azure_origin: Resource reference to the Azure origin resource.
        :paramtype azure_origin: ~azure.mgmt.cdn.models.ResourceReference
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword shared_private_link_resource: The properties of the private link resource for private
         origin.
        :paramtype shared_private_link_resource:
         ~azure.mgmt.cdn.models.SharedPrivateLinkResourceProperties
        :keyword enabled_state: Whether to enable health probes to be made against backends defined
         under backendPools. Health probes can only be disabled if there is a single enabled backend in
         single enabled backend pool. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        :keyword enforce_certificate_name_check: Whether to enable certificate name check at origin
         level.
        :paramtype enforce_certificate_name_check: bool
        """
        super().__init__(**kwargs)
        self.origin_group_name = None
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.enforce_certificate_name_check = enforce_certificate_name_check


class AfdPurgeParameters(_serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :ivar content_paths: The path to the content to be purged. Can describe a file path or a wild
     card directory. Required.
    :vartype content_paths: list[str]
    :ivar domains: List of domains.
    :vartype domains: list[str]
    """

    _validation = {
        "content_paths": {"required": True},
    }

    _attribute_map = {
        "content_paths": {"key": "contentPaths", "type": "[str]"},
        "domains": {"key": "domains", "type": "[str]"},
    }

    def __init__(self, *, content_paths: List[str], domains: Optional[List[str]] = None, **kwargs):
        """
        :keyword content_paths: The path to the content to be purged. Can describe a file path or a
         wild card directory. Required.
        :paramtype content_paths: list[str]
        :keyword domains: List of domains.
        :paramtype domains: list[str]
        """
        super().__init__(**kwargs)
        self.content_paths = content_paths
        self.domains = domains


class AfdRouteCacheConfiguration(_serialization.Model):
    """Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.

    :ivar query_string_caching_behavior: Defines how Frontdoor caches requests that include query
     strings. You can ignore any query strings when caching, ignore specific query strings, cache
     every request with a unique URL, or cache specific query strings. Known values are:
     "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings", and
     "IncludeSpecifiedQueryStrings".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.AfdQueryStringCachingBehavior
    :ivar query_parameters: query parameters to include or exclude (comma separated).
    :vartype query_parameters: str
    :ivar compression_settings: compression settings.
    :vartype compression_settings: ~azure.mgmt.cdn.models.CompressionSettings
    """

    _attribute_map = {
        "query_string_caching_behavior": {"key": "queryStringCachingBehavior", "type": "str"},
        "query_parameters": {"key": "queryParameters", "type": "str"},
        "compression_settings": {"key": "compressionSettings", "type": "CompressionSettings"},
    }

    def __init__(
        self,
        *,
        query_string_caching_behavior: Optional[Union[str, "_models.AfdQueryStringCachingBehavior"]] = None,
        query_parameters: Optional[str] = None,
        compression_settings: Optional["_models.CompressionSettings"] = None,
        **kwargs
    ):
        """
        :keyword query_string_caching_behavior: Defines how Frontdoor caches requests that include
         query strings. You can ignore any query strings when caching, ignore specific query strings,
         cache every request with a unique URL, or cache specific query strings. Known values are:
         "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings", and
         "IncludeSpecifiedQueryStrings".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.AfdQueryStringCachingBehavior
        :keyword query_parameters: query parameters to include or exclude (comma separated).
        :paramtype query_parameters: str
        :keyword compression_settings: compression settings.
        :paramtype compression_settings: ~azure.mgmt.cdn.models.CompressionSettings
        """
        super().__init__(**kwargs)
        self.query_string_caching_behavior = query_string_caching_behavior
        self.query_parameters = query_parameters
        self.compression_settings = compression_settings


class Certificate(_serialization.Model):
    """Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        "subject": {"readonly": True},
        "expiration_date": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SecretType"]] = None, **kwargs):
        """
        :keyword type: The type of the secret resource. Known values are: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        """
        super().__init__(**kwargs)
        self.type = type
        self.subject = None
        self.expiration_date = None


class AzureFirstPartyManagedCertificate(Certificate):
    """Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        "subject": {"readonly": True},
        "expiration_date": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SecretType"]] = None, **kwargs):
        """
        :keyword type: The type of the secret resource. Known values are: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        """
        super().__init__(type=type, **kwargs)


class SecretParameters(_serialization.Model):
    """The json object containing secret parameters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFirstPartyManagedCertificateParameters, CustomerCertificateParameters,
    ManagedCertificateParameters, UrlSigningKeyParameters

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the secret resource. Required. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AzureFirstPartyManagedCertificate": "AzureFirstPartyManagedCertificateParameters",
            "CustomerCertificate": "CustomerCertificateParameters",
            "ManagedCertificate": "ManagedCertificateParameters",
            "UrlSigningKey": "UrlSigningKeyParameters",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureFirstPartyManagedCertificateParameters(SecretParameters):
    """Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the secret resource. Required. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = "AzureFirstPartyManagedCertificate"  # type: str


class CacheConfiguration(_serialization.Model):
    """Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.

    :ivar query_string_caching_behavior: Defines how Frontdoor caches requests that include query
     strings. You can ignore any query strings when caching, ignore specific query strings, cache
     every request with a unique URL, or cache specific query strings. Known values are:
     "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings", and
     "IncludeSpecifiedQueryStrings".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.RuleQueryStringCachingBehavior
    :ivar query_parameters: query parameters to include or exclude (comma separated).
    :vartype query_parameters: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled. If compression
     is enabled, content will be served as compressed if user requests for a compressed version.
     Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or
     larger than 1 MB. Known values are: "Enabled" and "Disabled".
    :vartype is_compression_enabled: str or ~azure.mgmt.cdn.models.RuleIsCompressionEnabled
    :ivar cache_behavior: Caching behavior for the requests. Known values are: "HonorOrigin",
     "OverrideAlways", and "OverrideIfOriginMissing".
    :vartype cache_behavior: str or ~azure.mgmt.cdn.models.RuleCacheBehavior
    :ivar cache_duration: The duration for which the content needs to be cached. Allowed format is
     [d.]hh:mm:ss.
    :vartype cache_duration: str
    """

    _attribute_map = {
        "query_string_caching_behavior": {"key": "queryStringCachingBehavior", "type": "str"},
        "query_parameters": {"key": "queryParameters", "type": "str"},
        "is_compression_enabled": {"key": "isCompressionEnabled", "type": "str"},
        "cache_behavior": {"key": "cacheBehavior", "type": "str"},
        "cache_duration": {"key": "cacheDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        query_string_caching_behavior: Optional[Union[str, "_models.RuleQueryStringCachingBehavior"]] = None,
        query_parameters: Optional[str] = None,
        is_compression_enabled: Optional[Union[str, "_models.RuleIsCompressionEnabled"]] = None,
        cache_behavior: Optional[Union[str, "_models.RuleCacheBehavior"]] = None,
        cache_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword query_string_caching_behavior: Defines how Frontdoor caches requests that include
         query strings. You can ignore any query strings when caching, ignore specific query strings,
         cache every request with a unique URL, or cache specific query strings. Known values are:
         "IgnoreQueryString", "UseQueryString", "IgnoreSpecifiedQueryStrings", and
         "IncludeSpecifiedQueryStrings".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.RuleQueryStringCachingBehavior
        :keyword query_parameters: query parameters to include or exclude (comma separated).
        :paramtype query_parameters: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled. If
         compression is enabled, content will be served as compressed if user requests for a compressed
         version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1
         byte or larger than 1 MB. Known values are: "Enabled" and "Disabled".
        :paramtype is_compression_enabled: str or ~azure.mgmt.cdn.models.RuleIsCompressionEnabled
        :keyword cache_behavior: Caching behavior for the requests. Known values are: "HonorOrigin",
         "OverrideAlways", and "OverrideIfOriginMissing".
        :paramtype cache_behavior: str or ~azure.mgmt.cdn.models.RuleCacheBehavior
        :keyword cache_duration: The duration for which the content needs to be cached. Allowed format
         is [d.]hh:mm:ss.
        :paramtype cache_duration: str
        """
        super().__init__(**kwargs)
        self.query_string_caching_behavior = query_string_caching_behavior
        self.query_parameters = query_parameters
        self.is_compression_enabled = is_compression_enabled
        self.cache_behavior = cache_behavior
        self.cache_duration = cache_duration


class CacheExpirationActionParameters(_serialization.Model):
    """Defines the parameters for the cache expiration action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleCacheExpirationActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.CacheExpirationActionParametersTypeName
    :ivar cache_behavior: Caching behavior for the requests. Required. Known values are:
     "BypassCache", "Override", and "SetIfMissing".
    :vartype cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
    :ivar cache_type: The level at which the content needs to be cached. Required. "All"
    :vartype cache_type: str or ~azure.mgmt.cdn.models.CacheType
    :ivar cache_duration: The duration for which the content needs to be cached. Allowed format is
     [d.]hh:mm:ss.
    :vartype cache_duration: str
    """

    _validation = {
        "type_name": {"required": True},
        "cache_behavior": {"required": True},
        "cache_type": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "cache_behavior": {"key": "cacheBehavior", "type": "str"},
        "cache_type": {"key": "cacheType", "type": "str"},
        "cache_duration": {"key": "cacheDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.CacheExpirationActionParametersTypeName"],
        cache_behavior: Union[str, "_models.CacheBehavior"],
        cache_type: Union[str, "_models.CacheType"],
        cache_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleCacheExpirationActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.CacheExpirationActionParametersTypeName
        :keyword cache_behavior: Caching behavior for the requests. Required. Known values are:
         "BypassCache", "Override", and "SetIfMissing".
        :paramtype cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
        :keyword cache_type: The level at which the content needs to be cached. Required. "All"
        :paramtype cache_type: str or ~azure.mgmt.cdn.models.CacheType
        :keyword cache_duration: The duration for which the content needs to be cached. Allowed format
         is [d.]hh:mm:ss.
        :paramtype cache_duration: str
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.cache_behavior = cache_behavior
        self.cache_type = cache_type
        self.cache_duration = cache_duration


class CacheKeyQueryStringActionParameters(_serialization.Model):
    """Defines the parameters for the cache-key query string action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParametersTypeName
    :ivar query_string_behavior: Caching behavior for the requests. Required. Known values are:
     "Include", "IncludeAll", "Exclude", and "ExcludeAll".
    :vartype query_string_behavior: str or ~azure.mgmt.cdn.models.QueryStringBehavior
    :ivar query_parameters: query parameters to include or exclude (comma separated).
    :vartype query_parameters: str
    """

    _validation = {
        "type_name": {"required": True},
        "query_string_behavior": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "query_string_behavior": {"key": "queryStringBehavior", "type": "str"},
        "query_parameters": {"key": "queryParameters", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.CacheKeyQueryStringActionParametersTypeName"],
        query_string_behavior: Union[str, "_models.QueryStringBehavior"],
        query_parameters: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParametersTypeName
        :keyword query_string_behavior: Caching behavior for the requests. Required. Known values are:
         "Include", "IncludeAll", "Exclude", and "ExcludeAll".
        :paramtype query_string_behavior: str or ~azure.mgmt.cdn.models.QueryStringBehavior
        :keyword query_parameters: query parameters to include or exclude (comma separated).
        :paramtype query_parameters: str
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.query_string_behavior = query_string_behavior
        self.query_parameters = query_parameters


class CdnCertificateSourceParameters(_serialization.Model):
    """Defines the parameters for using CDN managed certificate for securing custom domain.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "CdnCertificateSourceParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.CdnCertificateSourceParametersTypeName
    :ivar certificate_type: Type of certificate used. Required. Known values are: "Shared" and
     "Dedicated".
    :vartype certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
    """

    _validation = {
        "type_name": {"required": True},
        "certificate_type": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "certificate_type": {"key": "certificateType", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.CdnCertificateSourceParametersTypeName"],
        certificate_type: Union[str, "_models.CertificateType"],
        **kwargs
    ):
        """
        :keyword type_name: Required. "CdnCertificateSourceParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.CdnCertificateSourceParametersTypeName
        :keyword certificate_type: Type of certificate used. Required. Known values are: "Shared" and
         "Dedicated".
        :paramtype certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.certificate_type = certificate_type


class CdnEndpoint(_serialization.Model):
    """Defines the ARM Resource ID for the linked endpoints.

    :ivar id: ARM Resource ID string.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: ARM Resource ID string.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class CustomDomainHttpsParameters(_serialization.Model):
    """The JSON object that contains the properties to secure a custom domain.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    UserManagedHttpsParameters, CdnManagedHttpsParameters

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_source: Defines the source of the SSL certificate. Required. Known values
     are: "AzureKeyVault" and "Cdn".
    :vartype certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :ivar protocol_type: Defines the TLS extension protocol that is used for secure delivery.
     Required. Known values are: "ServerNameIndication" and "IPBased".
    :vartype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Known values are:
     "None", "TLS10", and "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    """

    _validation = {
        "certificate_source": {"required": True},
        "protocol_type": {"required": True},
    }

    _attribute_map = {
        "certificate_source": {"key": "certificateSource", "type": "str"},
        "protocol_type": {"key": "protocolType", "type": "str"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
    }

    _subtype_map = {
        "certificate_source": {"AzureKeyVault": "UserManagedHttpsParameters", "Cdn": "CdnManagedHttpsParameters"}
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "_models.ProtocolType"],
        minimum_tls_version: Optional[Union[str, "_models.MinimumTlsVersion"]] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Defines the TLS extension protocol that is used for secure delivery.
         Required. Known values are: "ServerNameIndication" and "IPBased".
        :paramtype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Known values
         are: "None", "TLS10", and "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
        """
        super().__init__(**kwargs)
        self.certificate_source = None  # type: Optional[str]
        self.protocol_type = protocol_type
        self.minimum_tls_version = minimum_tls_version


class CdnManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using CDN managed certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_source: Defines the source of the SSL certificate. Required. Known values
     are: "AzureKeyVault" and "Cdn".
    :vartype certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :ivar protocol_type: Defines the TLS extension protocol that is used for secure delivery.
     Required. Known values are: "ServerNameIndication" and "IPBased".
    :vartype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Known values are:
     "None", "TLS10", and "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :ivar certificate_source_parameters: Defines the certificate source parameters using CDN
     managed certificate for enabling SSL. Required.
    :vartype certificate_source_parameters: ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
    """

    _validation = {
        "certificate_source": {"required": True},
        "protocol_type": {"required": True},
        "certificate_source_parameters": {"required": True},
    }

    _attribute_map = {
        "certificate_source": {"key": "certificateSource", "type": "str"},
        "protocol_type": {"key": "protocolType", "type": "str"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "certificate_source_parameters": {
            "key": "certificateSourceParameters",
            "type": "CdnCertificateSourceParameters",
        },
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "_models.ProtocolType"],
        certificate_source_parameters: "_models.CdnCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "_models.MinimumTlsVersion"]] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Defines the TLS extension protocol that is used for secure delivery.
         Required. Known values are: "ServerNameIndication" and "IPBased".
        :paramtype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Known values
         are: "None", "TLS10", and "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
        :keyword certificate_source_parameters: Defines the certificate source parameters using CDN
         managed certificate for enabling SSL. Required.
        :paramtype certificate_source_parameters: ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
        """
        super().__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = "Cdn"  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class CdnWebApplicationFirewallPolicy(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Defines web application firewall policy for Azure CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar sku: The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy. Required.
    :vartype sku: ~azure.mgmt.cdn.models.Sku
    :ivar policy_settings: Describes  policySettings for policy.
    :vartype policy_settings: ~azure.mgmt.cdn.models.PolicySettings
    :ivar rate_limit_rules: Describes rate limit rules inside the policy.
    :vartype rate_limit_rules: ~azure.mgmt.cdn.models.RateLimitRuleList
    :ivar custom_rules: Describes custom rules inside the policy.
    :vartype custom_rules: ~azure.mgmt.cdn.models.CustomRuleList
    :ivar managed_rules: Describes managed rules inside the policy.
    :vartype managed_rules: ~azure.mgmt.cdn.models.ManagedRuleSetList
    :ivar endpoint_links: Describes Azure CDN endpoints associated with this Web Application
     Firewall policy.
    :vartype endpoint_links: list[~azure.mgmt.cdn.models.CdnEndpoint]
    :ivar provisioning_state: Provisioning state of the WebApplicationFirewallPolicy. Known values
     are: "Creating", "Succeeded", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.ProvisioningState
    :ivar resource_state: Resource status of the policy. Known values are: "Creating", "Enabling",
     "Enabled", "Disabling", "Disabled", and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.PolicyResourceState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "endpoint_links": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "policy_settings": {"key": "properties.policySettings", "type": "PolicySettings"},
        "rate_limit_rules": {"key": "properties.rateLimitRules", "type": "RateLimitRuleList"},
        "custom_rules": {"key": "properties.customRules", "type": "CustomRuleList"},
        "managed_rules": {"key": "properties.managedRules", "type": "ManagedRuleSetList"},
        "endpoint_links": {"key": "properties.endpointLinks", "type": "[CdnEndpoint]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        policy_settings: Optional["_models.PolicySettings"] = None,
        rate_limit_rules: Optional["_models.RateLimitRuleList"] = None,
        custom_rules: Optional["_models.CustomRuleList"] = None,
        managed_rules: Optional["_models.ManagedRuleSetList"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword sku: The pricing tier (defines a CDN provider, feature list and rate) of the
         CdnWebApplicationFirewallPolicy. Required.
        :paramtype sku: ~azure.mgmt.cdn.models.Sku
        :keyword policy_settings: Describes  policySettings for policy.
        :paramtype policy_settings: ~azure.mgmt.cdn.models.PolicySettings
        :keyword rate_limit_rules: Describes rate limit rules inside the policy.
        :paramtype rate_limit_rules: ~azure.mgmt.cdn.models.RateLimitRuleList
        :keyword custom_rules: Describes custom rules inside the policy.
        :paramtype custom_rules: ~azure.mgmt.cdn.models.CustomRuleList
        :keyword managed_rules: Describes managed rules inside the policy.
        :paramtype managed_rules: ~azure.mgmt.cdn.models.ManagedRuleSetList
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.policy_settings = policy_settings
        self.rate_limit_rules = rate_limit_rules
        self.custom_rules = custom_rules
        self.managed_rules = managed_rules
        self.endpoint_links = None
        self.provisioning_state = None
        self.resource_state = None


class CdnWebApplicationFirewallPolicyList(_serialization.Model):
    """Defines a list of WebApplicationFirewallPolicies for Azure CDN. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Azure CDN WebApplicationFirewallPolicies within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.CdnWebApplicationFirewallPolicy]
    :ivar next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CdnWebApplicationFirewallPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there
         are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CdnWebApplicationFirewallPolicyPatchParameters(_serialization.Model):
    """Properties required to update a CdnWebApplicationFirewallPolicy.

    :ivar tags: CdnWebApplicationFirewallPolicy tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: CdnWebApplicationFirewallPolicy tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CheckEndpointNameAvailabilityInput(_serialization.Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The resource name to validate. Required.
    :vartype name: str
    :ivar type: The type of the resource whose name is to be validated. Required. Known values are:
     "Microsoft.Cdn/Profiles/Endpoints" and "Microsoft.Cdn/Profiles/AfdEndpoints".
    :vartype type: str or ~azure.mgmt.cdn.models.ResourceType
    :ivar auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
     default value is TenantReuse. Known values are: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "auto_generated_domain_name_label_scope": {"key": "autoGeneratedDomainNameLabelScope", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ResourceType"],
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        **kwargs
    ):
        """
        :keyword name: The resource name to validate. Required.
        :paramtype name: str
        :keyword type: The type of the resource whose name is to be validated. Required. Known values
         are: "Microsoft.Cdn/Profiles/Endpoints" and "Microsoft.Cdn/Profiles/AfdEndpoints".
        :paramtype type: str or ~azure.mgmt.cdn.models.ResourceType
        :keyword auto_generated_domain_name_label_scope: Indicates the endpoint name reuse scope. The
         default value is TenantReuse. Known values are: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", and "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.cdn.models.AutoGeneratedDomainNameLabelScope
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope


class CheckEndpointNameAvailabilityOutput(_serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar available_hostname: Returns the available hostname generated based on the
     AutoGeneratedDomainNameLabelScope when the name is available, otherwise it returns empty
     string.
    :vartype available_hostname: str
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "available_hostname": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "available_hostname": {"key": "availableHostname", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.available_hostname = None
        self.reason = None
        self.message = None


class CheckHostNameAvailabilityInput(_serialization.Model):
    """Input of CheckHostNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar host_name: The host name to validate. Required.
    :vartype host_name: str
    """

    _validation = {
        "host_name": {"required": True},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
    }

    def __init__(self, *, host_name: str, **kwargs):
        """
        :keyword host_name: The host name to validate. Required.
        :paramtype host_name: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name


class CheckNameAvailabilityInput(_serialization.Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The resource name to validate. Required.
    :vartype name: str
    :ivar type: The type of the resource whose name is to be validated. Required. Known values are:
     "Microsoft.Cdn/Profiles/Endpoints" and "Microsoft.Cdn/Profiles/AfdEndpoints".
    :vartype type: str or ~azure.mgmt.cdn.models.ResourceType
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Union[str, "_models.ResourceType"], **kwargs):
        """
        :keyword name: The resource name to validate. Required.
        :paramtype name: str
        :keyword type: The type of the resource whose name is to be validated. Required. Known values
         are: "Microsoft.Cdn/Profiles/Endpoints" and "Microsoft.Cdn/Profiles/AfdEndpoints".
        :paramtype type: str or ~azure.mgmt.cdn.models.ResourceType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityOutput(_serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CidrIpAddress(_serialization.Model):
    """CIDR Ip address.

    :ivar base_ip_address: Ip address itself.
    :vartype base_ip_address: str
    :ivar prefix_length: The length of the prefix of the ip address.
    :vartype prefix_length: int
    """

    _attribute_map = {
        "base_ip_address": {"key": "baseIpAddress", "type": "str"},
        "prefix_length": {"key": "prefixLength", "type": "int"},
    }

    def __init__(self, *, base_ip_address: Optional[str] = None, prefix_length: Optional[int] = None, **kwargs):
        """
        :keyword base_ip_address: Ip address itself.
        :paramtype base_ip_address: str
        :keyword prefix_length: The length of the prefix of the ip address.
        :paramtype prefix_length: int
        """
        super().__init__(**kwargs)
        self.base_ip_address = base_ip_address
        self.prefix_length = prefix_length


class ClientPortMatchConditionParameters(_serialization.Model):
    """Defines the parameters for ClientPort match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleClientPortConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.ClientPortMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.ClientPortOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.ClientPortMatchConditionParametersTypeName"],
        operator: Union[str, "_models.ClientPortOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleClientPortConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.ClientPortMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.ClientPortOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems(_serialization.Model):
    """Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems.

    :ivar date_time:
    :vartype date_time: ~datetime.datetime
    :ivar value:
    :vartype value: float
    """

    _attribute_map = {
        "date_time": {"key": "dateTime", "type": "iso-8601"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, date_time: Optional[datetime.datetime] = None, value: Optional[float] = None, **kwargs):
        """
        :keyword date_time:
        :paramtype date_time: ~datetime.datetime
        :keyword value:
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.date_time = date_time
        self.value = value


class Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems(_serialization.Model):
    """Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems.

    :ivar date_time:
    :vartype date_time: ~datetime.datetime
    :ivar value:
    :vartype value: float
    """

    _attribute_map = {
        "date_time": {"key": "dateTime", "type": "iso-8601"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, date_time: Optional[datetime.datetime] = None, value: Optional[float] = None, **kwargs):
        """
        :keyword date_time:
        :paramtype date_time: ~datetime.datetime
        :keyword value:
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.date_time = date_time
        self.value = value


class ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems(_serialization.Model):
    """ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems.

    :ivar metric:
    :vartype metric: str
    :ivar value:
    :vartype value: int
    :ivar percentage:
    :vartype percentage: float
    """

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "value": {"key": "value", "type": "int"},
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(
        self, *, metric: Optional[str] = None, value: Optional[int] = None, percentage: Optional[float] = None, **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword value:
        :paramtype value: int
        :keyword percentage:
        :paramtype percentage: float
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.value = value
        self.percentage = percentage


class CompressionSettings(_serialization.Model):
    """settings for compression.

    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar is_compression_enabled: Indicates whether content compression is enabled on
     AzureFrontDoor. Default value is false. If compression is enabled, content will be served as
     compressed if user requests for a compressed version. Content won't be compressed on
     AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    """

    _attribute_map = {
        "content_types_to_compress": {"key": "contentTypesToCompress", "type": "[str]"},
        "is_compression_enabled": {"key": "isCompressionEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        content_types_to_compress: Optional[List[str]] = None,
        is_compression_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword is_compression_enabled: Indicates whether content compression is enabled on
         AzureFrontDoor. Default value is false. If compression is enabled, content will be served as
         compressed if user requests for a compressed version. Content won't be compressed on
         AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        """
        super().__init__(**kwargs)
        self.content_types_to_compress = content_types_to_compress
        self.is_compression_enabled = is_compression_enabled


class ContinentsResponse(_serialization.Model):
    """Continents Response.

    :ivar continents:
    :vartype continents: list[~azure.mgmt.cdn.models.ContinentsResponseContinentsItem]
    :ivar country_or_regions:
    :vartype country_or_regions:
     list[~azure.mgmt.cdn.models.ContinentsResponseCountryOrRegionsItem]
    """

    _attribute_map = {
        "continents": {"key": "continents", "type": "[ContinentsResponseContinentsItem]"},
        "country_or_regions": {"key": "countryOrRegions", "type": "[ContinentsResponseCountryOrRegionsItem]"},
    }

    def __init__(
        self,
        *,
        continents: Optional[List["_models.ContinentsResponseContinentsItem"]] = None,
        country_or_regions: Optional[List["_models.ContinentsResponseCountryOrRegionsItem"]] = None,
        **kwargs
    ):
        """
        :keyword continents:
        :paramtype continents: list[~azure.mgmt.cdn.models.ContinentsResponseContinentsItem]
        :keyword country_or_regions:
        :paramtype country_or_regions:
         list[~azure.mgmt.cdn.models.ContinentsResponseCountryOrRegionsItem]
        """
        super().__init__(**kwargs)
        self.continents = continents
        self.country_or_regions = country_or_regions


class ContinentsResponseContinentsItem(_serialization.Model):
    """ContinentsResponseContinentsItem.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id:
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ContinentsResponseCountryOrRegionsItem(_serialization.Model):
    """ContinentsResponseCountryOrRegionsItem.

    :ivar id:
    :vartype id: str
    :ivar continent_id:
    :vartype continent_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "continent_id": {"key": "continentId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        continent_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword continent_id:
        :paramtype continent_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.continent_id = continent_id


class CookiesMatchConditionParameters(_serialization.Model):
    """Defines the parameters for Cookies match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleCookiesConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.CookiesMatchConditionParametersTypeName
    :ivar selector: Name of Cookies to be matched.
    :vartype selector: str
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.CookiesOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.CookiesMatchConditionParametersTypeName"],
        operator: Union[str, "_models.CookiesOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleCookiesConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.CookiesMatchConditionParametersTypeName
        :keyword selector: Name of Cookies to be matched.
        :paramtype selector: str
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.CookiesOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class CustomDomain(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar host_name: The host name of the custom domain. Must be a domain name.
    :vartype host_name: str
    :ivar resource_state: Resource status of the custom domain. Known values are: "Creating",
     "Active", and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.CustomDomainResourceState
    :ivar custom_https_provisioning_state: Provisioning status of the custom domain. Known values
     are: "Enabling", "Enabled", "Disabling", "Disabled", and "Failed".
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the progress of custom
     HTTPS enabling/disabling process step by step. Known values are:
     "SubmittingDomainControlValidationRequest", "PendingDomainControlValidationREquestApproval",
     "DomainControlValidationRequestApproved", "DomainControlValidationRequestRejected",
     "DomainControlValidationRequestTimedOut", "IssuingCertificate", "DeployingCertificate",
     "CertificateDeployed", "DeletingCertificate", and "CertificateDeleted".
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningSubstate
    :ivar custom_https_parameters: Certificate parameters for securing custom HTTPS.
    :vartype custom_https_parameters: ~azure.mgmt.cdn.models.CustomDomainHttpsParameters
    :ivar validation_data: Special validation or data may be required when delivering CDN to some
     regions due to local compliance reasons. E.g. ICP license number of a custom domain is required
     to deliver content in China.
    :vartype validation_data: str
    :ivar provisioning_state: Provisioning status of Custom Https of the custom domain. Known
     values are: "Enabling", "Enabled", "Disabling", "Disabled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.CustomHttpsProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "resource_state": {"readonly": True},
        "custom_https_provisioning_state": {"readonly": True},
        "custom_https_provisioning_substate": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "custom_https_provisioning_state": {"key": "properties.customHttpsProvisioningState", "type": "str"},
        "custom_https_provisioning_substate": {"key": "properties.customHttpsProvisioningSubstate", "type": "str"},
        "custom_https_parameters": {"key": "properties.customHttpsParameters", "type": "CustomDomainHttpsParameters"},
        "validation_data": {"key": "properties.validationData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        custom_https_parameters: Optional["_models.CustomDomainHttpsParameters"] = None,
        validation_data: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The host name of the custom domain. Must be a domain name.
        :paramtype host_name: str
        :keyword custom_https_parameters: Certificate parameters for securing custom HTTPS.
        :paramtype custom_https_parameters: ~azure.mgmt.cdn.models.CustomDomainHttpsParameters
        :keyword validation_data: Special validation or data may be required when delivering CDN to
         some regions due to local compliance reasons. E.g. ICP license number of a custom domain is
         required to deliver content in China.
        :paramtype validation_data: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_parameters = custom_https_parameters
        self.validation_data = validation_data
        self.provisioning_state = None


class CustomDomainListResult(_serialization.Model):
    """Result of the request to list custom domains. It contains a list of custom domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN CustomDomains within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.CustomDomain]
    :ivar next_link: URL to get the next set of custom domain objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of custom domain objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CustomDomainParameters(_serialization.Model):
    """The customDomain JSON object required for custom domain creation or update.

    :ivar host_name: The host name of the custom domain. Must be a domain name.
    :vartype host_name: str
    """

    _attribute_map = {
        "host_name": {"key": "properties.hostName", "type": "str"},
    }

    def __init__(self, *, host_name: Optional[str] = None, **kwargs):
        """
        :keyword host_name: The host name of the custom domain. Must be a domain name.
        :paramtype host_name: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name


class CustomerCertificate(Certificate):
    """Customer Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    :ivar secret_source: Resource reference to the Azure Key Vault certificate. Expected to be in
     format of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Certificate version.
    :vartype secret_version: str
    :ivar certificate_authority: Certificate issuing authority.
    :vartype certificate_authority: str
    :ivar use_latest_version: Whether to use the latest version for the certificate.
    :vartype use_latest_version: bool
    :ivar subject_alternative_names: The list of SANs.
    :vartype subject_alternative_names: list[str]
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        "subject": {"readonly": True},
        "expiration_date": {"readonly": True},
        "certificate_authority": {"readonly": True},
        "thumbprint": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
        "secret_source": {"key": "secretSource", "type": "ResourceReference"},
        "secret_version": {"key": "secretVersion", "type": "str"},
        "certificate_authority": {"key": "certificateAuthority", "type": "str"},
        "use_latest_version": {"key": "useLatestVersion", "type": "bool"},
        "subject_alternative_names": {"key": "subjectAlternativeNames", "type": "[str]"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SecretType"]] = None,
        secret_source: Optional["_models.ResourceReference"] = None,
        secret_version: Optional[str] = None,
        use_latest_version: Optional[bool] = None,
        subject_alternative_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of the secret resource. Known values are: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        :keyword secret_source: Resource reference to the Azure Key Vault certificate. Expected to be
         in format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Certificate version.
        :paramtype secret_version: str
        :keyword use_latest_version: Whether to use the latest version for the certificate.
        :paramtype use_latest_version: bool
        :keyword subject_alternative_names: The list of SANs.
        :paramtype subject_alternative_names: list[str]
        """
        super().__init__(type=type, **kwargs)
        self.secret_source = secret_source
        self.secret_version = secret_version
        self.certificate_authority = None
        self.use_latest_version = use_latest_version
        self.subject_alternative_names = subject_alternative_names
        self.thumbprint = None


class CustomerCertificateParameters(SecretParameters):
    """Customer Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the secret resource. Required. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar secret_source: Resource reference to the Azure Key Vault certificate. Expected to be in
     format of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
     Required.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Version of the secret to be used.
    :vartype secret_version: str
    :ivar use_latest_version: Whether to use the latest version for the certificate.
    :vartype use_latest_version: bool
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    :ivar certificate_authority: Certificate issuing authority.
    :vartype certificate_authority: str
    :ivar subject_alternative_names: The list of SANs.
    :vartype subject_alternative_names: list[str]
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        "type": {"required": True},
        "secret_source": {"required": True},
        "subject": {"readonly": True},
        "expiration_date": {"readonly": True},
        "certificate_authority": {"readonly": True},
        "thumbprint": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "secret_source": {"key": "secretSource", "type": "ResourceReference"},
        "secret_version": {"key": "secretVersion", "type": "str"},
        "use_latest_version": {"key": "useLatestVersion", "type": "bool"},
        "subject": {"key": "subject", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
        "certificate_authority": {"key": "certificateAuthority", "type": "str"},
        "subject_alternative_names": {"key": "subjectAlternativeNames", "type": "[str]"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        secret_source: "_models.ResourceReference",
        secret_version: Optional[str] = None,
        use_latest_version: Optional[bool] = None,
        subject_alternative_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword secret_source: Resource reference to the Azure Key Vault certificate. Expected to be
         in format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
         Required.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Version of the secret to be used.
        :paramtype secret_version: str
        :keyword use_latest_version: Whether to use the latest version for the certificate.
        :paramtype use_latest_version: bool
        :keyword subject_alternative_names: The list of SANs.
        :paramtype subject_alternative_names: list[str]
        """
        super().__init__(**kwargs)
        self.type = "CustomerCertificate"  # type: str
        self.secret_source = secret_source
        self.secret_version = secret_version
        self.use_latest_version = use_latest_version
        self.subject = None
        self.expiration_date = None
        self.certificate_authority = None
        self.subject_alternative_names = subject_alternative_names
        self.thumbprint = None


class CustomRule(_serialization.Model):
    """Defines the common attributes for a custom rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Defines the name of the custom rule. Required.
    :vartype name: str
    :ivar enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Known values are: "Disabled" and "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :ivar priority: Defines in what order this rule be evaluated in the overall list of custom
     rules. Required.
    :vartype priority: int
    :ivar match_conditions: List of match conditions. Required.
    :vartype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :ivar action: Describes what action to be applied when rule matches. Required. Known values
     are: "Allow", "Block", "Log", and "Redirect".
    :vartype action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        "name": {"required": True},
        "priority": {"required": True, "maximum": 1000, "minimum": 0},
        "match_conditions": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "match_conditions": {"key": "matchConditions", "type": "[MatchCondition]"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["_models.MatchCondition"],
        action: Union[str, "_models.ActionType"],
        enabled_state: Optional[Union[str, "_models.CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword name: Defines the name of the custom rule. Required.
        :paramtype name: str
        :keyword enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults
         to Enabled if not specified. Known values are: "Disabled" and "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
        :keyword priority: Defines in what order this rule be evaluated in the overall list of custom
         rules. Required.
        :paramtype priority: int
        :keyword match_conditions: List of match conditions. Required.
        :paramtype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
        :keyword action: Describes what action to be applied when rule matches. Required. Known values
         are: "Allow", "Block", "Log", and "Redirect".
        :paramtype action: str or ~azure.mgmt.cdn.models.ActionType
        """
        super().__init__(**kwargs)
        self.name = name
        self.enabled_state = enabled_state
        self.priority = priority
        self.match_conditions = match_conditions
        self.action = action


class CustomRuleList(_serialization.Model):
    """Defines contents of custom rules.

    :ivar rules: List of rules.
    :vartype rules: list[~azure.mgmt.cdn.models.CustomRule]
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[CustomRule]"},
    }

    def __init__(self, *, rules: Optional[List["_models.CustomRule"]] = None, **kwargs):
        """
        :keyword rules: List of rules.
        :paramtype rules: list[~azure.mgmt.cdn.models.CustomRule]
        """
        super().__init__(**kwargs)
        self.rules = rules


class DeepCreatedCustomDomain(_serialization.Model):
    """Custom domains created on the CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Custom domain name. Required.
    :vartype name: str
    :ivar host_name: The host name of the custom domain. Must be a domain name.
    :vartype host_name: str
    :ivar validation_data: Special validation or data may be required when delivering CDN to some
     regions due to local compliance reasons. E.g. ICP license number of a custom domain is required
     to deliver content in China.
    :vartype validation_data: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "validation_data": {"key": "properties.validationData", "type": "str"},
    }

    def __init__(self, *, name: str, host_name: Optional[str] = None, validation_data: Optional[str] = None, **kwargs):
        """
        :keyword name: Custom domain name. Required.
        :paramtype name: str
        :keyword host_name: The host name of the custom domain. Must be a domain name.
        :paramtype host_name: str
        :keyword validation_data: Special validation or data may be required when delivering CDN to
         some regions due to local compliance reasons. E.g. ICP license number of a custom domain is
         required to deliver content in China.
        :paramtype validation_data: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.host_name = host_name
        self.validation_data = validation_data


class DeepCreatedOrigin(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The main origin of CDN content which is added when creating a CDN endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Origin name which must be unique within the endpoint. Required.
    :vartype name: str
    :ivar host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6
     address. This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not. By default, origin is always
     enabled.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Known values are: "Pending", "Approved", "Rejected", "Disconnected", and "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        "name": {"required": True},
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
        "private_endpoint_status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "http_port": {"key": "properties.httpPort", "type": "int"},
        "https_port": {"key": "properties.httpsPort", "type": "int"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "private_link_alias": {"key": "properties.privateLinkAlias", "type": "str"},
        "private_link_resource_id": {"key": "properties.privateLinkResourceId", "type": "str"},
        "private_link_location": {"key": "properties.privateLinkLocation", "type": "str"},
        "private_link_approval_message": {"key": "properties.privateLinkApprovalMessage", "type": "str"},
        "private_endpoint_status": {"key": "properties.privateEndpointStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Origin name which must be unique within the endpoint. Required.
        :paramtype name: str
        :keyword host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6
         address. This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not. By default, origin is always
         enabled.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message
        self.private_endpoint_status = None


class DeepCreatedOriginGroup(_serialization.Model):
    """The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Origin group name which must be unique within the endpoint. Required.
    :vartype name: str
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses.This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        "name": {"required": True},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "health_probe_settings": {"key": "properties.healthProbeSettings", "type": "HealthProbeParameters"},
        "origins": {"key": "properties.origins", "type": "[ResourceReference]"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "response_based_origin_error_detection_settings": {
            "key": "properties.responseBasedOriginErrorDetectionSettings",
            "type": "ResponseBasedOriginErrorDetectionParameters",
        },
    }

    def __init__(
        self,
        *,
        name: str,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        origins: Optional[List["_models.ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional[
            "_models.ResponseBasedOriginErrorDetectionParameters"
        ] = None,
        **kwargs
    ):
        """
        :keyword name: Origin group name which must be unique within the endpoint. Required.
        :paramtype name: str
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses.This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super().__init__(**kwargs)
        self.name = name
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class DeliveryRule(_serialization.Model):
    """A rule that specifies a set of actions and conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the rule.
    :vartype name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied. Required.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied. Required.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    """

    _validation = {
        "order": {"required": True},
        "actions": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "conditions": {"key": "conditions", "type": "[DeliveryRuleCondition]"},
        "actions": {"key": "actions", "type": "[DeliveryRuleAction]"},
    }

    def __init__(
        self,
        *,
        order: int,
        actions: List["_models.DeliveryRuleAction"],
        name: Optional[str] = None,
        conditions: Optional[List["_models.DeliveryRuleCondition"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the rule.
        :paramtype name: str
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied. Required.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied. Required.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        """
        super().__init__(**kwargs)
        self.name = name
        self.order = order
        self.conditions = conditions
        self.actions = actions


class DeliveryRuleAction(_serialization.Model):
    """An action for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DeliveryRuleCacheExpirationAction, DeliveryRuleCacheKeyQueryStringAction,
    DeliveryRuleRequestHeaderAction, DeliveryRuleResponseHeaderAction, OriginGroupOverrideAction,
    DeliveryRuleRouteConfigurationOverrideAction, UrlRedirectAction, UrlRewriteAction,
    UrlSigningAction

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    _subtype_map = {
        "name": {
            "CacheExpiration": "DeliveryRuleCacheExpirationAction",
            "CacheKeyQueryString": "DeliveryRuleCacheKeyQueryStringAction",
            "ModifyRequestHeader": "DeliveryRuleRequestHeaderAction",
            "ModifyResponseHeader": "DeliveryRuleResponseHeaderAction",
            "OriginGroupOverride": "OriginGroupOverrideAction",
            "RouteConfigurationOverride": "DeliveryRuleRouteConfigurationOverrideAction",
            "UrlRedirect": "UrlRedirectAction",
            "UrlRewrite": "UrlRewriteAction",
            "UrlSigning": "UrlSigningAction",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleCacheExpirationAction(DeliveryRuleAction):
    """Defines the cache expiration action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "CacheExpirationActionParameters"},
    }

    def __init__(self, *, parameters: "_models.CacheExpirationActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
        """
        super().__init__(**kwargs)
        self.name = "CacheExpiration"  # type: str
        self.parameters = parameters


class DeliveryRuleCacheKeyQueryStringAction(DeliveryRuleAction):
    """Defines the cache-key query string action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "CacheKeyQueryStringActionParameters"},
    }

    def __init__(self, *, parameters: "_models.CacheKeyQueryStringActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
        """
        super().__init__(**kwargs)
        self.name = "CacheKeyQueryString"  # type: str
        self.parameters = parameters


class DeliveryRuleCondition(_serialization.Model):
    """A condition for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DeliveryRuleClientPortCondition, DeliveryRuleCookiesCondition, DeliveryRuleHostNameCondition,
    DeliveryRuleHttpVersionCondition, DeliveryRuleIsDeviceCondition, DeliveryRulePostArgsCondition,
    DeliveryRuleQueryStringCondition, DeliveryRuleRemoteAddressCondition,
    DeliveryRuleRequestBodyCondition, DeliveryRuleRequestHeaderCondition,
    DeliveryRuleRequestMethodCondition, DeliveryRuleRequestSchemeCondition,
    DeliveryRuleRequestUriCondition, DeliveryRuleServerPortCondition,
    DeliveryRuleSocketAddrCondition, DeliveryRuleSslProtocolCondition,
    DeliveryRuleUrlFileExtensionCondition, DeliveryRuleUrlFileNameCondition,
    DeliveryRuleUrlPathCondition

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    _subtype_map = {
        "name": {
            "ClientPort": "DeliveryRuleClientPortCondition",
            "Cookies": "DeliveryRuleCookiesCondition",
            "HostName": "DeliveryRuleHostNameCondition",
            "HttpVersion": "DeliveryRuleHttpVersionCondition",
            "IsDevice": "DeliveryRuleIsDeviceCondition",
            "PostArgs": "DeliveryRulePostArgsCondition",
            "QueryString": "DeliveryRuleQueryStringCondition",
            "RemoteAddress": "DeliveryRuleRemoteAddressCondition",
            "RequestBody": "DeliveryRuleRequestBodyCondition",
            "RequestHeader": "DeliveryRuleRequestHeaderCondition",
            "RequestMethod": "DeliveryRuleRequestMethodCondition",
            "RequestScheme": "DeliveryRuleRequestSchemeCondition",
            "RequestUri": "DeliveryRuleRequestUriCondition",
            "ServerPort": "DeliveryRuleServerPortCondition",
            "SocketAddr": "DeliveryRuleSocketAddrCondition",
            "SslProtocol": "DeliveryRuleSslProtocolCondition",
            "UrlFileExtension": "DeliveryRuleUrlFileExtensionCondition",
            "UrlFileName": "DeliveryRuleUrlFileNameCondition",
            "UrlPath": "DeliveryRuleUrlPathCondition",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleClientPortCondition(DeliveryRuleCondition):
    """Defines the ClientPort condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.ClientPortMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "ClientPortMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.ClientPortMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.ClientPortMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "ClientPort"  # type: str
        self.parameters = parameters


class DeliveryRuleCookiesCondition(DeliveryRuleCondition):
    """Defines the Cookies condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "CookiesMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.CookiesMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "Cookies"  # type: str
        self.parameters = parameters


class DeliveryRuleHostNameCondition(DeliveryRuleCondition):
    """Defines the HostName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.HostNameMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "HostNameMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.HostNameMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.HostNameMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "HostName"  # type: str
        self.parameters = parameters


class DeliveryRuleHttpVersionCondition(DeliveryRuleCondition):
    """Defines the HttpVersion condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "HttpVersionMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.HttpVersionMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "HttpVersion"  # type: str
        self.parameters = parameters


class DeliveryRuleIsDeviceCondition(DeliveryRuleCondition):
    """Defines the IsDevice condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "IsDeviceMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.IsDeviceMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "IsDevice"  # type: str
        self.parameters = parameters


class DeliveryRulePostArgsCondition(DeliveryRuleCondition):
    """Defines the PostArgs condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "PostArgsMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.PostArgsMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "PostArgs"  # type: str
        self.parameters = parameters


class DeliveryRuleQueryStringCondition(DeliveryRuleCondition):
    """Defines the QueryString condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "QueryStringMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.QueryStringMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "QueryString"  # type: str
        self.parameters = parameters


class DeliveryRuleRemoteAddressCondition(DeliveryRuleCondition):
    """Defines the RemoteAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RemoteAddressMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.RemoteAddressMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "RemoteAddress"  # type: str
        self.parameters = parameters


class DeliveryRuleRequestBodyCondition(DeliveryRuleCondition):
    """Defines the RequestBody condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RequestBodyMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.RequestBodyMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "RequestBody"  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderAction(DeliveryRuleAction):
    """Defines the request header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "HeaderActionParameters"},
    }

    def __init__(self, *, parameters: "_models.HeaderActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
        """
        super().__init__(**kwargs)
        self.name = "ModifyRequestHeader"  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderCondition(DeliveryRuleCondition):
    """Defines the RequestHeader condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RequestHeaderMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.RequestHeaderMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "RequestHeader"  # type: str
        self.parameters = parameters


class DeliveryRuleRequestMethodCondition(DeliveryRuleCondition):
    """Defines the RequestMethod condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RequestMethodMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.RequestMethodMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "RequestMethod"  # type: str
        self.parameters = parameters


class DeliveryRuleRequestSchemeCondition(DeliveryRuleCondition):
    """Defines the RequestScheme condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RequestSchemeMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.RequestSchemeMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "RequestScheme"  # type: str
        self.parameters = parameters


class DeliveryRuleRequestUriCondition(DeliveryRuleCondition):
    """Defines the RequestUri condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RequestUriMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.RequestUriMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "RequestUri"  # type: str
        self.parameters = parameters


class DeliveryRuleResponseHeaderAction(DeliveryRuleAction):
    """Defines the response header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "HeaderActionParameters"},
    }

    def __init__(self, *, parameters: "_models.HeaderActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
        """
        super().__init__(**kwargs)
        self.name = "ModifyResponseHeader"  # type: str
        self.parameters = parameters


class DeliveryRuleRouteConfigurationOverrideAction(DeliveryRuleAction):
    """Defines the route configuration override action for the delivery rule. Only applicable to Frontdoor Standard/Premium Profiles.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.RouteConfigurationOverrideActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "RouteConfigurationOverrideActionParameters"},
    }

    def __init__(self, *, parameters: "_models.RouteConfigurationOverrideActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.RouteConfigurationOverrideActionParameters
        """
        super().__init__(**kwargs)
        self.name = "RouteConfigurationOverride"  # type: str
        self.parameters = parameters


class DeliveryRuleServerPortCondition(DeliveryRuleCondition):
    """Defines the ServerPort condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.ServerPortMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "ServerPortMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.ServerPortMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.ServerPortMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "ServerPort"  # type: str
        self.parameters = parameters


class DeliveryRuleSocketAddrCondition(DeliveryRuleCondition):
    """Defines the SocketAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.SocketAddrMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "SocketAddrMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.SocketAddrMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.SocketAddrMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "SocketAddr"  # type: str
        self.parameters = parameters


class DeliveryRuleSslProtocolCondition(DeliveryRuleCondition):
    """Defines the SslProtocol condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.SslProtocolMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "SslProtocolMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.SslProtocolMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.SslProtocolMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "SslProtocol"  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileExtensionCondition(DeliveryRuleCondition):
    """Defines the UrlFileExtension condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "UrlFileExtensionMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.UrlFileExtensionMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "UrlFileExtension"  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileNameCondition(DeliveryRuleCondition):
    """Defines the UrlFileName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "UrlFileNameMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.UrlFileNameMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "UrlFileName"  # type: str
        self.parameters = parameters


class DeliveryRuleUrlPathCondition(DeliveryRuleCondition):
    """Defines the UrlPath condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the condition for the delivery rule. Required. Known values are:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "SocketAddr", "ClientPort", "ServerPort", "HostName", and "SslProtocol".
    :vartype name: str or ~azure.mgmt.cdn.models.MatchVariable
    :ivar parameters: Defines the parameters for the condition. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "UrlPathMatchConditionParameters"},
    }

    def __init__(self, *, parameters: "_models.UrlPathMatchConditionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the condition. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
        """
        super().__init__(**kwargs)
        self.name = "UrlPath"  # type: str
        self.parameters = parameters


class DimensionProperties(_serialization.Model):
    """Type of operation: get, read, delete, etc.

    :ivar name: Name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    :ivar internal_name: Internal name of dimension.
    :vartype internal_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        :keyword internal_name: Internal name of dimension.
        :paramtype internal_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class DomainValidationProperties(_serialization.Model):
    """The JSON object that contains the properties to validate a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_token: Challenge used for DNS TXT record or file based validation.
    :vartype validation_token: str
    :ivar expiration_date: The date time that the token expires.
    :vartype expiration_date: str
    """

    _validation = {
        "validation_token": {"readonly": True},
        "expiration_date": {"readonly": True},
    }

    _attribute_map = {
        "validation_token": {"key": "validationToken", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.validation_token = None
        self.expiration_date = None


class EdgeNode(ProxyResource):
    """Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar ip_address_groups: List of ip address groups.
    :vartype ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "ip_address_groups": {"key": "properties.ipAddressGroups", "type": "[IpAddressGroup]"},
    }

    def __init__(self, *, ip_address_groups: Optional[List["_models.IpAddressGroup"]] = None, **kwargs):
        """
        :keyword ip_address_groups: List of ip address groups.
        :paramtype ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
        """
        super().__init__(**kwargs)
        self.ip_address_groups = ip_address_groups


class EdgenodeResult(_serialization.Model):
    """Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Edge node of CDN service.
    :vartype value: list[~azure.mgmt.cdn.models.EdgeNode]
    :ivar next_link: URL to get the next set of edgenode list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EdgeNode]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of edgenode list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Endpoint(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Known values
     are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar origins: The source of the content being delivered via CDN.
    :vartype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :ivar origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :vartype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar custom_domains: The custom domains under the endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.DeepCreatedCustomDomain]
    :ivar resource_state: Resource status of the endpoint. Known values are: "Creating",
     "Deleting", "Running", "Starting", "Stopped", and "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint. Known values are: "Succeeded",
     "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.EndpointProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "host_name": {"readonly": True},
        "custom_domains": {"readonly": True},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "origin_path": {"key": "properties.originPath", "type": "str"},
        "content_types_to_compress": {"key": "properties.contentTypesToCompress", "type": "[str]"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "is_compression_enabled": {"key": "properties.isCompressionEnabled", "type": "bool"},
        "is_http_allowed": {"key": "properties.isHttpAllowed", "type": "bool"},
        "is_https_allowed": {"key": "properties.isHttpsAllowed", "type": "bool"},
        "query_string_caching_behavior": {"key": "properties.queryStringCachingBehavior", "type": "str"},
        "optimization_type": {"key": "properties.optimizationType", "type": "str"},
        "probe_path": {"key": "properties.probePath", "type": "str"},
        "geo_filters": {"key": "properties.geoFilters", "type": "[GeoFilter]"},
        "default_origin_group": {"key": "properties.defaultOriginGroup", "type": "ResourceReference"},
        "url_signing_keys": {"key": "properties.urlSigningKeys", "type": "[UrlSigningKey]"},
        "delivery_policy": {
            "key": "properties.deliveryPolicy",
            "type": "EndpointPropertiesUpdateParametersDeliveryPolicy",
        },
        "web_application_firewall_policy_link": {
            "key": "properties.webApplicationFirewallPolicyLink",
            "type": "EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink",
        },
        "host_name": {"key": "properties.hostName", "type": "str"},
        "origins": {"key": "properties.origins", "type": "[DeepCreatedOrigin]"},
        "origin_groups": {"key": "properties.originGroups", "type": "[DeepCreatedOriginGroup]"},
        "custom_domains": {"key": "properties.customDomains", "type": "[DeepCreatedCustomDomain]"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "_models.QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "_models.OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["_models.GeoFilter"]] = None,
        default_origin_group: Optional["_models.ResourceReference"] = None,
        url_signing_keys: Optional[List["_models.UrlSigningKey"]] = None,
        delivery_policy: Optional["_models.EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional[
            "_models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"
        ] = None,
        origins: Optional[List["_models.DeepCreatedOrigin"]] = None,
        origin_groups: Optional[List["_models.DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Known values
         are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        :keyword origins: The source of the content being delivered via CDN.
        :paramtype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
        :keyword origin_groups: The origin groups comprising of origins that are used for load
         balancing the traffic based on availability.
        :paramtype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.custom_domains = None
        self.resource_state = None
        self.provisioning_state = None


class EndpointListResult(_serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Endpoint]
    :ivar next_link: URL to get the next set of endpoint objects if there is any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Endpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of endpoint objects if there is any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class EndpointPropertiesUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The JSON object containing endpoint update parameters.

    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Known values
     are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        "origin_path": {"key": "originPath", "type": "str"},
        "content_types_to_compress": {"key": "contentTypesToCompress", "type": "[str]"},
        "origin_host_header": {"key": "originHostHeader", "type": "str"},
        "is_compression_enabled": {"key": "isCompressionEnabled", "type": "bool"},
        "is_http_allowed": {"key": "isHttpAllowed", "type": "bool"},
        "is_https_allowed": {"key": "isHttpsAllowed", "type": "bool"},
        "query_string_caching_behavior": {"key": "queryStringCachingBehavior", "type": "str"},
        "optimization_type": {"key": "optimizationType", "type": "str"},
        "probe_path": {"key": "probePath", "type": "str"},
        "geo_filters": {"key": "geoFilters", "type": "[GeoFilter]"},
        "default_origin_group": {"key": "defaultOriginGroup", "type": "ResourceReference"},
        "url_signing_keys": {"key": "urlSigningKeys", "type": "[UrlSigningKey]"},
        "delivery_policy": {"key": "deliveryPolicy", "type": "EndpointPropertiesUpdateParametersDeliveryPolicy"},
        "web_application_firewall_policy_link": {
            "key": "webApplicationFirewallPolicyLink",
            "type": "EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink",
        },
    }

    def __init__(
        self,
        *,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "_models.QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "_models.OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["_models.GeoFilter"]] = None,
        default_origin_group: Optional["_models.ResourceReference"] = None,
        url_signing_keys: Optional[List["_models.UrlSigningKey"]] = None,
        delivery_policy: Optional["_models.EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional[
            "_models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"
        ] = None,
        **kwargs
    ):
        """
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Known values
         are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        """
        super().__init__(**kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class EndpointProperties(EndpointPropertiesUpdateParameters):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Known values
     are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :ivar origins: The source of the content being delivered via CDN. Required.
    :vartype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :ivar origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :vartype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar custom_domains: The custom domains under the endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.DeepCreatedCustomDomain]
    :ivar resource_state: Resource status of the endpoint. Known values are: "Creating",
     "Deleting", "Running", "Starting", "Stopped", and "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint. Known values are: "Succeeded",
     "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.EndpointProvisioningState
    """

    _validation = {
        "host_name": {"readonly": True},
        "origins": {"required": True},
        "custom_domains": {"readonly": True},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "origin_path": {"key": "originPath", "type": "str"},
        "content_types_to_compress": {"key": "contentTypesToCompress", "type": "[str]"},
        "origin_host_header": {"key": "originHostHeader", "type": "str"},
        "is_compression_enabled": {"key": "isCompressionEnabled", "type": "bool"},
        "is_http_allowed": {"key": "isHttpAllowed", "type": "bool"},
        "is_https_allowed": {"key": "isHttpsAllowed", "type": "bool"},
        "query_string_caching_behavior": {"key": "queryStringCachingBehavior", "type": "str"},
        "optimization_type": {"key": "optimizationType", "type": "str"},
        "probe_path": {"key": "probePath", "type": "str"},
        "geo_filters": {"key": "geoFilters", "type": "[GeoFilter]"},
        "default_origin_group": {"key": "defaultOriginGroup", "type": "ResourceReference"},
        "url_signing_keys": {"key": "urlSigningKeys", "type": "[UrlSigningKey]"},
        "delivery_policy": {"key": "deliveryPolicy", "type": "EndpointPropertiesUpdateParametersDeliveryPolicy"},
        "web_application_firewall_policy_link": {
            "key": "webApplicationFirewallPolicyLink",
            "type": "EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink",
        },
        "host_name": {"key": "hostName", "type": "str"},
        "origins": {"key": "origins", "type": "[DeepCreatedOrigin]"},
        "origin_groups": {"key": "originGroups", "type": "[DeepCreatedOriginGroup]"},
        "custom_domains": {"key": "customDomains", "type": "[DeepCreatedCustomDomain]"},
        "resource_state": {"key": "resourceState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        origins: List["_models.DeepCreatedOrigin"],
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "_models.QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "_models.OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["_models.GeoFilter"]] = None,
        default_origin_group: Optional["_models.ResourceReference"] = None,
        url_signing_keys: Optional[List["_models.UrlSigningKey"]] = None,
        delivery_policy: Optional["_models.EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional[
            "_models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"
        ] = None,
        origin_groups: Optional[List["_models.DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        """
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Known values
         are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        :keyword origins: The source of the content being delivered via CDN. Required.
        :paramtype origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
        :keyword origin_groups: The origin groups comprising of origins that are used for load
         balancing the traffic based on availability.
        :paramtype origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
        """
        super().__init__(
            origin_path=origin_path,
            content_types_to_compress=content_types_to_compress,
            origin_host_header=origin_host_header,
            is_compression_enabled=is_compression_enabled,
            is_http_allowed=is_http_allowed,
            is_https_allowed=is_https_allowed,
            query_string_caching_behavior=query_string_caching_behavior,
            optimization_type=optimization_type,
            probe_path=probe_path,
            geo_filters=geo_filters,
            default_origin_group=default_origin_group,
            url_signing_keys=url_signing_keys,
            delivery_policy=delivery_policy,
            web_application_firewall_policy_link=web_application_firewall_policy_link,
            **kwargs
        )
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.custom_domains = None
        self.resource_state = None
        self.provisioning_state = None


class EndpointPropertiesUpdateParametersDeliveryPolicy(_serialization.Model):
    """A policy that specifies the delivery rules to be used for an endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar description: User-friendly description of the policy.
    :vartype description: str
    :ivar rules: A list of the delivery rules. Required.
    :vartype rules: list[~azure.mgmt.cdn.models.DeliveryRule]
    """

    _validation = {
        "rules": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "rules": {"key": "rules", "type": "[DeliveryRule]"},
    }

    def __init__(self, *, rules: List["_models.DeliveryRule"], description: Optional[str] = None, **kwargs):
        """
        :keyword description: User-friendly description of the policy.
        :paramtype description: str
        :keyword rules: A list of the delivery rules. Required.
        :paramtype rules: list[~azure.mgmt.cdn.models.DeliveryRule]
        """
        super().__init__(**kwargs)
        self.description = description
        self.rules = rules


class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink(_serialization.Model):
    """Defines the Web Application Firewall policy for the endpoint (if applicable).

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class EndpointUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties required to create or update an endpoint.

    :ivar tags: Endpoint tags.
    :vartype tags: dict[str, str]
    :ivar origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :vartype content_types_to_compress: list[str]
    :ivar origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :vartype origin_host_header: str
    :ivar is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :vartype is_compression_enabled: bool
    :ivar is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default value
     is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_http_allowed: bool
    :ivar is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :vartype is_https_allowed: bool
    :ivar query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Known values
     are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
    :vartype query_string_caching_behavior: str or
     ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :ivar optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
    :vartype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :ivar probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :vartype probe_path: str
    :ivar geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each geo
     filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :vartype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :ivar default_origin_group: A reference to the origin group.
    :vartype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar url_signing_keys: List of keys used to validate the signed URL hashes.
    :vartype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :ivar delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :vartype delivery_policy:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :ivar web_application_firewall_policy_link: Defines the Web Application Firewall policy for the
     endpoint (if applicable).
    :vartype web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "origin_path": {"key": "properties.originPath", "type": "str"},
        "content_types_to_compress": {"key": "properties.contentTypesToCompress", "type": "[str]"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "is_compression_enabled": {"key": "properties.isCompressionEnabled", "type": "bool"},
        "is_http_allowed": {"key": "properties.isHttpAllowed", "type": "bool"},
        "is_https_allowed": {"key": "properties.isHttpsAllowed", "type": "bool"},
        "query_string_caching_behavior": {"key": "properties.queryStringCachingBehavior", "type": "str"},
        "optimization_type": {"key": "properties.optimizationType", "type": "str"},
        "probe_path": {"key": "properties.probePath", "type": "str"},
        "geo_filters": {"key": "properties.geoFilters", "type": "[GeoFilter]"},
        "default_origin_group": {"key": "properties.defaultOriginGroup", "type": "ResourceReference"},
        "url_signing_keys": {"key": "properties.urlSigningKeys", "type": "[UrlSigningKey]"},
        "delivery_policy": {
            "key": "properties.deliveryPolicy",
            "type": "EndpointPropertiesUpdateParametersDeliveryPolicy",
        },
        "web_application_firewall_policy_link": {
            "key": "properties.webApplicationFirewallPolicyLink",
            "type": "EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "_models.QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "_models.OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["_models.GeoFilter"]] = None,
        default_origin_group: Optional["_models.ResourceReference"] = None,
        url_signing_keys: Optional[List["_models.UrlSigningKey"]] = None,
        delivery_policy: Optional["_models.EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional[
            "_models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"
        ] = None,
        **kwargs
    ):
        """
        :keyword tags: Endpoint tags.
        :paramtype tags: dict[str, str]
        :keyword origin_path: A directory path on the origin that CDN can use to retrieve content from,
         e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword content_types_to_compress: List of content types on which compression applies. The
         value should be a valid MIME type.
        :paramtype content_types_to_compress: list[str]
        :keyword origin_host_header: The host header value sent to the origin with each request. This
         property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
         the same property specified at origin.If you leave this blank, the request hostname determines
         this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
         host header value to match the origin hostname by default.
        :paramtype origin_host_header: str
        :keyword is_compression_enabled: Indicates whether content compression is enabled on CDN.
         Default value is false. If compression is enabled, content will be served as compressed if user
         requests for a compressed version. Content won't be compressed on CDN when requested content is
         smaller than 1 byte or larger than 1 MB.
        :paramtype is_compression_enabled: bool
        :keyword is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_http_allowed: bool
        :keyword is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
         value is true. At least one protocol (HTTP or HTTPS) must be allowed.
        :paramtype is_https_allowed: bool
        :keyword query_string_caching_behavior: Defines how CDN caches requests that include query
         strings. You can ignore any query strings when caching, bypass caching to prevent requests that
         contain query strings from being cached, or cache every request with a unique URL. Known values
         are: "IgnoreQueryString", "BypassCaching", "UseQueryString", and "NotSet".
        :paramtype query_string_caching_behavior: str or
         ~azure.mgmt.cdn.models.QueryStringCachingBehavior
        :keyword optimization_type: Specifies what scenario the customer wants this CDN endpoint to
         optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
         driven optimization. Known values are: "GeneralWebDelivery", "GeneralMediaStreaming",
         "VideoOnDemandMediaStreaming", "LargeFileDownload", and "DynamicSiteAcceleration".
        :paramtype optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
        :keyword probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
         dynamic content and calculate the most optimal routes for the CDN. This is relative to the
         origin path. This property is only relevant when using a single origin.
        :paramtype probe_path: str
        :keyword geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
         geo filter defines an access rule to a specified path or content, e.g. block APAC for path
         /pictures/.
        :paramtype geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
        :keyword default_origin_group: A reference to the origin group.
        :paramtype default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword url_signing_keys: List of keys used to validate the signed URL hashes.
        :paramtype url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
        :keyword delivery_policy: A policy that specifies the delivery rules to be used for an
         endpoint.
        :paramtype delivery_policy:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
        :keyword web_application_firewall_policy_link: Defines the Web Application Firewall policy for
         the endpoint (if applicable).
        :paramtype web_application_firewall_policy_link:
         ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.cdn.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.cdn.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Error response indicates Azure Front Door Standard or Azure Front Door Premium or CDN service is not able to process the incoming request. The reason is provided in the error message.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cdn.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cdn.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GeoFilter(_serialization.Model):
    """Rules defining user's geo access within a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar relative_path: Relative path applicable to geo filter. (e.g. '/mypictures',
     '/mypicture/kitty.jpg', and etc.). Required.
    :vartype relative_path: str
    :ivar action: Action of the geo filter, i.e. allow or block access. Required. Known values are:
     "Block" and "Allow".
    :vartype action: str or ~azure.mgmt.cdn.models.GeoFilterActions
    :ivar country_codes: Two letter country or region codes defining user country or region access
     in a geo filter, e.g. AU, MX, US. Required.
    :vartype country_codes: list[str]
    """

    _validation = {
        "relative_path": {"required": True},
        "action": {"required": True},
        "country_codes": {"required": True},
    }

    _attribute_map = {
        "relative_path": {"key": "relativePath", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "country_codes": {"key": "countryCodes", "type": "[str]"},
    }

    def __init__(
        self, *, relative_path: str, action: Union[str, "_models.GeoFilterActions"], country_codes: List[str], **kwargs
    ):
        """
        :keyword relative_path: Relative path applicable to geo filter. (e.g. '/mypictures',
         '/mypicture/kitty.jpg', and etc.). Required.
        :paramtype relative_path: str
        :keyword action: Action of the geo filter, i.e. allow or block access. Required. Known values
         are: "Block" and "Allow".
        :paramtype action: str or ~azure.mgmt.cdn.models.GeoFilterActions
        :keyword country_codes: Two letter country or region codes defining user country or region
         access in a geo filter, e.g. AU, MX, US. Required.
        :paramtype country_codes: list[str]
        """
        super().__init__(**kwargs)
        self.relative_path = relative_path
        self.action = action
        self.country_codes = country_codes


class HeaderActionParameters(_serialization.Model):
    """Defines the parameters for the request header action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleHeaderActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.HeaderActionParametersTypeName
    :ivar header_action: Action to perform. Required. Known values are: "Append", "Overwrite", and
     "Delete".
    :vartype header_action: str or ~azure.mgmt.cdn.models.HeaderAction
    :ivar header_name: Name of the header to modify. Required.
    :vartype header_name: str
    :ivar value: Value for the specified action.
    :vartype value: str
    """

    _validation = {
        "type_name": {"required": True},
        "header_action": {"required": True},
        "header_name": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "header_action": {"key": "headerAction", "type": "str"},
        "header_name": {"key": "headerName", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.HeaderActionParametersTypeName"],
        header_action: Union[str, "_models.HeaderAction"],
        header_name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleHeaderActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.HeaderActionParametersTypeName
        :keyword header_action: Action to perform. Required. Known values are: "Append", "Overwrite",
         and "Delete".
        :paramtype header_action: str or ~azure.mgmt.cdn.models.HeaderAction
        :keyword header_name: Name of the header to modify. Required.
        :paramtype header_name: str
        :keyword value: Value for the specified action.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.header_action = header_action
        self.header_name = header_name
        self.value = value


class HealthProbeParameters(_serialization.Model):
    """The JSON object that contains the properties to send health probes to origin.

    :ivar probe_path: The path relative to the origin that is used to determine the health of the
     origin.
    :vartype probe_path: str
    :ivar probe_request_type: The type of health probe request that is made. Known values are:
     "NotSet", "GET", and "HEAD".
    :vartype probe_request_type: str or ~azure.mgmt.cdn.models.HealthProbeRequestType
    :ivar probe_protocol: Protocol to use for health probe. Known values are: "NotSet", "Http", and
     "Https".
    :vartype probe_protocol: str or ~azure.mgmt.cdn.models.ProbeProtocol
    :ivar probe_interval_in_seconds: The number of seconds between health probes.Default is 240sec.
    :vartype probe_interval_in_seconds: int
    """

    _validation = {
        "probe_interval_in_seconds": {"maximum": 255, "minimum": 1},
    }

    _attribute_map = {
        "probe_path": {"key": "probePath", "type": "str"},
        "probe_request_type": {"key": "probeRequestType", "type": "str"},
        "probe_protocol": {"key": "probeProtocol", "type": "str"},
        "probe_interval_in_seconds": {"key": "probeIntervalInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        probe_path: Optional[str] = None,
        probe_request_type: Optional[Union[str, "_models.HealthProbeRequestType"]] = None,
        probe_protocol: Optional[Union[str, "_models.ProbeProtocol"]] = None,
        probe_interval_in_seconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword probe_path: The path relative to the origin that is used to determine the health of
         the origin.
        :paramtype probe_path: str
        :keyword probe_request_type: The type of health probe request that is made. Known values are:
         "NotSet", "GET", and "HEAD".
        :paramtype probe_request_type: str or ~azure.mgmt.cdn.models.HealthProbeRequestType
        :keyword probe_protocol: Protocol to use for health probe. Known values are: "NotSet", "Http",
         and "Https".
        :paramtype probe_protocol: str or ~azure.mgmt.cdn.models.ProbeProtocol
        :keyword probe_interval_in_seconds: The number of seconds between health probes.Default is
         240sec.
        :paramtype probe_interval_in_seconds: int
        """
        super().__init__(**kwargs)
        self.probe_path = probe_path
        self.probe_request_type = probe_request_type
        self.probe_protocol = probe_protocol
        self.probe_interval_in_seconds = probe_interval_in_seconds


class HostNameMatchConditionParameters(_serialization.Model):
    """Defines the parameters for HostName match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleHostNameConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.HostNameMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.HostNameOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.HostNameMatchConditionParametersTypeName"],
        operator: Union[str, "_models.HostNameOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleHostNameConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.HostNameMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.HostNameOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class HttpErrorRangeParameters(_serialization.Model):
    """The JSON object that represents the range for http status codes.

    :ivar begin: The inclusive start of the http status code range.
    :vartype begin: int
    :ivar end: The inclusive end of the http status code range.
    :vartype end: int
    """

    _validation = {
        "begin": {"maximum": 999, "minimum": 100},
        "end": {"maximum": 999, "minimum": 100},
    }

    _attribute_map = {
        "begin": {"key": "begin", "type": "int"},
        "end": {"key": "end", "type": "int"},
    }

    def __init__(self, *, begin: Optional[int] = None, end: Optional[int] = None, **kwargs):
        """
        :keyword begin: The inclusive start of the http status code range.
        :paramtype begin: int
        :keyword end: The inclusive end of the http status code range.
        :paramtype end: int
        """
        super().__init__(**kwargs)
        self.begin = begin
        self.end = end


class HttpVersionMatchConditionParameters(_serialization.Model):
    """Defines the parameters for HttpVersion match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleHttpVersionConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.HttpVersionMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. "Equal"
    :vartype operator: str or ~azure.mgmt.cdn.models.HttpVersionOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.HttpVersionMatchConditionParametersTypeName"],
        operator: Union[str, "_models.HttpVersionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleHttpVersionConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.HttpVersionMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. "Equal"
        :paramtype operator: str or ~azure.mgmt.cdn.models.HttpVersionOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class IpAddressGroup(_serialization.Model):
    """CDN Ip address group.

    :ivar delivery_region: The delivery region of the ip address group.
    :vartype delivery_region: str
    :ivar ipv4_addresses: The list of ip v4 addresses.
    :vartype ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    :ivar ipv6_addresses: The list of ip v6 addresses.
    :vartype ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    """

    _attribute_map = {
        "delivery_region": {"key": "deliveryRegion", "type": "str"},
        "ipv4_addresses": {"key": "ipv4Addresses", "type": "[CidrIpAddress]"},
        "ipv6_addresses": {"key": "ipv6Addresses", "type": "[CidrIpAddress]"},
    }

    def __init__(
        self,
        *,
        delivery_region: Optional[str] = None,
        ipv4_addresses: Optional[List["_models.CidrIpAddress"]] = None,
        ipv6_addresses: Optional[List["_models.CidrIpAddress"]] = None,
        **kwargs
    ):
        """
        :keyword delivery_region: The delivery region of the ip address group.
        :paramtype delivery_region: str
        :keyword ipv4_addresses: The list of ip v4 addresses.
        :paramtype ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
        :keyword ipv6_addresses: The list of ip v6 addresses.
        :paramtype ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
        """
        super().__init__(**kwargs)
        self.delivery_region = delivery_region
        self.ipv4_addresses = ipv4_addresses
        self.ipv6_addresses = ipv6_addresses


class IsDeviceMatchConditionParameters(_serialization.Model):
    """Defines the parameters for IsDevice match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleIsDeviceConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. "Equal"
    :vartype operator: str or ~azure.mgmt.cdn.models.IsDeviceOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or
     ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.IsDeviceMatchConditionParametersTypeName"],
        operator: Union[str, "_models.IsDeviceOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "_models.IsDeviceMatchConditionParametersMatchValuesItem"]]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleIsDeviceConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. "Equal"
        :paramtype operator: str or ~azure.mgmt.cdn.models.IsDeviceOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or
         ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class KeyVaultCertificateSourceParameters(_serialization.Model):
    """Describes the parameters for using a user's KeyVault certificate for securing custom domain.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "KeyVaultCertificateSourceParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParametersTypeName
    :ivar subscription_id: Subscription Id of the user's Key Vault containing the SSL certificate.
     Required.
    :vartype subscription_id: str
    :ivar resource_group_name: Resource group of the user's Key Vault containing the SSL
     certificate. Required.
    :vartype resource_group_name: str
    :ivar vault_name: The name of the user's Key Vault containing the SSL certificate. Required.
    :vartype vault_name: str
    :ivar secret_name: The name of Key Vault Secret (representing the full certificate PFX) in Key
     Vault. Required.
    :vartype secret_name: str
    :ivar secret_version: The version(GUID) of Key Vault Secret in Key Vault.
    :vartype secret_version: str
    :ivar update_rule: Describes the action that shall be taken when the certificate is updated in
     Key Vault. Required. "NoAction"
    :vartype update_rule: str or ~azure.mgmt.cdn.models.UpdateRule
    :ivar delete_rule: Describes the action that shall be taken when the certificate is removed
     from Key Vault. Required. "NoAction"
    :vartype delete_rule: str or ~azure.mgmt.cdn.models.DeleteRule
    """

    _validation = {
        "type_name": {"required": True},
        "subscription_id": {"required": True},
        "resource_group_name": {"required": True},
        "vault_name": {"required": True},
        "secret_name": {"required": True},
        "update_rule": {"required": True},
        "delete_rule": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "vault_name": {"key": "vaultName", "type": "str"},
        "secret_name": {"key": "secretName", "type": "str"},
        "secret_version": {"key": "secretVersion", "type": "str"},
        "update_rule": {"key": "updateRule", "type": "str"},
        "delete_rule": {"key": "deleteRule", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.KeyVaultCertificateSourceParametersTypeName"],
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        update_rule: Union[str, "_models.UpdateRule"],
        delete_rule: Union[str, "_models.DeleteRule"],
        secret_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "KeyVaultCertificateSourceParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParametersTypeName
        :keyword subscription_id: Subscription Id of the user's Key Vault containing the SSL
         certificate. Required.
        :paramtype subscription_id: str
        :keyword resource_group_name: Resource group of the user's Key Vault containing the SSL
         certificate. Required.
        :paramtype resource_group_name: str
        :keyword vault_name: The name of the user's Key Vault containing the SSL certificate. Required.
        :paramtype vault_name: str
        :keyword secret_name: The name of Key Vault Secret (representing the full certificate PFX) in
         Key Vault. Required.
        :paramtype secret_name: str
        :keyword secret_version: The version(GUID) of Key Vault Secret in Key Vault.
        :paramtype secret_version: str
        :keyword update_rule: Describes the action that shall be taken when the certificate is updated
         in Key Vault. Required. "NoAction"
        :paramtype update_rule: str or ~azure.mgmt.cdn.models.UpdateRule
        :keyword delete_rule: Describes the action that shall be taken when the certificate is removed
         from Key Vault. Required. "NoAction"
        :paramtype delete_rule: str or ~azure.mgmt.cdn.models.DeleteRule
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.update_rule = update_rule
        self.delete_rule = delete_rule


class KeyVaultSigningKeyParameters(_serialization.Model):
    """Describes the parameters for using a user's KeyVault for URL Signing Key.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "KeyVaultSigningKeyParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.KeyVaultSigningKeyParametersTypeName
    :ivar subscription_id: Subscription Id of the user's Key Vault containing the secret. Required.
    :vartype subscription_id: str
    :ivar resource_group_name: Resource group of the user's Key Vault containing the secret.
     Required.
    :vartype resource_group_name: str
    :ivar vault_name: The name of the user's Key Vault containing the secret. Required.
    :vartype vault_name: str
    :ivar secret_name: The name of secret in Key Vault. Required.
    :vartype secret_name: str
    :ivar secret_version: The version(GUID) of secret in Key Vault. Required.
    :vartype secret_version: str
    """

    _validation = {
        "type_name": {"required": True},
        "subscription_id": {"required": True},
        "resource_group_name": {"required": True},
        "vault_name": {"required": True},
        "secret_name": {"required": True},
        "secret_version": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "vault_name": {"key": "vaultName", "type": "str"},
        "secret_name": {"key": "secretName", "type": "str"},
        "secret_version": {"key": "secretVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.KeyVaultSigningKeyParametersTypeName"],
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        secret_version: str,
        **kwargs
    ):
        """
        :keyword type_name: Required. "KeyVaultSigningKeyParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.KeyVaultSigningKeyParametersTypeName
        :keyword subscription_id: Subscription Id of the user's Key Vault containing the secret.
         Required.
        :paramtype subscription_id: str
        :keyword resource_group_name: Resource group of the user's Key Vault containing the secret.
         Required.
        :paramtype resource_group_name: str
        :keyword vault_name: The name of the user's Key Vault containing the secret. Required.
        :paramtype vault_name: str
        :keyword secret_name: The name of secret in Key Vault. Required.
        :paramtype secret_name: str
        :keyword secret_version: The version(GUID) of secret in Key Vault. Required.
        :paramtype secret_version: str
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version


class LoadBalancingSettingsParameters(_serialization.Model):
    """Round-Robin load balancing settings for a backend pool.

    :ivar sample_size: The number of samples to consider for load balancing decisions.
    :vartype sample_size: int
    :ivar successful_samples_required: The number of samples within the sample period that must
     succeed.
    :vartype successful_samples_required: int
    :ivar additional_latency_in_milliseconds: The additional latency in milliseconds for probes to
     fall into the lowest latency bucket.
    :vartype additional_latency_in_milliseconds: int
    """

    _attribute_map = {
        "sample_size": {"key": "sampleSize", "type": "int"},
        "successful_samples_required": {"key": "successfulSamplesRequired", "type": "int"},
        "additional_latency_in_milliseconds": {"key": "additionalLatencyInMilliseconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        sample_size: Optional[int] = None,
        successful_samples_required: Optional[int] = None,
        additional_latency_in_milliseconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword sample_size: The number of samples to consider for load balancing decisions.
        :paramtype sample_size: int
        :keyword successful_samples_required: The number of samples within the sample period that must
         succeed.
        :paramtype successful_samples_required: int
        :keyword additional_latency_in_milliseconds: The additional latency in milliseconds for probes
         to fall into the lowest latency bucket.
        :paramtype additional_latency_in_milliseconds: int
        """
        super().__init__(**kwargs)
        self.sample_size = sample_size
        self.successful_samples_required = successful_samples_required
        self.additional_latency_in_milliseconds = additional_latency_in_milliseconds


class LoadParameters(_serialization.Model):
    """Parameters required for content load.

    All required parameters must be populated in order to send to Azure.

    :ivar content_paths: The path to the content to be loaded. Path should be a relative file URL
     of the origin. Required.
    :vartype content_paths: list[str]
    """

    _validation = {
        "content_paths": {"required": True},
    }

    _attribute_map = {
        "content_paths": {"key": "contentPaths", "type": "[str]"},
    }

    def __init__(self, *, content_paths: List[str], **kwargs):
        """
        :keyword content_paths: The path to the content to be loaded. Path should be a relative file
         URL of the origin. Required.
        :paramtype content_paths: list[str]
        """
        super().__init__(**kwargs)
        self.content_paths = content_paths


class LogSpecification(_serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    :ivar log_filter_pattern: Pattern to filter based on name.
    :vartype log_filter_pattern: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
        "log_filter_pattern": {"key": "logFilterPattern", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        log_filter_pattern: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        :keyword log_filter_pattern: Pattern to filter based on name.
        :paramtype log_filter_pattern: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration
        self.log_filter_pattern = log_filter_pattern


class ManagedCertificate(Certificate):
    """Managed Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the secret resource. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        "subject": {"readonly": True},
        "expiration_date": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SecretType"]] = None, **kwargs):
        """
        :keyword type: The type of the secret resource. Known values are: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
        :paramtype type: str or ~azure.mgmt.cdn.models.SecretType
        """
        super().__init__(type=type, **kwargs)


class ManagedCertificateParameters(SecretParameters):
    """Managed Certificate used for https.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the secret resource. Required. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar subject: Subject name in the certificate.
    :vartype subject: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: str
    """

    _validation = {
        "type": {"required": True},
        "subject": {"readonly": True},
        "expiration_date": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = "ManagedCertificate"  # type: str
        self.subject = None
        self.expiration_date = None


class ManagedRuleDefinition(_serialization.Model):
    """Describes a managed rule definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_id: Identifier for the managed rule.
    :vartype rule_id: str
    :ivar description: Describes the functionality of the managed rule.
    :vartype description: str
    """

    _validation = {
        "rule_id": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.rule_id = None
        self.description = None


class ManagedRuleGroupDefinition(_serialization.Model):
    """Describes a managed rule group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_group_name: Name of the managed rule group.
    :vartype rule_group_name: str
    :ivar description: Description of the managed rule group.
    :vartype description: str
    :ivar rules: List of rules within the managed rule group.
    :vartype rules: list[~azure.mgmt.cdn.models.ManagedRuleDefinition]
    """

    _validation = {
        "rule_group_name": {"readonly": True},
        "description": {"readonly": True},
        "rules": {"readonly": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rules": {"key": "rules", "type": "[ManagedRuleDefinition]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.rule_group_name = None
        self.description = None
        self.rules = None


class ManagedRuleGroupOverride(_serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: Describes the managed rule group within the rule set to override.
     Required.
    :vartype rule_group_name: str
    :ivar rules: List of rules that will be enabled. If none specified, all rules in the group will
     be disabled.
    :vartype rules: list[~azure.mgmt.cdn.models.ManagedRuleOverride]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[ManagedRuleOverride]"},
    }

    def __init__(self, *, rule_group_name: str, rules: Optional[List["_models.ManagedRuleOverride"]] = None, **kwargs):
        """
        :keyword rule_group_name: Describes the managed rule group within the rule set to override.
         Required.
        :paramtype rule_group_name: str
        :keyword rules: List of rules that will be enabled. If none specified, all rules in the group
         will be disabled.
        :paramtype rules: list[~azure.mgmt.cdn.models.ManagedRuleOverride]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ManagedRuleOverride(_serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_id: Identifier for the managed rule. Required.
    :vartype rule_id: str
    :ivar enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults to
     Disabled if not specified. Known values are: "Disabled" and "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.ManagedRuleEnabledState
    :ivar action: Describes the override action to be applied when rule matches. Known values are:
     "Allow", "Block", "Log", and "Redirect".
    :vartype action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        rule_id: str,
        enabled_state: Optional[Union[str, "_models.ManagedRuleEnabledState"]] = None,
        action: Optional[Union[str, "_models.ActionType"]] = None,
        **kwargs
    ):
        """
        :keyword rule_id: Identifier for the managed rule. Required.
        :paramtype rule_id: str
        :keyword enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults
         to Disabled if not specified. Known values are: "Disabled" and "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.ManagedRuleEnabledState
        :keyword action: Describes the override action to be applied when rule matches. Known values
         are: "Allow", "Block", "Log", and "Redirect".
        :paramtype action: str or ~azure.mgmt.cdn.models.ActionType
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.enabled_state = enabled_state
        self.action = action


class ManagedRuleSet(_serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_set_type: Defines the rule set type to use. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: Defines the version of the rule set to use. Required.
    :vartype rule_set_version: str
    :ivar anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this
     describes the threshold for blocking requests.
    :vartype anomaly_score: int
    :ivar rule_group_overrides: Defines the rule overrides to apply to the rule set.
    :vartype rule_group_overrides: list[~azure.mgmt.cdn.models.ManagedRuleGroupOverride]
    """

    _validation = {
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
        "anomaly_score": {"maximum": 20, "minimum": 0},
    }

    _attribute_map = {
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "anomaly_score": {"key": "anomalyScore", "type": "int"},
        "rule_group_overrides": {"key": "ruleGroupOverrides", "type": "[ManagedRuleGroupOverride]"},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        anomaly_score: Optional[int] = None,
        rule_group_overrides: Optional[List["_models.ManagedRuleGroupOverride"]] = None,
        **kwargs
    ):
        """
        :keyword rule_set_type: Defines the rule set type to use. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: Defines the version of the rule set to use. Required.
        :paramtype rule_set_version: str
        :keyword anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this
         describes the threshold for blocking requests.
        :paramtype anomaly_score: int
        :keyword rule_group_overrides: Defines the rule overrides to apply to the rule set.
        :paramtype rule_group_overrides: list[~azure.mgmt.cdn.models.ManagedRuleGroupOverride]
        """
        super().__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.anomaly_score = anomaly_score
        self.rule_group_overrides = rule_group_overrides


class ManagedRuleSetDefinition(Resource):
    """Describes a managed rule set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar sku: The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :vartype sku: ~azure.mgmt.cdn.models.Sku
    :ivar provisioning_state: Provisioning state of the managed rule set.
    :vartype provisioning_state: str
    :ivar rule_set_type: Type of the managed rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: Version of the managed rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: Rule groups of the managed rule set.
    :vartype rule_groups: list[~azure.mgmt.cdn.models.ManagedRuleGroupDefinition]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "rule_set_type": {"readonly": True},
        "rule_set_version": {"readonly": True},
        "rule_groups": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rule_set_type": {"key": "properties.ruleSetType", "type": "str"},
        "rule_set_version": {"key": "properties.ruleSetVersion", "type": "str"},
        "rule_groups": {"key": "properties.ruleGroups", "type": "[ManagedRuleGroupDefinition]"},
    }

    def __init__(self, *, sku: Optional["_models.Sku"] = None, **kwargs):
        """
        :keyword sku: The pricing tier (defines a CDN provider, feature list and rate) of the
         CdnWebApplicationFirewallPolicy.
        :paramtype sku: ~azure.mgmt.cdn.models.Sku
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.provisioning_state = None
        self.rule_set_type = None
        self.rule_set_version = None
        self.rule_groups = None


class ManagedRuleSetDefinitionList(_serialization.Model):
    """List of managed rule set definitions available for use in a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of managed rule set definitions.
    :vartype value: list[~azure.mgmt.cdn.models.ManagedRuleSetDefinition]
    :ivar next_link: URL to retrieve next set of managed rule set definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedRuleSetDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to retrieve next set of managed rule set definitions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ManagedRuleSetList(_serialization.Model):
    """Defines the list of managed rule sets for the policy.

    :ivar managed_rule_sets: List of rule sets.
    :vartype managed_rule_sets: list[~azure.mgmt.cdn.models.ManagedRuleSet]
    """

    _attribute_map = {
        "managed_rule_sets": {"key": "managedRuleSets", "type": "[ManagedRuleSet]"},
    }

    def __init__(self, *, managed_rule_sets: Optional[List["_models.ManagedRuleSet"]] = None, **kwargs):
        """
        :keyword managed_rule_sets: List of rule sets.
        :paramtype managed_rule_sets: list[~azure.mgmt.cdn.models.ManagedRuleSet]
        """
        super().__init__(**kwargs)
        self.managed_rule_sets = managed_rule_sets


class MatchCondition(_serialization.Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar match_variable: Match variable to compare against. Required. Known values are:
     "RemoteAddr", "SocketAddr", "RequestMethod", "RequestHeader", "RequestUri", "QueryString",
     "RequestBody", "Cookies", and "PostArgs".
    :vartype match_variable: str or ~azure.mgmt.cdn.models.WafMatchVariable
    :ivar selector: Selector can used to match a specific key for QueryString, Cookies,
     RequestHeader or PostArgs.
    :vartype selector: str
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "IPMatch",
     "GeoMatch", "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual",
     "GreaterThanOrEqual", "BeginsWith", "EndsWith", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.Operator
    :ivar negate_condition: Describes if the result of this condition should be negated.
    :vartype negate_condition: bool
    :ivar match_value: List of possible match values. Required.
    :vartype match_value: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.TransformType]
    """

    _validation = {
        "match_variable": {"required": True},
        "operator": {"required": True},
        "match_value": {"required": True},
    }

    _attribute_map = {
        "match_variable": {"key": "matchVariable", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_value": {"key": "matchValue", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        match_variable: Union[str, "_models.WafMatchVariable"],
        operator: Union[str, "_models.Operator"],
        match_value: List[str],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "_models.TransformType"]]] = None,
        **kwargs
    ):
        """
        :keyword match_variable: Match variable to compare against. Required. Known values are:
         "RemoteAddr", "SocketAddr", "RequestMethod", "RequestHeader", "RequestUri", "QueryString",
         "RequestBody", "Cookies", and "PostArgs".
        :paramtype match_variable: str or ~azure.mgmt.cdn.models.WafMatchVariable
        :keyword selector: Selector can used to match a specific key for QueryString, Cookies,
         RequestHeader or PostArgs.
        :paramtype selector: str
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual",
         "GreaterThanOrEqual", "BeginsWith", "EndsWith", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.Operator
        :keyword negate_condition: Describes if the result of this condition should be negated.
        :paramtype negate_condition: bool
        :keyword match_value: List of possible match values. Required.
        :paramtype match_value: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.TransformType]
        """
        super().__init__(**kwargs)
        self.match_variable = match_variable
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_value = match_value
        self.transforms = transforms


class MetricAvailability(_serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs):
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
    :vartype unit: str
    :ivar aggregation_type: The metric aggregation type. Possible values include: 'Average',
     'Count', 'Total'.
    :vartype aggregation_type: str
    :ivar availabilities: Retention policies of a resource metric.
    :vartype availabilities: list[~azure.mgmt.cdn.models.MetricAvailability]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar dimensions: The dimensions of metric.
    :vartype dimensions: list[~azure.mgmt.cdn.models.DimensionProperties]
    :ivar fill_gap_with_zero: Property to specify whether to fill gap with zero.
    :vartype fill_gap_with_zero: bool
    :ivar metric_filter_pattern: Pattern to filter based on name.
    :vartype metric_filter_pattern: str
    :ivar is_internal: Property to specify metric is internal or not.
    :vartype is_internal: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[MetricAvailability]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "dimensions": {"key": "dimensions", "type": "[DimensionProperties]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "is_internal": {"key": "isInternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        availabilities: Optional[List["_models.MetricAvailability"]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        dimensions: Optional[List["_models.DimensionProperties"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        metric_filter_pattern: Optional[str] = None,
        is_internal: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
        :paramtype unit: str
        :keyword aggregation_type: The metric aggregation type. Possible values include: 'Average',
         'Count', 'Total'.
        :paramtype aggregation_type: str
        :keyword availabilities: Retention policies of a resource metric.
        :paramtype availabilities: list[~azure.mgmt.cdn.models.MetricAvailability]
        :keyword supported_time_grain_types: The supported time grain types for the metrics.
        :paramtype supported_time_grain_types: list[str]
        :keyword dimensions: The dimensions of metric.
        :paramtype dimensions: list[~azure.mgmt.cdn.models.DimensionProperties]
        :keyword fill_gap_with_zero: Property to specify whether to fill gap with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword metric_filter_pattern: Pattern to filter based on name.
        :paramtype metric_filter_pattern: str
        :keyword is_internal: Property to specify metric is internal or not.
        :paramtype is_internal: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities
        self.supported_time_grain_types = supported_time_grain_types
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.metric_filter_pattern = metric_filter_pattern
        self.is_internal = is_internal


class MetricsResponse(_serialization.Model):
    """Metrics Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar granularity: Known values are: "PT5M", "PT1H", and "P1D".
    :vartype granularity: str or ~azure.mgmt.cdn.models.MetricsResponseGranularity
    :ivar series:
    :vartype series: list[~azure.mgmt.cdn.models.MetricsResponseSeriesItem]
    """

    _attribute_map = {
        "date_time_begin": {"key": "dateTimeBegin", "type": "iso-8601"},
        "date_time_end": {"key": "dateTimeEnd", "type": "iso-8601"},
        "granularity": {"key": "granularity", "type": "str"},
        "series": {"key": "series", "type": "[MetricsResponseSeriesItem]"},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        granularity: Optional[Union[str, "_models.MetricsResponseGranularity"]] = None,
        series: Optional[List["_models.MetricsResponseSeriesItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword granularity: Known values are: "PT5M", "PT1H", and "P1D".
        :paramtype granularity: str or ~azure.mgmt.cdn.models.MetricsResponseGranularity
        :keyword series:
        :paramtype series: list[~azure.mgmt.cdn.models.MetricsResponseSeriesItem]
        """
        super().__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.granularity = granularity
        self.series = series


class MetricsResponseSeriesItem(_serialization.Model):
    """MetricsResponseSeriesItem.

    :ivar metric:
    :vartype metric: str
    :ivar unit: Known values are: "count", "bytes", "bitsPerSecond", and "milliSeconds".
    :vartype unit: str or ~azure.mgmt.cdn.models.MetricsResponseSeriesItemUnit
    :ivar groups:
    :vartype groups: list[~azure.mgmt.cdn.models.MetricsResponseSeriesPropertiesItemsItem]
    :ivar data:
    :vartype data:
     list[~azure.mgmt.cdn.models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]
    """

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "groups": {"key": "groups", "type": "[MetricsResponseSeriesPropertiesItemsItem]"},
        "data": {
            "key": "data",
            "type": "[Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]",
        },
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        unit: Optional[Union[str, "_models.MetricsResponseSeriesItemUnit"]] = None,
        groups: Optional[List["_models.MetricsResponseSeriesPropertiesItemsItem"]] = None,
        data: Optional[
            List["_models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems"]
        ] = None,
        **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword unit: Known values are: "count", "bytes", "bitsPerSecond", and "milliSeconds".
        :paramtype unit: str or ~azure.mgmt.cdn.models.MetricsResponseSeriesItemUnit
        :keyword groups:
        :paramtype groups: list[~azure.mgmt.cdn.models.MetricsResponseSeriesPropertiesItemsItem]
        :keyword data:
        :paramtype data:
         list[~azure.mgmt.cdn.models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.unit = unit
        self.groups = groups
        self.data = data


class MetricsResponseSeriesPropertiesItemsItem(_serialization.Model):
    """MetricsResponseSeriesPropertiesItemsItem.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword value:
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class Operation(_serialization.Model):
    """CDN REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.cdn.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.cdn.models.ServiceSpecification
    """

    _validation = {
        "name": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.cdn.models.OperationDisplay
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.cdn.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = is_data_action
        self.display = display
        self.origin = None
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.Cdn.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationsListResult(_serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of CDN operations supported by the CDN resource provider.
    :vartype value: list[~azure.mgmt.cdn.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of CDN operations supported by the CDN resource provider.
        :paramtype value: list[~azure.mgmt.cdn.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Origin(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Known values are: "Creating", "Active",
     and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin. Known values are: "Succeeded",
     "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.OriginProvisioningState
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Known values are: "Pending", "Approved", "Rejected", "Disconnected", and "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "http_port": {"key": "properties.httpPort", "type": "int"},
        "https_port": {"key": "properties.httpsPort", "type": "int"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "private_link_alias": {"key": "properties.privateLinkAlias", "type": "str"},
        "private_link_resource_id": {"key": "properties.privateLinkResourceId", "type": "str"},
        "private_link_location": {"key": "properties.privateLinkLocation", "type": "str"},
        "private_link_approval_message": {"key": "properties.privateLinkApprovalMessage", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_status": {"key": "properties.privateEndpointStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginGroup(ProxyResource):
    """Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Known values are: "Creating",
     "Active", and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group. Known values are:
     "Succeeded", "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.OriginGroupProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "health_probe_settings": {"key": "properties.healthProbeSettings", "type": "HealthProbeParameters"},
        "origins": {"key": "properties.origins", "type": "[ResourceReference]"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "response_based_origin_error_detection_settings": {
            "key": "properties.responseBasedOriginErrorDetectionSettings",
            "type": "ResponseBasedOriginErrorDetectionParameters",
        },
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        origins: Optional[List["_models.ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional[
            "_models.ResponseBasedOriginErrorDetectionParameters"
        ] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super().__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupListResult(_serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.OriginGroup]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OriginGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginGroupOverride(_serialization.Model):
    """Defines the parameters for the origin group override configuration.

    :ivar origin_group: defines the OriginGroup that would override the DefaultOriginGroup on
     route.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    """

    _attribute_map = {
        "origin_group": {"key": "originGroup", "type": "ResourceReference"},
        "forwarding_protocol": {"key": "forwardingProtocol", "type": "str"},
    }

    def __init__(
        self,
        *,
        origin_group: Optional["_models.ResourceReference"] = None,
        forwarding_protocol: Optional[Union[str, "_models.ForwardingProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword origin_group: defines the OriginGroup that would override the DefaultOriginGroup on
         route.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        """
        super().__init__(**kwargs)
        self.origin_group = origin_group
        self.forwarding_protocol = forwarding_protocol


class OriginGroupOverrideAction(DeliveryRuleAction):
    """Defines the origin group override action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.OriginGroupOverrideActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "OriginGroupOverrideActionParameters"},
    }

    def __init__(self, *, parameters: "_models.OriginGroupOverrideActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.OriginGroupOverrideActionParameters
        """
        super().__init__(**kwargs)
        self.name = "OriginGroupOverride"  # type: str
        self.parameters = parameters


class OriginGroupOverrideActionParameters(_serialization.Model):
    """Defines the parameters for the origin group override action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleOriginGroupOverrideActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.OriginGroupOverrideActionParametersTypeName
    :ivar origin_group: defines the OriginGroup that would override the DefaultOriginGroup.
     Required.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        "type_name": {"required": True},
        "origin_group": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "origin_group": {"key": "originGroup", "type": "ResourceReference"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.OriginGroupOverrideActionParametersTypeName"],
        origin_group: "_models.ResourceReference",
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleOriginGroupOverrideActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.OriginGroupOverrideActionParametersTypeName
        :keyword origin_group: defines the OriginGroup that would override the DefaultOriginGroup.
         Required.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.origin_group = origin_group


class OriginGroupUpdatePropertiesParameters(_serialization.Model):
    """The JSON object that contains the properties of the origin group.

    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "health_probe_settings": {"key": "healthProbeSettings", "type": "HealthProbeParameters"},
        "origins": {"key": "origins", "type": "[ResourceReference]"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "response_based_origin_error_detection_settings": {
            "key": "responseBasedOriginErrorDetectionSettings",
            "type": "ResponseBasedOriginErrorDetectionParameters",
        },
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        origins: Optional[List["_models.ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional[
            "_models.ResponseBasedOriginErrorDetectionParameters"
        ] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super().__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginGroupProperties(OriginGroupUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Known values are: "Creating",
     "Active", and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group. Known values are:
     "Succeeded", "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.OriginGroupProvisioningState
    """

    _validation = {
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "health_probe_settings": {"key": "healthProbeSettings", "type": "HealthProbeParameters"},
        "origins": {"key": "origins", "type": "[ResourceReference]"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "response_based_origin_error_detection_settings": {
            "key": "responseBasedOriginErrorDetectionSettings",
            "type": "ResponseBasedOriginErrorDetectionParameters",
        },
        "resource_state": {"key": "resourceState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        origins: Optional[List["_models.ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional[
            "_models.ResponseBasedOriginErrorDetectionParameters"
        ] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super().__init__(
            health_probe_settings=health_probe_settings,
            origins=origins,
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes,
            response_based_origin_error_detection_settings=response_based_origin_error_detection_settings,
            **kwargs
        )
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupUpdateParameters(_serialization.Model):
    """Origin group properties needed for origin group creation or update.

    :ivar health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :vartype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :ivar origins: The source of the content being delivered via CDN within given origin group.
    :vartype origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :vartype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :ivar response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :vartype response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {"maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "health_probe_settings": {"key": "properties.healthProbeSettings", "type": "HealthProbeParameters"},
        "origins": {"key": "properties.origins", "type": "[ResourceReference]"},
        "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes": {
            "key": "properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            "type": "int",
        },
        "response_based_origin_error_detection_settings": {
            "key": "properties.responseBasedOriginErrorDetectionSettings",
            "type": "ResponseBasedOriginErrorDetectionParameters",
        },
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["_models.HealthProbeParameters"] = None,
        origins: Optional[List["_models.ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional[
            "_models.ResponseBasedOriginErrorDetectionParameters"
        ] = None,
        **kwargs
    ):
        """
        :keyword health_probe_settings: Health probe settings to the origin that is used to determine
         the health of the origin.
        :paramtype health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
        :keyword origins: The source of the content being delivered via CDN within given origin group.
        :paramtype origins: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to
         shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
         endpoint is added. Default is 10 mins. This property is currently not supported.
        :paramtype traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
        :keyword response_based_origin_error_detection_settings: The JSON object that contains the
         properties to determine origin health using real requests/responses. This property is currently
         not supported.
        :paramtype response_based_origin_error_detection_settings:
         ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
        """
        super().__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = (
            traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        )
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginListResult(_serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.Origin]
    :ivar next_link: URL to get the next set of origin objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Origin]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of origin objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginUpdatePropertiesParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties of the origin.

    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    """

    _validation = {
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "http_port": {"key": "httpPort", "type": "int"},
        "https_port": {"key": "httpsPort", "type": "int"},
        "origin_host_header": {"key": "originHostHeader", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "weight": {"key": "weight", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
        "private_link_alias": {"key": "privateLinkAlias", "type": "str"},
        "private_link_resource_id": {"key": "privateLinkResourceId", "type": "str"},
        "private_link_location": {"key": "privateLinkLocation", "type": "str"},
        "private_link_approval_message": {"key": "privateLinkApprovalMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class OriginProperties(OriginUpdatePropertiesParameters):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Known values are: "Creating", "Active",
     and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin. Known values are: "Succeeded",
     "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.OriginProvisioningState
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Known values are: "Pending", "Approved", "Rejected", "Disconnected", and "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_status": {"readonly": True},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "http_port": {"key": "httpPort", "type": "int"},
        "https_port": {"key": "httpsPort", "type": "int"},
        "origin_host_header": {"key": "originHostHeader", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "weight": {"key": "weight", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
        "private_link_alias": {"key": "privateLinkAlias", "type": "str"},
        "private_link_resource_id": {"key": "privateLinkResourceId", "type": "str"},
        "private_link_location": {"key": "privateLinkLocation", "type": "str"},
        "private_link_approval_message": {"key": "privateLinkApprovalMessage", "type": "str"},
        "resource_state": {"key": "resourceState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint_status": {"key": "privateEndpointStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super().__init__(
            host_name=host_name,
            http_port=http_port,
            https_port=https_port,
            origin_host_header=origin_host_header,
            priority=priority,
            weight=weight,
            enabled=enabled,
            private_link_alias=private_link_alias,
            private_link_resource_id=private_link_resource_id,
            private_link_location=private_link_location,
            private_link_approval_message=private_link_approval_message,
            **kwargs
        )
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Origin properties needed for origin update.

    :ivar host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :vartype host_name: str
    :ivar http_port: The value of the HTTP port. Must be between 1 and 65535.
    :vartype http_port: int
    :ivar https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :vartype https_port: int
    :ivar origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :vartype origin_host_header: str
    :ivar priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :vartype priority: int
    :ivar weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :vartype weight: int
    :ivar enabled: Origin is enabled for load balancing or not.
    :vartype enabled: bool
    :ivar private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :vartype private_link_alias: str
    :ivar private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :vartype private_link_resource_id: str
    :ivar private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :vartype private_link_location: str
    :ivar private_link_approval_message: A custom message to be included in the approval request to
     connect to the Private Link.
    :vartype private_link_approval_message: str
    """

    _validation = {
        "http_port": {"maximum": 65535, "minimum": 1},
        "https_port": {"maximum": 65535, "minimum": 1},
        "priority": {"maximum": 5, "minimum": 1},
        "weight": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "host_name": {"key": "properties.hostName", "type": "str"},
        "http_port": {"key": "properties.httpPort", "type": "int"},
        "https_port": {"key": "properties.httpsPort", "type": "int"},
        "origin_host_header": {"key": "properties.originHostHeader", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "private_link_alias": {"key": "properties.privateLinkAlias", "type": "str"},
        "private_link_resource_id": {"key": "properties.privateLinkResourceId", "type": "str"},
        "private_link_location": {"key": "properties.privateLinkLocation", "type": "str"},
        "private_link_approval_message": {"key": "properties.privateLinkApprovalMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
         are supported.This should be unique across all origins in an endpoint.
        :paramtype host_name: str
        :keyword http_port: The value of the HTTP port. Must be between 1 and 65535.
        :paramtype http_port: int
        :keyword https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :paramtype https_port: int
        :keyword origin_host_header: The host header value sent to the origin with each request. If you
         leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
         Apps, Blob Storage, and Cloud Services require this host header value to match the origin
         hostname by default. This overrides the host header defined at Endpoint.
        :paramtype origin_host_header: str
        :keyword priority: Priority of origin in given origin group for load balancing. Higher
         priorities will not be used for load balancing if any lower priority origin is healthy.Must be
         between 1 and 5.
        :paramtype priority: int
        :keyword weight: Weight of the origin in given origin group for load balancing. Must be between
         1 and 1000.
        :paramtype weight: int
        :keyword enabled: Origin is enabled for load balancing or not.
        :paramtype enabled: bool
        :keyword private_link_alias: The Alias of the Private Link resource. Populating this optional
         field indicates that this origin is 'Private'.
        :paramtype private_link_alias: str
        :keyword private_link_resource_id: The Resource Id of the Private Link resource. Populating
         this optional field indicates that this backend is 'Private'.
        :paramtype private_link_resource_id: str
        :keyword private_link_location: The location of the Private Link resource. Required only if
         'privateLinkResourceId' is populated.
        :paramtype private_link_location: str
        :keyword private_link_approval_message: A custom message to be included in the approval request
         to connect to the Private Link.
        :paramtype private_link_approval_message: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class PolicySettings(_serialization.Model):
    """Defines contents of a web application firewall global configuration.

    :ivar enabled_state: describes if the policy is in enabled state or disabled state. Known
     values are: "Disabled" and "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.PolicyEnabledState
    :ivar mode: Describes if it is in detection mode or prevention mode at policy level. Known
     values are: "Prevention" and "Detection".
    :vartype mode: str or ~azure.mgmt.cdn.models.PolicyMode
    :ivar default_redirect_url: If action type is redirect, this field represents the default
     redirect URL for the client.
    :vartype default_redirect_url: str
    :ivar default_custom_block_response_status_code: If the action type is block, this field
     defines the default customer overridable http response status code. Known values are: 200, 403,
     405, 406, and 429.
    :vartype default_custom_block_response_status_code: int or
     ~azure.mgmt.cdn.models.PolicySettingsDefaultCustomBlockResponseStatusCode
    :ivar default_custom_block_response_body: If the action type is block, customer can override
     the response body. The body must be specified in base64 encoding.
    :vartype default_custom_block_response_body: str
    """

    _validation = {
        "default_custom_block_response_body": {
            "pattern": r"^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
        },
    }

    _attribute_map = {
        "enabled_state": {"key": "enabledState", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "default_redirect_url": {"key": "defaultRedirectUrl", "type": "str"},
        "default_custom_block_response_status_code": {"key": "defaultCustomBlockResponseStatusCode", "type": "int"},
        "default_custom_block_response_body": {"key": "defaultCustomBlockResponseBody", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "_models.PolicyEnabledState"]] = None,
        mode: Optional[Union[str, "_models.PolicyMode"]] = None,
        default_redirect_url: Optional[str] = None,
        default_custom_block_response_status_code: Optional[
            Union[int, "_models.PolicySettingsDefaultCustomBlockResponseStatusCode"]
        ] = None,
        default_custom_block_response_body: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword enabled_state: describes if the policy is in enabled state or disabled state. Known
         values are: "Disabled" and "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.PolicyEnabledState
        :keyword mode: Describes if it is in detection mode or prevention mode at policy level. Known
         values are: "Prevention" and "Detection".
        :paramtype mode: str or ~azure.mgmt.cdn.models.PolicyMode
        :keyword default_redirect_url: If action type is redirect, this field represents the default
         redirect URL for the client.
        :paramtype default_redirect_url: str
        :keyword default_custom_block_response_status_code: If the action type is block, this field
         defines the default customer overridable http response status code. Known values are: 200, 403,
         405, 406, and 429.
        :paramtype default_custom_block_response_status_code: int or
         ~azure.mgmt.cdn.models.PolicySettingsDefaultCustomBlockResponseStatusCode
        :keyword default_custom_block_response_body: If the action type is block, customer can override
         the response body. The body must be specified in base64 encoding.
        :paramtype default_custom_block_response_body: str
        """
        super().__init__(**kwargs)
        self.enabled_state = enabled_state
        self.mode = mode
        self.default_redirect_url = default_redirect_url
        self.default_custom_block_response_status_code = default_custom_block_response_status_code
        self.default_custom_block_response_body = default_custom_block_response_body


class PostArgsMatchConditionParameters(_serialization.Model):
    """Defines the parameters for PostArgs match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRulePostArgsConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.PostArgsMatchConditionParametersTypeName
    :ivar selector: Name of PostArg to be matched.
    :vartype selector: str
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.PostArgsMatchConditionParametersTypeName"],
        operator: Union[str, "_models.PostArgsOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRulePostArgsConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.PostArgsMatchConditionParametersTypeName
        :keyword selector: Name of PostArg to be matched.
        :paramtype selector: str
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class Profile(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A profile is a logical grouping of endpoints that share the same settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider,
     feature list and rate) of the profile. Required.
    :vartype sku: ~azure.mgmt.cdn.models.Sku
    :ivar kind: Kind of the profile. Used by portal to differentiate traditional CDN profile and
     new AFD profile.
    :vartype kind: str
    :ivar resource_state: Resource status of the profile. Known values are: "Creating", "Active",
     "Deleting", and "Disabled".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.ProfileResourceState
    :ivar provisioning_state: Provisioning status of the profile. Known values are: "Succeeded",
     "Failed", "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.ProfileProvisioningState
    :ivar front_door_id: The Id of the frontdoor.
    :vartype front_door_id: str
    :ivar origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :vartype origin_response_timeout_seconds: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "kind": {"readonly": True},
        "resource_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "front_door_id": {"readonly": True},
        "origin_response_timeout_seconds": {"minimum": 16},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "front_door_id": {"key": "properties.frontDoorId", "type": "str"},
        "origin_response_timeout_seconds": {"key": "properties.originResponseTimeoutSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        origin_response_timeout_seconds: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider,
         feature list and rate) of the profile. Required.
        :paramtype sku: ~azure.mgmt.cdn.models.Sku
        :keyword origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
         origin. When timeout is reached, the request fails and returns.
        :paramtype origin_response_timeout_seconds: int
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind = None
        self.resource_state = None
        self.provisioning_state = None
        self.front_door_id = None
        self.origin_response_timeout_seconds = origin_response_timeout_seconds


class ProfileListResult(_serialization.Model):
    """Result of the request to list profiles. It contains a list of profile objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN profiles within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.Profile]
    :ivar next_link: URL to get the next set of profile objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Profile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of profile objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ProfileUpdateParameters(_serialization.Model):
    """Properties required to update a profile.

    :ivar tags: Profile tags.
    :vartype tags: dict[str, str]
    :ivar origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :vartype origin_response_timeout_seconds: int
    """

    _validation = {
        "origin_response_timeout_seconds": {"minimum": 16},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "origin_response_timeout_seconds": {"key": "properties.originResponseTimeoutSeconds", "type": "int"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, origin_response_timeout_seconds: Optional[int] = None, **kwargs
    ):
        """
        :keyword tags: Profile tags.
        :paramtype tags: dict[str, str]
        :keyword origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
         origin. When timeout is reached, the request fails and returns.
        :paramtype origin_response_timeout_seconds: int
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.origin_response_timeout_seconds = origin_response_timeout_seconds


class PurgeParameters(_serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :ivar content_paths: The path to the content to be purged. Can describe a file path or a wild
     card directory. Required.
    :vartype content_paths: list[str]
    """

    _validation = {
        "content_paths": {"required": True},
    }

    _attribute_map = {
        "content_paths": {"key": "contentPaths", "type": "[str]"},
    }

    def __init__(self, *, content_paths: List[str], **kwargs):
        """
        :keyword content_paths: The path to the content to be purged. Can describe a file path or a
         wild card directory. Required.
        :paramtype content_paths: list[str]
        """
        super().__init__(**kwargs)
        self.content_paths = content_paths


class QueryStringMatchConditionParameters(_serialization.Model):
    """Defines the parameters for QueryString match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleQueryStringConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.QueryStringMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.QueryStringMatchConditionParametersTypeName"],
        operator: Union[str, "_models.QueryStringOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleQueryStringConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.QueryStringMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RankingsResponse(_serialization.Model):
    """Rankings Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar tables:
    :vartype tables: list[~azure.mgmt.cdn.models.RankingsResponseTablesItem]
    """

    _attribute_map = {
        "date_time_begin": {"key": "dateTimeBegin", "type": "iso-8601"},
        "date_time_end": {"key": "dateTimeEnd", "type": "iso-8601"},
        "tables": {"key": "tables", "type": "[RankingsResponseTablesItem]"},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        tables: Optional[List["_models.RankingsResponseTablesItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword tables:
        :paramtype tables: list[~azure.mgmt.cdn.models.RankingsResponseTablesItem]
        """
        super().__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.tables = tables


class RankingsResponseTablesItem(_serialization.Model):
    """RankingsResponseTablesItem.

    :ivar ranking:
    :vartype ranking: str
    :ivar data:
    :vartype data: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsItem]
    """

    _attribute_map = {
        "ranking": {"key": "ranking", "type": "str"},
        "data": {"key": "data", "type": "[RankingsResponseTablesPropertiesItemsItem]"},
    }

    def __init__(
        self,
        *,
        ranking: Optional[str] = None,
        data: Optional[List["_models.RankingsResponseTablesPropertiesItemsItem"]] = None,
        **kwargs
    ):
        """
        :keyword ranking:
        :paramtype ranking: str
        :keyword data:
        :paramtype data: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsItem]
        """
        super().__init__(**kwargs)
        self.ranking = ranking
        self.data = data


class RankingsResponseTablesPropertiesItemsItem(_serialization.Model):
    """RankingsResponseTablesPropertiesItemsItem.

    :ivar name:
    :vartype name: str
    :ivar metrics:
    :vartype metrics: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsMetricsItem]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "metrics": {"key": "metrics", "type": "[RankingsResponseTablesPropertiesItemsMetricsItem]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        metrics: Optional[List["_models.RankingsResponseTablesPropertiesItemsMetricsItem"]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword metrics:
        :paramtype metrics:
         list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsMetricsItem]
        """
        super().__init__(**kwargs)
        self.name = name
        self.metrics = metrics


class RankingsResponseTablesPropertiesItemsMetricsItem(_serialization.Model):
    """RankingsResponseTablesPropertiesItemsMetricsItem.

    :ivar metric:
    :vartype metric: str
    :ivar value:
    :vartype value: int
    :ivar percentage:
    :vartype percentage: float
    """

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "value": {"key": "value", "type": "int"},
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(
        self, *, metric: Optional[str] = None, value: Optional[int] = None, percentage: Optional[float] = None, **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword value:
        :paramtype value: int
        :keyword percentage:
        :paramtype percentage: float
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.value = value
        self.percentage = percentage


class RateLimitRule(CustomRule):
    """Defines a rate limiting rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Defines the name of the custom rule. Required.
    :vartype name: str
    :ivar enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Known values are: "Disabled" and "Enabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :ivar priority: Defines in what order this rule be evaluated in the overall list of custom
     rules. Required.
    :vartype priority: int
    :ivar match_conditions: List of match conditions. Required.
    :vartype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :ivar action: Describes what action to be applied when rule matches. Required. Known values
     are: "Allow", "Block", "Log", and "Redirect".
    :vartype action: str or ~azure.mgmt.cdn.models.ActionType
    :ivar rate_limit_threshold: Defines rate limit threshold. Required.
    :vartype rate_limit_threshold: int
    :ivar rate_limit_duration_in_minutes: Defines rate limit duration. Default is 1 minute.
     Required.
    :vartype rate_limit_duration_in_minutes: int
    """

    _validation = {
        "name": {"required": True},
        "priority": {"required": True, "maximum": 1000, "minimum": 0},
        "match_conditions": {"required": True},
        "action": {"required": True},
        "rate_limit_threshold": {"required": True, "minimum": 0},
        "rate_limit_duration_in_minutes": {"required": True, "maximum": 60, "minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "match_conditions": {"key": "matchConditions", "type": "[MatchCondition]"},
        "action": {"key": "action", "type": "str"},
        "rate_limit_threshold": {"key": "rateLimitThreshold", "type": "int"},
        "rate_limit_duration_in_minutes": {"key": "rateLimitDurationInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["_models.MatchCondition"],
        action: Union[str, "_models.ActionType"],
        rate_limit_threshold: int,
        rate_limit_duration_in_minutes: int,
        enabled_state: Optional[Union[str, "_models.CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword name: Defines the name of the custom rule. Required.
        :paramtype name: str
        :keyword enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults
         to Enabled if not specified. Known values are: "Disabled" and "Enabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
        :keyword priority: Defines in what order this rule be evaluated in the overall list of custom
         rules. Required.
        :paramtype priority: int
        :keyword match_conditions: List of match conditions. Required.
        :paramtype match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
        :keyword action: Describes what action to be applied when rule matches. Required. Known values
         are: "Allow", "Block", "Log", and "Redirect".
        :paramtype action: str or ~azure.mgmt.cdn.models.ActionType
        :keyword rate_limit_threshold: Defines rate limit threshold. Required.
        :paramtype rate_limit_threshold: int
        :keyword rate_limit_duration_in_minutes: Defines rate limit duration. Default is 1 minute.
         Required.
        :paramtype rate_limit_duration_in_minutes: int
        """
        super().__init__(
            name=name,
            enabled_state=enabled_state,
            priority=priority,
            match_conditions=match_conditions,
            action=action,
            **kwargs
        )
        self.rate_limit_threshold = rate_limit_threshold
        self.rate_limit_duration_in_minutes = rate_limit_duration_in_minutes


class RateLimitRuleList(_serialization.Model):
    """Defines contents of rate limit rules.

    :ivar rules: List of rules.
    :vartype rules: list[~azure.mgmt.cdn.models.RateLimitRule]
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[RateLimitRule]"},
    }

    def __init__(self, *, rules: Optional[List["_models.RateLimitRule"]] = None, **kwargs):
        """
        :keyword rules: List of rules.
        :paramtype rules: list[~azure.mgmt.cdn.models.RateLimitRule]
        """
        super().__init__(**kwargs)
        self.rules = rules


class RemoteAddressMatchConditionParameters(_serialization.Model):
    """Defines the parameters for RemoteAddress match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRemoteAddressConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "IPMatch",
     and "GeoMatch".
    :vartype operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: Match values to match against. The operator will apply to each value in
     here with OR semantics. If any of them match the variable with the given operator this match
     condition is considered a match.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RemoteAddressMatchConditionParametersTypeName"],
        operator: Union[str, "_models.RemoteAddressOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRemoteAddressConditionParameters"
        :paramtype type_name: str or
         ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "IPMatch", and "GeoMatch".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: Match values to match against. The operator will apply to each value in
         here with OR semantics. If any of them match the variable with the given operator this match
         condition is considered a match.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestBodyMatchConditionParameters(_serialization.Model):
    """Defines the parameters for RequestBody match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRequestBodyConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.RequestBodyMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RequestBodyMatchConditionParametersTypeName"],
        operator: Union[str, "_models.RequestBodyOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRequestBodyConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.RequestBodyMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestHeaderMatchConditionParameters(_serialization.Model):
    """Defines the parameters for RequestHeader match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRequestHeaderConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParametersTypeName
    :ivar selector: Name of Header to be matched.
    :vartype selector: str
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RequestHeaderMatchConditionParametersTypeName"],
        operator: Union[str, "_models.RequestHeaderOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRequestHeaderConditionParameters"
        :paramtype type_name: str or
         ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParametersTypeName
        :keyword selector: Name of Header to be matched.
        :paramtype selector: str
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestMethodMatchConditionParameters(_serialization.Model):
    """Defines the parameters for RequestMethod match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRequestMethodConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. "Equal"
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestMethodOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or
     ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "transforms": {"key": "transforms", "type": "[str]"},
        "match_values": {"key": "matchValues", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RequestMethodMatchConditionParametersTypeName"],
        operator: Union[str, "_models.RequestMethodOperator"],
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        match_values: Optional[List[Union[str, "_models.RequestMethodMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRequestMethodConditionParameters"
        :paramtype type_name: str or
         ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. "Equal"
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestMethodOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or
         ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.transforms = transforms
        self.match_values = match_values


class RequestSchemeMatchConditionParameters(_serialization.Model):
    """Defines the parameters for RequestScheme match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRequestSchemeConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. "Equal"
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or
     ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "transforms": {"key": "transforms", "type": "[str]"},
        "match_values": {"key": "matchValues", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RequestSchemeMatchConditionParametersTypeName"],
        operator: Union[str, "_models.RequestSchemeMatchConditionParametersOperator"],
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        match_values: Optional[List[Union[str, "_models.RequestSchemeMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRequestSchemeConditionParameters"
        :paramtype type_name: str or
         ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. "Equal"
        :paramtype operator: str or
         ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or
         ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.transforms = transforms
        self.match_values = match_values


class RequestUriMatchConditionParameters(_serialization.Model):
    """Defines the parameters for RequestUri match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRequestUriConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.RequestUriMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RequestUriMatchConditionParametersTypeName"],
        operator: Union[str, "_models.RequestUriOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRequestUriConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.RequestUriMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class ResourceReference(_serialization.Model):
    """Reference to another resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ResourcesResponse(_serialization.Model):
    """Resources Response.

    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsItem]
    :ivar custom_domains:
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ResourcesResponseCustomDomainsItem]
    """

    _attribute_map = {
        "endpoints": {"key": "endpoints", "type": "[ResourcesResponseEndpointsItem]"},
        "custom_domains": {"key": "customDomains", "type": "[ResourcesResponseCustomDomainsItem]"},
    }

    def __init__(
        self,
        *,
        endpoints: Optional[List["_models.ResourcesResponseEndpointsItem"]] = None,
        custom_domains: Optional[List["_models.ResourcesResponseCustomDomainsItem"]] = None,
        **kwargs
    ):
        """
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsItem]
        :keyword custom_domains:
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ResourcesResponseCustomDomainsItem]
        """
        super().__init__(**kwargs)
        self.endpoints = endpoints
        self.custom_domains = custom_domains


class ResourcesResponseCustomDomainsItem(_serialization.Model):
    """ResourcesResponseCustomDomainsItem.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar endpoint_id:
    :vartype endpoint_id: str
    :ivar history:
    :vartype history: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "endpoint_id": {"key": "endpointId", "type": "str"},
        "history": {"key": "history", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        endpoint_id: Optional[str] = None,
        history: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword endpoint_id:
        :paramtype endpoint_id: str
        :keyword history:
        :paramtype history: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.endpoint_id = endpoint_id
        self.history = history


class ResourcesResponseEndpointsItem(_serialization.Model):
    """ResourcesResponseEndpointsItem.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar history:
    :vartype history: bool
    :ivar custom_domains:
    :vartype custom_domains:
     list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsPropertiesItemsItem]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "history": {"key": "history", "type": "bool"},
        "custom_domains": {"key": "customDomains", "type": "[ResourcesResponseEndpointsPropertiesItemsItem]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        history: Optional[bool] = None,
        custom_domains: Optional[List["_models.ResourcesResponseEndpointsPropertiesItemsItem"]] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword history:
        :paramtype history: bool
        :keyword custom_domains:
        :paramtype custom_domains:
         list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsPropertiesItemsItem]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.history = history
        self.custom_domains = custom_domains


class ResourcesResponseEndpointsPropertiesItemsItem(_serialization.Model):
    """ResourcesResponseEndpointsPropertiesItemsItem.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar endpoint_id:
    :vartype endpoint_id: str
    :ivar history:
    :vartype history: bool
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "endpoint_id": {"key": "endpointId", "type": "str"},
        "history": {"key": "history", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        endpoint_id: Optional[str] = None,
        history: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword name:
        :paramtype name: str
        :keyword endpoint_id:
        :paramtype endpoint_id: str
        :keyword history:
        :paramtype history: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.endpoint_id = endpoint_id
        self.history = history


class ResourceUsage(_serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: Resource type for which the usage is provided.
    :vartype resource_type: str
    :ivar unit: Unit of the usage. e.g. count. "count"
    :vartype unit: str or ~azure.mgmt.cdn.models.ResourceUsageUnit
    :ivar current_value: Actual value of usage on the specified resource type.
    :vartype current_value: int
    :ivar limit: Quota of the specified resource type.
    :vartype limit: int
    """

    _validation = {
        "resource_type": {"readonly": True},
        "unit": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.unit = None
        self.current_value = None
        self.limit = None


class ResourceUsageListResult(_serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of resource usages.
    :vartype value: list[~azure.mgmt.cdn.models.ResourceUsage]
    :ivar next_link: URL to get the next set of custom domain objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of custom domain objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ResponseBasedOriginErrorDetectionParameters(_serialization.Model):
    """The JSON object that contains the properties to determine origin health using real requests/responses.

    :ivar response_based_detected_error_types: Type of response errors for real user requests for
     which origin will be deemed unhealthy. Known values are: "None", "TcpErrorsOnly", and
     "TcpAndHttpErrors".
    :vartype response_based_detected_error_types: str or
     ~azure.mgmt.cdn.models.ResponseBasedDetectedErrorTypes
    :ivar response_based_failover_threshold_percentage: The percentage of failed requests in the
     sample where failover should trigger.
    :vartype response_based_failover_threshold_percentage: int
    :ivar http_error_ranges: The list of Http status code ranges that are considered as server
     errors for origin and it is marked as unhealthy.
    :vartype http_error_ranges: list[~azure.mgmt.cdn.models.HttpErrorRangeParameters]
    """

    _validation = {
        "response_based_failover_threshold_percentage": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "response_based_detected_error_types": {"key": "responseBasedDetectedErrorTypes", "type": "str"},
        "response_based_failover_threshold_percentage": {
            "key": "responseBasedFailoverThresholdPercentage",
            "type": "int",
        },
        "http_error_ranges": {"key": "httpErrorRanges", "type": "[HttpErrorRangeParameters]"},
    }

    def __init__(
        self,
        *,
        response_based_detected_error_types: Optional[Union[str, "_models.ResponseBasedDetectedErrorTypes"]] = None,
        response_based_failover_threshold_percentage: Optional[int] = None,
        http_error_ranges: Optional[List["_models.HttpErrorRangeParameters"]] = None,
        **kwargs
    ):
        """
        :keyword response_based_detected_error_types: Type of response errors for real user requests
         for which origin will be deemed unhealthy. Known values are: "None", "TcpErrorsOnly", and
         "TcpAndHttpErrors".
        :paramtype response_based_detected_error_types: str or
         ~azure.mgmt.cdn.models.ResponseBasedDetectedErrorTypes
        :keyword response_based_failover_threshold_percentage: The percentage of failed requests in the
         sample where failover should trigger.
        :paramtype response_based_failover_threshold_percentage: int
        :keyword http_error_ranges: The list of Http status code ranges that are considered as server
         errors for origin and it is marked as unhealthy.
        :paramtype http_error_ranges: list[~azure.mgmt.cdn.models.HttpErrorRangeParameters]
        """
        super().__init__(**kwargs)
        self.response_based_detected_error_types = response_based_detected_error_types
        self.response_based_failover_threshold_percentage = response_based_failover_threshold_percentage
        self.http_error_ranges = http_error_ranges


class Route(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Friendly Routes name mapping to the any Routes or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Known values are: "Enabled" and "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Known values are: "Enabled" and "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "endpoint_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "endpoint_name": {"key": "properties.endpointName", "type": "str"},
        "custom_domains": {"key": "properties.customDomains", "type": "[ActivatedResourceReference]"},
        "origin_group": {"key": "properties.originGroup", "type": "ResourceReference"},
        "origin_path": {"key": "properties.originPath", "type": "str"},
        "rule_sets": {"key": "properties.ruleSets", "type": "[ResourceReference]"},
        "supported_protocols": {"key": "properties.supportedProtocols", "type": "[str]"},
        "patterns_to_match": {"key": "properties.patternsToMatch", "type": "[str]"},
        "cache_configuration": {"key": "properties.cacheConfiguration", "type": "AfdRouteCacheConfiguration"},
        "forwarding_protocol": {"key": "properties.forwardingProtocol", "type": "str"},
        "link_to_default_domain": {"key": "properties.linkToDefaultDomain", "type": "str"},
        "https_redirect": {"key": "properties.httpsRedirect", "type": "str"},
        "enabled_state": {"key": "properties.enabledState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["_models.ActivatedResourceReference"]] = None,
        origin_group: Optional["_models.ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["_models.ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "_models.AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["_models.AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "_models.ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "_models.LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "_models.HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Known values are: "Enabled" and "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Known values are: "Enabled" and "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class RouteConfigurationOverrideActionParameters(_serialization.Model):
    """Defines the parameters for the route configuration override action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleRouteConfigurationOverrideActionParameters"
    :vartype type_name: str or
     ~azure.mgmt.cdn.models.RouteConfigurationOverrideActionParametersTypeName
    :ivar origin_group_override: A reference to the origin group override configuration. Leave
     empty to use the default origin group on route.
    :vartype origin_group_override: ~azure.mgmt.cdn.models.OriginGroupOverride
    :ivar cache_configuration: The caching configuration associated with this rule. To disable
     caching, do not provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.CacheConfiguration
    """

    _validation = {
        "type_name": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "origin_group_override": {"key": "originGroupOverride", "type": "OriginGroupOverride"},
        "cache_configuration": {"key": "cacheConfiguration", "type": "CacheConfiguration"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.RouteConfigurationOverrideActionParametersTypeName"],
        origin_group_override: Optional["_models.OriginGroupOverride"] = None,
        cache_configuration: Optional["_models.CacheConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleRouteConfigurationOverrideActionParameters"
        :paramtype type_name: str or
         ~azure.mgmt.cdn.models.RouteConfigurationOverrideActionParametersTypeName
        :keyword origin_group_override: A reference to the origin group override configuration. Leave
         empty to use the default origin group on route.
        :paramtype origin_group_override: ~azure.mgmt.cdn.models.OriginGroupOverride
        :keyword cache_configuration: The caching configuration associated with this rule. To disable
         caching, do not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.CacheConfiguration
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.origin_group_override = origin_group_override
        self.cache_configuration = cache_configuration


class RouteListResult(_serialization.Model):
    """Result of the request to list routes. It contains a list of route objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor routes within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Route]
    :ivar next_link: URL to get the next set of route objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Route]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of route objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RouteUpdatePropertiesParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Known values are: "Enabled" and "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Known values are: "Enabled" and "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "endpoint_name": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_name": {"key": "endpointName", "type": "str"},
        "custom_domains": {"key": "customDomains", "type": "[ActivatedResourceReference]"},
        "origin_group": {"key": "originGroup", "type": "ResourceReference"},
        "origin_path": {"key": "originPath", "type": "str"},
        "rule_sets": {"key": "ruleSets", "type": "[ResourceReference]"},
        "supported_protocols": {"key": "supportedProtocols", "type": "[str]"},
        "patterns_to_match": {"key": "patternsToMatch", "type": "[str]"},
        "cache_configuration": {"key": "cacheConfiguration", "type": "AfdRouteCacheConfiguration"},
        "forwarding_protocol": {"key": "forwardingProtocol", "type": "str"},
        "link_to_default_domain": {"key": "linkToDefaultDomain", "type": "str"},
        "https_redirect": {"key": "httpsRedirect", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["_models.ActivatedResourceReference"]] = None,
        origin_group: Optional["_models.ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["_models.ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "_models.AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["_models.AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "_models.ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "_models.LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "_models.HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Known values are: "Enabled" and "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Known values are: "Enabled" and "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class RouteProperties(
    RouteUpdatePropertiesParameters, AFDStateProperties
):  # pylint: disable=too-many-instance-attributes
    """The JSON object that contains the properties of the Routes to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Known values are: "Enabled" and "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Known values are: "Enabled" and "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "endpoint_name": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "endpoint_name": {"key": "endpointName", "type": "str"},
        "custom_domains": {"key": "customDomains", "type": "[ActivatedResourceReference]"},
        "origin_group": {"key": "originGroup", "type": "ResourceReference"},
        "origin_path": {"key": "originPath", "type": "str"},
        "rule_sets": {"key": "ruleSets", "type": "[ResourceReference]"},
        "supported_protocols": {"key": "supportedProtocols", "type": "[str]"},
        "patterns_to_match": {"key": "patternsToMatch", "type": "[str]"},
        "cache_configuration": {"key": "cacheConfiguration", "type": "AfdRouteCacheConfiguration"},
        "forwarding_protocol": {"key": "forwardingProtocol", "type": "str"},
        "link_to_default_domain": {"key": "linkToDefaultDomain", "type": "str"},
        "https_redirect": {"key": "httpsRedirect", "type": "str"},
        "enabled_state": {"key": "enabledState", "type": "str"},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["_models.ActivatedResourceReference"]] = None,
        origin_group: Optional["_models.ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["_models.ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "_models.AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["_models.AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "_models.ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "_models.LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "_models.HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Known values are: "Enabled" and "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Known values are: "Enabled" and "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(
            custom_domains=custom_domains,
            origin_group=origin_group,
            origin_path=origin_path,
            rule_sets=rule_sets,
            supported_protocols=supported_protocols,
            patterns_to_match=patterns_to_match,
            cache_configuration=cache_configuration,
            forwarding_protocol=forwarding_protocol,
            link_to_default_domain=link_to_default_domain,
            https_redirect=https_redirect,
            enabled_state=enabled_state,
            **kwargs
        )
        self.provisioning_state = None
        self.deployment_status = None
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class RouteUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The domain JSON object required for domain creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint_name: The name of the endpoint which holds the route.
    :vartype endpoint_name: str
    :ivar custom_domains: Domains referenced by this endpoint.
    :vartype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar origin_group: A reference to the origin group.
    :vartype origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :ivar origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :vartype origin_path: str
    :ivar rule_sets: rule sets referenced by this endpoint.
    :vartype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :ivar supported_protocols: List of supported protocols for this route.
    :vartype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :ivar patterns_to_match: The route patterns of the rule.
    :vartype patterns_to_match: list[str]
    :ivar cache_configuration: The caching configuration for this route. To disable caching, do not
     provide a cacheConfiguration object.
    :vartype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
    :ivar forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
    :vartype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :ivar link_to_default_domain: whether this route will be linked to the default endpoint domain.
     Known values are: "Enabled" and "Disabled".
    :vartype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :ivar https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Known values are: "Enabled" and "Disabled".
    :vartype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :ivar enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        "endpoint_name": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_name": {"key": "properties.endpointName", "type": "str"},
        "custom_domains": {"key": "properties.customDomains", "type": "[ActivatedResourceReference]"},
        "origin_group": {"key": "properties.originGroup", "type": "ResourceReference"},
        "origin_path": {"key": "properties.originPath", "type": "str"},
        "rule_sets": {"key": "properties.ruleSets", "type": "[ResourceReference]"},
        "supported_protocols": {"key": "properties.supportedProtocols", "type": "[str]"},
        "patterns_to_match": {"key": "properties.patternsToMatch", "type": "[str]"},
        "cache_configuration": {"key": "properties.cacheConfiguration", "type": "AfdRouteCacheConfiguration"},
        "forwarding_protocol": {"key": "properties.forwardingProtocol", "type": "str"},
        "link_to_default_domain": {"key": "properties.linkToDefaultDomain", "type": "str"},
        "https_redirect": {"key": "properties.httpsRedirect", "type": "str"},
        "enabled_state": {"key": "properties.enabledState", "type": "str"},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["_models.ActivatedResourceReference"]] = None,
        origin_group: Optional["_models.ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["_models.ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "_models.AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        cache_configuration: Optional["_models.AfdRouteCacheConfiguration"] = None,
        forwarding_protocol: Optional[Union[str, "_models.ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "_models.LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "_models.HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "_models.EnabledState"]] = None,
        **kwargs
    ):
        """
        :keyword custom_domains: Domains referenced by this endpoint.
        :paramtype custom_domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword origin_group: A reference to the origin group.
        :paramtype origin_group: ~azure.mgmt.cdn.models.ResourceReference
        :keyword origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
         content from, e.g. contoso.cloudapp.net/originpath.
        :paramtype origin_path: str
        :keyword rule_sets: rule sets referenced by this endpoint.
        :paramtype rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
        :keyword supported_protocols: List of supported protocols for this route.
        :paramtype supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
        :keyword patterns_to_match: The route patterns of the rule.
        :paramtype patterns_to_match: list[str]
        :keyword cache_configuration: The caching configuration for this route. To disable caching, do
         not provide a cacheConfiguration object.
        :paramtype cache_configuration: ~azure.mgmt.cdn.models.AfdRouteCacheConfiguration
        :keyword forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
         Known values are: "HttpOnly", "HttpsOnly", and "MatchRequest".
        :paramtype forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
        :keyword link_to_default_domain: whether this route will be linked to the default endpoint
         domain. Known values are: "Enabled" and "Disabled".
        :paramtype link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
        :keyword https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
         that this is a easy way to set up this rule and it will be the first rule that gets executed.
         Known values are: "Enabled" and "Disabled".
        :paramtype https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
        :keyword enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
        """
        super().__init__(**kwargs)
        self.endpoint_name = None
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.cache_configuration = cache_configuration
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class Rule(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Friendly Rules name mapping to the any Rules or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Known values are:
     "Continue" and "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "rule_set_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "rule_set_name": {"key": "properties.ruleSetName", "type": "str"},
        "order": {"key": "properties.order", "type": "int"},
        "conditions": {"key": "properties.conditions", "type": "[DeliveryRuleCondition]"},
        "actions": {"key": "properties.actions", "type": "[DeliveryRuleAction]"},
        "match_processing_behavior": {"key": "properties.matchProcessingBehavior", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["_models.DeliveryRuleCondition"]] = None,
        actions: Optional[List["_models.DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "_models.MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Known values are:
         "Continue" and "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super().__init__(**kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior
        self.provisioning_state = None
        self.deployment_status = None


class RuleListResult(_serialization.Model):
    """Result of the request to list rules. It contains a list of rule objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor rules within a rule set.
    :vartype value: list[~azure.mgmt.cdn.models.Rule]
    :ivar next_link: URL to get the next set of rule objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Rule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of rule objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RuleUpdatePropertiesParameters(_serialization.Model):
    """The JSON object that contains the properties of the rule to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Known values are:
     "Continue" and "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _validation = {
        "rule_set_name": {"readonly": True},
    }

    _attribute_map = {
        "rule_set_name": {"key": "ruleSetName", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "conditions": {"key": "conditions", "type": "[DeliveryRuleCondition]"},
        "actions": {"key": "actions", "type": "[DeliveryRuleAction]"},
        "match_processing_behavior": {"key": "matchProcessingBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["_models.DeliveryRuleCondition"]] = None,
        actions: Optional[List["_models.DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "_models.MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Known values are:
         "Continue" and "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super().__init__(**kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class RuleProperties(RuleUpdatePropertiesParameters, AFDStateProperties):
    """The JSON object that contains the properties of the Rules to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Known values are:
     "Continue" and "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "rule_set_name": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "rule_set_name": {"key": "ruleSetName", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "conditions": {"key": "conditions", "type": "[DeliveryRuleCondition]"},
        "actions": {"key": "actions", "type": "[DeliveryRuleAction]"},
        "match_processing_behavior": {"key": "matchProcessingBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["_models.DeliveryRuleCondition"]] = None,
        actions: Optional[List["_models.DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "_models.MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Known values are:
         "Continue" and "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super().__init__(
            order=order,
            conditions=conditions,
            actions=actions,
            match_processing_behavior=match_processing_behavior,
            **kwargs
        )
        self.provisioning_state = None
        self.deployment_status = None
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class RuleSet(ProxyResource):
    """Friendly RuleSet name mapping to the any RuleSet or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the rule set.
    :vartype profile_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None


class RuleSetListResult(_serialization.Model):
    """Result of the request to list rule sets. It contains a list of rule set objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor rule sets within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.RuleSet]
    :ivar next_link: URL to get the next set of rule set objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RuleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of rule set objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RuleSetProperties(AFDStateProperties):
    """The JSON object that contains the properties of the Rule Set to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the rule set.
    :vartype profile_name: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "profile_name": {"key": "profileName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.profile_name = None


class RuleUpdateParameters(_serialization.Model):
    """The domain JSON object required for domain creation or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_set_name: The name of the rule set containing the rule.
    :vartype rule_set_name: str
    :ivar order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :vartype order: int
    :ivar conditions: A list of conditions that must be matched for the actions to be executed.
    :vartype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :ivar actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :vartype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :ivar match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Known values are:
     "Continue" and "Stop".
    :vartype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _validation = {
        "rule_set_name": {"readonly": True},
    }

    _attribute_map = {
        "rule_set_name": {"key": "properties.ruleSetName", "type": "str"},
        "order": {"key": "properties.order", "type": "int"},
        "conditions": {"key": "properties.conditions", "type": "[DeliveryRuleCondition]"},
        "actions": {"key": "properties.actions", "type": "[DeliveryRuleAction]"},
        "match_processing_behavior": {"key": "properties.matchProcessingBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["_models.DeliveryRuleCondition"]] = None,
        actions: Optional[List["_models.DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "_models.MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        """
        :keyword order: The order in which the rules are applied for the endpoint. Possible values
         {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
         Rule with order 0 is a special rule. It does not require any condition and actions listed in it
         will always be applied.
        :paramtype order: int
        :keyword conditions: A list of conditions that must be matched for the actions to be executed.
        :paramtype conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
        :keyword actions: A list of actions that are executed when all the conditions of a rule are
         satisfied.
        :paramtype actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
        :keyword match_processing_behavior: If this rule is a match should the rules engine continue
         running the remaining rules or stop. If not present, defaults to Continue. Known values are:
         "Continue" and "Stop".
        :paramtype match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
        """
        super().__init__(**kwargs)
        self.rule_set_name = None
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class Secret(ProxyResource):
    """Friendly Secret name mapping to the any Secret or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the secret.
    :vartype profile_name: str
    :ivar parameters: object which contains secret parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecretParameters
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "SecretParameters"},
    }

    def __init__(self, *, parameters: Optional["_models.SecretParameters"] = None, **kwargs):
        """
        :keyword parameters: object which contains secret parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecretParameters
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None
        self.parameters = parameters


class SecretListResult(_serialization.Model):
    """Result of the request to list secrets. It contains a list of Secret objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor secrets within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Secret]
    :ivar next_link: URL to get the next set of Secret objects if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Secret]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of Secret objects if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecretProperties(AFDStateProperties):
    """The JSON object that contains the properties of the Secret to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the secret.
    :vartype profile_name: str
    :ivar parameters: object which contains secret parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecretParameters
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "profile_name": {"key": "profileName", "type": "str"},
        "parameters": {"key": "parameters", "type": "SecretParameters"},
    }

    def __init__(self, *, parameters: Optional["_models.SecretParameters"] = None, **kwargs):
        """
        :keyword parameters: object which contains secret parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecretParameters
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.parameters = parameters


class SecurityPolicy(ProxyResource):
    """SecurityPolicy association for AzureFrontDoor profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the security policy.
    :vartype profile_name: str
    :ivar parameters: object which contains security policy parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "str"},
        "profile_name": {"key": "properties.profileName", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "SecurityPolicyPropertiesParameters"},
    }

    def __init__(self, *, parameters: Optional["_models.SecurityPolicyPropertiesParameters"] = None, **kwargs):
        """
        :keyword parameters: object which contains security policy parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.profile_name = None
        self.parameters = parameters


class SecurityPolicyListResult(_serialization.Model):
    """Result of the request to list security policies. It contains a list of security policy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Security policies within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.SecurityPolicy]
    :ivar next_link: URL to get the next set of security policy objects if there is any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to get the next set of security policy objects if there is any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecurityPolicyProperties(AFDStateProperties):
    """The json object that contains properties required to create a security policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Known values are: "Succeeded", "Failed",
     "Updating", "Deleting", and "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status: Known values are: "NotStarted", "InProgress", "Succeeded", and
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar profile_name: The name of the profile which holds the security policy.
    :vartype profile_name: str
    :ivar parameters: object which contains security policy parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_status": {"readonly": True},
        "profile_name": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "profile_name": {"key": "profileName", "type": "str"},
        "parameters": {"key": "parameters", "type": "SecurityPolicyPropertiesParameters"},
    }

    def __init__(self, *, parameters: Optional["_models.SecurityPolicyPropertiesParameters"] = None, **kwargs):
        """
        :keyword parameters: object which contains security policy parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
        """
        super().__init__(**kwargs)
        self.profile_name = None
        self.parameters = parameters


class SecurityPolicyPropertiesParameters(_serialization.Model):
    """The json object containing security policy parameters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SecurityPolicyWebApplicationFirewallParameters

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the Security policy to create. Required. "WebApplicationFirewall"
    :vartype type: str or ~azure.mgmt.cdn.models.SecurityPolicyType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"WebApplicationFirewall": "SecurityPolicyWebApplicationFirewallParameters"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class SecurityPolicyUpdateParameters(_serialization.Model):
    """The JSON object containing security policy update parameters.

    :ivar parameters: object which contains security policy parameters.
    :vartype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
    """

    _attribute_map = {
        "parameters": {"key": "properties.parameters", "type": "SecurityPolicyPropertiesParameters"},
    }

    def __init__(self, *, parameters: Optional["_models.SecurityPolicyPropertiesParameters"] = None, **kwargs):
        """
        :keyword parameters: object which contains security policy parameters.
        :paramtype parameters: ~azure.mgmt.cdn.models.SecurityPolicyPropertiesParameters
        """
        super().__init__(**kwargs)
        self.parameters = parameters


class SecurityPolicyWebApplicationFirewallAssociation(_serialization.Model):
    """settings for security policy patterns to match.

    :ivar domains: List of domains.
    :vartype domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
    :ivar patterns_to_match: List of paths.
    :vartype patterns_to_match: list[str]
    """

    _attribute_map = {
        "domains": {"key": "domains", "type": "[ActivatedResourceReference]"},
        "patterns_to_match": {"key": "patternsToMatch", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        domains: Optional[List["_models.ActivatedResourceReference"]] = None,
        patterns_to_match: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword domains: List of domains.
        :paramtype domains: list[~azure.mgmt.cdn.models.ActivatedResourceReference]
        :keyword patterns_to_match: List of paths.
        :paramtype patterns_to_match: list[str]
        """
        super().__init__(**kwargs)
        self.domains = domains
        self.patterns_to_match = patterns_to_match


class SecurityPolicyWebApplicationFirewallParameters(SecurityPolicyPropertiesParameters):
    """The json object containing security policy waf parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the Security policy to create. Required. "WebApplicationFirewall"
    :vartype type: str or ~azure.mgmt.cdn.models.SecurityPolicyType
    :ivar waf_policy: Resource ID.
    :vartype waf_policy: ~azure.mgmt.cdn.models.ResourceReference
    :ivar associations: Waf associations.
    :vartype associations:
     list[~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallAssociation]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "waf_policy": {"key": "wafPolicy", "type": "ResourceReference"},
        "associations": {"key": "associations", "type": "[SecurityPolicyWebApplicationFirewallAssociation]"},
    }

    def __init__(
        self,
        *,
        waf_policy: Optional["_models.ResourceReference"] = None,
        associations: Optional[List["_models.SecurityPolicyWebApplicationFirewallAssociation"]] = None,
        **kwargs
    ):
        """
        :keyword waf_policy: Resource ID.
        :paramtype waf_policy: ~azure.mgmt.cdn.models.ResourceReference
        :keyword associations: Waf associations.
        :paramtype associations:
         list[~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallAssociation]
        """
        super().__init__(**kwargs)
        self.type = "WebApplicationFirewall"  # type: str
        self.waf_policy = waf_policy
        self.associations = associations


class ServerPortMatchConditionParameters(_serialization.Model):
    """Defines the parameters for ServerPort match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleServerPortConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.ServerPortMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.ServerPortOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.ServerPortMatchConditionParametersTypeName"],
        operator: Union[str, "_models.ServerPortOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleServerPortConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.ServerPortMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.ServerPortOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class ServiceSpecification(_serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.cdn.models.LogSpecification]
    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications: list[~azure.mgmt.cdn.models.MetricSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications: list[~azure.mgmt.cdn.models.LogSpecification]
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications: list[~azure.mgmt.cdn.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class SharedPrivateLinkResourceProperties(_serialization.Model):
    """Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin.

    :ivar private_link: The resource id of the resource the shared private link resource is for.
    :vartype private_link: ~azure.mgmt.cdn.models.ResourceReference
    :ivar private_link_location: The location of the shared private link resource.
    :vartype private_link_location: str
    :ivar group_id: The group id from the provider of resource the shared private link resource is
     for.
    :vartype group_id: str
    :ivar request_message: The request message for requesting approval of the shared private link
     resource.
    :vartype request_message: str
    :ivar status: Status of the shared private link resource. Can be Pending, Approved, Rejected,
     Disconnected, or Timeout. Known values are: "Pending", "Approved", "Rejected", "Disconnected",
     and "Timeout".
    :vartype status: str or ~azure.mgmt.cdn.models.SharedPrivateLinkResourceStatus
    """

    _attribute_map = {
        "private_link": {"key": "privateLink", "type": "ResourceReference"},
        "private_link_location": {"key": "privateLinkLocation", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "request_message": {"key": "requestMessage", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link: Optional["_models.ResourceReference"] = None,
        private_link_location: Optional[str] = None,
        group_id: Optional[str] = None,
        request_message: Optional[str] = None,
        status: Optional[Union[str, "_models.SharedPrivateLinkResourceStatus"]] = None,
        **kwargs
    ):
        """
        :keyword private_link: The resource id of the resource the shared private link resource is for.
        :paramtype private_link: ~azure.mgmt.cdn.models.ResourceReference
        :keyword private_link_location: The location of the shared private link resource.
        :paramtype private_link_location: str
        :keyword group_id: The group id from the provider of resource the shared private link resource
         is for.
        :paramtype group_id: str
        :keyword request_message: The request message for requesting approval of the shared private
         link resource.
        :paramtype request_message: str
        :keyword status: Status of the shared private link resource. Can be Pending, Approved,
         Rejected, Disconnected, or Timeout. Known values are: "Pending", "Approved", "Rejected",
         "Disconnected", and "Timeout".
        :paramtype status: str or ~azure.mgmt.cdn.models.SharedPrivateLinkResourceStatus
        """
        super().__init__(**kwargs)
        self.private_link = private_link
        self.private_link_location = private_link_location
        self.group_id = group_id
        self.request_message = request_message
        self.status = status


class Sku(_serialization.Model):
    """Standard_Verizon = The SKU name for a Standard Verizon CDN profile.
    Premium_Verizon = The SKU name for a Premium Verizon CDN profile.
    Custom_Verizon = The SKU name for a Custom Verizon CDN profile.
    Standard_Akamai = The SKU name for an Akamai CDN profile.
    Standard_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using GB based billing model.
    Standard_Microsoft = The SKU name for a Standard Microsoft CDN profile.
    Standard_AzureFrontDoor =  The SKU name for an Azure Front Door Standard profile.
    Premium_AzureFrontDoor = The SKU name for an Azure Front Door Premium profile.
    Standard_955BandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using 95-5 peak bandwidth billing model.
    Standard_AvgBandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using monthly average peak bandwidth billing model.
    StandardPlus_ChinaCdn = The SKU name for a China CDN profile for live-streaming using GB based billing model.
    StandardPlus_955BandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5 peak bandwidth billing model.
    StandardPlus_AvgBandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using monthly average peak bandwidth billing model.

        :ivar name: Name of the pricing tier. Known values are: "Standard_Verizon", "Premium_Verizon",
         "Custom_Verizon", "Standard_Akamai", "Standard_ChinaCdn", "Standard_Microsoft",
         "Standard_AzureFrontDoor", "Premium_AzureFrontDoor", "Standard_955BandWidth_ChinaCdn",
         "Standard_AvgBandWidth_ChinaCdn", "StandardPlus_ChinaCdn",
         "StandardPlus_955BandWidth_ChinaCdn", and "StandardPlus_AvgBandWidth_ChinaCdn".
        :vartype name: str or ~azure.mgmt.cdn.models.SkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs):
        """
        :keyword name: Name of the pricing tier. Known values are: "Standard_Verizon",
         "Premium_Verizon", "Custom_Verizon", "Standard_Akamai", "Standard_ChinaCdn",
         "Standard_Microsoft", "Standard_AzureFrontDoor", "Premium_AzureFrontDoor",
         "Standard_955BandWidth_ChinaCdn", "Standard_AvgBandWidth_ChinaCdn", "StandardPlus_ChinaCdn",
         "StandardPlus_955BandWidth_ChinaCdn", and "StandardPlus_AvgBandWidth_ChinaCdn".
        :paramtype name: str or ~azure.mgmt.cdn.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name


class SocketAddrMatchConditionParameters(_serialization.Model):
    """Defines the parameters for SocketAddress match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleSocketAddrConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.SocketAddrMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any" and
     "IPMatch".
    :vartype operator: str or ~azure.mgmt.cdn.models.SocketAddrOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.SocketAddrMatchConditionParametersTypeName"],
        operator: Union[str, "_models.SocketAddrOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleSocketAddrConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.SocketAddrMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any" and
         "IPMatch".
        :paramtype operator: str or ~azure.mgmt.cdn.models.SocketAddrOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class SslProtocolMatchConditionParameters(_serialization.Model):
    """Defines the parameters for SslProtocol match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleSslProtocolConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.SslProtocolMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. "Equal"
    :vartype operator: str or ~azure.mgmt.cdn.models.SslProtocolOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str or ~azure.mgmt.cdn.models.SslProtocol]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.SslProtocolMatchConditionParametersTypeName"],
        operator: Union[str, "_models.SslProtocolOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "_models.SslProtocol"]]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleSslProtocolConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.SslProtocolMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. "Equal"
        :paramtype operator: str or ~azure.mgmt.cdn.models.SslProtocolOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str or ~azure.mgmt.cdn.models.SslProtocol]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class SsoUri(_serialization.Model):
    """The URI required to login to the supplemental portal from the Azure portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sso_uri_value: The URI used to login to the supplemental portal.
    :vartype sso_uri_value: str
    """

    _validation = {
        "sso_uri_value": {"readonly": True},
    }

    _attribute_map = {
        "sso_uri_value": {"key": "ssoUriValue", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.sso_uri_value = None


class SupportedOptimizationTypesListResult(_serialization.Model):
    """The result of the GetSupportedOptimizationTypes API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar supported_optimization_types: Supported optimization types for a profile.
    :vartype supported_optimization_types: list[str or ~azure.mgmt.cdn.models.OptimizationType]
    """

    _validation = {
        "supported_optimization_types": {"readonly": True},
    }

    _attribute_map = {
        "supported_optimization_types": {"key": "supportedOptimizationTypes", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.supported_optimization_types = None


class SystemData(_serialization.Model):
    """Read only system data.

    :ivar created_by: An identifier for the identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "user", "application", "managedIdentity", and "key".
    :vartype created_by_type: str or ~azure.mgmt.cdn.models.IdentityType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: An identifier for the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "user", "application", "managedIdentity", and "key".
    :vartype last_modified_by_type: str or ~azure.mgmt.cdn.models.IdentityType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: An identifier for the identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "user", "application", "managedIdentity", and "key".
        :paramtype created_by_type: str or ~azure.mgmt.cdn.models.IdentityType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: An identifier for the identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "user", "application", "managedIdentity", and "key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.cdn.models.IdentityType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UrlFileExtensionMatchConditionParameters(_serialization.Model):
    """Defines the parameters for UrlFileExtension match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleUrlFileExtensionMatchConditionParameters"
    :vartype type_name: str or
     ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.UrlFileExtensionMatchConditionParametersTypeName"],
        operator: Union[str, "_models.UrlFileExtensionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleUrlFileExtensionMatchConditionParameters"
        :paramtype type_name: str or
         ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlFileNameMatchConditionParameters(_serialization.Model):
    """Defines the parameters for UrlFilename match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleUrlFilenameConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.UrlFileNameMatchConditionParametersTypeName"],
        operator: Union[str, "_models.UrlFileNameOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleUrlFilenameConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlPathMatchConditionParameters(_serialization.Model):
    """Defines the parameters for UrlPath match conditions.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleUrlPathMatchConditionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.UrlPathMatchConditionParametersTypeName
    :ivar operator: Describes operator to be matched. Required. Known values are: "Any", "Equal",
     "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "Wildcard", and "RegEx".
    :vartype operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
    :ivar negate_condition: Describes if this is negate condition or not.
    :vartype negate_condition: bool
    :ivar match_values: The match value for the condition of the delivery rule.
    :vartype match_values: list[str]
    :ivar transforms: List of transforms.
    :vartype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        "type_name": {"required": True},
        "operator": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "negate_condition": {"key": "negateCondition", "type": "bool"},
        "match_values": {"key": "matchValues", "type": "[str]"},
        "transforms": {"key": "transforms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.UrlPathMatchConditionParametersTypeName"],
        operator: Union[str, "_models.UrlPathOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "_models.Transform"]]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleUrlPathMatchConditionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.UrlPathMatchConditionParametersTypeName
        :keyword operator: Describes operator to be matched. Required. Known values are: "Any",
         "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
         "GreaterThanOrEqual", "Wildcard", and "RegEx".
        :paramtype operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
        :keyword negate_condition: Describes if this is negate condition or not.
        :paramtype negate_condition: bool
        :keyword match_values: The match value for the condition of the delivery rule.
        :paramtype match_values: list[str]
        :keyword transforms: List of transforms.
        :paramtype transforms: list[str or ~azure.mgmt.cdn.models.Transform]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlRedirectAction(DeliveryRuleAction):
    """Defines the url redirect action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "UrlRedirectActionParameters"},
    }

    def __init__(self, *, parameters: "_models.UrlRedirectActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
        """
        super().__init__(**kwargs)
        self.name = "UrlRedirect"  # type: str
        self.parameters = parameters


class UrlRedirectActionParameters(_serialization.Model):
    """Defines the parameters for the url redirect action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleUrlRedirectActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.UrlRedirectActionParametersTypeName
    :ivar redirect_type: The redirect type the rule will use when redirecting traffic. Required.
     Known values are: "Moved", "Found", "TemporaryRedirect", and "PermanentRedirect".
    :vartype redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
    :ivar destination_protocol: Protocol to use for the redirect. The default value is
     MatchRequest. Known values are: "MatchRequest", "Http", and "Https".
    :vartype destination_protocol: str or ~azure.mgmt.cdn.models.DestinationProtocol
    :ivar custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave
     empty to use the incoming path as destination path.
    :vartype custom_path: str
    :ivar custom_hostname: Host to redirect. Leave empty to use the incoming host as the
     destination host.
    :vartype custom_hostname: str
    :ivar custom_query_string: The set of query strings to be placed in the redirect URL. Setting
     this value would replace any existing query string; leave empty to preserve the incoming query
     string. Query string must be in :code:`<key>`=:code:`<value>` format. ? and & will be added
     automatically so do not include them.
    :vartype custom_query_string: str
    :ivar custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
     that comes after #. Do not include the #.
    :vartype custom_fragment: str
    """

    _validation = {
        "type_name": {"required": True},
        "redirect_type": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "redirect_type": {"key": "redirectType", "type": "str"},
        "destination_protocol": {"key": "destinationProtocol", "type": "str"},
        "custom_path": {"key": "customPath", "type": "str"},
        "custom_hostname": {"key": "customHostname", "type": "str"},
        "custom_query_string": {"key": "customQueryString", "type": "str"},
        "custom_fragment": {"key": "customFragment", "type": "str"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.UrlRedirectActionParametersTypeName"],
        redirect_type: Union[str, "_models.RedirectType"],
        destination_protocol: Optional[Union[str, "_models.DestinationProtocol"]] = None,
        custom_path: Optional[str] = None,
        custom_hostname: Optional[str] = None,
        custom_query_string: Optional[str] = None,
        custom_fragment: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleUrlRedirectActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.UrlRedirectActionParametersTypeName
        :keyword redirect_type: The redirect type the rule will use when redirecting traffic. Required.
         Known values are: "Moved", "Found", "TemporaryRedirect", and "PermanentRedirect".
        :paramtype redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
        :keyword destination_protocol: Protocol to use for the redirect. The default value is
         MatchRequest. Known values are: "MatchRequest", "Http", and "Https".
        :paramtype destination_protocol: str or ~azure.mgmt.cdn.models.DestinationProtocol
        :keyword custom_path: The full path to redirect. Path cannot be empty and must start with /.
         Leave empty to use the incoming path as destination path.
        :paramtype custom_path: str
        :keyword custom_hostname: Host to redirect. Leave empty to use the incoming host as the
         destination host.
        :paramtype custom_hostname: str
        :keyword custom_query_string: The set of query strings to be placed in the redirect URL.
         Setting this value would replace any existing query string; leave empty to preserve the
         incoming query string. Query string must be in :code:`<key>`=:code:`<value>` format. ? and &
         will be added automatically so do not include them.
        :paramtype custom_query_string: str
        :keyword custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
         that comes after #. Do not include the #.
        :paramtype custom_fragment: str
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.redirect_type = redirect_type
        self.destination_protocol = destination_protocol
        self.custom_path = custom_path
        self.custom_hostname = custom_hostname
        self.custom_query_string = custom_query_string
        self.custom_fragment = custom_fragment


class UrlRewriteAction(DeliveryRuleAction):
    """Defines the url rewrite action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "UrlRewriteActionParameters"},
    }

    def __init__(self, *, parameters: "_models.UrlRewriteActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
        """
        super().__init__(**kwargs)
        self.name = "UrlRewrite"  # type: str
        self.parameters = parameters


class UrlRewriteActionParameters(_serialization.Model):
    """Defines the parameters for the url rewrite action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleUrlRewriteActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.UrlRewriteActionParametersTypeName
    :ivar source_pattern: define a request URI pattern that identifies the type of requests that
     may be rewritten. If value is blank, all strings are matched. Required.
    :vartype source_pattern: str
    :ivar destination: Define the relative URL to which the above requests will be rewritten by.
     Required.
    :vartype destination: str
    :ivar preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
    :vartype preserve_unmatched_path: bool
    """

    _validation = {
        "type_name": {"required": True},
        "source_pattern": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "source_pattern": {"key": "sourcePattern", "type": "str"},
        "destination": {"key": "destination", "type": "str"},
        "preserve_unmatched_path": {"key": "preserveUnmatchedPath", "type": "bool"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.UrlRewriteActionParametersTypeName"],
        source_pattern: str,
        destination: str,
        preserve_unmatched_path: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleUrlRewriteActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.UrlRewriteActionParametersTypeName
        :keyword source_pattern: define a request URI pattern that identifies the type of requests that
         may be rewritten. If value is blank, all strings are matched. Required.
        :paramtype source_pattern: str
        :keyword destination: Define the relative URL to which the above requests will be rewritten by.
         Required.
        :paramtype destination: str
        :keyword preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
        :paramtype preserve_unmatched_path: bool
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.source_pattern = source_pattern
        self.destination = destination
        self.preserve_unmatched_path = preserve_unmatched_path


class UrlSigningAction(DeliveryRuleAction):
    """Defines the url signing action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the action for the delivery rule. Required. Known values are:
     "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader", "ModifyResponseHeader",
     "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride", and
     "RouteConfigurationOverride".
    :vartype name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :ivar parameters: Defines the parameters for the action. Required.
    :vartype parameters: ~azure.mgmt.cdn.models.UrlSigningActionParameters
    """

    _validation = {
        "name": {"required": True},
        "parameters": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "UrlSigningActionParameters"},
    }

    def __init__(self, *, parameters: "_models.UrlSigningActionParameters", **kwargs):
        """
        :keyword parameters: Defines the parameters for the action. Required.
        :paramtype parameters: ~azure.mgmt.cdn.models.UrlSigningActionParameters
        """
        super().__init__(**kwargs)
        self.name = "UrlSigning"  # type: str
        self.parameters = parameters


class UrlSigningActionParameters(_serialization.Model):
    """Defines the parameters for the Url Signing action.

    All required parameters must be populated in order to send to Azure.

    :ivar type_name: Required. "DeliveryRuleUrlSigningActionParameters"
    :vartype type_name: str or ~azure.mgmt.cdn.models.UrlSigningActionParametersTypeName
    :ivar algorithm: Algorithm to use for URL signing. "SHA256"
    :vartype algorithm: str or ~azure.mgmt.cdn.models.Algorithm
    :ivar parameter_name_override: Defines which query string parameters in the url to be
     considered for expires, key id etc.
    :vartype parameter_name_override: list[~azure.mgmt.cdn.models.UrlSigningParamIdentifier]
    """

    _validation = {
        "type_name": {"required": True},
    }

    _attribute_map = {
        "type_name": {"key": "typeName", "type": "str"},
        "algorithm": {"key": "algorithm", "type": "str"},
        "parameter_name_override": {"key": "parameterNameOverride", "type": "[UrlSigningParamIdentifier]"},
    }

    def __init__(
        self,
        *,
        type_name: Union[str, "_models.UrlSigningActionParametersTypeName"],
        algorithm: Optional[Union[str, "_models.Algorithm"]] = None,
        parameter_name_override: Optional[List["_models.UrlSigningParamIdentifier"]] = None,
        **kwargs
    ):
        """
        :keyword type_name: Required. "DeliveryRuleUrlSigningActionParameters"
        :paramtype type_name: str or ~azure.mgmt.cdn.models.UrlSigningActionParametersTypeName
        :keyword algorithm: Algorithm to use for URL signing. "SHA256"
        :paramtype algorithm: str or ~azure.mgmt.cdn.models.Algorithm
        :keyword parameter_name_override: Defines which query string parameters in the url to be
         considered for expires, key id etc.
        :paramtype parameter_name_override: list[~azure.mgmt.cdn.models.UrlSigningParamIdentifier]
        """
        super().__init__(**kwargs)
        self.type_name = type_name
        self.algorithm = algorithm
        self.parameter_name_override = parameter_name_override


class UrlSigningKey(_serialization.Model):
    """Url signing key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_id: Defines the customer defined key Id. This id will exist in the incoming request
     to indicate the key used to form the hash. Required.
    :vartype key_id: str
    :ivar key_source_parameters: Defines the parameters for using customer key vault for Url
     Signing Key. Required.
    :vartype key_source_parameters: ~azure.mgmt.cdn.models.KeyVaultSigningKeyParameters
    """

    _validation = {
        "key_id": {"required": True},
        "key_source_parameters": {"required": True},
    }

    _attribute_map = {
        "key_id": {"key": "keyId", "type": "str"},
        "key_source_parameters": {"key": "keySourceParameters", "type": "KeyVaultSigningKeyParameters"},
    }

    def __init__(self, *, key_id: str, key_source_parameters: "_models.KeyVaultSigningKeyParameters", **kwargs):
        """
        :keyword key_id: Defines the customer defined key Id. This id will exist in the incoming
         request to indicate the key used to form the hash. Required.
        :paramtype key_id: str
        :keyword key_source_parameters: Defines the parameters for using customer key vault for Url
         Signing Key. Required.
        :paramtype key_source_parameters: ~azure.mgmt.cdn.models.KeyVaultSigningKeyParameters
        """
        super().__init__(**kwargs)
        self.key_id = key_id
        self.key_source_parameters = key_source_parameters


class UrlSigningKeyParameters(SecretParameters):
    """Url signing key parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the secret resource. Required. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar key_id: Defines the customer defined key Id. This id will exist in the incoming request
     to indicate the key used to form the hash. Required.
    :vartype key_id: str
    :ivar secret_source: Resource reference to the Azure Key Vault secret. Expected to be in format
     of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
     Required.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Version of the secret to be used.
    :vartype secret_version: str
    """

    _validation = {
        "type": {"required": True},
        "key_id": {"required": True},
        "secret_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "key_id": {"key": "keyId", "type": "str"},
        "secret_source": {"key": "secretSource", "type": "ResourceReference"},
        "secret_version": {"key": "secretVersion", "type": "str"},
    }

    def __init__(
        self, *, key_id: str, secret_source: "_models.ResourceReference", secret_version: Optional[str] = None, **kwargs
    ):
        """
        :keyword key_id: Defines the customer defined key Id. This id will exist in the incoming
         request to indicate the key used to form the hash. Required.
        :paramtype key_id: str
        :keyword secret_source: Resource reference to the Azure Key Vault secret. Expected to be in
         format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
         Required.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Version of the secret to be used.
        :paramtype secret_version: str
        """
        super().__init__(**kwargs)
        self.type = "UrlSigningKey"  # type: str
        self.key_id = key_id
        self.secret_source = secret_source
        self.secret_version = secret_version


class UrlSigningParamIdentifier(_serialization.Model):
    """Defines how to identify a parameter for a specific purpose e.g. expires.

    All required parameters must be populated in order to send to Azure.

    :ivar param_indicator: Indicates the purpose of the parameter. Required. Known values are:
     "Expires", "KeyId", and "Signature".
    :vartype param_indicator: str or ~azure.mgmt.cdn.models.ParamIndicator
    :ivar param_name: Parameter name. Required.
    :vartype param_name: str
    """

    _validation = {
        "param_indicator": {"required": True},
        "param_name": {"required": True},
    }

    _attribute_map = {
        "param_indicator": {"key": "paramIndicator", "type": "str"},
        "param_name": {"key": "paramName", "type": "str"},
    }

    def __init__(self, *, param_indicator: Union[str, "_models.ParamIndicator"], param_name: str, **kwargs):
        """
        :keyword param_indicator: Indicates the purpose of the parameter. Required. Known values are:
         "Expires", "KeyId", and "Signature".
        :paramtype param_indicator: str or ~azure.mgmt.cdn.models.ParamIndicator
        :keyword param_name: Parameter name. Required.
        :paramtype param_name: str
        """
        super().__init__(**kwargs)
        self.param_indicator = param_indicator
        self.param_name = param_name


class Usage(_serialization.Model):
    """Describes resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :ivar unit: An enum describing the unit of measurement. Required. "Count"
    :vartype unit: str or ~azure.mgmt.cdn.models.UsageUnit
    :ivar current_value: The current value of the usage. Required.
    :vartype current_value: int
    :ivar limit: The limit of usage. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.cdn.models.UsageName
    """

    _validation = {
        "id": {"readonly": True},
        "unit": {"required": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "_models.UsageUnit"],
        current_value: int,
        limit: int,
        name: "_models.UsageName",
        **kwargs
    ):
        """
        :keyword unit: An enum describing the unit of measurement. Required. "Count"
        :paramtype unit: str or ~azure.mgmt.cdn.models.UsageUnit
        :keyword current_value: The current value of the usage. Required.
        :paramtype current_value: int
        :keyword limit: The limit of usage. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.cdn.models.UsageName
        """
        super().__init__(**kwargs)
        self.id = None
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The usage names.

    :ivar value: A string describing the resource name.
    :vartype value: str
    :ivar localized_value: A localized string describing the resource name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs):
        """
        :keyword value: A string describing the resource name.
        :paramtype value: str
        :keyword localized_value: A localized string describing the resource name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(_serialization.Model):
    """The list usages operation response.

    :ivar value: The list of resource usages.
    :vartype value: list[~azure.mgmt.cdn.models.Usage]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Usage"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of resource usages.
        :paramtype value: list[~azure.mgmt.cdn.models.Usage]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using user's keyvault certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_source: Defines the source of the SSL certificate. Required. Known values
     are: "AzureKeyVault" and "Cdn".
    :vartype certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :ivar protocol_type: Defines the TLS extension protocol that is used for secure delivery.
     Required. Known values are: "ServerNameIndication" and "IPBased".
    :vartype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :ivar minimum_tls_version: TLS protocol version that will be used for Https. Known values are:
     "None", "TLS10", and "TLS12".
    :vartype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :ivar certificate_source_parameters: Defines the certificate source parameters using user's
     keyvault certificate for enabling SSL. Required.
    :vartype certificate_source_parameters:
     ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
    """

    _validation = {
        "certificate_source": {"required": True},
        "protocol_type": {"required": True},
        "certificate_source_parameters": {"required": True},
    }

    _attribute_map = {
        "certificate_source": {"key": "certificateSource", "type": "str"},
        "protocol_type": {"key": "protocolType", "type": "str"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "certificate_source_parameters": {
            "key": "certificateSourceParameters",
            "type": "KeyVaultCertificateSourceParameters",
        },
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "_models.ProtocolType"],
        certificate_source_parameters: "_models.KeyVaultCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "_models.MinimumTlsVersion"]] = None,
        **kwargs
    ):
        """
        :keyword protocol_type: Defines the TLS extension protocol that is used for secure delivery.
         Required. Known values are: "ServerNameIndication" and "IPBased".
        :paramtype protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
        :keyword minimum_tls_version: TLS protocol version that will be used for Https. Known values
         are: "None", "TLS10", and "TLS12".
        :paramtype minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
        :keyword certificate_source_parameters: Defines the certificate source parameters using user's
         keyvault certificate for enabling SSL. Required.
        :paramtype certificate_source_parameters:
         ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
        """
        super().__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = "AzureKeyVault"  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class ValidateCustomDomainInput(_serialization.Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :ivar host_name: The host name of the custom domain. Must be a domain name. Required.
    :vartype host_name: str
    """

    _validation = {
        "host_name": {"required": True},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
    }

    def __init__(self, *, host_name: str, **kwargs):
        """
        :keyword host_name: The host name of the custom domain. Must be a domain name. Required.
        :paramtype host_name: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name


class ValidateCustomDomainOutput(_serialization.Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not valid.
    :vartype message: str
    """

    _validation = {
        "custom_domain_validated": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "custom_domain_validated": {"key": "customDomainValidated", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class ValidateProbeInput(_serialization.Model):
    """Input of the validate probe API.

    All required parameters must be populated in order to send to Azure.

    :ivar probe_url: The probe URL to validate. Required.
    :vartype probe_url: str
    """

    _validation = {
        "probe_url": {"required": True},
    }

    _attribute_map = {
        "probe_url": {"key": "probeURL", "type": "str"},
    }

    def __init__(self, *, probe_url: str, **kwargs):
        """
        :keyword probe_url: The probe URL to validate. Required.
        :paramtype probe_url: str
        """
        super().__init__(**kwargs)
        self.probe_url = probe_url


class ValidateProbeOutput(_serialization.Model):
    """Output of the validate probe API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Indicates whether the probe URL is accepted or not.
    :vartype is_valid: bool
    :ivar error_code: Specifies the error code when the probe url is not accepted.
    :vartype error_code: str
    :ivar message: The detailed error message describing why the probe URL is not accepted.
    :vartype message: str
    """

    _validation = {
        "is_valid": {"readonly": True},
        "error_code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "error_code": {"key": "errorCode", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.is_valid = None
        self.error_code = None
        self.message = None


class ValidateSecretInput(_serialization.Model):
    """Input of the secret to be validated.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: The secret type. Required. Known values are: "UrlSigningKey",
     "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
    :vartype secret_type: str or ~azure.mgmt.cdn.models.SecretType
    :ivar secret_source: Resource reference to the Azure Key Vault secret. Expected to be in format
     of
     /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
     Required.
    :vartype secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :ivar secret_version: Secret version, if customer is using a specific version.
    :vartype secret_version: str
    """

    _validation = {
        "secret_type": {"required": True},
        "secret_source": {"required": True},
    }

    _attribute_map = {
        "secret_type": {"key": "secretType", "type": "str"},
        "secret_source": {"key": "secretSource", "type": "ResourceReference"},
        "secret_version": {"key": "secretVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        secret_type: Union[str, "_models.SecretType"],
        secret_source: "_models.ResourceReference",
        secret_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword secret_type: The secret type. Required. Known values are: "UrlSigningKey",
         "CustomerCertificate", "ManagedCertificate", and "AzureFirstPartyManagedCertificate".
        :paramtype secret_type: str or ~azure.mgmt.cdn.models.SecretType
        :keyword secret_source: Resource reference to the Azure Key Vault secret. Expected to be in
         format of
         /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
         Required.
        :paramtype secret_source: ~azure.mgmt.cdn.models.ResourceReference
        :keyword secret_version: Secret version, if customer is using a specific version.
        :paramtype secret_version: str
        """
        super().__init__(**kwargs)
        self.secret_type = secret_type
        self.secret_source = secret_source
        self.secret_version = secret_version


class ValidateSecretOutput(_serialization.Model):
    """Output of the validated secret.

    :ivar status: The validation status. Known values are: "Valid", "Invalid", "AccessDenied", and
     "CertificateExpired".
    :vartype status: str or ~azure.mgmt.cdn.models.Status
    :ivar message: Detailed error message.
    :vartype message: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, status: Optional[Union[str, "_models.Status"]] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword status: The validation status. Known values are: "Valid", "Invalid", "AccessDenied",
         and "CertificateExpired".
        :paramtype status: str or ~azure.mgmt.cdn.models.Status
        :keyword message: Detailed error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.message = message


class ValidationToken(_serialization.Model):
    """The validation token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar token:
    :vartype token: str
    """

    _validation = {
        "token": {"readonly": True},
    }

    _attribute_map = {
        "token": {"key": "token", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.token = None


class WafMetricsResponse(_serialization.Model):
    """Waf Metrics Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar granularity: Known values are: "PT5M", "PT1H", and "P1D".
    :vartype granularity: str or ~azure.mgmt.cdn.models.WafMetricsResponseGranularity
    :ivar series:
    :vartype series: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesItem]
    """

    _attribute_map = {
        "date_time_begin": {"key": "dateTimeBegin", "type": "iso-8601"},
        "date_time_end": {"key": "dateTimeEnd", "type": "iso-8601"},
        "granularity": {"key": "granularity", "type": "str"},
        "series": {"key": "series", "type": "[WafMetricsResponseSeriesItem]"},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        granularity: Optional[Union[str, "_models.WafMetricsResponseGranularity"]] = None,
        series: Optional[List["_models.WafMetricsResponseSeriesItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword granularity: Known values are: "PT5M", "PT1H", and "P1D".
        :paramtype granularity: str or ~azure.mgmt.cdn.models.WafMetricsResponseGranularity
        :keyword series:
        :paramtype series: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesItem]
        """
        super().__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.granularity = granularity
        self.series = series


class WafMetricsResponseSeriesItem(_serialization.Model):
    """WafMetricsResponseSeriesItem.

    :ivar metric:
    :vartype metric: str
    :ivar unit: "count"
    :vartype unit: str or ~azure.mgmt.cdn.models.WafMetricsResponseSeriesItemUnit
    :ivar groups:
    :vartype groups: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesPropertiesItemsItem]
    :ivar data:
    :vartype data:
     list[~azure.mgmt.cdn.models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]
    """

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "groups": {"key": "groups", "type": "[WafMetricsResponseSeriesPropertiesItemsItem]"},
        "data": {
            "key": "data",
            "type": "[Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]",
        },
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        unit: Optional[Union[str, "_models.WafMetricsResponseSeriesItemUnit"]] = None,
        groups: Optional[List["_models.WafMetricsResponseSeriesPropertiesItemsItem"]] = None,
        data: Optional[
            List["_models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems"]
        ] = None,
        **kwargs
    ):
        """
        :keyword metric:
        :paramtype metric: str
        :keyword unit: "count"
        :paramtype unit: str or ~azure.mgmt.cdn.models.WafMetricsResponseSeriesItemUnit
        :keyword groups:
        :paramtype groups: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesPropertiesItemsItem]
        :keyword data:
        :paramtype data:
         list[~azure.mgmt.cdn.models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.unit = unit
        self.groups = groups
        self.data = data


class WafMetricsResponseSeriesPropertiesItemsItem(_serialization.Model):
    """WafMetricsResponseSeriesPropertiesItemsItem.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword name:
        :paramtype name: str
        :keyword value:
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class WafRankingsResponse(_serialization.Model):
    """Waf Rankings Response.

    :ivar date_time_begin:
    :vartype date_time_begin: ~datetime.datetime
    :ivar date_time_end:
    :vartype date_time_end: ~datetime.datetime
    :ivar groups:
    :vartype groups: list[str]
    :ivar data:
    :vartype data: list[~azure.mgmt.cdn.models.WafRankingsResponseDataItem]
    """

    _attribute_map = {
        "date_time_begin": {"key": "dateTimeBegin", "type": "iso-8601"},
        "date_time_end": {"key": "dateTimeEnd", "type": "iso-8601"},
        "groups": {"key": "groups", "type": "[str]"},
        "data": {"key": "data", "type": "[WafRankingsResponseDataItem]"},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        groups: Optional[List[str]] = None,
        data: Optional[List["_models.WafRankingsResponseDataItem"]] = None,
        **kwargs
    ):
        """
        :keyword date_time_begin:
        :paramtype date_time_begin: ~datetime.datetime
        :keyword date_time_end:
        :paramtype date_time_end: ~datetime.datetime
        :keyword groups:
        :paramtype groups: list[str]
        :keyword data:
        :paramtype data: list[~azure.mgmt.cdn.models.WafRankingsResponseDataItem]
        """
        super().__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.groups = groups
        self.data = data


class WafRankingsResponseDataItem(_serialization.Model):
    """WafRankingsResponseDataItem.

    :ivar group_values:
    :vartype group_values: list[str]
    :ivar metrics:
    :vartype metrics:
     list[~azure.mgmt.cdn.models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]
    """

    _attribute_map = {
        "group_values": {"key": "groupValues", "type": "[str]"},
        "metrics": {
            "key": "metrics",
            "type": "[ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]",
        },
    }

    def __init__(
        self,
        *,
        group_values: Optional[List[str]] = None,
        metrics: Optional[
            List["_models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems"]
        ] = None,
        **kwargs
    ):
        """
        :keyword group_values:
        :paramtype group_values: list[str]
        :keyword metrics:
        :paramtype metrics:
         list[~azure.mgmt.cdn.models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]
        """
        super().__init__(**kwargs)
        self.group_values = group_values
        self.metrics = metrics
