#!/bin/sh

# panic: sleeping without a lock
# cpuid = 17
# time = 1594020733
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe013e99d6d0
# vpanic() at vpanic+0x182/frame 0xfffffe013e99d720
# panic() at panic+0x43/frame 0xfffffe013e99d780
# _sleep() at _sleep+0x466/frame 0xfffffe013e99d820
# soclose() at soclose+0x12a/frame 0xfffffe013e99d890
# _fdrop() at _fdrop+0x1a/frame 0xfffffe013e99d8b0
# closef() at closef+0x1db/frame 0xfffffe013e99d940
# fdescfree_fds() at fdescfree_fds+0x3c/frame 0xfffffe013e99d990
# fdescfree() at fdescfree+0x36c/frame 0xfffffe013e99da50
# exit1() at exit1+0x487/frame 0xfffffe013e99dac0
# sys_sys_exit() at sys_sys_exit+0xd/frame 0xfffffe013e99dad0
# amd64_syscall() at amd64_syscall+0x159/frame 0xfffffe013e99dbf0
# fast_syscall_common() at fast_syscall_common+0x101/frame 0xfffffe013e99dbf0
# --- syscall (1, FreeBSD ELF64, sys_sys_exit), rip = 0x8004513da, rsp = 0x7fffffffe548, rbp = 0x7fffffffe560 ---
# KDB: enter: panic
# [ thread pid 86998 tid 100362 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10c3a16(%rip)
# db> x/s version
# version:FreeBSD 13.0-CURRENT #2 r362887+d0cb7ae7cb9-c248258(mlnx3): Sat
# Jul  4 10:28:49 CEST 2020 pho@t2.osted.lan:/var/tmp/deviant2/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller19.c <<EOF
// https://syzkaller.appspot.com/bug?id=2196001e8447f2133532abeabaea2ebc0351f67b
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+e625d92c1dd74e402c81@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused;
  for (iter = 0;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 0x1cul, 1ul, 0x84);
  if (res != -1)
    r[0] = res;
  *(uint8_t*)0x20000000 = 0x1c;
  *(uint8_t*)0x20000001 = 0x1c;
  *(uint16_t*)0x20000002 = htobe16(0x4e22);
  *(uint32_t*)0x20000004 = 0;
  *(uint8_t*)0x20000008 = 0;
  *(uint8_t*)0x20000009 = 0;
  *(uint8_t*)0x2000000a = 0;
  *(uint8_t*)0x2000000b = 0;
  *(uint8_t*)0x2000000c = 0;
  *(uint8_t*)0x2000000d = 0;
  *(uint8_t*)0x2000000e = 0;
  *(uint8_t*)0x2000000f = 0;
  *(uint8_t*)0x20000010 = 0;
  *(uint8_t*)0x20000011 = 0;
  *(uint8_t*)0x20000012 = 0;
  *(uint8_t*)0x20000013 = 0;
  *(uint8_t*)0x20000014 = 0;
  *(uint8_t*)0x20000015 = 0;
  *(uint8_t*)0x20000016 = 0;
  *(uint8_t*)0x20000017 = 0;
  *(uint32_t*)0x20000018 = 0;
  syscall(SYS_bind, r[0], 0x20000000ul, 0x1cul);
  *(uint8_t*)0x20000180 = 0x1c;
  *(uint8_t*)0x20000181 = 0x1c;
  *(uint16_t*)0x20000182 = htobe16(0x4e22);
  *(uint32_t*)0x20000184 = 0;
  *(uint64_t*)0x20000188 = htobe64(0);
  *(uint64_t*)0x20000190 = htobe64(1);
  *(uint32_t*)0x20000198 = 0;
  syscall(SYS_connect, r[0], 0x20000180ul, 0x1cul);
  *(uint64_t*)0x20000080 = 0;
  *(uint32_t*)0x20000088 = 0;
  *(uint64_t*)0x20000090 = 0;
  *(uint64_t*)0x20000098 = 0;
  *(uint64_t*)0x200000a0 = 0;
  *(uint64_t*)0x200000a8 = 0x60;
  *(uint32_t*)0x200000b0 = 0;
  syscall(SYS_sendmsg, r[0], 0x20000080ul, 0x10cul);
  *(uint32_t*)0x200000c0 = 0xbd;
  *(uint32_t*)0x200000c4 = 0;
  syscall(SYS_setsockopt, r[0], 0xffff, 0x80, 0x200000c0ul, 8ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller19 -Wall -Wextra -O2 /tmp/syzkaller19.c -lpthread ||
    exit 1

(cd ../testcases/swap; ./swap -t 1m -i 20 -h > /dev/null 2>&1) &
(cd /tmp; ./syzkaller19) &
sleep 60
pkill -9 syzkaller19
while pkill swap; do sleep 1; done
wait

rm -f /tmp/syzkaller19 /tmp/syzkaller19.c /tmp/syzkaller19.core
exit 0
