#define __MOST_VERSION__ "4.22"
#define __MOST_USAGE__ "most [-bstvw1] [+line] [+/string] [+[C][D]] filename"
/*
               Most ---- a more/less paging type program.

   Copyright (C) 1991, 1993 by John E. Davis. (davis@amy.tch.harvard.edu)

                   The following disclaimer from GNU emacs.

                                 NO WARRANTY

  BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, WE PROVIDE ABSOLUTELY NO
WARRANTY, TO THE EXTENT PERMITTED BY APPLICABLE STATE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING, JOHN E. DAVIS AND/OR OTHER PARTIES PROVIDE THIS
PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND
PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE,
YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

 IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL JOHN E. DAVIS, AND/OR ANY
OTHER PARTY WHO MAY MODIFY AND REDISTRIBUTE THIS PROGRAM AS PERMITTED BELOW,
BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR
OTHER SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE
PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS) THIS PROGRAM, EVEN IF YOU HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER
PARTY.

                        GENERAL PUBLIC LICENSE TO COPY

  1. You may copy and distribute verbatim copies of this source file as you
receive it, in any medium, provided that you conspicuously and appropriately
publish on each copy a valid copyright notice "Copyright (C) 1990 John E.
Davis"; and include following the copyright notice a verbatim copy of the
above disclaimer of warranty and of this License.  You may charge a
distribution fee for the physical act of transferring a copy.

  2. You may modify your copy or copies of this source file or
any portion of it, and copy and distribute such modifications under
the terms of Paragraph 1 above, provided that you also do the following:

    a) cause the modified files to carry prominent notices stating
    that you changed the files and the date of any change; and

    b) cause the whole of any work that you distribute or publish,
    that in whole or in part contains or is a derivative of this
    program or any part thereof, to be licensed at no charge to all
    third parties on terms identical to those contained in this
    License Agreement (except that you may choose to grant more extensive
    warranty protection to some or all third parties, at your option).

    c) You may charge a distribution fee for the physical act of
    transferring a copy, and you may at your option offer warranty
    protection in exchange for a fee.

Mere aggregation of another unrelated program with this program (or its
derivative) on a volume of a storage or distribution medium does not bring
the other program under the scope of these terms.

  3. You may copy and distribute this program (or a portion or derivative
of it, under Paragraph 2) in object code or executable form under the terms
of Paragraphs 1 and 2 above provided that you also do one of the following:

    a) accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of
    Paragraphs 1 and 2 above; or,

    b) accompany it with a written offer, valid for at least three
    years, to give any third party free (except for a nominal
    shipping charge) a complete machine-readable copy of the
    corresponding source code, to be distributed under the terms of
    Paragraphs 1 and 2 above; or,

    c) accompany it with the information you received as to where the
    corresponding source code may be obtained.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form alone.)

For an executable file, complete source code means all the source code for
all modules it contains; but, as a special exception, it need not include
source code for modules which are standard libraries that accompany the
operating system on which the executable file runs.

  4. You may not copy, sublicense, distribute or transfer this program
except as expressly provided under this License Agreement.  Any attempt
otherwise to copy, sublicense, distribute or transfer this program is void and
your rights to use the program under this License agreement shall be
automatically terminated.  However, parties who have received computer
software programs from you with this License Agreement will not have
their licenses terminated so long as such parties remain in full compliance.

In other words, you are welcome to use, share and improve this program.
You are forbidden to forbid anyone else to use, share and improve
what you give them.   Help stamp out software-hoarding!  */

char *MOST_VERSION = __MOST_VERSION__ ;
#include <stdio.h>
#include "externs.h"
#include "window.h"
#include "buffer.h"
#include "file.h"
#include "sysdep.h"
#include "most.h"

int MOST_K_OPT = 0;    /* Display 8 bit unformatted (Kanji) */
int  STARTING_LINE;
char *MOST_PROGRAM;	/* Program Name (argv[0]) */

#include <ctype.h>

#ifdef VMS
#include <stdlib.h>
#ifndef isalpha
#define isalpha(x) \
      (((x >= 'A') && (x <= 'Z'))||((x >= 'a') && (x <= 'z')) ? 1 : 0)
#endif
#endif

#include "display.h"

void do_extended_switches(char *str)
{
    int i;
    char ch,numstr[7];
    
    i = 0;
    ch = *(++str);
    if ( ch == '/')
      {
          strcpy(SEARCH_STR,++str);
      }
    else if (ch >= '0' && ch <= '9')
      {
          while (ch >= '0' && ch <= '9')
            {
                numstr[i++] = ch;
                ch = *(++str);
            }
          numstr[i] = '\0';
          (void) sscanf(numstr,"%d",&STARTING_LINE);
      }
    else if (isalpha(ch))
      {
          while (isalpha(ch))
            {
                if ((ch == 'C') || (ch == 'c'))
                  CASE_SENSITIVE = 1;
                else if ((ch == 'D') || (ch == 'd'))
                  MOST_D_OPT = 1;   /* delete file mode */
                ch = *(++str);
            }
      }
    
    else
      {
          fprintf(stdout,"switch '+%s' not valid.\n",str);
          exit(0);
      }
}

/* if non-zero, assume terminal is only a generic vt100 */
static int assume_vt100 = 0;

void do_switches(char *str)
{

    while (*str != '\0')
      {
          switch (*str++)
            {
              case 'a':
              case 'A':
                MOST_A_OPT = 1; break;  /* check to see if file is binary */
              case 's':
              case 'S':
                SQUEEZE_LINES = 1; break;
              case 'c':
              case 'C':
                MOST_C_OPT = 1; break;
              case 'V':
              case 'v':
                MOST_V_OPT = 1;  /* verbose-- convert control chars to '^' 'ch' */
                break;
              case 'W':
              case 'w':  MOST_W_OPT = 1; break;
              case 'K':
              case 'k':  MOST_K_OPT = 1; break;
              case 'B':
              case 'b':
                MOST_B_OPT = 1;  /* Binary display 8 bit */
                break;
              case 't':
              case 'T': /* expand tabs to '^I'; meaningful only with 'v' */
                MOST_T_OPT = 1;
                break;
              case 'L':
              case 'l':
                MOST_L_OPT = 1;  /* use ^L to clear screen */
                break;
	     case '1': assume_vt100 = 1;
            }
      }
}

void exit_error(char *s)
{
   reset_tty();
   reset_display();
   fprintf(stderr, "%s\n", s);
   exit(1);
}

void play_cat()
{
   char buf[2048];
   int n;
   
   while ((n = fread(buf, 1, 2048, stdin)) > 0)
     {
	fwrite (buf, 1, n, stdout);
     }
   exit(0);
}


extern char *getenv();
int main(int argc, char *argv[])
{
    char file[255], *switches;
    int file_i = 0, quit,i,piped,a_opt;
    unsigned long context;

#ifdef VMS
   char filename[256];
#else
   int j;
#endif

   
    extern int isatty(int);
    extern void sysinit(void);

    MOST_PROGRAM = argv[0];
    piped = 0;
    switches = getenv("MOST_SWITCHES");
    if (switches !=  NULL)  do_switches(switches);
          
    i = 1;
    if (argc > 1)
      {
          quit = 0;
          while ((!quit) && (i < argc))
            {
                if (argv[i][0] == '-')
                  do_switches(argv[i++]);
                else if (argv[i][0] == '+')
                  do_extended_switches(argv[i++]);
                else quit = 1;
            }
      }

    
    if (i == argc)
      {
          if (isatty(0))   /* 1 if stdin is a terminal, 0 otherwise */
            {
                fprintf(stderr,"MOST(%s) Usage: %s\n",MOST_VERSION,__MOST_USAGE__);
                        exit(0);
            }
          /* assume input is from stdin */
          file[0] = '\0';  /* tells most this is stdin */
          piped = 1;
          MOST_A_OPT = 0;  /* in this version since we cannot do an fseek */
	 if (!isatty(fileno(stdout))) play_cat();
      }
    else
      strcpy(file,argv[i]);

    NUM_FILES = 0;
    context = 0;

    init_tty();
#ifdef unix
    get_terminfo();           /* set up esc sequences etc... */
#else
   set_term_vtxxx(assume_vt100);
#endif
   
    if (MOST_B_OPT) MOST_A_OPT = 0;   /* explicit b overrides a */
    a_opt = MOST_A_OPT;

    if (!piped)
      {
          file_i = i;
#ifdef VMS
          while(i < argc)
            {
                if (argv[i][0] == '.') strcpy(file,"*"); else *file = 0;
                strcat(file,unix2vms(argv[i++]));
                while (expand_file_name(file,filename))
                  {
                      FILE_RING[NUM_FILES] = (char*) MALLOC(strlen(filename) + 1);
                      strcpy(FILE_RING[NUM_FILES++], filename);
                  }
            }
	 if (NUM_FILES) strcpy(file,FILE_RING[0]);
	 else fputs("%%MOST-W-NOFILES, no files found\n", stderr);
#else
          j = 0;
          NUM_FILES = argc - i;
          while (i < argc)
            {
                FILE_RING[j++] = argv[i++];
            }
#endif
      }

    if (NUM_FILES) quit = 0; else quit = 1;
    if (!quit || piped) most(file,STARTING_LINE);
    if (quit) fprintf(stderr,"File %s not found\n", argv[file_i]);

    reset_tty();
    reset_display();
#ifndef  VMS
    tt_putchar('\n');
#endif    
    exit(0);
    return (0);
}

