/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.datetime;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.buildins.datetime.DateTimePrologCode;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class Predicate_stamp_date_time
extends DateTimePrologCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (!(args[0] instanceof FloatTerm)) {
            PrologException.typeError(TermConstants.floatAtom, args[0]);
        }
        double ts = ((FloatTerm)args[0]).value;
        if (!(args[1] instanceof VariableTerm)) {
            PrologException.typeError(TermConstants.variableAtom, args[1]);
        }
        TimeZone tz = null;
        if (args[2] instanceof IntegerTerm) {
            tz = new SimpleTimeZone(((IntegerTerm)args[2]).value * 1000, "-");
        } else if (args[2] instanceof AtomTerm) {
            String tzString = ((AtomTerm)args[2]).value;
            tz = TimeZone.getTimeZone(tzString);
        } else {
            PrologException.typeError(TermConstants.atomAtom, args[2]);
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(Math.round(ts * 1000.0));
        Term[] dateTime = new Term[9];
        dateTime[0] = IntegerTerm.get(cal.get(1));
        dateTime[1] = IntegerTerm.get(cal.get(2) + 1);
        dateTime[2] = IntegerTerm.get(cal.get(5));
        dateTime[3] = IntegerTerm.get(cal.get(11));
        dateTime[4] = IntegerTerm.get(cal.get(12));
        dateTime[5] = new FloatTerm((double)cal.get(13) + (double)cal.get(14) / 1000.0);
        dateTime[6] = IntegerTerm.get(cal.get(15) / 1000);
        if (tz != null) {
            dateTime[7] = AtomTerm.get(tz.getID());
            dateTime[8] = tz.useDaylightTime() ? (tz.inDaylightTime(cal.getTime()) ? TermConstants.trueAtom : TermConstants.falseAtom) : AtomTerm.get("-");
        } else {
            dateTime[7] = AtomTerm.get("-");
            dateTime[8] = AtomTerm.get("-");
        }
        CompoundTerm res = new CompoundTerm(date9Tag, dateTime);
        return interpreter.unify(args[1], res);
    }
}

