/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.test;

import gnu.prolog.Version;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.TermReader;
import gnu.prolog.io.TermWriter;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Iterator;

public class GoalRunner {
    private GoalRunner() {
    }

    private static void usage() {
        System.out.println("usage: java gnu.prolog.test.GoalRunner [-once] <text to load> <goal to run>");
        System.out.println("example: java gnu.prolog.test.GoalRunner append.pro append([a,b],[c,d],R)");
        System.exit(-1);
    }

    public static void main(String[] args) {
        try {
            String goalToRun;
            String textToLoad;
            boolean once;
            System.out.println("GNU Prolog for Java (" + Version.getVersion() + ") Goal runner (c) Constantine Plotnikov, 1997-1999.");
            if (args.length < 2) {
                GoalRunner.usage();
            }
            if ("-once".equals(args[0])) {
                if (args.length < 3) {
                    GoalRunner.usage();
                }
                once = true;
                textToLoad = args[1];
                goalToRun = args[2];
            } else {
                once = false;
                textToLoad = args[0];
                goalToRun = args[1];
            }
            Environment env = new Environment();
            env.ensureLoaded(AtomTerm.get(textToLoad));
            Interpreter interpreter = env.createInterpreter();
            env.runIntialization(interpreter);
            Iterator<PrologTextLoaderError> i$ = env.getLoadingErrors().iterator();
            while (i$.hasNext()) {
                PrologTextLoaderError element;
                PrologTextLoaderError err = element = i$.next();
                System.err.println(err);
            }
            LineNumberReader kin = new LineNumberReader(new InputStreamReader(System.in));
            StringReader rd = new StringReader(goalToRun);
            TermReader trd = new TermReader(rd, env);
            TermWriter out = new TermWriter(new OutputStreamWriter(System.out));
            ReadOptions rd_ops = new ReadOptions();
            rd_ops.operatorSet = env.getOperatorSet();
            WriteOptions wr_ops = new WriteOptions();
            wr_ops.operatorSet = env.getOperatorSet();
            Term goalTerm = trd.readTermEof(rd_ops);
            Interpreter.Goal goal = interpreter.prepareGoal(goalTerm);
            while (true) {
                long startTime = System.currentTimeMillis();
                int rc = interpreter.execute(goal);
                long stopTime = System.currentTimeMillis();
                env.getUserOutput().flushOutput(null);
                System.out.println("time = " + (stopTime - startTime) + "ms");
                String response = "n";
                switch (rc) {
                    case 0: {
                        WriteOptions options = new WriteOptions();
                        options.operatorSet = new OperatorSet();
                        for (String name : rd_ops.variableNames.keySet()) {
                            out.print(name + " = ");
                            out.print(options, rd_ops.variableNames.get(name).dereference());
                            out.print("; ");
                        }
                        out.println();
                        if (once) {
                            out.print("SUCCESS. redo suppressed by command line option \"-once\"");
                            return;
                        }
                        out.print("SUCCESS. redo (y/n/a)?");
                        out.flush();
                        response = kin.readLine();
                        if ("a".equals(response)) {
                            interpreter.stop(goal);
                            goal = interpreter.prepareGoal(goalTerm);
                        }
                        if (!"n".equals(response)) break;
                        return;
                    }
                    case 1: {
                        WriteOptions options = new WriteOptions();
                        options.operatorSet = new OperatorSet();
                        for (String name : rd_ops.variableNames.keySet()) {
                            out.print(name + " = ");
                            out.print(options, rd_ops.variableNames.get(name).dereference());
                            out.print("; ");
                        }
                        out.println();
                        out.println("SUCCESS LAST");
                        out.flush();
                        return;
                    }
                    case -1: {
                        out.println("FAIL");
                        out.flush();
                        return;
                    }
                    case -2: {
                        env.closeStreams();
                        out.println("HALT");
                        out.flush();
                        System.exit(interpreter.getExitCode());
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}

