/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharConversionTable {
    protected Map<Character, Character> conv = new HashMap<Character, Character>();

    public boolean hasConversions() {
        return !this.conv.isEmpty();
    }

    public void setConversion(char from, char to) {
        if (from == to) {
            this.conv.remove(Character.valueOf(from));
        } else {
            this.conv.put(Character.valueOf(from), Character.valueOf(to));
        }
    }

    public char convert(char input) {
        if (this.conv.containsKey(Character.valueOf(input))) {
            return this.conv.get(Character.valueOf(input)).charValue();
        }
        return input;
    }

    public Set<Character> convertsTo(char toChar) {
        HashSet<Character> res = new HashSet<Character>();
        if (!this.conv.containsKey(Character.valueOf(toChar))) {
            res.add(Character.valueOf(toChar));
        }
        for (Map.Entry<Character, Character> entry : this.conv.entrySet()) {
            if (entry.getValue().charValue() != toChar) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    public Term charConvert(Term term, Environment environment) {
        Term status = environment.getPrologFlag(Environment.charConversionAtom);
        if (status == Environment.onAtom) {
            if ((term = term.dereference()) instanceof AtomTerm) {
                AtomTerm aTerm = (AtomTerm)term;
                term = AtomTerm.get(this.applyConversion(aTerm.value));
            } else if (term instanceof CompoundTerm) {
                CompoundTerm cTerm = (CompoundTerm)term;
                AtomTerm convertedFunctor = (AtomTerm)this.charConvert(cTerm.tag.functor, environment);
                Term[] convertedArgs = new Term[cTerm.args.length];
                int i = 0;
                while (i < cTerm.args.length) {
                    convertedArgs[i] = this.charConvert(cTerm.args[i], environment);
                    ++i;
                }
                term = new CompoundTerm(convertedFunctor, convertedArgs);
            }
        }
        return term;
    }

    public String applyConversion(String fromString) {
        char[] fromCharacters = fromString.toCharArray();
        char[] toCharacters = new char[fromCharacters.length];
        int i = 0;
        while (i < fromCharacters.length) {
            toCharacters[i] = this.convert(fromCharacters[i]);
            ++i;
        }
        return new String(toCharacters);
    }
}

