/*
** updatehosts - accept /etc/host file section updates via mail.
**
**  Accepts mail on stdin, then looks at body of message for:
**      # begin: foo
**
**  whereupon it writes this and all lines up to and including:
**      # end: foo
**
**  to the file HOSTDIR/foo... If a line of the format:
**      # adminmail: goober
**  is encountered an acknowledgment is sent to goober. 
**
**  If it sees: 
**      send
**  it will send the sender a copy of the current hosts file. If it
**  sees:
**      help
**  it will send the sender a copy of the help file
**
**
**  to make the program receive mail addressed to updatehosts,
**  add the following line to your /usr/lib/aliases file 
**	updatehosts: "|/usr/local/adm/hosts/updatehosts"
**
**  Written by Bob Coggeshall (coggs@boulder.Colorado.EDU)
**
*/

#define JTY "Just thought you'd like to know.\n"

#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>

#define HOSTDIR         "/usr/local/adm/hosts/hostsrc/"
#define HOSTS           "/usr/local/adm/hosts/hostsrc/hosts"
#define HELPFILE        "/usr/local/adm/hosts/doc/updatehosts.catme"
/** NEDITOR should be the name of the person allowed to edit  **/
#define NEDITOR         "coggs"
#define TEMPFILEPREF    "/tmp/updatehosts."
#define STDERR      	"/tmp/updatehosts.stderr"
#define UMASK		002

/** domainame contains your domain name **/
char *domainame = "colorado.edu";
char hostname[MAXHOSTNAMELEN];


/* values used by upexit() */

#define FAIL 1
#define FAKEFAIL 0		/* avoid generating mail bounces */
#define SUCCESS 0

/* values returned by parsline() */

#define BEGIN       1
#define END         2
#define ADMINMAIL   3
#define MAILHEAD    4
#define DATA        5
#define SEND        6
#define HELP        7
#define SUBJECT     8	

/* values used by mail() */

#define INDENT   1
#define NOINDENT 0

char *gets();
char *rindex();
char *index();
char *getcuradmin();
FILE *fopen();
FILE *freopen();

char *progname;

char wrkline[256];          /* yet another */
char wrkline1[256];         /* yet another 1 */

char realsender[256];       /* sender from the 'From ' line */
char curadminmail[256];     /* current value of 'Adminmail:' arg from file */

FILE *fd = NULL;            /* file descriptor for writing section file */
FILE *tfd = NULL;           /* file descriptor for temp file */
FILE *efd = NULL;           /* file descriptor for stderr */
char *cp;                   /* general purpose character pointer */
char tempfile[256];         /* name of temporary file */

main(ac,av)
int ac;
char **av;
{

    char arg[256];              /* rhs of arguments from input file */
    char line[256];             /* general purpose line buffer */
    char secfile[256];          /* name of section file */
    char secname[256];          /* name of section */
    char adminmail[256];        /* administrator mail arg */
    int pid;                    /* process id */
    int freadcount;             /* count returned from fread() */
    int systatus;               /* returned by system() */

	umask(UMASK);

    /*
    ** get the hostname and the program name.
    */
    gethostname(hostname,sizeof(hostname));

    if ((progname = rindex(*av,'/')) == 0)
        progname = *av;
    else
        progname++;

    /*
    ** redirect stderr to a file
    */
    if ( (efd = freopen(STDERR,"w+",stderr)) == NULL) {
        sprintf(wrkline, "%s: couldn't freopen() %s", progname,STDERR);
        mail(NEDITOR,wrkline, JTY,0,0);
    }

    /* 
    ** process input, parseline figures out what kind of line it is
    ** and this case statement decides what to do.
    */
    while (gets(line) != NULL)
    {
        switch (parseline(line,arg)) {

                case ADMINMAIL:         /* snarf adminmail arg */
                    if (tfd) {
                        fputs(line,tfd);
                        fputc('\n',tfd);
                    }
                    strcpy(adminmail,arg);
                    /*
                    ** check that old adminmail and new adminmail args match
                    */
                    strcpy(wrkline,adminmail);
                    if ((cp = index(wrkline,'@')) != 0) 
                            *cp = '\0';

                    strcpy(wrkline1,curadminmail);
                    if ((cp = index(wrkline1,'@')) != 0) 
                            *cp = '\0';

                    if ( (strncmp(wrkline,wrkline1,sizeof(wrkline)) != 0) ) {
                        sprintf(wrkline,
			"%s: new adminmail:%s and current adminmail: %s  don't match",
                        progname,adminmail,curadminmail);
                        mail(NEDITOR,wrkline, JTY,0,0);
                        upexit(FAKEFAIL);
                    }
                    break;

                case MAILHEAD:          /* its the mail header, skip it */
                    strcpy(realsender,arg); /* snarf sender */
					fprintf(stderr,"realsender: %s\n",realsender);
                    break;

                case SUBJECT: 
                    break;

                case SEND:          /* they want a copy of the whole thing */
                    sprintf(wrkline,"%s: copy of current hosts file:",progname);
                    mail(realsender,wrkline,"",HOSTS,NOINDENT);

                    sprintf(wrkline,"%s: sent %s copy of current hosts file",
                            progname,realsender);
                    mail(NEDITOR,wrkline,JTY,0,0);

                    upexit(SUCCESS);

                    break;

                case HELP:          /* send them the help file */
                    sprintf(wrkline,"%s: help file",progname);
                    mail(realsender,wrkline,"",HELPFILE,NOINDENT);

                    sprintf(wrkline,"%s: sent %s the help file",
                            progname,realsender);
                    mail(NEDITOR,wrkline,JTY,0,0);

                    upexit(SUCCESS);
                    break;

                case DATA:              /* its data, snarf it. */
                    if (tfd) {
                        fputs(line,tfd);
                        fputc('\n',tfd);
                    }
                    break;

                case BEGIN:             
                    /*
                    ** if begin, then see if section file exists
                    ** if it doesn't send mail and die. if it does
                    ** open it tempfile for write.
                    */
                    strcpy(secfile,HOSTDIR);
                    strcpy(secname,arg);
                    strcat(secfile,secname);

                    if (access(secfile,0) != 0) {
                        sprintf(wrkline,"%s: Can't access() %s",
                        progname,secfile);
                        mail(NEDITOR,wrkline,
                        "File needs to exist before i'll overwrite it",0,0);
                        upexit(FAKEFAIL);
                    }
                
                    /* 
                    ** read secfile and get the current adminmail: arg
                    ** and authenticate by comparing it with sender
                    */
                    strcpy(curadminmail,getcuradmin(secfile));

                    strcpy(wrkline,curadminmail);
                    if ((cp = index(wrkline,'@')) != 0) 
                            *cp = '\0';

                    strcpy(wrkline1,realsender);
                    if ((cp = index(wrkline1,'@')) != 0) 
                            *cp = '\0';

                    if ( (strncmp(wrkline,wrkline1,sizeof(wrkline)) != 0) ) {
                    /*
                    ** some exceptions....
                    */
                    strcpy(wrkline,NEDITOR);
                    if ((cp  = index(wrkline,'@')) != 0)
                        *cp = '\0';
                    if ( (strncmp(wrkline,wrkline1,sizeof(wrkline)) == 0)|| 
                        strncmp(wrkline,"root",sizeof("root")) == 0)
                        goto except;

                    sprintf(wrkline,
                    "%s: sender: %s and current adminmail: %s don't match",
                    progname,realsender,curadminmail);
                    mail(NEDITOR,wrkline, JTY,0,0);
                    upexit(FAKEFAIL);
                }
            except:

                    /*
                    ** open temporary file.
                    */
                    pid = getpid(); 
                    sprintf(tempfile,"%s%d",TEMPFILEPREF,pid);
                    if ( (tfd = fopen(tempfile,"w+")) == 0) {
                        sprintf(wrkline,"%s: Can't fopen() %s",
                        progname,tempfile);
                        mail(NEDITOR,wrkline,JTY,0,0);
                        upexit(FAKEFAIL);
                    }

                    if ( (fputs("##\n",tfd)) == EOF) {
                        sprintf(wrkline,"%s: %s: Write failed", 
                        progname, tempfile);
                        mail(NEDITOR,wrkline,JTY,0,0);
                        upexit(FAKEFAIL);
                    }
                    fputs(line,tfd);
                    fputc('\n',tfd);
                    break;

                case END:
                    /*
                    **   if end then close file, make sure begin and
                    **  end agree. complain and die if not. otherwise
                    **  send mail that things are ok
                    */
                    strcpy(wrkline,HOSTDIR);
                    strcat(wrkline,arg);

                    if (strncmp(wrkline,secfile,strlen(tempfile)) != 0) {
                        sprintf(wrkline,"%s %s",NEDITOR,adminmail);
                        sprintf(wrkline1,
                        "%s: 'End:' arg disagreed with 'Begin:' arg",progname);
                        mail(wrkline,wrkline1,JTY,0,0);
                        upexit(FAKEFAIL);
                    }

                    fputs(line,tfd);
                    fputc('\n',tfd);
                    fputs("##\n",tfd);
                    (void)fseek(tfd,0L,0);

                    if ( (fd = fopen(secfile,"w")) == 0) {
                        sprintf(wrkline,"%s: Can't fopen() %s",
                        progname,secfile);
                        mail(NEDITOR,wrkline,JTY,0,0);
                        upexit(FAKEFAIL);
                    }

                    while( (freadcount = fread(wrkline, 
                                        sizeof(*wrkline),
                                        sizeof(wrkline),tfd))  > 0)

                        if ((fwrite(wrkline,
                            sizeof(*wrkline),freadcount,fd))  < 0) {
                            sprintf(wrkline,"%s: Can't fwrite() %s",
                            progname,secfile);
                            mail(NEDITOR,wrkline,JTY,0,0);
                            upexit(FAKEFAIL);
                        }
            
                    if ( (fclose(fd) == EOF) ) {
                            sprintf(wrkline,"%s: Can't fclose() %s",
                            progname,secfile);
                            mail(NEDITOR,wrkline,JTY,0,0);
                            upexit(FAKEFAIL);
                    }

                    fclose(tfd);
                    unlink(tempfile);
                
                    sprintf(wrkline,"%s, %s",NEDITOR,adminmail);
                    sprintf(wrkline1,
                    "%s: \"%s\" submitted by \"%s\" successfully",
                    progname,secname,adminmail);
                    mail(wrkline,wrkline1,"Revised file: \n",secfile,NOINDENT); 

                    /*
                    ** do a 'make hosts'
                    */
                    sprintf(wrkline,"cd %s;make hosts > /dev/null\n",HOSTDIR);
                    if ( (systatus = system(wrkline)) != SUCCESS) {
                        fclose(efd);
                        sprintf(wrkline1,"%s: make returns %d",
				progname,systatus);
                        mail(NEDITOR,wrkline1,wrkline,STDERR,INDENT);
                        upexit(FAKEFAIL);
		    }
                    
                    break;


                default:
                    break;
        }
    }
    upexit(SUCCESS);
}
    


/*
** tolowers(string) - convert string to lowercase
**
*/
        
tolowers(string)
char *string;
{
    char *s;

    s = string;

        while (*s++)
            *s = (isupper(*s) ? tolower(*s) : *s ) ;
}


/*
** parseline(line,arg) - determine what kinda line it is 
**
**  line - input string
**  arg  - string parsed out of Begin: End: or adminmail: line
**
** returns BEGIN        - if it was a '# Begin:'
**         END          - if it was a '# End:'
**         ADMINMAIL    - if it was a '# AdminMail:'
**         MAILHEAD     - if it was a 'From '
**         DATA         - if it was anything else
**         SEND         - if it was a 'Subject: Send '
**         HELP         - if it was a 'Subject: Help '
**         SUBJECT      - if it was a 'Subject: anything'
*/
parseline(s,arg)
char *s,*arg;
{
    char wrkline[256];
    char *cp;
    int result;

        strcpy(wrkline,s);

        cp = wrkline;
        
        result = DATA;

        if (strncmp(cp,"From ",strlen("From ")) == 0) {
                sscanf(cp,"%*s %s",arg);    
                result = MAILHEAD;
                return(result);
        }

        tolowers(wrkline);

        /* 
        ** check out subject line for 'help' or 'send'
        */
        if (strncmp(cp,"Subject:",strlen("Subject:")) == 0) {
                sscanf(cp,"%*s %s",arg);    
                if (strncmp(arg,"send",strlen("send")) == 0) {
                        arg = "";
                        result = SEND;
                        return(result);
                }
                if (strncmp(arg,"help",strlen("help")) == 0) {
                        arg = "";
                        result = HELP;
                        return(result);
                }
                result = SUBJECT;
                return(result);
        }
                

        if (*cp++ == '#') 
        {


            while (*cp == ' ' || *cp == '\t') 
             cp++;

            if (strncmp(cp,"begin:",strlen("begin:")) == 0)
                    result = BEGIN;

            if (strncmp(cp,"end:",strlen("end:")) == 0)
                     result = END;

            if (strncmp(cp,"adminmail:",strlen("adminmail:")) == 0)
                    result = ADMINMAIL;
    
		sscanf(cp,"%*s %s",arg);    

        return(result);
        }
    return(result);
}


/*
** mail(recipient,subject,message,file,indent) - send somebuddy mail.
**
**
*/
static
mail(recip,subj,mesg,file,indent)
char *recip, *subj, *mesg, *file;
int indent;
{
    FILE *pfd;
    FILE *ifd;
    char *aav[11];
    int fildes[2];
    int stdin_fd;
    int pid;
    char retaddr[128];
    char line[128];

    /*
    ** put together arglist for sendmail 
    */
    sprintf(retaddr,"%s@%s",progname,hostname);
    aav[0] = "/usr/lib/sendmail";
    aav[1] = "-t";
    aav[2] = "-oi";
    aav[3] = "-f";
    aav[4] = retaddr;
    aav[5] = "-F";
    aav[6] = "/etc/host updating facility";
    aav[7] = NULL;      /* grimble snort */

    /* prep pipe to write to child */

    pipe (fildes);

    /* save stdin  */

    stdin_fd = dup(0);

    /* cauterize stdin temporarily */

    dup2(fildes[0], 0);

    /* fork; child execs sendmail, parent writes to child (sendmail). */

    if ( (pid = vfork()) < 0) {
        fputs("vfork botch",stderr);
        perror(progname);
    }
    if (pid == 0) {
            execv (aav[0],aav);
    }

    /* make standard in normal again in parent  */

    dup2 (stdin_fd, 0);

    /* associate file descriptor with a stream so we can fputs, etc */
    if ( (pfd = fdopen(fildes[1],"w")) ==  NULL)
        perror(progname);
    
    fprintf(pfd,"To: %s\n",recip);
    fprintf(pfd,"Subject: %s\n",subj);
    fputs("\n",pfd);

    fprintf(pfd,"%s", mesg);

    /* 
    ** read send file along
    */
    if (file != 0) {
        if ( (ifd = fopen(file,"r")) == NULL) 
            fprintf(pfd,">> Couldn't fopen() %s\n",file);

        if (indent) 
                fputs("> \n",pfd);

        while(fgets(line,sizeof(line),ifd) != NULL) {
		if (indent)
			fputs("> ",pfd);
	        fputs(line,pfd);
        }
        fclose(ifd);
    }
    
    fprintf(pfd,"\nyours truly,\n\n");
    fprintf(pfd,"%s",retaddr);
    fclose(pfd);
    close (fildes[1]);
    return(SUCCESS);
}


/*
** skipheader(fd) - skip over mail header
**
**  actually just read until you get a blank line...
**
*/

skipheader(fd)
FILE *fd;
{
    char line[256];
    while(fgets(line,sizeof(line),fd) != NULL) {
        if (line[0] == '\n')
                break;
    }
}
/* 
** getcuradmin(secfile) - read an existing section file and 
**                      return the adminmail: arg
*/

char *getcuradmin(secfile)
char *secfile;
{
    FILE *fd;
    char line[256];
    char arg[256];
    char s[256];

    if ( (fd = fopen(secfile,"r")) == 0) {
            sprintf(wrkline,"%s: Can't fopen() %s",
                    progname,secfile);
            mail(NEDITOR,wrkline,JTY,0,0);
            upexit(FAKEFAIL);
    }

    while ( (fgets(line,256,fd) != NULL ))  {

        switch (parseline(line,arg)) {

        case ADMINMAIL:
            strcpy(s,arg);
            break;

        default:
            break;
        }   
    }

fclose(fd);
return(s);
}

/*
** upexit(code) - clean up and pass 'code' to system exit()
*/
upexit(code)
int code;
{
    if (tfd != NULL) fclose(tfd);
    if (efd != NULL) fclose(efd);
    if (fd  != NULL) fclose(fd);
    unlink(tempfile);
    unlink(STDERR);
    exit(code);
}
