.TH ckyorn L "5/29/91" "Auburn University"
.SH NAME
ckyorn \- ask for an input of yes or no
.SH SYNOPSIS
.B ckyorn
[
.B \-Q
]
[
.B \-d
.I default
]
[
.B \-p
.I prompt
]
.SH DESCRIPTION
.B ckyorn
prompts the user and validates the response.  The prompt is user
specifiable as is the default response.

Valid responses are any case permutation of yes and no.  Optionally
the user may respond with quit.  Command line swithes control the 
default and quit behavior of 
.B ckyorn.
.SH OPTIONS
The options and arguments for this command are:
.TP 1.0i
-Q
Specifies that quit will not be allowed as a valid response.
.TP 1.0i
-d
Defines the default value as
.I default.
.TP 1.0i
-p
Defines the prompt message as
.I prompt.
.SH "SEE ALSO"
ckitem(l), ckpath(l)
.SH "EXIT CODES"
.PD 0
0 = Successful execution
.PP
1 = EOF on input
.PP
2 = Usage Error
.PP
3 = User termination (quit)
.PD
.SH AUTHORS
Matthew Long <long1@eng.auburn.edu>,                    
.br
Hunter Eidson <eeidson@eng.auburn.edu>
.SH BUGS
.B ckyorn
doesn't support all of the features of the System V Release 4 version.
Of special note, all of the formatting options are missing.
.SH NOTES
.B ckyorn
prints the question to stderr and accepts input from
stdin.  This allows
.B ckyorn
to appear interactive and yet return a string on stdout.

The default prompt for
.B ckyorn
is:
.PP
.RS
.B
Yes or No [y,n,?,q]:
.RE
.PP
One question mark will give a help message and then redisplay the 
prompt.   

The default error message is:
.PP
.RS
.PD 0
.B
ERROR - Please enter yes or no.
.RE
.PD
.PP
The default help message is:
.PP
.RS
.PD 0
.B
To respond in the affirmative, enter y, yes, Y, or YES.
.PP
.B
To respond in the negative, enter n, no, N, or NO.
.RE
.PP
When the quit option is chosen (and allowed), an empty string
is returned along with the return code 3.
