/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	93/01/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Removes all loaded modulefiles from the environment.
 *	
 * $Log: ModuleCmd_Purge.c,v $
 * Revision 2.0  1993/02/22  02:34:50  jlf
 * Release Modules 2.0
 *
 *
 * Revision 1.4  1993/01/25  18:54:54  jlf
 * Undid previous change because it was not necessary.  Added the free
 * of the lmodules data.
 *
 * Revision 1.3  1993/01/25  04:19:17  jlf
 * Fixed a strtok() problem with cur_modulefile.
 *
 * Revision 1.2  1993/01/22  17:37:04  jlf
 * Removed extra log message.
 *
 * Revision 1.1  1993/01/22  17:35:29  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Purge.c,v 2.0 1993/02/22 02:34:50 jlf Exp jlf $";

#include <sys/types.h>
#include <sys/stat.h>
#include "global.h"

int
ModuleCmd_Purge(Tcl_Interp* interp,
                int         argc,
                char*       argv[])
{
    char*  loaded_modules = Tcl_GetVar2(interp, "env", "LOADEDMODULES", TCL_GLOBAL_ONLY);
    char*  lmodules = NULL;
    char*  cur_module = NULL;
    int    unload_argc = 0, status, i=0;
    char*  unload_argv[1024];
    
    if(!loaded_modules) { return TCL_OK; }

    lmodules = strdup(loaded_modules);

    cur_module = strtok(lmodules, ":");
    while(cur_module && unload_argc<1023) {
        unload_argv[unload_argc++] = cur_module;
        cur_module = strtok(NULL, ":");
    }
    unload_argv[unload_argc] = NULL;
    
    status = ModuleCmd_Load(interp, 0, unload_argc, unload_argv);

    free(lmodules);
    return status;
}
