/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include <utmp.h>
#include <pwd.h>
#include "shell.h"

char *getnjobs(), **getusers(), *gettime();

extern struct proc_tab *proc;
extern int max_ent;
extern char newmail, **_mailnotice, *_home, **_homedirs, *_term[11];
extern char buf[1024], path[1024];
extern long TIMEON;

static int p, a, pmax,amax;

char *pline(s,m,n)
char *s;
short m,n;
{
  static char *tc[12] = {"SO","SE","CE","KS","KE","DC","IC","DS","TC","FS","HS",0};
  int i, j, users = 0;
  char *jobs = NULL;
  char **user = NULL;
  char *t;

  amax = m > 1023? 1023 : m;
  pmax = n > 1023? 1023 : n;

  p = a = 0;
  do {
    if (*s == '%') {
      if (isupper(*(s+1)) && isupper(*(s+2))) {
        j = FALSE;
	path[0] = *(s+1);
	path[1] = *(s+2);
	path[2] = 0;
	for(i=0;tc[i];i++)
	  if (!strcmp(path,tc[i])) {
	    insert(_term[i]);
	    s += 2;
	    j = TRUE;
	    break;
	  }
	if (j) continue;
      }
      switch(*++s) {
	case 't':
	  insert(gettime(0));
	  break;
	case 'w':
	  insert(gettime(1));
	  break;
	case 'd':
	  insert(gettime(2));
	  break;
	case 'm':
	  insert(gettime(3));
	  break;
	case 'y':
	  insert(gettime(4));
	  break;
	case 'M':
	  insert(gettime(5));
	  break;
	case 'T':
	  i = time(0) - TIMEON;
	  sprintf(path,"%d:%02d",i/3600,(i%3600)/60);
	  insert(path);
	  break;
	case 'j':
	  if (!jobs) jobs = getnjobs();
	  insert(jobs);
	  break;
	case '~':
	  getwd(path);
	  j = strlen(_home);
	  if (!strncmp(_home,path,j)) {
	    insert("~");
	    if (strlen(path) == j) break;
	    insert(path+j);
	    break;
	  }
	  for(i=0;_homedirs[i];i++) {
	    j = strlen(_homedirs[i]);
	    if (!strncmp(_homedirs[i],path,j)) {
	      if (strlen(path) == j) continue;
	      insert("~");
	      insert(path+j+(_homedirs[i][j-1]=='/'?0:1));
	      break;
	    }
	  }
	  if (!_homedirs[i]) insert(path);
	  break;
	case 'p':
	  getwd(path);
	  insert(path);
	  break;
	case 'P':
	  getwd(path);
	  for(i=strlen(path);i>=0 && path[i] != '/'; i--);
	  insert(path+i+1);
	  break;
	case 'u':
	  if (!users) user = getusers(&users);
	  sprintf(path,"%d",users);
	  insert(path);
	  break;
	case 'U':
	  if (!user) user = getusers(&users);
	  for(i=0;user[i];i++) insert(user[i]);
	  break;
	case 'l':
	  t = (char *)getenv("USER");
	  if (!users) user = getusers(&users);
	  for(i=j=0;user[i];i++) if (!strncmp(user[i],t,strlen(user[i])-1)) j++;
	  free(t);
	  sprintf(path,"%d",j);
	  insert(path);
	  break;
	case 'n':
	  if (newmail){
	    if (_mailnotice) {
	      if (_mailnotice[1]) insert(_mailnotice[1]);
	      else insert(" New mail ");
	    } else insert(" New mail ");
	  }
	  break;
	case 'i':
	  for(i=0;_term[SO][i];i++) buf[p++] = _term[SO][i];
	  break;
	case 'I':
	  for(i=0;_term[SE][i];i++) buf[p++] = _term[SE][i];
	  break;
	case '%':
	  buf[p++] = '%';
	  a++;
	  break;
	default:
	  buf[p++] = '%';
	  buf[p++] = *s;
	  a += 2;
	  break;
      }
    } else {
      buf[p++] = *s;
      a++;
    }
  } while (*s++ && a < amax && p < pmax);
  if (p > pmax) p = pmax;
  buf[p] = 0;
  if (user) {
    for(i=0;user[i];i++) free(user[i]);
    free(user);
  }
  return buf;
}

char *gettime(fmt)
char fmt;
{
  time_t tp;
  struct tm *ti;
  static char str[30];
  static char *month[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  static char *day[7] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};

  time(&tp);
  ti = localtime(&tp);
  switch(fmt) {
    case 0:
      sprintf(str,"%d:%02d %s",(ti->tm_hour>12?ti->tm_hour-12:ti->tm_hour),ti->tm_min,(ti->tm_hour>11?"pm":"am"));
      break;
    case 1:
      sprintf(str,"%s",day[ti->tm_wday]);
      break;
    case 2:
      sprintf(str,"%d",ti->tm_mday);
      break;
    case 3:
      sprintf(str,"%s",month[ti->tm_mon]);
      break;
    case 4:
      sprintf(str,"%d",1900+ti->tm_year);
      break;
    case 5:
      sprintf(str,"%d:%02d",ti->tm_hour,ti->tm_min);
      break;
  }
  return str;
}

char **getusers(nusers)
int *nusers;
{
  char **users = (char **)malloc(sizeof(char *));
  int fd;
  struct utmp utmp;

  fd=open("/etc/utmp",O_RDONLY);
  for (;;) {
    if(read(fd,&utmp,sizeof(utmp)) <= 0) {
      close(fd);
      users[*nusers] = NULL;
      users[*nusers-1][strlen(users[*nusers-1])-1] = 0;
      return users;
    }
    if(utmp.ut_name[0] == '\0') continue;
    users = (char **)realloc(users, sizeof(char *) * (*nusers + 2));
    users[*nusers] = (char *)malloc(strlen(utmp.ut_name)+2);
    strcpy(users[*nusers],utmp.ut_name);
    strcat(users[*nusers]," ");
    *nusers += 1;
  }
}

char *getnjobs()
{
  unsigned long mask;
  int i,j = 0;
  char tmp[4];

  mask = sigblock(sigmask(SIGCHLD));
  for(i=0;i<max_ent;i++) if (proc[i].pid) j++;
  sigsetmask(mask);
  sprintf(tmp,"%d",j);
  return tmp;
}

insert(str)
char *str;
{
  while(*str && a < amax && p < pmax) {
    buf[p++] = *str++;
    a++;
  }
}
