/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include "shell.h"
#include <fcntl.h>

#define MAX_FILES	10

extern char buf[1024],path[1024];

struct _FILES FILES[MAX_FILES];

/* sopen
 * sopen <desc>
 * sopen <desc> <file> <mode> [<mode> .. <mode>]
 *    modes:
 *	READ		reading
 *	WRITE		writing
 *	APPEND		appended to file
 *	TRUNCATE	truncate on open
 *	PIPE		Open a pipe descriptor for READ and WRITE.
 */
SOPEN(n,arg,fout,ferr)
int n;
char **arg;
FILE *fout, *ferr;
{
  static char *fmts[] = {"READ","WRITE","APPEND","TRUNCATE","PIPE",0};
  char i,j, p = -1;
  int fmt, pd[2];

  if (n == 1) {
    for(i=0;i<MAX_FILES;i++) {
      if (FILES[i].name)
        fprintf(fout,"%s [%s] is open for %s%s%s.\n",FILES[i].name,FILES[i].file,FILES[i].read?"reading":"",(FILES[i].read && FILES[i].write)?" and ":"",FILES[i].write?"writing":"");
    }
    return 0;
  }
  if (n == 2) {
    for(i=0;i<MAX_FILES;i++) {
      if (FILES[i].name && !strcmp(arg[1],FILES[i].name)) {
        fprintf(fout,"%s [%s] is open for %s%s%s.\n",FILES[i].name,FILES[i].file,FILES[i].read?"reading":"",FILES[i].read && FILES[i].write?" and ":"",FILES[i].write?"writing":"");
	return 0;
      }
    }
    return 0;
  }
  for(i=0;i<MAX_FILES;i++) {
    if (FILES[i].name && !strcmp(arg[1],FILES[i].name)) {
      fprintf(ferr,"sopen: descriptor %s already references file %s.\n",FILES[i].name,FILES[i].file);
      return 1;
    }
    if (p < 0 && !FILES[i].name) p = i;
  }
  if (p < 0) {
    fprintf(ferr,"sopen: file descriptor table full.\n");
    return 1;
  }
  FILES[p].pread = FILES[p].pwrite = 0;
  FILES[p].ispipe = FILES[p].pipe = FILES[p].read = FILES[p].write = 0;
  fmt = O_CREAT;
  if (n > 3) {
    for(i=3;i<n;i++) {
      for(j=0;fmts[j];j++)
	if (!strcmp(fmts[j],arg[i])) break;
      if (fmts[j]) {
	switch(j) {
	  case 0:
	    if (FILES[p].write) {
	      fmt &= ~O_WRONLY;
	      fmt |= O_RDWR;
	    } else fmt |= O_RDONLY;
	    FILES[p].read = 1;	
	    break;
	  case 1:
	    if (FILES[p].read) {
	      fmt &= ~O_RDONLY;
	      fmt |= O_RDWR;
	    } else fmt |= O_WRONLY;
	    FILES[p].write = 1;
	    break;
	  case 2:
	    fmt |= O_APPEND;
	    FILES[p].write = 1;
	    break;
	  case 3:
	    fmt |= O_TRUNC;
	    FILES[p].write = 1;
	    break;
	  case 4:
	    FILES[p].ispipe = 1;
	    break;
	}
      }
    }
  } else {
    fmt |= O_RDONLY;
    FILES[p].read = 1;
  }
  if (FILES[p].ispipe) {
    FILES[p].read = FILES[p].write = 1;
    if (pipe(pd) < 0) {
      fprintf(ferr,"sopen: error opening pipe %s.\n",arg[1]);
      return 1;
    }
    FILES[p].pipe = pd[0];
    FILES[p].desc = pd[1];
    fcntl(FILES[p].pipe,F_SETFD,1);
  } else if ((FILES[p].desc = open(arg[2],fmt,0777)) < 0) {
    fprintf(ferr,"sopen: error opening file %s for %s.\n",arg[3],FILES[p].read?"reading":"writing");
    return 1;
  }
  fcntl(FILES[p].desc,F_SETFD,1);
  FILES[p].name = SCOPY(arg[1]);
  FILES[p].file = SCOPY(arg[2]);
  return 0;
}

/*
 * sclose <desc> [<desc> ... <desc>]
 */
SCLOSE(n,arg,ferr)
int n;
char **arg;
FILE *ferr;
{
  int i,j;

  if (n < 2) {
    fprintf(ferr,"sclose: missing file descriptor specification.\n");
    return 1;
  }
  for(i=1;i<n;i++) {
    for(j=0;j<MAX_FILES;j++)
      if (!strcmp(FILES[j].name,arg[i])) break;
    if (j < MAX_FILES) {
      if (FILES[j].pipe) close(FILES[j].pipe);
      close(FILES[j].desc);
      free(FILES[j].name);
      FILES[j].name = NULL;
      free(FILES[j].file);
    } else {
      fprintf(ferr,"sclose: invalid file descriptor '%s'.\n",arg[i]);
    }
  }
  return 0;
}

/* sseek <desc> <mode> <expression>
 * mode:
 *   INCR
 *   SET
 *   XTND
 */

SSEEK(n,arg,ferr)
int n;
char **arg;
FILE *ferr;
{
  static char *modes[] = {"INCR","SET","XTND",0};
  char *ex;
  BYTE f;
  int i,mode;
  long pos,rpos;

  if (n < 4) {
    fprintf(ferr,"sseek: Not enough arguments.\n");
    return 1;
  }

  for(f=0;f<MAX_FILES;f++)
    if (!strcmp(arg[1],FILES[f].name)) break;

  if (f == MAX_FILES) {
    fprintf(ferr,"sseek: %s not a valid open file descriptor.\n",arg[1]);
    return 1;
  }
  if (FILES[f].ispipe) {
    fprintf(ferr,"sseek: seeks not allowed on pipes.\n");
    return 1;
  }
  for(i=0;modes[i];i++)
    if (!strcmp(modes[i],arg[2])) break;

  if (!modes[i]) {
    fprintf(ferr,"sseek: invalid seek operation '%s'.\n",arg[2]);
    return 1;
  }
  if (!i) mode = L_INCR;
  else if (i == 1) mode = L_SET;
  else mode = L_XTND;
  ex = (char *)grab(arg,3,NULL,&i);
  if (!ex) {
    fprintf(ferr,"sseek: expected expression.\n");
    return 1;
  }
  pos = expr(ex);
  free(ex);
  rpos = lseek(FILES[f].desc,pos,mode);
  makenvar("filepos",rpos);
  return 0;
}

/*
 * swrite <desc> [-n] <data>
 */

SWRITE(n,arg,ferr)
int n;
char **arg;
FILE *ferr;
{
  BYTE f,b,flg = FALSE;
  int i;
  char *res;

  if (n < 3) {
    fprintf(ferr,"swrite: Not enough arguments.\n");
    return 1;
  }
  for(f=0;f<MAX_FILES;f++)
    if (!strcmp(FILES[f].name,arg[1])) break;
  if (f == MAX_FILES) {
    fprintf(ferr,"swrite: unknown file descriptor '%s'.\n",arg[1]);
    return 1;
  }
  if (!FILES[f].write) {
    fprintf(ferr,"swrite: '%s' not open for writing.  Operation aborted.\n",FILES[f].name);
    return 1;
  }
  if (FILES[f].ispipe && FILES[f].read && FILES[f].write) {
    FILES[f].read = 0;
    close(FILES[f].pipe);
    FILES[f].pipe = 0;
  }
  for(b=TRUE,i=2;i<n;i++) {
    if (arg[i][0] == '-' && arg[i][1] == 'n' && !arg[i][2]) b = FALSE;
    else {
      res = (char *)pline(arg[i],1023,1023);
      if (flg) {
	if (write(FILES[f].desc," ",1) < 0) {
	  fprintf(stderr,"swrite: Error writing to file %s [%s].\n",FILES[f].name,FILES[f].file);
	  return 1;
	}
      }
      if (write(FILES[f].desc,res,strlen(res)) < 0) {
	fprintf(stderr,"swrite: Error writing to file %s [%s].\n",FILES[f].name,FILES[f].file);
	return 1;
      } else flg = TRUE;
    }
  }
  if (b) if (write(FILES[f].desc,"\n",1) < 0) {
    fprintf(stderr,"swrite: Error writing to file %s [%s].\n",FILES[f].name,FILES[f].file);
    return 1;
  }
  return 0;
}

/*
 * sread <desc> [-c] [-l] [-w] [-bn] <var>
 *  -l	Read in a line.
 *  -w	Read in a line, breaking it up into words.
 *  -c	Read in a character.
 *  -bn	Read in n characters.
 */
SREAD(n,arg,ferr)
int n;
char **arg;
FILE *ferr;
{
  BYTE f, mode = 0;
  WORD i, j, k, res;

  if (n < 3) {
    fprintf(ferr,"read: not enough arguments.\n");
    return 1;
  }
  for(f=0;f<MAX_FILES;f++)
    if (!strcmp(arg[1],FILES[f].name)) break;
  if (f == MAX_FILES) {
    fprintf(ferr,"sread: invalid file descriptor '%s'.\n",arg[1]);
    return 1;
  }
  if (!FILES[f].read) {
    fprintf(ferr,"sread: '%s' not open for reading.  Operation aborted.\n",FILES[f].name);
    return 1;
  }
  if (FILES[f].ispipe && FILES[f].write && FILES[f].read) {
    FILES[f].write = 0;
    close(FILES[f].desc);
    FILES[f].desc = FILES[f].pipe;
    FILES[f].pipe = 0;
  }

  for(i=2;i<n;i++) {
    if (arg[i][0] == '-') {
      switch(arg[i][1]) {
	case 'l':
	  mode = 0;
	  break;
	case 'w':
	  mode = 1;
	  break;
	case 'c':
	  mode = 2;
	  break;
	case 'b':
	  mode = 3;
	  k = atoi(arg[i]+2);
	  break;
	default:
	  fprintf(stderr,"sread: '%s' invalid option.\n",arg[i]);
	  return 1;
      }
      continue;
    }
    switch(mode) {
      case 0:
      case 1:
	for(j=0;;j++) {
	  if ((res = read(FILES[f].desc,buf+j,1)) < 0) {
	    fprintf(ferr,"sread: error reading from %s [%s].\n",FILES[f].name,FILES[f].file);
	    return 1;
	  }
	  if (!res) {
	    buf[j] = 0;
	    makeset(arg[i],buf);
	    makeset("EOF",FILES[f].name);
	    return 0;
	  }
	  if (buf[j] == '\n') break;
	}
	buf[j] = 0;
	if (mode) makewset(arg[i],buf);
	else makeset(arg[i],buf);
	break;
      case 2:
	if ((res = read(FILES[f].desc,buf,1)) < 0) {
	  fprintf(ferr,"sread: error reading from %s [%s].\n",FILES[f].name,FILES[f].file);
	  return 1;
	}
	if (!res) {
	  makeset("EOF",FILES[f].name);
	  return 0;
	}
	buf[1] = 0;
	makeset(arg[i],buf);
	break;
      case 3:
	if (read(FILES[f].desc,buf,k) < 0) {
	  fprintf(ferr,"sread: error reading from %s [%s].\n",FILES[f].name,FILES[f].file);
	  return 1;
	}
	if (!res) {
	  makeset("EOF",FILES[f].name);
	  return 0;
	}
	buf[k] = 0;
	makeset(arg[i],buf);
	break;
    }
  }
  return 0;
}
