/*
 * Command Input Shell
 * Dave Clemans
 * 12/88-1/89
 *
 * "spiritually" based on Bourne, Korn shells
 *
 * $Id: shell.h,v 1.10 89/03/05 15:38:52 dclemans Exp $
 *
 * $Log:	shell.h,v $
 * Revision 1.10  89/03/05  15:38:52  dclemans
 * more fixes
 * 
 * Revision 1.9  89/02/22  21:32:02  dclemans
 * Implement simple background job monitoring facility
 * 
 * Revision 1.8  89/02/22  13:19:00  dclemans
 * Implement $!
 * 
 * Revision 1.7  89/02/22  08:17:15  dclemans
 * implement left-justified, right-justified, etc. parameter attributes
 * 
 * Revision 1.6  89/02/21  19:40:11  dclemans
 * Implement RANDOM and SECONDS variables
 * 
 * Revision 1.5  89/02/20  20:07:16  dclemans
 * Add RCS identifiers
 * 
 */
#ifdef  USG
#include <string.h>
#else
#include <strings.h>
#endif  /* USG */
#include <ctype.h>
#ifdef  GEMDOS
#include <osbind.h>
#ifdef  MWC
#define DEFSTACK    6144L
#endif  /* MWC */
#endif  /* GEMDOS */

#define LOC(r)  __FILE__,r,__LINE__

#include <errno.h>

#ifndef GEMDOS
#ifndef USG
#define strchr  index
#define strrchr rindex
#define memcpy(t,f,n) bcopy(f,t,n)
#endif  /* USG */
#else
#define	bcopy(f,t,n) memcpy(t,f,n)
#endif  /* GEMDOS */

#ifdef  GEMDOS
#define NO_FILE(rc) (rc == AEFILNF || rc == AEPTHNF || rc == AENHNDL || rc == AENSMEM || rc == AEDRIVE || rc == AENMFIL)
#define NOT_EXEC(rc)    (rc == AEPLFMT)
#else
/* fix these */
#define NO_FILE(rc) (rc == ENOENT)
#define NOT_EXEC(rc)    (rc == ENOEXEC)
#endif  /* GEMDOS */

#define SYM_MARKER          -3
#define SYM_EOF             -2
#define SYM_EOL             -1
#define SYM_WORD            0
#define SYM_SEMI            1
#define SYM_BACK            2
#define SYM_LT              3
#define SYM_LLT             4
#define SYM_RT              5
#define SYM_RRT             6
#define SYM_LBT             7
#define SYM_RBT             8
#define SYM_LBRACE          9
#define SYM_RBRACE          10
#define SYM_PIPE            11
#define SYM_ORIF            12
#define SYM_ANDIF           13
#define SYM_KEYWORD         14
#define SYM_NUMBER          15
#define SYM_LPAREN          16
#define SYM_RPAREN          17
#define SYM_PIPER           18      /* pseudo-marker used in pipe tagging */
#define SYM_BQUOTE          19
#define SYM_DLPAREN         20
#define SYM_DRPAREN         21
#define SYM_LLTL            22
#define SYM_DLBRACK         23
#define SYM_DRBRACK         24
#define SYM_DSEMI           25

#define DEFAULT_HISTORY 16
#define PROMPT_MAX      3
#ifdef  GEMDOS
#define ESCAPE_CHAR     '@'
#define DIR_SEPARATOR   '\\'
#define MAXUFD          5
#else
#define ESCAPE_CHAR     '\\'
#define DIR_SEPARATOR   '/'
#define MAXUFD          ((_NFILE > 20) ? 20 : _NFILE)
#endif  /* GEMDOS */

#define SHERR_NOMEM     -1
#define SHERR_PERROR    -2

#define TYPE_EXPORTED   0x01
#define TYPE_READONLY   0x02
#define TYPE_INTEGER    0x04
#define TYPE_UPPERCASE	0x10
#define TYPE_LOWERCASE	0x20
#define TYPE_TAGGED     0x40
#define TYPE_FUNCTION   0x80
#define TYPE_LEFTJUST   0x100
#define TYPE_RIGHTJUST  0x200
#define TYPE_ZEROS      0x400
#define TYPE_HOSTMAP    0x800
#define TYPE_DELETED    0x8000

#define TYPE_TRACKED    0x4000

/*
 * Shell lexing structures
 */
struct token
{
    int     type;
    struct  token *next;
    char    name[1];        /* over-indexed, must be at end */
};
struct  iotoken
{
    int     fd;
    int     type;
    char    *tempfile;
    struct  iotoken *next;
    char    file[1];        /* over-indexed; must be at end */
};
struct phrase
{
    struct  token *type;
    struct  token *body;
    struct  token *body_end;
    struct  token *var;
    struct  token *var_end;
    struct  iotoken *io;
    struct  iotoken *io_end;
    struct  phrase *group;
    struct  phrase *group_end;
    struct  phrase *next;
};
struct  infile
{
    char    *name;
    int     fp;
    int     delete;
    int     nonl;
    int     markeof;
    char    *start;
    char    *end;
    char    buffer[256];
    struct  infile *next;
};
struct strsave
{
    char    *string;
    char    *ptr;
    struct  strsave *next;
};
#ifndef GEMDOS
struct procs
{
    int pid;
    struct procs *next;
};
struct bg_job
{
    struct phrase *job;
    struct procs *cmds;
    struct bg_job *next;
};
#endif  /* GEMDOS */

/*
 * Shell environment structures
 */
struct  commands
{
    char    *name;
    int     (*cmd)();
};
struct variable
{
    char    *name;
    char    *value;
    int     cmd;
    int     type;
    int     misc;
    struct  variable *left,*right;
};
struct  aliases
{
    char    *name;
    struct  token *tp;
    int     type;
    struct  aliases *left,*right;
};
struct  function
{
    char    *name;
    struct  phrase *code;
    struct  function *left,*right;
};
struct  iostack
{
    int input;
    int output;
    int errout;
    struct  iostack *next;
};
struct  dirstack
{
    char    *current;
    struct  dirstack *next;
};
struct  varstack
{
    struct  variable *table;
    struct  varstack *next;
};
struct  herestack
{
    struct  iotoken *doc;
    struct  herestack *next;
};
struct  hist_phrase
{   int     number;
    struct  phrase *cmd;
};
struct  envinfo
{
    long    start_at;
    int     prompts_issued[PROMPT_MAX+1];
    char    *prompts[PROMPT_MAX+1];
    char    *homedir;
    char    *envfile;
    char    *shellname;
    int     columns,lines;
    char    *separators;
    char    *cd_path;
    char    *exec_path;
    int     break_level;
    int     continue_level;
    int     temp_count;
    int     history_size;
    struct  hist_phrase *history_list;
#ifdef  GEMDOS
    int     fd_con,fd_aux,fd_prn;
    char    *tmpdir;
    char    *exec_suff;
#endif  /* GEMDOS */
    struct  varstack *var;
    struct  aliases *alias_table;
    struct  function *func_table;
    struct  dirstack *dir;
#ifndef GEMDOS
    struct  bg_job *jobs;
#endif  /* GEMDOS */
    int     fd_input;
    int     background_pid;
    struct  iostack *io;
    struct  herestack *pending_heredocs;
};

extern  char    shell_version[];
extern  struct  envinfo base_env;

extern  char    *var_arg0;
extern  int     var_argc;
extern  char    **var_argv;
extern  char    *var_init[];
extern  void    var_dump();
extern  void    var_settype();
extern  void    var_resetargs();
extern  void    var_shiftargs();
extern  void    var_define0();
extern  char    *var_makeenv();
extern  char    *var_normal();
extern  char    *var_reference();

extern  void    alias_dump();
extern  int     alias_print();
extern  void    alias_define();
extern  int     alias_tracked();
extern  struct  aliases *alias_get();

extern  void    io_writestring();
extern  struct  infile *buffile;
extern  struct  strsave *strings;

extern  int     lchdir();
extern  char    *strcopy();
extern  void    stripquotes();
extern  int     errmsg();
extern  char    *new_string();
extern  char    **new_argv();
extern  struct  phrase *copy_phrase();
extern  struct  phrase *copy_group();
extern  struct  phrase *new_phrase();
extern  struct  token *new_token();
extern  struct  iotoken *new_iotoken();
extern  struct  variable *new_variable();
extern  struct  aliases *new_alias();
extern  struct  function *new_function();
extern  struct  infile *new_infile();
extern  struct  strsave *new_strsave();

extern  struct  phrase *lex_sentence();
extern	struct	phrase *lex_phrase();
extern  struct  token *lex_token();
extern  struct  token *lex_reparse_tokens();

extern  struct  function *func_get();
extern  char    *exec_pathsearch();
extern  int     exec_phrase();
extern	void	phrase_dump();
extern  void    sentence_dump();
extern	void	phrase_free();
extern  void    sentence_free();
extern  void    tokens_free();

extern  int     flag_echoinput;
extern  int     flag_echoexec;
extern  int     flag_keywords;
extern  int     flag_cmdhash;
extern  int     flag_varerr;
extern  int     flag_noglob;
extern  int     flag_allexport;
extern  int     flag_noexec;
extern  int     flag_interactive;
extern  int     flag_monitor;

extern  int     cmd_lastrc;
extern  int     cmd_forceexit;
extern  int     cmd_returnexit;
extern  int     cmd_count;
extern  struct  commands cmd_builtin[];

extern  struct  token *wild_search();

#ifndef GEMDOS
extern  int     main_fdget();
extern  int     main_fdput();
#endif  /* GEMDOS */
extern  int     main_iopush();
extern  int     main_iopop();
extern  int     main_dirpush();
extern  int     main_dirpop();
