/*
 * Command Input Shell
 * Dave Clemans
 * 12/88-1/89
 *
 * "spiritually" based on Bourne, Korn shells
 *
 * Command Aliasing
 *
 * $Id: alias.c,v 1.4 89/02/20 20:15:24 dclemans Exp $
 *
 * $Log:	alias.c,v $
 * Revision 1.4  89/02/20  20:15:24  dclemans
 * Add RCS identifiers
 * 
 */
#include <stdio.h>
#include "shell.h"

static char *def_aliases[] =
{
    "autoload",         "typeset -fu",
    "echo",             "print -",
    "false",            "let 0",   
    "functions",        "typeset -f",
    "hash",             "alias -t",
    "history",          "fc -l",
    "integer",          "typeset -i",
    "r",                "fc -e -",
    "source",           ".",
    "true",             ":",
    "type",             "whence -v",
    (char *)NULL,       (char *)NULL
};

static void dump_alias(svp)
struct aliases *svp;
{
    register struct token *tp;

    io_writestring(0,svp->name);
    io_writestring(0,"=");
    for (tp = svp->tp; tp != (struct token *)NULL; tp = tp->next)
    {   /* dump each token */
        io_writestring(0,tp->name);
        if (tp->next != (struct token *)NULL)
            io_writestring(0," ");
    }
    io_writestring(0,"\n");
}   /* end of dump_alias */

struct aliases *alias_get(name)
register char *name;
{
    register struct aliases *svp;
    register int rc;

    for (svp = base_env.alias_table; svp != (struct aliases *)NULL; )
    {   /* look for where to put the variable */
        rc = strcmp(name,svp->name);
        if (rc == 0)
        {   /* found it */
            return svp;
        }
        else if (rc < 0)
        {   /* go down the left side? */
            if (svp->left == (struct aliases *)NULL)
                break;
            svp = svp->left;
        }
        else
        {   /* go down right side */
            if (svp->right == (struct aliases *)NULL)
                break;
            svp = svp->right;
        }
    }
    return (struct aliases *)NULL;
}   /* end of alias_get */

void alias_define(name,value,type)
char *name;
struct token *value;
int type;
{
    register struct aliases *vp,*svp;
    register struct token *tp;
    struct token *otp,*last;
    int rc;

    vp = new_alias();
    if (vp == (struct aliases *)NULL)
    {   /* enough memory */
        errmsg(SHERR_NOMEM,LOC("alias_define"));
        return;
    }
    last = (struct token *)NULL;
    for (tp = value; tp != (struct token *)NULL; tp = tp->next)
    {   /* for each value token */
        otp = new_token(strlen(tp->name));
        if (otp == (struct token *)NULL)
        {   /* enough memory? */
            errmsg(SHERR_NOMEM,LOC("alias_define"));
            tokens_free(vp->tp);
            free(vp);
            return;
        }
        otp->type = tp->type;
        strcpy(otp->name,tp->name);
        if (vp->tp == (struct token *)NULL)
            vp->tp = last = otp;
        else
        {   /* tack onto end */
            last->next = otp;
            last = otp;
        }
    }

    rc = 0;
    for (svp = base_env.alias_table; svp != (struct aliases *)NULL; )
    {   /* look for where to put the variable */
        rc = strcmp(name,svp->name);
        if (rc == 0)
        {   /* replace existing value */
            tokens_free(svp->tp);
            svp->tp = vp->tp;
            svp->type = type;
            free(vp);
            return;
        }
        else if (rc < 0)
        {   /* go down the left side? */
            if (svp->left == (struct aliases *)NULL)
                break;
            svp = svp->left;
        }
        else
        {   /* go down right side */
            if (svp->right == (struct aliases *)NULL)
                break;
            svp = svp->right;
        }
    }

    vp->name = strcopy(name);
    vp->type = type;
    if (base_env.alias_table == (struct aliases *)NULL)
        base_env.alias_table = vp;
    else if (rc < 0)
        svp->left = vp;
    else
        svp->right = vp;
}   /* end of alias_define */

void alias_sdefine(name,value,type)
char *name;
char *value;
int type;
{
    register struct token *tp,*ftp,*ltp;
    struct strsave *savep;

    savep = strings;
    io_pushtoken(value,1);
    ftp = ltp = (struct token *)NULL;
    while (!lex_sempty(savep))
    {   /* lex the alias value into tokens */
        tp = lex_token(1);
        if (tp == (struct token *)NULL)
            break;
        if (ftp == (struct token *)NULL)
            ftp = ltp = tp;
        else
        {   /* tack onto end */
            ltp->next = tp;
            ltp = tp;
        }
    }
    alias_define(name,ftp,type);
    tokens_free(ftp);
}   /* end of alias_sdefine */

int alias_tracked(name)
char *name;
{
    register struct aliases *svp;

    svp = alias_get(name);
    if (svp != (struct aliases *)NULL)
    {   /* if the alias was found */
        return svp->type & TYPE_TRACKED;
    }
    return 0;
}   /* end of alias_tracked */

int alias_print(name)
char *name;
{
    register struct aliases *svp;

    svp = alias_get(name);
    if (svp != (struct aliases *)NULL)
    {   /* if variable was found */
        if (svp->tp != (struct token *)NULL)
            dump_alias(svp);
        return 0;
    }
    return 1;
}   /* end of alias_print */

void alias_dump(vp,type)
register struct aliases *vp;
int type;
{
    if (vp == (struct aliases *)NULL)
        return;
    if (vp->left != (struct aliases *)NULL)
        alias_dump(vp->left,type);
    if (vp->tp != (struct token *)NULL &&
        ((type == 0) || (vp->type & type)))
    {   /* if the alias is really defined and type matches */
        dump_alias(vp);
    }
    if (vp->right != (struct aliases *)NULL)
        alias_dump(vp->right,type);
}   /* end of alias_dump */

void alias_init()
{
    register int i;

    for (i = 0; def_aliases[i] != (char *)NULL; i += 2)
    {   /* for each default alias */
        alias_sdefine(def_aliases[i],def_aliases[i+1],0);
    }
}   /* end of alias_init */
