/*
 * killring		- implement a simple kill ring for reader
 *
 * Dave Clemans, 4/84 (initial version); 1/89 (more generality)
 *
 * Entry points:
 *	_pushOnKillRing		push string on kill ring
 *	_popOffKillRing		pull string off onto pendingInput buffer
 *
 * $Id: killring.c,v 1.2 89/02/20 20:20:16 dclemans Exp $
 *
 * $Log:	killring.c,v $
 * Revision 1.2  89/02/20  20:20:16  dclemans
 * Add RCS identifiers
 * 
 */
#ifndef GEMDOS
#include <sgtty.h>
#endif  GEMDOS
#ifndef LOC
#define LOC(r)  __FILE__,r,__LINE__
#endif  LOC

#include "history.h"

/*
 * The kill ring
 */
#define	MAX_RING	4
struct	killRingElement
{
	char *contents;
	short int size;
};
static struct killRingElement killRing[MAX_RING];
static int nextKillRing;

/*
 * Push a string onto the kill ring
 *
 * The string body comes from the global History.currentLine
 */
_pushOnKillRing(first,last)
int first;
int last;
{
	register int temp;
	register char *in,*out;

	if (killRing[nextKillRing].contents)
	{	/* re-using an old element */
		free(killRing[nextKillRing].contents);
		killRing[nextKillRing].contents = (char *)NULL;
	}
	if (first > last)
	{	/* given in wrong order; swap around to be nice */
		temp = last;
		last = first;
		first = temp;
	}
	killRing[nextKillRing].size = last - first + 1;
	killRing[nextKillRing].contents =
		(char *)malloc(killRing[nextKillRing].size+1);
	if (!killRing[nextKillRing].contents)
	{	/* out of core */
		errmsg(-1,LOC("pushOnKillRing"));
		exit(-1);
	}
	temp = killRing[nextKillRing].size;
	in = &History.currentLine->contents[first];
	out = killRing[nextKillRing].contents;
	while (temp--)
		*out++ = *in++;
	nextKillRing++;
	if (nextKillRing >= MAX_RING)
		nextKillRing = 0;
};	/* end of _pushOnKillRing */

/*
 * Pop the top string off the kill ring into the pending input buffer
 */
_popOffKillRing()
{
	register int counter,size;
	register char *p;

	nextKillRing--;
	if (nextKillRing < 0)
		nextKillRing = MAX_RING - 1;
	p = killRing[nextKillRing].contents;
	if (!p)
	{	/* nothing there */
		_writechar('\007');
		return;
	}
	size = killRing[nextKillRing].size;
	for (counter = 0; counter < size; counter++)
		_savechar(*p++);
	free(killRing[nextKillRing].contents);
	killRing[nextKillRing].contents = (char *)NULL;
};	/* end of popOffKillRing */
