/*
 * $Id: tester.c,v 1.6 89/03/07 19:37:46 dclemans Exp $
 *
 * $Log:	tester.c,v $
 * Revision 1.6  89/03/07  19:37:46  dclemans
 * make work on bsd systems
 * 
 * Revision 1.5  89/02/20  20:20:28  dclemans
 * Add RCS identifiers
 * 
 */
#ifndef GEMDOS
#include <sgtty.h>
#endif  GEMDOS

#include "history.h"

main()
{
	char buffer[1024];
	int rc;
	int count;
	struct historyLine *hp;

	for (count = 1; ; count++)
	{
		printf("%d-> ",count);
		fflush(stdout);
		rc = Reader(fileno(stdin),buffer,sizeof buffer - 1);
		if (rc <= 0)
		{	/* check for error or eof */
            printf("\r\n");
			break;
		}
		printf("\r\nline %d: %s\n",count,buffer);
		printf("History list:\r\n");
		for (hp = History.listTop; hp; hp = hp->next)
			if (hp->command)
				printf("\t%d:\t%s\n",hp->command,hp->contents);
	}
};

#ifdef  GEMDOS
#define	ESCAPE_CHAR	'@'
#else
#define ESCAPE_CHAR '\\'
#endif  /* GEMDOS */
#define	SHERR_NOMEM	-1
#ifndef LOC
#define LOC(r)  __FILE__,r,__LINE__
#endif  LOC

long io_savestring()
{
	return 0L;
}

long phrase_free()
{
	return 0L;
}

long lex_token()
{
	return 0L;
}

char *var_arg0 = "tester";

struct token
{
    int type;
    struct token *next;
    char name[4];
};

struct token *new_token(len)
int len;
{
    register struct token *tp;

    tp = (struct token *)malloc(sizeof(*tp)+len);
    if (tp == (struct token *)NULL)
        return (struct token *)NULL;
    tp->next = (struct token *)NULL;
    tp->type = -1;
    tp->name[0] = '\0';

    return tp;
}   /* end of new_token */

int errmsg(code,file,routine,line,fmt,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)
int code;
char *file;
char *routine;
int line;
char *fmt;
{
    extern int errno;
    char buffer[BUFSIZ];
    char *p;
    int fd;

    fd = 1;
    sprintf(buffer,"%s: %s(%s,%d): ",var_arg0,file,routine,line);
    for (p = buffer; *p; p++)
        /* do nothing */;
    switch (code)
    {   /* check for common err messages; else do normal one */
        case -1:
            strcpy(p,"out of memory");
            break;
        default:
            sprintf(p,fmt,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
            break;
    }
    while (*p)
        p++;
#ifdef  GEMDOS
    *p++ = '\r';
#endif  GEMDOS
    *p++ = '\n';
    *p = '\0';
    write(fd,buffer,(unsigned)strlen(buffer));
    return 0;
}   /* end of errmsg */

char *strcopy(s)
char *s;
{
    char *ns;

    ns = (char *)malloc(strlen(s)+1);
    if (ns == (char *)NULL)
    {   /* enough memory? */
        errmsg(SHERR_NOMEM,LOC("strcopy"));
        return ns;
    }
    strcpy(ns,s);
    return ns;
}   /* end of strcopy */

char *new_string(len)
int len;
{
    register char *cp;

    cp = (char *)malloc(len);
    if (cp == (char *)NULL)
        return (char *)NULL;
    *cp = '\0';

    return cp;
}   /* end of new_string */

void stripquotes(s)
char *s;
{
    char *p;

    for (p = s; *p != '\0'; p++)
    {   /* check for special chars */
        switch (*p)
        {   /* a special char? */
            case '\'':
            strcpy(p,p+1);
            while (*p && *p != '\'')
                p++;
            if (*p == '\'')
                strcpy(p,p+1);
            break;
            case '"':
            strcpy(p,p+1);
            while (*p && *p != '"')
            {   /* scan the string */
                if (*p == ESCAPE_CHAR)
                    strcpy(p,p+1);
                p++;
            }
            if (*p == '"')
                strcpy(p,p+1);
            break;
            case ESCAPE_CHAR:
            strcpy(p,p+1);
            break;
            default:
            break;
        }
    }
}   /* end of stripquotes */

char *var_normal(name)
char *name;
{
	char *p;
	extern char *getenv();

	p = getenv(&name[1]);
	if (p == (char *)NULL)
		return p;
	return strcopy(p);
}

struct
{
	long x;
} base_env;
