/*
 * eb_main.h
 *
 * This is the header file for EasyBase.
 *
 * Written by Mark Overmars
 *
 * Version 1.0
 * Last Changed: Sep 25, 1992
 */

#include "forms.h"
#include "eb_forms.h"

/***********************
    Global stuff
 ***********************/

#define MAXFIELDLENGHT	1024
	/* Maximal lenght of a field */
#define MAXFIELDNUMB	20
	/* Maximal number of fields in a record */
#define MAXSTRINGLENGHT	(MAXFIELDNUMB*MAXFIELDLENGHT)
	/* Maximal lenght a record string can have */
#define MAXRECORD	32000
	/* Maximal number of records */

#define FIELDSEP	':'
	/* Separating character between fields */
#define ESCAPE		'!'
	/* Escape character to put separators in the text */

typedef struct {
  int level;			/* selection level */
  char *data;			/* The contents */
  int dsize;			/* current size of the data field */
} RECORD;

extern RECORD database[];	/* The database */
extern int recordnumb;		/* Number of records in the database */
extern int fieldnumb;		/* Number of fields in a record */
extern int selectlevel;		/* Level of selection */
extern int changed;		/* Whether database has been changed by user */
extern int currentrecord;	/* Index of the current record */
extern int deletioncount;	/* Level counter for deleted records (<0) */

extern char currentfile[];	/* Name of the current file */

/***********************
    in eb_convert.c
 ***********************/

/*********
 *  int string_to_fields(char str[], char fields[][MAXFIELDLENGHT])
 *	Convert a string into a set of fields. Fields should be
 *	separated by FIELDSEP which can be escaped by placing an
 *	ESCAPE in front of it. Twice ESCAPE means the escape itself.
 *	The routine returns the number of fields.
 *		str		= the string to convert
 *		fields		= the fields in which to put the result
 *********/

int string_to_fields(char str[], char fields[][MAXFIELDLENGHT]);

/*********
 *  void string_to_field(char str[], char field[], int fnumb)
 *	Gets field fnumb out of the string str.
 *		str		= the string to convert
 *		field		= the field in which to put the result
 *		fnumb		= the number of field required
 *********/

void string_to_field(char str[], char field[], int fnumb);

/*********
 *  void fields_to_string(char fields[][], char str[], int fnumb)
 *	Convert a set of fields int a string.
 *		fields		= the fields to convert
 *		str		= the string to put the result in
 *		fnumb		= number of fields
 *********/

int fields_to_string(char fields[][MAXFIELDLENGHT], char str[], int fnumb);


/********************
  in eb_data.c
 ********************/


/*******************************************
 *********  UPDATING THE DATABASE  *********
 *******************************************/


/*********
 *  void change_record(int ind, char str[])
 *	Changed the contents of a particular record in the database.
 *		ind		= index of the record
 *		str		= new contents
 *********/

void change_record(int, char []);


/*********
 *  void append_record()
 *	Appends an empty record after the current record.
 *********/

void append_record();


/*********
 *  void insert_record()
 *	Inserts an empty record before the current record.
 *********/

void insert_record();
  

/*********
 *  void delete_record()
 *	Deletes the current record.
 *********/

void delete_record();


/*********
 *  void undelete_record()
 *	Undoes the last deletion.
 *********/

void undelete_record();


/*******************************************
 *********      MOVING AROUND      *********
 *******************************************/


/*********
 *  int find_first()
 *	Goes to the first record in the current level. Returns whether 
 *	successful.
 *********/

int find_first();


/*********
 *  int find_next()
 *	Goes to the next record in the current level. Returns whether 
 *	successful.
 *********/

int find_next();


/*********
 *  int find_previous()
 *	Goes to the previous record in the current level. Returns whether 
 *	successful.
 *********/

int find_previous();


/*********
 *  int find_last()
 *	Goes to the last record in the current level. Returns whether 
 *	successful.
 *********/

int find_last();


/*********
 *  int find_number(int numb)
 *	Goes to record numb in the current level. Returns whether 
 *	successful.
 *********/

int find_number(int );


/*******************************************
 *********        INFORMATION      *********
 *******************************************/


/*********
 *  void get_database_info(int *total, int *selected, int *current)
 *	returns some information about the current state of the database.
 *		*total		= total number of (undeleted) records
 *		*selected	= number of selected records
 *		*current	= number of the current record in selection
 *********/

void get_database_info(int *, int *, int *);


/*********
 *  void get_field_name(int field, char *fieldname)
 *	Returns the name of a field.
 *		field		= the field number (>=1)
 *		fieldname	= string in which name is returned
 *********/

void get_field_name(int , char *);


/***********************
    in eb_file.c
 ***********************/


/*********
 *  void init_database()
 *	Initializes the database. Should be called before anything else.
 *********/

void init_database();


/*********
 *  int load_database(char fname[])
 *	Loads a database file into the database. Returns whether successful.
 *		fname		= name of the file
 *********/

int load_database(char []);

/*********
 *  int merge_database(char fname[])
 *	Merges a database file with the database. Returns whether successful.
 *		fname		= name of the file
 *********/

int merge_database(char []);

/*********
 *  int save_database(char fname[])
 *	Saves the whole database in a file. Returns whether successful.
 *		fname		= name of the file
 *********/

int save_database(char []);


/*********
 *  int save_selection(char fname[])
 *	Saves the current selection in the database to a file. Returns
 *	whether successful.
 *		fname		= name of the file
 *********/

int save_selection(char []);


/*********
 *  void print_selection(char fname[], int format)
 *	Prints the current selection according to format into a file. The
 *	following formats are supported: 1 = LaTeX, 2 = a list, 3 = records.
 *		fname		= file to write output to
 *		format		= printing format
 *********/

void print_selection(char [], int );


/***********************
    in eb_design.c
 ***********************/

/*********
 *  void change_database_layout()
 *	Changes the layout of the database. Can also be called to create
 *	a new database layout.
 *********/
 
void change_database_layout();


/***********************
    in eb_select.c
 ***********************/

/*******************************************
 *********        SELECTING        *********
 *******************************************/


/*********
 *  void level_up()
 *	Go up one level in the selection hierarchy.
 *********/

void level_up();


/*********
 *  void level_zero()
 *	Go up to level 0 in the selection hierarchy.
 *********/

void level_zero();


/*********
 * void make_selection(int extend, int field, int oper, int inverse, char pat[])
 *	Makes a selection in the database, either extending or restricting
 *	the current selection.
 *		extend		= whether to extend the selection
 *		field		= the field on which to select (>=1)
 *		oper		= the operation (see below)
 *		inverse		= whether to inverse the operation
 *		pat		= the selection pattern with which to compare
 *********/

void make_selection(int , int , int , int , char []);


/*******************************************
 *********         SORTING         *********
 *******************************************/

/*********
 * void sort_database(int field, int increasing, int style)
 *	Sort the complete database using a (stable) merge sort.
 *		field		= field on which to sort (>=1)
 *		increasing	= whether increasing
 *		style		= 0 (normal) 1 (case insensitive) 2 (numeric)
 *********/


void sort_database(int , int , int );


/***********************
    in eb_display.c
 ***********************/

#define RECORD_VIEW     0
#define LIST_VIEW       1

extern int viewmode;		/* The current view. */


/*********
 *  void fillin_form()
 *	Fill all the information of the current record into the form.
 *********/

void fillin_form();


/*********
 *  void readout_form()
 *	Read back the information in the form into the current record.
 *********/

void readout_form();


/*********
 *  void init_view()
 *	Initializes the view for the current database.
 *********/

void init_view();


/*********
 *  void set_viewmode(int mode)
 *	Changes the viewmode.
 *		mode	= the new viewmode (RECORD_VIEW or LIST_VIEW)
 *********/

void set_viewmode(int );
