/*
 * eb_main.c
 *
 * This is the main program file of EasyBase, A very simple
 * database, using the Forms Library.
 *
 * Written by Mark Overmars
 *
 * Version 1.0
 * Last Changed: Sep 25, 1992
 */

#include "forms.h"
#include "eb_main.h"

main(int argc, char **arg)
{
  fl_init();
/*
  fl_set_graphics_mode(0,0);
*/
  create_the_forms();

  fl_addto_choice(sinverseobj,"must");
  fl_addto_choice(sinverseobj,"must not");
  fl_set_choice(sinverseobj,1);
 
  fl_addto_choice(soperobj,"contain");
  fl_addto_choice(soperobj,"be equal to");
  fl_addto_choice(soperobj,"be smaller than");
  fl_addto_choice(soperobj,"be smaller/equal to");
  fl_addto_choice(soperobj,"be numeric equal to");
  fl_addto_choice(soperobj,"be numeric smaller than");
  fl_addto_choice(soperobj,"be numeric smaller/equal to");
  fl_set_choice(soperobj,1);

  fl_addto_choice(odecrobj,"increasing");
  fl_addto_choice(odecrobj,"decreasing");
  fl_set_choice(odecrobj,1);

  fl_addto_choice(ocaseobj,"case sensitive");
  fl_addto_choice(ocaseobj,"case insensitive");
  fl_addto_choice(ocaseobj,"numeric");
  fl_set_choice(ocaseobj,1);

  fl_set_button_shortcut(addbut,"^N");
  fl_set_button_shortcut(insertbut,"^I");
  fl_set_button_shortcut(deletebut,"^X");
  fl_set_button_shortcut(undeletebut,"^U");
  fl_set_button_shortcut(clearbut,"^E");
  fl_set_button_shortcut(restorebut,"^R");
  fl_set_button_shortcut(orderbut,"^O");
  fl_set_button_shortcut(viewbut,"^V");
  fl_set_button_shortcut(prevbut,"^C");
  fl_set_button_shortcut(nextbut,"^D");
  fl_set_button_shortcut(saveobj,"^S");

  init_database();
  init_view();

  if (argc > 1)
  {
    strcpy(currentfile, arg[1]);
    load_database(currentfile);
    fl_set_object_label(fileobj,currentfile);
    init_view();
    fillin_form();
  }
  else
  {
    load_cb(NULL,0);
  }
  if (fieldnumb == 0) 
  {
      fl_show_message("Cannot handle records without fields", "", "");
      exit(0);
  }
  fl_show_form(mainform,FL_PLACE_CENTER,FALSE,"EasyBase");
  fl_set_form_position(selectform, mainform->x, mainform->y-selectform->h);
  fl_show_form(selectform, FL_PLACE_POSITION, FALSE, "Selection");
  while (1) fl_do_forms();
}
