/*
 * eb_display.c
 *
 * This file is part of EasyBase.
 * It contains the routines that handle the display of the 
 * information on the screen.
 *
 * Written by Mark Overmars
 *
 * Version 1.0
 * Last Changed: Sep 18, 1992
 */

#include <string.h>

#include "forms.h"
#include "eb_main.h"

/****************************** INTERNAL VARIABLES **********************/


/****************************** EXTERNAL VARIABLES **********************/

int viewmode = RECORD_VIEW;		/* The current view. */

/****************************** EXTERNAL ROUTINES **********************/

/*********
 *  void fillin_form()
 *	Fill all the information of the current record into the form.
 *********/

void fillin_form()
{
  char ff[MAXFIELDNUMB][MAXFIELDLENGHT];
  int i, total, selected, current;
  char str[64];

  get_database_info(&total,&selected,&current);
  /* Fill in the data */
  switch (viewmode) {
    case RECORD_VIEW:
      string_to_fields(database[currentrecord].data,ff);
      fl_freeze_object(maingroup);
      for (i=0; i<MAXFIELDNUMB; i++)
        fl_set_input(inpobj[i],ff[i]);
      fl_set_object_focus(mainform,inpobj[0]);
      fl_unfreeze_object(maingroup);
      break;
    case LIST_VIEW:
      fl_freeze_object(maingroup);
      while (current > selected-MAXFIELDNUMB+1 && find_previous()) current--;
      for (i=0; i<MAXFIELDNUMB; i++)
      {
	fl_set_input(inpobj[i],"");
        fl_set_object_label(fobj[i],"");
      }
      for (i=0; i<MAXFIELDNUMB; i++)
      {
        fl_set_input(inpobj[i],database[currentrecord].data);
	sprintf(str,"%d",current+i);
        fl_set_object_label(fobj[i],str);
	if (!find_next()) i = MAXFIELDNUMB;
      }
      find_number(current);
      fl_unfreeze_object(maingroup);
      break;
  }
  /* Fill in the information */
  sprintf(str,"Level %2d:  %3d selected from %3d total.",
				selectlevel,selected,total);
  fl_set_object_label(textobj,str);
  /* Fill in the slider */
  fl_freeze_object(slidobj);
  sprintf(str,"%d",current);
  fl_set_object_label(slidobj,str);
  if (viewmode == LIST_VIEW) selected -= MAXFIELDNUMB-1;
  if (selected <= 0) selected = 1;
  fl_set_slider_bounds(slidobj,0.0,(float)selected-1.0);
  fl_set_slider_value(slidobj,(float) (selected-current));
  fl_set_slider_step(slidobj,1.0);
  if (selected > 18)
    fl_set_slider_size(slidobj,1.0/18.0);
  else
    fl_set_slider_size(slidobj,1.0/selected);
  fl_unfreeze_object(slidobj);
}

/*********
 *  void readout_form()
 *      Read back the information in the form into the current record.
 *********/

void readout_form()
{
  int i;
  char ff[MAXFIELDNUMB][MAXFIELDLENGHT];
  char str[MAXSTRINGLENGHT];
  if (viewmode != RECORD_VIEW) return;
  if (currentrecord == 0) return;
  for (i=0; i<MAXFIELDNUMB; i++)
    strcpy(ff[i],fl_get_input(inpobj[i]));
  fields_to_string(ff,str,fieldnumb);
  change_record(currentrecord,str);
}


/*********
 *  void init_view()
 *      Initializes the view for the current database.
 *********/

void init_view()
{
  int i;
  char str[128];
  /* Fill in the field choice items */
  fl_clear_choice(sfieldobj);
  fl_addto_choice(sfieldobj, "SOME FIELD");
  fl_clear_choice(ofieldobj);
  for (i=0; i<fieldnumb; i++)
  {
    get_field_name(i+1,str);
    fl_addto_choice(sfieldobj,str);
    fl_addto_choice(ofieldobj,str);
  }
  fl_set_choice(sfieldobj,1);
  fl_set_choice(ofieldobj,1);
  set_viewmode(viewmode);
}


/*********
 *  void set_viewmode(int mode)
 *      Changes the viewmode.
 *              mode    = the new viewmode (RECORD_VIEW or LIST_VIEW)
 *********/

void set_viewmode(int mode)
/* Sets the current viewmode */
{
  int i;
  char str[128];
  viewmode = mode;
  if (viewmode == RECORD_VIEW)
  {
    fl_freeze_object(maingroup);
    fl_hide_object(maingroup);
    for (i=0; i<fieldnumb; i++)
    {
      inpobj[i]->active = 1;
      inpobj[i]->input = 1;
      get_field_name(i+1,str);
      fl_set_object_label(fobj[i],str);
      fl_show_object(fobj[i]);
      fl_show_object(inpobj[i]);
    }
  }
  else
  {
    fl_freeze_object(maingroup);
    fl_set_object_focus(mainform,NULL);
    fl_hide_object(maingroup);
    for (i=0; i<MAXFIELDNUMB; i++)
    {
      inpobj[i]->active = 0;
      inpobj[i]->input = 0;
      fl_set_object_label(fobj[i],"");
    }
    fl_show_object(maingroup);
  }
}
