/*
 * eb_callback.c
 *
 * This file is part of EasyBase.
 * It contains the callback routines of the main form.
 *
 * Written by Mark Overmars
 *
 * Version 1.1
 * Last Changed: Nov 23, 1992
 */

#include <gl/device.h>
#include <string.h>

#include "forms.h"
#include "eb_main.h"

/******** In Main Form ********/

void append_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  if (getbutton(LEFTSHIFTKEY) || getbutton(RIGHTSHIFTKEY))
    find_last();
  append_record();
  fillin_form();
}

void insert_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  if (getbutton(LEFTSHIFTKEY) || getbutton(RIGHTSHIFTKEY))
    find_first();
  insert_record();
  fillin_form();
}

void delete_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  delete_record();
  fillin_form();
}

void undelete_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  undelete_record();
  fillin_form();
}

void clear_cb(FL_OBJECT *obj, long arg)
{
  int i;
  fl_freeze_object(maingroup);
  for (i=0; i<MAXFIELDNUMB; i++) fl_set_input(inpobj[i],"");
  fl_unfreeze_object(maingroup);
}

void restore_cb(FL_OBJECT *obj, long arg)
{
  fillin_form();
}

void next_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  if (getbutton(LEFTSHIFTKEY) || getbutton(RIGHTSHIFTKEY))
    find_last();
  else
    find_next();
  fillin_form();
}

void previous_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  if (getbutton(LEFTSHIFTKEY) || getbutton(RIGHTSHIFTKEY))
    find_first();
  else
    find_previous();
  fillin_form();
}

void slid_cb(FL_OBJECT *obj, long arg)
{
  int total,selected,current;
  int ind;
  readout_form();
  get_database_info(&total,&selected,&current);
  ind = selected - (int) fl_get_slider_value(slidobj);
  if (viewmode == LIST_VIEW) ind -= MAXFIELDNUMB-1;
  if (ind == current) return;
  find_number(ind);
  fillin_form();
}

void sort_cb(FL_OBJECT *obj, long arg)
{
  readout_form();  
  fl_deactivate_all_forms();
  fl_show_form(sortform,FL_PLACE_MOUSE,FALSE,NULL);
}

void view_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  set_viewmode((viewmode+1)%2);
  fillin_form();
  if (viewmode == RECORD_VIEW)
    fl_show_object(editgroup);
  else
    fl_hide_object(editgroup);
}

void change_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  change_database_layout();
  init_view();
  fillin_form();
}

void print_cb(FL_OBJECT *obj, long arg)
{
  char *fname;
  int format;
  readout_form();
  format = fl_show_choice("Format to print selection:","","",
				3,"LaTeX","List","Record");
  if (format == 1)
    fname = fl_show_file_selector("File to print to","","*.tex","select.tex");
  else
    fname = fl_show_file_selector("File to print to","","*.out","select.out");
  if (fname == NULL) return;
  print_selection(fname,format);
}

char currentfile[1024];

void load_cb(FL_OBJECT *obj, long arg)
{
  char *fname;
  int rep;
  readout_form();
  if (changed)
  {
    rep = fl_show_choice("Database has been changed!",
				"Do you want to save the changes?","",
				3,"Save","Load New","Return");
    if (rep == 3) return;
    if (rep == 1) saveall_cb(NULL,0);
  }
  fname = fl_show_file_selector("Database to Load","","*.dat","");
  if (fname == NULL) return;
  strcpy(currentfile, fname);
  load_database(currentfile);
  fl_set_object_label(fileobj,fl_get_filename());
  init_view();
  fillin_form();
}

void merge_cb(FL_OBJECT *obj, long arg)
{
  char *fname;
  readout_form();
  fname = fl_show_file_selector("Database to Load","","*.dat","");
  if (fname == NULL) return;
  merge_database(fname);
  fillin_form();
}

void saveselect_cb(FL_OBJECT *obj, long arg)
{
  char *fname;
  readout_form();
  fname = fl_show_file_selector("File to Save Database to","","*.dat","");
  if (fname == NULL) return;
  if (!save_selection(fname))
    fl_show_message("Database could NOT be saved.","","");
  fillin_form();
}


void saveall_cb(FL_OBJECT *obj, long arg)
{
  char *fname;
  readout_form();
  if (getbutton(LEFTSHIFTKEY) || getbutton(RIGHTSHIFTKEY))
  {
    fname = fl_show_file_selector("File to Save Database to","","*.dat","");
    if (fname == NULL) return;
    strcpy(currentfile, fname);
    fl_set_object_label(fileobj,fl_get_filename());
  }
  if (!save_database(currentfile))
    fl_show_message("Database could NOT be saved.","","");
  fillin_form();
}

void exit_cb(FL_OBJECT *obj, long arg)
{
  int rep;
  readout_form();
  if (changed)
  {
    rep = fl_show_choice("Database has been changed!",
				"Do you want to save the changes?","",
				3,"Save","Exit","Return");
    if (rep == 3) return;
    if (rep == 1) saveall_cb(NULL,0);
  }
  exit(0);
}

/********* In Select Form ********/

void doselect_cb(FL_OBJECT *obj, long arg)
{
  int field, oper, inverse;
  char str[128];
  readout_form();
  field = fl_get_choice(sfieldobj) -2;
  inverse = fl_get_choice(sinverseobj) -1;
  oper = fl_get_choice(soperobj) -1;
  strcpy(str,fl_get_input(svalueobj));
  switch (arg) {
    case 0: /* Extend */
      make_selection(1,field,oper,inverse,str);
      break;
    case 1: /* Restrict */
      make_selection(0,field,oper,inverse,str);
      break;
    case 2: /* New */
      level_zero();
      make_selection(0,field,oper,inverse,str);
      break;
  }
  find_first();
  fillin_form();
}

void back_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  level_up();
  fillin_form();
}

void backzero_cb(FL_OBJECT *obj, long arg)
{
  readout_form();
  level_zero();
  fillin_form();
}

/********* In Sort Form ********/

void dosort_cb(FL_OBJECT *obj, long arg)
{
  fl_hide_form(sortform);
  if (arg == 0)
  {
    changed = 1;
    sort_database(fl_get_choice(ofieldobj)-1,
			2-fl_get_choice(odecrobj),fl_get_choice(ocaseobj)-1);
  }
  fillin_form();
  fl_activate_all_forms();
}
