/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/****************************
 *
 * make the popup menus
 *
 ****************************/

#include <gl.h>
#include "graph.h"

extern Menu   *menu;
extern View   view;
extern Flag   flag;
extern Obj    *obj;
extern Light  *light;
extern Lmodel *lmodel;

char   *malloc();

allocate_menu()
{
  menu = (Menu *)malloc((unsigned)sizeof(Menu));
}


make_menu()
{
  /* 
   * static menus
   */
  menu->scale_menu = defpup("Scale Menu%t|uniform|x scale|y scale|z scale");
  menu->rot_menu = defpup("Rotate Menu%t|x rotate|y rotate|z rotate");
  menu->trans_menu = defpup("Trans Menu%t|x trans|y trans|z trans");
  menu->obj_menu = defpup("Modeling Menu%t|Rotate menu|Scale menu|Trans menu");
  menu->dir_menu = defpup("Direction Menu%t|azimuthal angle|incidence angle");
  menu->scale_only = defpup("Scale Slice%t|uniform scale only");
  menu->rgb_menu = defpup("RGB menu%t|uniform|red|green|blue");
  menu->warning_menu = defpup("Warning%t|NOT ACTIVE");
  menu->depthcue_menu = defpup("Depthcue range%t|Start RGB menu|End RGB menu");
  view.pers_menu = defpup("Perspective%t|fovy|aspect|near|far");
  view.ortho_menu = defpup("Othogonal%t|left|right|bottom|top|near|far");
  view.proj_type_menu = defpup("Projections%t|Othogonal|Perspective");
  view.view_menu = defpup("View Menu%t|vx|vy|vz|px|py|pz|twist|radius|azim angle|inci angle|vx & px|vy & py|vz & pz|zoom ");
  view.proj_view_mod_menu = defpup("PVM menu%t|Modeling menu|Viewing menu|Projection menu");
  
  menu->l_and_m_menu=defpup("LIGHT %t|L-Model menu|Lights on & off|Lights Menu");
  menu->material_menu =
    defpup("Material Menu%t|Emission menu|Ambient menu|Diffuse menu|Specular menu|shine|alpha");
  menu->spotlight_menu= defpup("SpotLight%t|azimuthal angle|incidence angle|exponent|spread angle");
  menu->nonlocal_menu = defpup("Warning%t|not a local light src");
  menu->nonspot_menu = defpup("Warning%t| not a spot light src");
  /*
   * dynamic menus
   */

  update_extra_menu();

  if(flag.slice)
    update_slice_menu();
  if(flag.light)
    {
      update_on_light_menu(0);
      update_lmodel_menu();
    }
  update_main_menu();
}
/************************************************************************/

static char main_1[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other |Change Light|Change Box|Change Slice";
static char main_2[] = "Main Menu%t|Global Change|Local Change|  freeze|exit |reset|Other |Change Light|Change Box";
static char main_3[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other |Change Light|Change Slice";
static char main_4[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other |Change Light";
static char main_5[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other |Change Box|Change Slice";
static char main_6[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other |Change Box";
static char main_7[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other |Change Slice";
static char main_8[] = "Main Menu%t|Global Change|Local Change|  freeze|exit|reset|Other ";

static char *main_menu_item;

update_main_menu()
{
  if(flag.light && flag.box_flag && flag.slice)
    main_menu_item = main_1;
  else if(flag.light && flag.box_flag) 
    main_menu_item = main_2;
  else if(flag.light && flag.slice)
    main_menu_item = main_3; 
  else if( flag.light)
    main_menu_item = main_4; 
  else if(flag.box_flag && flag.slice)
    main_menu_item = main_5; 
  else if(flag.box_flag)
    main_menu_item = main_6; 
  else if(flag.slice) 
    main_menu_item = main_7; 
  else 
    main_menu_item = main_8; 
  if(flag.redraw)
    {
      *(main_menu_item + 39) = ' ';
      *(main_menu_item + 40) = ' ';
    }
  else
    {
      *(main_menu_item + 39) = 'u';
      *(main_menu_item + 40) = 'n';
    }
  menu->menu = defpup(main_menu_item);
}

/*********************************************************************/
static char slice_menu_item[] = 
  "Slice Menu%t|Direction Menu|Scale Menu|distance|Ortho Menu|scale plane|S plane o  |back color";

update_slice_menu()
{
  if(flag.sp_flag)
    {
      slice_menu_item[80] = 'f';
      slice_menu_item[81] = 'f';
    }
  else
    {
      slice_menu_item[80] = 'n';
      slice_menu_item[81] = ' ';
    }
  menu->slice_menu = defpup(slice_menu_item);

}
/********************************************************************/

static char local_menu_item[] =
  "Objects Menu%t|Modeling menu|Material list|  visible";
static char local_menu_item1[] =
  "Objects Menu%t|Modeling menu|  visible";

update_local_menu(ii)
     int ii;
{
  if(flag.light)
    {
      if( (obj+ii)->draw)
	{
	  local_menu_item[43] = 'i';
	  local_menu_item[44] = 'n';
	}
      else
	{
	  local_menu_item[43] = ' ';
	  local_menu_item[44] = ' ';
	}
      menu->local_menu = defpup(local_menu_item);
    }
  else
    {
      if( (obj+ii)->draw)
	{
	  local_menu_item1[29] = 'i';
	  local_menu_item1[30] = 'n';
	}
      else
	{
	  local_menu_item1[29] = ' ';
	  local_menu_item1[30] = ' ';
	}
      menu->local_menu = defpup(local_menu_item1);
    }     
}
/********************************************************************/
static char on_light_menu_item[] =
  "Lights Menu%t|Light1 o  |Light2 o  |Light3 o  |Light4 o  |Light5 o  |Light6 o  |Light7 o  |Light8 o  ";

update_on_light_menu(ii)
     int ii;
{
  register int i,j;
  
  for(i = 0; i < 8; i++)
    {
      j = 13+11*i+9;
      if( (light+i)->on )
	{
	  if(!ii)
	    {
	      on_light_menu_item[j] = 'f';
	      on_light_menu_item[j+1] = 'f';
	    }
	  else
	    {
	      on_light_menu_item[j] = 'n';
	      on_light_menu_item[j+1] = ' ';
	    }
	}
      else
	{
	  if(!ii)
	    {
	      on_light_menu_item[j] = 'n';
	      on_light_menu_item[j+1] = ' ';
	    }
	  else
	    {
	      on_light_menu_item[j] = 'f';
	      on_light_menu_item[j+1] = 'f';
	    }
	}
    }
  menu->on_light_menu = defpup(on_light_menu_item);
}
/*******************************************************************/
static char lmodel_menu_item[] =
  "L-Model%t|Ambient menu|Local o  |Attenu f|Attenu v|Attenu2|Twoside o  |";
update_lmodel_menu()
{
  if( *(lmodel->token +5))
    {
      lmodel_menu_item[30] = 'f';
      lmodel_menu_item[31] = 'f';
    }
  else
    {
      lmodel_menu_item[30] = 'n';
      lmodel_menu_item[31] = ' ';
    }
  if( *(lmodel->token +12))
    {
      lmodel_menu_item[68] = 'f';      
      lmodel_menu_item[69] = 'f';      
    }
  else
    {
      lmodel_menu_item[68] = 'n';      
      lmodel_menu_item[69] = ' ';      
    }
  menu->lmodel_menu = defpup(lmodel_menu_item);
}

/*****************************************************************/
static char light_menu_item[] = 
"Lig Menu%t|Color menu|radius|azim angle|inci angle|   local light|Ambient menu|Spot light o  |SpotLight menu|bulb size(?)";

update_light_menu(ii)
     int ii;
{
  if( *( (light + ii) -> token + 8))
    {
      light_menu_item[51] = 'n';
      light_menu_item[52] = 'o';
      light_menu_item[53] = 'n';
    }
  else
    {
      light_menu_item[51] = ' ';
      light_menu_item[52] = ' ';
      light_menu_item[53] = ' ';
    }
  if( (light +ii)->spot)
    {
      light_menu_item[91] = 'f';      
      light_menu_item[92] = 'f';
    }
  else
    {
      light_menu_item[91] = 'n';
      light_menu_item[92] = ' '; 
    }
  menu->light_menu = defpup(light_menu_item);
}

/**********************************************************************/

update_extra_menu()
{
  if(flag.depthcue)
    menu->extra_menu = defpup("Extra Menu%t|background color|depthcue range");
  else
    menu->extra_menu = defpup("Extra Menu%t|background color");
}
/*******************************************************/
