/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/*********************************************************
 *
 * when light mode is on, define light source and 
 * light model to the defaults
 *
 **********************************************************/

#include <gl.h>
#include <device.h>
#include <math.h>
#include <stdio.h>
#include "graph.h" 

extern Menu   *menu;
extern Lmodel *lmodel;
extern Light  *light;
extern View   view;
extern float  factor;
extern float  sizze;
extern Flag   flag;

char   *malloc();
/*********************
 *
 * ini_lm() 
 *
 *********************/
ini_lm()
{
  int i;
  if(!lmodel)
    lmodel = (Lmodel *) malloc( (unsigned) sizeof(Lmodel));
  *(lmodel->token) = AMBIENT;
  *(lmodel->token + 1) = 0.2;
  *(lmodel->token + 2) = 0.2 ;
  *(lmodel->token + 3 ) = 0.2 ;
  *(lmodel->token + 4) = LOCALVIEWER;
  *(lmodel->token + 5) = 0.0;
  *(lmodel->token + 6) = ATTENUATION;
  *(lmodel->token + 7) = 0.8;
  *(lmodel->token + 8) = 0.0;

  *(lmodel->token + 9) = ATTENUATION2;
  *(lmodel->token + 10) = 0.0;
  *(lmodel->token + 11) = TWOSIDE;
  /*
   * change 1.0 to 0.0 if you want
   * TWOSIDE to be false by default
   */
  *(lmodel->token + 12) = 1.0;

  *(lmodel->token + 13) = LMNULL;
  lmodel->lmodel_change = 1;

  if(!light)
    light = (Light *) malloc( (unsigned) 8 * sizeof(Light));
  for(i = 0; i < 8; i++) 
    {
      (light + i) -> light_change = 1;
      if( i == 0 || i == 1 ) (light + i) -> on = 1;    
      else 
	(light + i) -> on = 0;    

      ((light + i) -> spot) = 0;

      *((light + i) -> token) = LCOLOR;
      if( i == 1) {
	*((light + i) -> token + 1) = 0.8;
	*((light + i) -> token + 2) = 0.8;
	*((light + i) -> token + 3) = 0.8;}
      else if(i == 2) {
	*((light + i) -> token + 1) = 1.0;
	*((light + i) -> token + 2) = 1.0;
	*((light + i) -> token + 3) = 0.0;}
      else if(i == 3) {
	*((light + i) -> token + 1) = 1.0;
	*((light + i) -> token + 2) = 0.0;
	*((light + i) -> token + 3) = 1.0;}
      else if(i == 4){
	*((light + i) -> token + 1) = 0.0;
	*((light + i) -> token + 2) = 1.0;
	*((light + i) -> token + 3) = 1.0;}
      else if(i == 5) {
	*((light + i) -> token + 1) = 0.0;
	*((light + i) -> token + 2) = 1.0;
	*((light + i) -> token + 3) = 1.0;}
      else if( i== 6) {
	*((light + i) -> token + 1) = 1.0;
	*((light + i) -> token + 2) = 0.0;
	*((light + i) -> token + 3) = 1.0; }
      else  {
	*((light + i) -> token + 1) = 0.7;
	*((light + i) -> token + 2) = 0.7;
	*((light + i) -> token + 3) = 0.7; }

      *((light + i) -> token + 4) = POSITION; 

      *((light + i) -> token + 7) = 0.0;
      *((light + i) -> token + 6) = 0.0;
      *((light + i) -> token + 5) = sizze;
      if( i == 0 )
	{
	  *((light + i) -> token + 5) = 0.0;
	  *((light + i) -> token + 6) = 0.7 * sizze;
	  *((light + i) -> token + 7) = 0.16 * sizze;
	}
      else if( i == 1)
	{
	  *((light + i) -> token + 5) = 0.7 * sizze;
	  *((light + i) -> token + 6) = 0.0;
	  *((light + i) -> token + 7) = 0.16 * sizze;
	}
      else if( i == 3)
	*((light + i) -> token + 5) = - sizze ;
      else if( i == 4)
	*((light + i) -> token + 6) = - sizze;
      else if( i == 2 || i == 5)
	*((light + i) -> token + 7) = sizze;
      else if( i == 7 || i == 6)
	*((light + i) -> token + 7) = - sizze;
      else
	{
	  *((light + i) -> token + 7) = ((i%2)-1.0)*sizze * i;
	  *((light + i) -> token + 5) = ((i%2)-1.0)*sizze * i; 
	  *((light + i) -> token + 6) = ((i%2)-1.0)*sizze * i;
	}
      *((light + i) -> token + 8) = 0.0; /* w */

      *((light + i) -> token + 9) = AMBIENT;
      *((light + i) -> token + 10) = 0.0;
      *((light + i) -> token + 11) = 0.0;
      *((light + i) -> token + 12) = 0.0;

      *((light + i) -> token + 13) = SPOTDIRECTION;
      *((light + i) -> token + 14) = 0.0;
      *((light + i) -> token + 15) = 0.0;
      *((light + i) -> token + 16) = 1.0;

      *((light + i) -> token + 17) = SPOTLIGHT;
      *((light + i) -> token + 18) = 0;
      *((light + i) -> token + 19) = 180.0;
      *((light + i) -> token + 20) = LMNULL;
      /*
       * for the flash light
       */
      *((light + i) -> token + 21) = 0.06*sizze;
    }
  flag.need_redefine_lm = 1;  flag.need_redefine_mp = 1;
  check_local_light();
}

/****************
 *
 * change_lm()
 *
 ****************/
change_lm()
{
  int menu_val,menu_val1;
  
  menu_val = dopup(menu->l_and_m_menu);
  if(menu_val <= 0){ qreset();  return;}
  if(menu_val == 1) change_lmodel();
  else if(menu_val == 2) turn_on_light();
  else if(menu_val == 3 ) 
    {
    again:
      update_on_light_menu(1);
      menu_val1 = dopup(menu->on_light_menu);
      if(menu_val1 <= 0){qreset(); return;}
      if( (light + menu_val1 - 1)->on) 
	{
	  update_light_menu(menu_val1 - 1);
	  change_light(menu_val1 - 1);
	}
      else
	{
	  (void) dopup(menu->warning_menu);
	  qreset();
	  goto again;
	}
    }
  qreset();
}

/*******************
 *
 *  turn_on_light()
 *
 *******************/
turn_on_light()
{
  int menu_val,dev; short val;
  
  update_on_light_menu(0);
 try:
  menu_val = dopup(menu->on_light_menu);
  if(menu_val <= 0){qreset(); return;}
  if(menu_val >= 1 && menu_val <= 8) 
    {
      flag.need_redefine_lm = 1;
      
      (light + menu_val -1)->light_change = 1;
      if( (light + menu_val -1)->on)
	(light + menu_val -1)->on = 0;
      else 
	(light + menu_val -1)->on = 1;
      make_object();

      update_on_light_menu(0);
    }
  else 
    return;
 try2:
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try2;
  if(dev == RIGHTMOUSE) goto try; 
}
/*********************************
 *
 * change_lmodel()
 *
 *********************************/
change_lmodel()
{
  int menu_val, menu_val1, dev,x0, x1;
  float dx;
  short val;

 tryagain:
  menu_val = dopup(menu->lmodel_menu);
  if(menu_val <= 0){qreset();  return;}
  
  /*
   * Toggle LOCALVIEWER 0/1
   */
  if(menu_val == 2)
    {
      flag.need_redefine_lm = 1;

      lmodel->lmodel_change = 1;	  
      if( *(lmodel->token +5) )
	*(lmodel->token + 5) = 0.0;
      else 
	*(lmodel->token + 5) = 1.0;

      check_local_light();
      update_lmodel_menu();
      
      if(flag.show_message_flag) 
	show_lmodel();
      make_object();
      goto try1;
    }
  /*
   * Toggle TWOSIDE 0/1
   */
  else if(menu_val == 6)  
    {
      flag.need_redefine_lm = 1;

      lmodel->lmodel_change = 1;	  
      if( *(lmodel->token +12) )
	*(lmodel->token + 12) = 0.0;
      else 
	*(lmodel->token + 12) = 1.0;

      update_lmodel_menu();
      
      if(flag.show_message_flag) show_lmodel();
      make_object();
      goto try1;
    }
  /*
   * Change AMBIENT light
   */
  if(menu_val == 1) 
    {
      menu_val1 = dopup(menu->rgb_menu);
      if(menu_val1 <= 0) {qreset(); return;}
    }

  if(menu_val == 1 || menu_val ==3 || menu_val == 4 || menu_val == 5)
    {
      x0 = getvaluator(MOUSEX);
    try1:
      while(!qtest())
	{
	  if(menu_val != 2) {

	    flag.need_redefine_lm = 1;

	    lmodel->lmodel_change = 1;	  
	    x1 = getvaluator(MOUSEX);
	    dx = 0.0002*(x1 - x0);
	    switch(menu_val)
	      {
	      case 1: /* AMBIENT */
		if(menu_val1 == 1)
		  {
		    *(lmodel->token +1) += dx; *(lmodel->token + 2) += dx; 
		    *(lmodel->token + 3) += dx;
		  }
		if(menu_val1 == 2)  
		  *(lmodel->token +1) += dx;
		if(menu_val1 == 3) 
		  *(lmodel->token + 2) += dx;
		if(menu_val1 == 4) 
		  *(lmodel->token + 3) += dx;

		if( *(lmodel->token +1) >= 1.0) *(lmodel->token +1) = 1.0;
		else if( *(lmodel->token +1) <= 0.0) *(lmodel->token +1) = 0.0;
		if( *(lmodel->token + 2) >= 1.0) *(lmodel->token +2) = 1.0;
		else if(*(lmodel->token + 2) <= 0.0) *(lmodel->token +2) = 0.0;
		if( *(lmodel->token + 3) >= 1.0) *(lmodel->token +3) = 1.0;
		else if(*(lmodel->token + 3) <= 0.0) *(lmodel->token +3) = 0.0;
		 
		break;
	      case 3:  /* ATTEN f */
		*(lmodel->token + 7) += 0.1 * dx;
		if( *(lmodel->token + 7) <= 0.0)  *(lmodel->token + 7) = 0.001;
		else if(*(lmodel->token + 7) >=1.0)*(lmodel->token + 7) = 1.00;
		break;
	      case 4:  /* ATTEN v */
		*(lmodel->token + 8) += 0.1 * dx;
		if( *(lmodel->token + 8) <= 0.0)  *(lmodel->token + 8) = 0.0;
		else if(*(lmodel->token + 8) >=1.0)*(lmodel->token + 8) = 1.00;
		break;
	      case 5:  /* ATTEN 2 */
		*(lmodel->token + 10) += 0.1 * dx;
		if( *(lmodel->token + 10) <= 0.0)  *(lmodel->token +10)= 0.0;
		else if(*(lmodel->token +10) >=1.0)*(lmodel->token +10) = 1.00;
		break;
	      default:
		break;
	      }
	    make_object();
	  }
	}
      dev = qread(&val);
      if(dev == INPUTCHANGE) 
	{
	  if(flag.show_message_flag) 	  
	    show_lmodel();
	  goto try1;
	}
      if(dev == RIGHTMOUSE) 
	{
	  if(flag.show_message_flag) 	  
	    show_lmodel();
	  goto tryagain;
	}
    }
}

/****************************
 *
 *  change_light()
 *
 ****************************/
change_light(nu)
     int nu;
{
  int menu_val, menu_val1, dev,x0, x1,c_or_a;
  float dx, dy,radius,theta,phi;
  short val;

 tryagain:
  menu_val = dopup(menu->light_menu);
  if(menu_val <= 0) {qreset(); return;}

  if(menu_val == 8)
    {
      if( *( (light + nu)->token +8) == 0.0)  
	{
	  (void)dopup(menu->nonlocal_menu);
	  qreset();
	  goto tryagain;
	}
      if( ( (light +nu)->spot) == 0)
	{
	  (void)dopup(menu->nonspot_menu);
	  qreset();
	  goto tryagain;
	}
      change_spotlight(nu);
    }

  if(menu_val == 5)
    {
      flag.need_redefine_lm = 1;

      (light + nu)->light_change = 1;
      if( *( (light + nu)->token +8) == 0.0)  
      *( (light + nu)->token + 8) = 1.0;
      else  *( (light + nu)->token + 8) = 0.0;
      check_local_light();
      if(flag.show_message_flag) show_lsrc(nu);
      update_light_menu(nu);
      make_object();
      goto try1;
    }

  radius=sqrt( *( (light + nu)->token + 5)  *  *( (light + nu)->token + 5) 
	      + *( (light + nu)->token + 6) *  *( (light + nu)->token + 6) 
	      +  *( (light + nu)->token + 7) *  *( (light + nu)->token + 7) );
  theta = asin(  *( (light + nu)->token + 7) /radius);
  if( *( (light + nu)->token + 5) == 0 && 
     *( (light + nu)->token + 6)  == 0) phi = 0.0;
  else
    phi = acos( *( (light + nu)->token + 5) 
	       /sqrt( *( (light + nu)->token + 5) *  
		     *( (light + nu)->token + 5) +
		     *( (light + nu)->token + 6) *  
		     *( (light + nu)->token + 6) ));
  if( *( (light + nu)->token + 6) <0.0) phi = 6.283185306 - phi;

  if(menu_val == 7)
    {
      flag.need_redefine_lm = 1;

      (light + nu)->light_change = 1;
      if( ( (light + nu)->spot) == 0)
	{
	  if( *( (light + nu)->token + 8) == 0.0)
	    {
	      (void)dopup(menu->nonlocal_menu);
	      qreset();
	      goto tryagain;
	    }
	  ( (light + nu)->spot) = 1;
	  *( (light + nu)->token + 14) = - cos(theta) * cos(phi);
	  *( (light + nu)->token + 15) = - cos(theta) * sin(phi);
	  *( (light + nu)->token + 16) = - sin(theta);
	  *( (light + nu)->token + 18) =  100.0;
	  *( (light + nu)->token + 19) =  45.0;
	}
      else
	{
	  ( (light + nu)->spot) = 0;
	  *( (light + nu)->token + 18) =  0.0;
	  *( (light + nu)->token + 19) =  180.0;
	}
      if(flag.show_message_flag) show_lsrc(nu);
      update_light_menu(nu);
      make_object();
      goto try1;
    }

  if(menu_val == 1 || menu_val == 6)
    {
      menu_val1 = dopup(menu->rgb_menu);
      if(menu_val1 <= 0){qreset(); return;}
      if( menu_val == 6) c_or_a = 9;
      else c_or_a = 0;
    }  

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      flag.need_redefine_lm = 1;

      if(menu_val != 5) {
	(light + nu)->light_change = 1;
	x1 = getvaluator(MOUSEX);
	dx = 0.0002*(x1 - x0); dy = factor * (float) (x1 - x0);
	if(menu_val == 1 || menu_val == 6)
	  {
	    if(menu_val1 == 1)
	      {
		*( (light + nu)->token + 1+c_or_a) += dx; 
		*( (light + nu)->token + 2+c_or_a) += dx;
		*( (light + nu)->token + 3+c_or_a) += dx;
	      }
	    else if(menu_val1 == 2)  
	      *( (light + nu)->token + 1+c_or_a) += dx;
	    else if(menu_val1 == 3) 
	      *( (light + nu)->token + 2+c_or_a) += dx;
	    else if(menu_val1 == 4) 
	      *( (light + nu)->token + 3+c_or_a) += dx;

	    if( *( (light + nu)->token + 1+c_or_a) >= 1.0) 
	      *( (light + nu)->token + 1+c_or_a) = 1.0;
	    else if( *( (light + nu)->token + 1+c_or_a) <= 0.0)  
	      *( (light + nu)->token + 1+c_or_a) = 0.0;
	    if( *( (light + nu)->token + 2+c_or_a) >= 1.0)  
	      *( (light + nu)->token + 2+c_or_a) = 1.0;
	    else if( *( (light + nu)->token + 2+c_or_a) <= 0.0)  
	      *( (light + nu)->token + 2+c_or_a) = 0.0;
	    if( *( (light + nu)->token + 3+c_or_a) >= 1.0)  
	      *( (light + nu)->token + 3+c_or_a) = 1.0;
	    else if( *( (light + nu)->token + 3+c_or_a) <= 0.0)  
	      *( (light + nu)->token + 3+c_or_a) = 0.0;
	  }

	if(menu_val >= 2 && menu_val <= 4 )
	  {
	    if(menu_val == 2) {
	      radius += dy;
	      if(radius <= 0.0) radius = 0.01;
	    }
	    if(menu_val == 3) theta += dx;
	    if(menu_val == 4) phi += dx;
	    
	    *( (light + nu)->token + 5) = radius * cos(theta) * cos(phi);
	    *( (light + nu)->token + 6) = radius * cos(theta) * sin(phi);
	    *( (light + nu)->token + 7) = radius * sin(theta) ;
	  }
	if(menu_val == 9) 
	  {
	    *( (light + nu)->token + 21) += dy;
	    if( *( (light + nu)->token + 21) <= 0.01)
	      *( (light + nu)->token + 21) = 0.01;
	  }
	make_object();
      }
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) 
    {
      if(flag.show_message_flag) 
	show_lsrc(nu); 
      goto try1;
    }
  if(dev == RIGHTMOUSE) 
    {
      if(flag.show_message_flag) 
	show_lsrc(nu); 
      goto tryagain;
    }
}
/******************************************
 *
 *  change_spolight()
 *
 */
change_spotlight(nu)
     int nu;
{
  int menu_val,dev,x0, x1;
  float dx, dy,theta,phi;
  short val;

 tryagain:
  menu_val = dopup(menu->spotlight_menu);
  if(menu_val <= 0) { qreset(); return;}

  theta = asin(  *( (light + nu)->token + 16));
  if( *( (light + nu)->token + 14) == 0 && 
     *( (light + nu)->token + 15)  == 0) 
    phi = 0.0;
  else
    phi = acos( *( (light + nu)->token + 14) 
	       /sqrt( *( (light + nu)->token + 14) *  
		     *( (light + nu)->token + 14) +
		     *( (light + nu)->token + 15) *  
		     *( (light + nu)->token + 15) ));
  if( *( (light + nu)->token + 15) <0.0) phi = 6.283185306 - phi;


  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      flag.need_redefine_lm = 1;
      if(1)
	{
	  (light + nu)->light_change = 1;
	  x1 = getvaluator(MOUSEX);
	  dx = 0.0002*(x1 - x0); dy = dx * 10.0;
	if(menu_val == 1 || menu_val == 2 )
	  {
	    if(menu_val == 1) theta += dx;
	    if(menu_val == 2) phi += dx;
	    
	    *( (light + nu)->token + 14) =  cos(theta) * cos(phi);
	    *( (light + nu)->token + 15) =  cos(theta) * sin(phi);
	    *( (light + nu)->token + 16) =  sin(theta) ;
	  }
	if(menu_val == 3) 
	  {
	    *( (light + nu)->token + 18) += dy;
	    if( *( (light + nu)->token + 18) <= 0.01)
	      *( (light + nu)->token + 18) = 0.01;
	    if( *( (light + nu)->token + 18) >= 128.0)
	      *( (light + nu)->token + 18) = 128.0;
	  }
	if(menu_val == 4) 
	  {
	    *( (light + nu)->token + 19) += dy;
	    if( *( (light + nu)->token + 19) <= 0.01)
	      *( (light + nu)->token + 19) = 0.0;
	    if( *( (light + nu)->token + 19) >= 90.0)
	      *( (light + nu)->token + 19) = 90.0;
	  }
	  make_object();
	}
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) 
    {
      if(flag.show_message_flag) show_lsrc(nu); 
      goto try1;
    }
  if(dev == RIGHTMOUSE) 
    {
      if(flag.show_message_flag) show_lsrc(nu); 
      goto tryagain;
    }
}
/******************************************
 *
 * def_light_model()
 *
 ******************************************/
def_light_model()
{
  int i;

  if( lmodel->lmodel_change)
    {
      lmdef(DEFLMODEL,1,14,lmodel->token);
    }

  for(i = 0; i < 8; i++) 
    {
      if( (light +i)->light_change) 
	{
	  lmdef(DEFLIGHT,i+1,21,(light + i)->token);
	  (light + i ) -> light_change = 0;
	}
    }
}
/***********************************************************************/

static int lights[8] = {1100,1101,1102,1103,1104,1105,1106,1107 };

bind_light_model()
{
  register int i;

  if( lmodel->lmodel_change)
    {
      lmbind(LMODEL,1);  
      lmodel->lmodel_change = 0;
    }

  for(i = 0 ; i < 8; i++) 
    {
      if((light + i)->on )
	lmbind(lights[i],i+1);   
      else lmbind(lights[i],0);
    }
}

/*******************************************************************/

set_no_light()
{
  register int i;
  
  lmbind(LMODEL,0);
  lmbind(MATERIAL,0);
  for(i = 0 ; i < 8; i++) 
    lmbind(lights[i],0);   
}
  
/***********************************************/

check_local_light()
{
  register int i;
  

  if ( *(lmodel->token + 5))
    {
      flag.local_light = 1;
      return;
    }

  for(i = 0; i < 8;i++)
    {
      if((light + i)->on )
	if( *((light + i) -> token + 8) )
	  {
	    flag.local_light = 1;
	    return;	 
	  } 
    }
  flag.local_light = 0;
}

/******************************************************/
