/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/******************************************************
 *
 * Set the global viewing,projection and modeling
 *
 ******************************************************/

#include <gl.h>
#include <device.h>
#include <math.h>
#include "graph.h"

extern int   *obj_style;
extern Box   *box;
extern Obj   *obj;
extern Menu  *menu;
extern Flag  flag;
extern View  view;
extern float factor;

int   dotrans(),update_rot();
float get_angle();
short anglex,angley,anglez;

/*********************************
 *
 * model_view_proj()
 * function that modify the viewing
 * projection and modeling
 *
 *********************************/
extern float back_color[];

model_view_proj()
{
  int menu_val, menu_val1;
  menu_val = dopup(view.proj_view_mod_menu);
  if(menu_val <= 0)
    {qreset(); return;}
  switch(menu_val)
    {
    case 1:
      global_model();
      break;
    case 2:
      change_view();
      break;
    case 3:
      menu_val1 = dopup(view.proj_type_menu);
      if(menu_val1 != ORTHOGONAL && menu_val1 != PERSPECTIVE)
	break;
      view.proj_flag = menu_val1;
      change_projection(menu_val1);
      break;
    default:
      break;
    }
  qreset();
}
/******************************
 * 
 *  Change background color
 *  add in on July 30, 1989
 *
 ******************************/

change_back_color(back_clor)
     float back_clor[];
{
  int menu_val1, dev,x0, x1;
  float dx; 
  short val;  

 tryagain:
  menu_val1 = dopup(menu->rgb_menu);
  if(menu_val1 <= 0) return;  

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = 0.0002*(x1 - x0); 
      if(menu_val1 == 1)
	{
	  back_clor[0] += dx;
	  back_clor[1] += dx;
	  back_clor[2] += dx;
	  if(back_clor[0] >= 1.0) back_clor[0] =1.0;
	  if(back_clor[1] >= 1.0) back_clor[1] =1.0;
	  if(back_clor[2] >= 1.0) back_clor[2] =1.0;
	  if(back_clor[0] < 0.0) back_clor[0] =0.0;
	  if(back_clor[1] < 0.0) back_clor[1] =0.0;
	  if(back_clor[2] < 0.0) back_clor[2] =0.0;
	}
      else if(menu_val1 == 2)  
	{
	  back_clor[0] += dx;
	  if(back_clor[0] >= 1.0) back_clor[0] =1.0;
	  if(back_clor[0] < 0.0) back_clor[0] =0.0;
	}
      else if(menu_val1 == 3) 
	{
	  back_clor[1] += dx;
	  if(back_clor[1] >= 1.0) back_clor[1] =1.0;
	  if(back_clor[1] < 0.0) back_clor[1] =0.0;
	}
      else if(menu_val1 == 4) 
	{	     
	  back_clor[2] += dx;
	  if(back_clor[2] >= 1.0) back_clor[2] =1.0;
	  if(back_clor[2] < 0.0) back_clor[2] =0.0;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE) goto tryagain;
}
/******************************
 *
 * change_view()
 *
 ******************************/

change_view()
{
  int   menu_val, x0,x1,dx,dev;
  short val; 
  float phi,theta,radius;
  float tx,ty,tz,ttx,tty,ttz,tttx,ttty,tttz;

 tryagain:
  menu_val = dopup(view.view_menu);
  if(menu_val <=0) return;

  if(menu_val >=8 &&  menu_val <= 10 ) {
    radius = sqrt( (view.vx - view.px)* (view.vx - view.px) +
		  (view.vy - view.py)* (view.vy - view.py) +
		  (view.vz - view.pz)* (view.vz - view.pz));
    theta = asin( (view.vz - view.pz)/ radius);
    if( (view.vx == view.px) && (view.vy == view.py))
      phi = 0.;
    else
      phi = acos( (view.vx - view.px)/ sqrt((view.vx - view.px)*
					    (view.vx - view.px) +
					    (view.vy - view.py)*
					    (view.vy - view.py)));
    if((view.vy - view.py ) < 0.) phi = 6.28318 - phi; }

  if( menu_val == 14)
    {
      tx= (view.vx - view.px); 
      ty= (view.vy - view.py);
      tz= (view.vz - view.pz);
      radius = fsqrt( tx * tx + ty * ty + tz * tz);
      tx /= radius; ty /= radius; tz /= radius;
      tx *= factor; ty *= factor; tz *= factor;
      ttx = view.px; tty = view.py; ttz = view.pz;
      tttx = view.vx; ttty = view.vy; tttz = view.vz;
      radius = 0.0;
    }
  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      view.view_change = 1;
      flag.need_redefine_lm = 1;
      x1 = getvaluator(MOUSEX);
      dx = x1 - x0;
      
      if(menu_val == 1 || menu_val == 11) view.vx += factor * (float) dx;
      else if(menu_val == 2 || menu_val == 12) view.vy += factor * (float) dx;
      else if(menu_val == 3 || menu_val == 13) view.vz += factor * (float) dx;

      if(menu_val == 4 || menu_val == 11) view.px += factor * (float) dx;
      else if(menu_val == 5 || menu_val == 12) view.py += factor * (float) dx;
      else if(menu_val == 6 || menu_val == 13) view.pz += factor * (float) dx;

      else if(menu_val == 7) view.twist += (short) (0.05*(float)dx);
      else if(menu_val >= 8 &&  menu_val <= 10)
	{
	  if(menu_val == 8 )
	    {
	      radius +=  factor* (float) dx;
	      if(radius <= 0.0) radius = 0.001;
	    }
	  else if(menu_val == 9) theta += 0.0005* (float) dx;
	  else if(menu_val == 10) phi += 0.0005* (float) dx;
	  view.vx = view.px + radius* cos(theta)* cos(phi);
	  view.vy = view.py + radius* cos(theta)* sin(phi);
	  view.vz = view.pz + radius* sin(theta);
	}
      else if( menu_val == 14)
	{
	  radius += (float)dx;
	  view.vx = tttx + radius * tx;
	  view.vy = ttty + radius * ty;
	  view.vz = tttz + radius * tz;
	  view.px = ttx +  radius * tx;
	  view.py = tty +  radius * ty;
	  view.pz = ttz +  radius * tz;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE)
    {
      if(flag.show_message_flag) show_view();      
      goto try1;
    }
  if(dev == RIGHTMOUSE )
    {
      if(flag.show_message_flag) show_view();            
      goto tryagain;
    }
}
  
/***************************************
 * 
 * Modify the projection operation
 *
 ***************************************/
change_projection(type)
     int type;
{
  int menu_val, dev, x1, x0;
  short val;
  float dx,pfac;

  pfac = 10.0 *factor;
 tryagain:
  if(type == PERSPECTIVE) menu_val = dopup(view.pers_menu);
  else if(type == ORTHOGONAL) menu_val = dopup(view.ortho_menu);
  if(menu_val <= 0) return;
  x0 = getvaluator(MOUSEX);  
 try1:
  while(!qtest())
    {
      view.proj_change = 1;
      x1 = getvaluator(MOUSEX);
      dx = factor* (float) (x1-x0);

      switch(type)
	{
	case PERSPECTIVE:
	  if(menu_val == 1) 
	    {
	      view.fovy += (short)(0.05*(float)(x1 - x0));
	      if(view.fovy <= 5) view.fovy = 10;
	      if(view.fovy >= 1790) view.fovy = 1790;
	    }
	  else if(menu_val == 2) 
	    {
	      view.aspect += 0.008 * dx;
	      if(view.aspect < 1.0) view.aspect = 1.0;
	      if(view.aspect > 2.0) view.aspect = 2.0;
	    }
	  else if(menu_val == 3)
	    {
	      view.pnear -= dx;
	      if(view.pnear < pfac)
		view.pnear =  pfac;
	    }
	  else if(menu_val == 4) view.pfar += dx;

	  break;
	  
	case ORTHOGONAL:
	  if(menu_val == 1) view.left -= dx;
	  else if(menu_val == 2) view.right += dx;
	  else if(menu_val == 3) view.bottom -= dx;
	  else if(menu_val == 4) view.top += dx;
	  else if(menu_val == 5) view.near -= dx;
	  else if(menu_val == 6) view.far += dx;
	  break;
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) 
    {
      if(flag.show_message_flag) show_view();                  
      goto try1;
    }
  if(dev == RIGHTMOUSE )
    {
      if(flag.show_message_flag) show_view();            
      goto tryagain;
    }
}

/********************************
 *
 * global_model()
 *
 ********************************/
global_model()
{
  int menu_val;
  menu_val = dopup(menu->obj_menu);
  if(menu_val <= 0) return;
  flag.slice_draw = 1;
  if(menu_val == 1) global_rotate();
  else if(menu_val == 2) global_scale();
  else if(menu_val == 3) global_trans();
  flag.slice_draw = 0;  
}
/******************************
 *
 *  global_trans()
 *
 *******************************/
global_trans()
{
  int menu_val,x0,x1,dev;
  short val; float dx;

 tryagain:
  menu_val = dopup(menu->trans_menu);
  if(menu_val <= 0) return;
  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = factor * (float) (x1 - x0);
      switch(menu_val)
	{
	case 1:
	  view.x_trans +=  dx; 
	  break;
	case 2:
	  view.y_trans +=  dx; 
	  break;
	case 3:
	  view.z_trans +=  dx;
	  break;
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE)  goto tryagain;
}
/******************************
 *
 * global_scale()
 *
 *******************************/
global_scale()
{
  int menu_val,x0,x1,dev;
  short val; float dx;

 tryagain:
  menu_val = dopup(menu->scale_menu);
  if(menu_val <= 0) return;
  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = 0.0001 * (float) (x1 - x0);
      switch(menu_val)
	{
	case 1:
	  view.x_scale +=  dx; 
	  view.y_scale +=  dx;
	  view.z_scale +=  dx;
	  break;
	case 2:
	  view.x_scale +=  dx;
	  break;
	case 3:
	  view.y_scale +=  dx;
	  break;
	case 4:
	  view.z_scale +=  dx;	  
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE)  goto tryagain;
}
/******************************
 *
 * global_rotate()
 *
 *******************************/
global_rotate()
{
  int menu_val,x0,x1,dev;
  short val; float dx;

 tryagain:
  menu_val = dopup(menu->rot_menu);

  /*--------- modify the necessary stuff for rotation --------*/
  if(menu_val <= 0) return;
  view.rot_new_flag = menu_val;
  if(flag.mode_flag >= 2 )
    {
      {
	redefine_local_rot(view.rot_new_flag);
	if(flag.box_flag) redefine_box_rot();
      }
    } 
  else 
    { 
      if(! update_rot(view.rot_old_flag,view.rot_new_flag,
		      view.x_rot,view.y_rot,view.z_rot)) 
	{
	  view.x_rot = anglex; view.y_rot = angley; view.z_rot = anglez; 
	}
    }
  view.rot_old_flag = menu_val;

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = 0.05 * (float) (x1 - x0);
      switch(menu_val)
	{
	case 1:
	  view.x_rot += (short) dx;
	  view.x_rot %= 3600;
	  break;
	case 2:
	  view.y_rot += (short) dx;
	  view.y_rot %= 3600;
	  break;
	case 3:
	  view.z_rot += (short) dx;
	  view.z_rot %= 3600;
	  break;
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE)  goto tryagain;
}

/*********************************************/
redefine_box_rot()
{
  if(! update_rot(view.rot_old_flag,view.rot_new_flag,
		  view.x_rot + box->brx,
		  view.y_rot + box->bry,
		  view.z_rot + box->brz)) 
    {
      box->brx = anglex - view.x_rot;
      box->bry = angley - view.y_rot; 
      box->brz = anglez - view.z_rot; 
    }
}
/*********************************************/

redefine_local_rot(rt)
     int rt;
{
  register int i;
  for(i = 0; i < obj_style[0]; i++) 
    {
      (obj+i)->rot_new = rt;
      if(! update_rot((obj+i)->rot_old,rt,(obj+i)->x_rot + view.x_rot,
		      (obj+i)->y_rot + view.y_rot,
		      (obj+i)->z_rot + view.z_rot))
	{
	  (obj+i)->x_rot = anglex - view.x_rot;
	  (obj+i)->y_rot = angley - view.y_rot;
	  (obj+i)->z_rot = anglez - view.z_rot;
	  (obj+i)->rot_old = rt;
	}
    }
}
/************************************
 *
 *  set_rotation()
 *
 ************************************/
set_rotation(aix,ddx,ddy,ddz)
     int aix ; short ddx,ddy,ddz;
{
  switch(aix) 
    {
    case XYZ:
      rotate(ddx,'x');rotate(ddy,'y');rotate(ddz,'z');
      break;
    case XZY:
      rotate(ddx,'x');rotate(ddz,'z');rotate(ddy,'y');
      break;
    case YZX:
      rotate(ddy,'y');rotate(ddz,'z');rotate(ddx,'x');
      break;
    default:
      break;
    }
}
/*********************************************************************
 *
 *  the following code change the rotation aixes only, do not edit it.
 *
 **********************************************************************/

/*************************************
 *
 * update_rot()
 *
 *************************************/
int update_rot(fro,fto,anx,any,anz)
     int fro,fto; short anx,any,anz;
{
  int kk;
  
  kk = 0;
  if( fro == fto)
    return (- 1);

  switch( fro) 
    {
    case XYZ:
      if(fto == XZY) 
	kk += dotrans(XYZ,XZY,anx,any,anz); 
      if(fto == YZX) 
	kk += dotrans(XYZ,YZX,anx,any,anz);
      break;
    case XZY:
      if(fto == XYZ) 
	kk += dotrans(XZY,XYZ,anx,any,anz);
      if(fto == YZX)
	{
	  kk += dotrans(XZY,XYZ,anx,any,anz);
	  anx = anglex; any = angley; anz = anglez;
	  kk += dotrans(XYZ,YZX,anx,any,anz); 
	} 
      break;
    case YZX:
      if(fto == XYZ)
	kk += dotrans(YZX,XYZ,anx,any,anz);
      if(fto == XZY) {
	kk += dotrans(YZX,XYZ,anx,any,anz);
	anx = anglex; any = angley; anz = anglez;
	kk += dotrans(XYZ,XZY,anx,any,anz);   
      }
      break;
    default:
      kk = 1;
      break;
    }
  if(kk) return(- 1);
  return(0);
}
/**********************************
 *
 * dotrans()
 *
 **********************************/
int dotrans(from,to,ax,ay,az)
     int from,to; short ax,ay,az;
{
  float a11,a12,a13,a21,a22,a23,a31,a32,a33;
  float b11,b13,b21,b22,b23,b31,b32,b33,cz;
  float x_ang,y_ang,z_ang, ang_x,ang_y,ang_z;
  float cosx,sinx,cosy,siny,cosz,sinz;
  int   check_flag;

  if(from == XYZ &&  to != YZX && to != XZY)
    return (-1);
  if(from == YZX && to != XYZ) 
    return (-1);
  if(from == XZY && to != XYZ) 
    return( -1);
    

  check_flag = 0;
  x_ang =  (float)  ax * D2R ; 
  y_ang =  (float)  ay * D2R ;
  z_ang =  (float)  az * D2R ;

  cosx = fcos(x_ang); 
  cosy = fcos(y_ang); 
  cosz = fcos(z_ang);
  sinx = fsin(x_ang); 
  siny = fsin(y_ang); 
  sinz = fsin(z_ang);
  
  if(from == XYZ ) 
    {
      a11 = cosy * cosz ;
      a12 = sinz * cosx +sinx * siny * cosz;
      a13 =sinz * sinx - cosx *cosz *siny;
      a21 = -sinz * cosy;
      a22 = cosx * cosz - sinx * siny * sinz;
      a23 = cosz * sinx + cosx * siny * sinz;
      a31 = siny;
      a32 = - cosy * sinx;
      a33 = cosx * cosy;  
    }
  
  if(from == YZX ) 
    {
      a11 = cosy * cosz ; a12 =  sinz ; 
      a13 = - cosz  * siny ; 
      a21 = sinx * siny - sinz * cosx * cosy;
      a22 = cosx * cosz ;
      a23 = siny * cosx * sinz + sinx * cosy;
      a31 = cosy * sinx * sinz  + cosx * siny ;
      a32 = - cosz * sinx;
      a33 = - siny * sinz *sinx + cosx *cosy; 
    }

  if(from == XZY ) 
    {
      a11 = cosy * cosz ; a21 = - sinz ;  a31 =  cosz * siny ;
      a12 = sinx * siny + cosx * cosy* sinz ;
      a22 = cosx * cosz ;       a23 =  cosz * sinx;
      a32 = cosx * siny * sinz - sinx* cosy;
      a13 = cosy * sinx * sinz  - cosx * siny ;
      a33 = cosx * cosy + sinx * siny * sinz ; 
    }

  if(to == XZY && from == XYZ) 
    { 
      check_flag = 1;
      ang_z = fasin(- a21);
      if( fabs( fabs(a21) - 1.0) <= 0.000001) 
	{
	  ang_y = 0.0;
	  ang_x = get_angle(- a32, a33); 
	}
      else
	{
	  cz = sqrt(  (1.0 - a21 * a21));
	  b22 =   a22 / cz; b23 =  a23 /cz;
	  b11 =   a11/cz; b31 =  a31/cz;
	  ang_y = get_angle(b31,b11);
	  ang_x = get_angle(b23,b22);
	}
    }

  if(to == YZX && from == XYZ) 
    {
      check_flag = 1;
      ang_z = fasin( a12);
      if(fabs( fabs(a12) - 1.0 ) < 0.000001) 
	{
	  ang_y = 0.0;
	  ang_x = get_angle( a23,  a33);
	}
      else
	{
	  cz = sqrt(1.0 - a12 * a12);
	  b22 =   a22 / cz; b32 =   a32 /cz;
	  b11 =  a11/cz; b13 =   a13/cz;
	  ang_y = get_angle(- b13,b11);
	  ang_x = get_angle(- b32,b22);
	}
    }
  
  if((to == XYZ) && (from == XZY || from == YZX)) 
    {
      check_flag = 1;
      ang_y = fasin( a31);
      if(fabs(fabs(a31) - 1.0) < 0.000001) 
	{
	  ang_x = 0.0;
	  ang_z = get_angle(a12,  a22);
	}
      else
	{
	  cz = sqrt(1.0 - a31 * a31);
	  b11 =   a11/cz; b21 =   a21/cz; 
	  b32 =   a32/cz; b33 =   a33/cz;
	  ang_z = get_angle(- b21,b11);
	  ang_x = get_angle(- b32,b33);
	}
    }
  if(!check_flag) return( - 1);

  anglex = (short) ( R2D * ang_x);
  angley = (short) ( R2D * ang_y);
  anglez = (short) ( R2D * ang_z);
  return(0);
}
/*******************************************
 *
 * get_angle()
 *
 ********************************************/
float get_angle(sinof,cosof)
     float sinof, cosof;
{
  float angle;

  if( sinof >= 0.0 )
    {
      if( cosof >= 0.0) 
	angle =  fasin(sinof);      
      if(cosof < 0.0)
	angle = M_PI - fasin(sinof);      
    }
  else /* if( sinof < 0.0 ) */
    {
      if( cosof <= 0.0)
	angle = M_PI - fasin(sinof);      
      if(cosof > 0.0)
	angle = 2.0 * M_PI + fasin(sinof);      
    }
  return(angle);
}
/*******************************************/  



