/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.mime.LegacyString;
import cryptix.security.CryptoError;
import cryptix.security.HashSHA;
import cryptix.security.MessageDigest;
import cryptix.util.core.Hex;
import java.io.PrintWriter;

public class SHA
extends MessageDigest
implements Cloneable {
    public static final int HASH_LENGTH = 20;
    public static final int DATA_LENGTH = 64;

    public SHA() {
        super(SHA.getDigestImpl());
    }

    private static java.security.MessageDigest getDigestImpl() {
        try {
            return java.security.MessageDigest.getInstance("SHA-1", "Cryptix");
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static byte[] hash(String string) {
        try {
            return java.security.MessageDigest.getInstance("SHA-1", "Cryptix").digest(LegacyString.toByteArray(string));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static byte[] hash(byte[] byArray) {
        try {
            return java.security.MessageDigest.getInstance("SHA-1", "Cryptix").digest(byArray);
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashSHA hashAsMessageHash(String string) {
        try {
            return new HashSHA(java.security.MessageDigest.getInstance("SHA-1", "Cryptix").digest(LegacyString.toByteArray(string)));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashSHA hashAsMessageHash(byte[] byArray) {
        try {
            return new HashSHA(java.security.MessageDigest.getInstance("SHA-1", "Cryptix").digest(byArray));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashSHA CreateHash(byte[] byArray) {
        return new HashSHA(byArray);
    }

    public static void main(String[] stringArray) {
        try {
            SHA.self_test(new PrintWriter(System.out, true));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        SHA.test(printWriter, "", "DA39A3EE5E6B4B0D3255BFEF95601890AFD80709");
        SHA.test(printWriter, "abc", "A9993E364706816ABA3E25717850C26C9CD0D89D");
        SHA.test(printWriter, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "84983E441C3BD26EBAAE4AA1F95129E5E54670F1");
    }

    private static void test(PrintWriter printWriter, String string, String string2) throws Exception {
        java.security.MessageDigest messageDigest = java.security.MessageDigest.getInstance("SHA-1", "Cryptix");
        messageDigest.update(LegacyString.toByteArray(string));
        String string3 = Hex.toString((byte[])messageDigest.digest());
        printWriter.println("Message:   \"" + string + "\"");
        printWriter.println("calc hash: " + string3);
        printWriter.println("real hash: " + string2);
        if (string2.equalsIgnoreCase(string3)) {
            printWriter.println("Good");
            return;
        }
        printWriter.println("************ SHA-1 FAILED ************");
        throw new Exception("SHA-1 (V2.2) Failed test <" + string + ">");
    }
}

