/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Certificate;
import cryptix.pgp.DecryptException;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyID;
import cryptix.pgp.KeyRingEntry;
import cryptix.pgp.KeyStore;
import cryptix.pgp.PacketInputStream;
import cryptix.pgp.PacketOutputStream;
import cryptix.pgp.Passphrase;
import cryptix.pgp.PublicKeyCertificate;
import cryptix.pgp.SecretKeyCertificate;
import cryptix.pgp.Signature;
import cryptix.pgp.UserId;
import cryptix.pgp.UserIdCertificate;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.SecretKey;
import cryptix.util.EmailAddress;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class KeyRing
extends KeyStore {
    protected Hashtable users = new Hashtable();
    protected Hashtable addresses = new Hashtable();
    protected Hashtable entriesById = new Hashtable();

    protected KeyRing() {
    }

    protected KeyRing(InputStream inputStream) throws IOException {
        this.init(new PacketInputStream(inputStream));
    }

    protected KeyRing(String string) throws FileNotFoundException, IOException {
        throw new NoSuchMethodError("cryptix.pgp.KeyRing(String filename) is no longer supported.");
    }

    protected abstract void init(PacketInputStream var1) throws IOException;

    public final String getUserName(KeyID keyID) {
        KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
        if (keyRingEntry != null) {
            return keyRingEntry.primaryName();
        }
        return "Key: " + (Object)((Object)keyID);
    }

    public final void add(KeyRingEntry keyRingEntry) throws FormatException {
        Certificate certificate = keyRingEntry.certificate();
        KeyID keyID = certificate instanceof PublicKeyCertificate ? new KeyID(((PublicKeyCertificate)certificate).publicKey().id()) : ((SecretKeyCertificate)certificate).id();
        this.entriesById.put(keyID, keyRingEntry);
        UserIdCertificate[] userIdCertificateArray = keyRingEntry.getUserIdCertificates();
        int n = userIdCertificateArray.length;
        if (n == 0) {
            throw new FormatException("Certificate does not have any names");
        }
        int n2 = 0;
        while (n2 < n) {
            String string = userIdCertificateArray[n2].userName();
            this.users.put(string, keyID);
            if (string.indexOf("@") != -1) {
                try {
                    EmailAddress emailAddress = new EmailAddress(string);
                    this.addresses.put(emailAddress, keyID);
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
    }

    public final String[] getFullNameList(KeyID keyID) {
        int n = this.users.size();
        if (n > 0) {
            Object object;
            Vector vector = new Vector();
            Enumeration enumeration = this.users.keys();
            int n2 = 0;
            while (n2 < n) {
                object = enumeration.nextElement();
                if (keyID.equals(this.users.get(object))) {
                    vector.addElement(object);
                }
                ++n2;
            }
            n = vector.size();
            if (n > 0) {
                object = new String[n];
                vector.copyInto((Object[])object);
                return object;
            }
        }
        return new String[0];
    }

    public final String[] getFullUserNameList() {
        int n = this.users.size();
        String[] stringArray = new String[n];
        if (n > 0) {
            Enumeration enumeration = this.users.keys();
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
        return stringArray;
    }

    protected final PublicKey getPublicKey(KeyID keyID) {
        Certificate certificate;
        KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
        if (keyRingEntry != null && (certificate = keyRingEntry.certificate()) instanceof PublicKeyCertificate) {
            return ((PublicKeyCertificate)certificate).publicKey();
        }
        return null;
    }

    protected final PublicKey getPublicKey(EmailAddress emailAddress) {
        Certificate certificate;
        KeyID keyID = (KeyID)((Object)this.addresses.get(emailAddress));
        if (keyID == null) {
            return null;
        }
        KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
        if (keyRingEntry != null && (certificate = keyRingEntry.certificate()) instanceof PublicKeyCertificate) {
            return ((PublicKeyCertificate)certificate).publicKey();
        }
        return null;
    }

    protected final SecretKey getSecretKey(KeyID keyID, Passphrase passphrase) throws DecryptException {
        Certificate certificate;
        KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
        if (keyRingEntry != null && (certificate = keyRingEntry.certificate()) instanceof SecretKeyCertificate) {
            return ((SecretKeyCertificate)certificate).getSecretKey(passphrase);
        }
        return null;
    }

    protected final SecretKey getSecretKey(EmailAddress emailAddress, Passphrase passphrase) throws DecryptException {
        Certificate certificate;
        KeyID keyID = (KeyID)((Object)this.addresses.get(emailAddress));
        if (keyID == null) {
            return null;
        }
        KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
        if (keyRingEntry != null && (certificate = keyRingEntry.certificate()) instanceof SecretKeyCertificate) {
            return ((SecretKeyCertificate)certificate).getSecretKey(passphrase);
        }
        return null;
    }

    protected final PublicKey getIfBegins(Enumeration enumeration, String string) throws IOException {
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            return this.getKey(string2);
        }
        return null;
    }

    public void write(OutputStream outputStream) throws IOException {
        PacketOutputStream packetOutputStream = outputStream instanceof PacketOutputStream ? (PacketOutputStream)outputStream : new PacketOutputStream(outputStream);
        Enumeration enumeration = this.entriesById.keys();
        while (enumeration.hasMoreElements()) {
            KeyID keyID = (KeyID)((Object)enumeration.nextElement());
            packetOutputStream.writeKeyRingEntry((KeyRingEntry)this.entriesById.get((Object)keyID));
        }
    }

    public boolean checkSignatures() {
        return this.checkSignatures(this);
    }

    public boolean checkSignatures(KeyStore keyStore) {
        Enumeration enumeration = this.entriesById.elements();
        while (enumeration.hasMoreElements()) {
            if (((KeyRingEntry)enumeration.nextElement()).checkSignatures(keyStore)) continue;
            return false;
        }
        return true;
    }

    public final void dump(PrintStream printStream) {
        Object object;
        Hashtable hashtable = this.users;
        printStream.println("Username to KeyID mappings ...");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            printStream.println(String.valueOf(object) + " maps to " + hashtable.get(object));
        }
        printStream.println();
        printStream.println("KeyID to Certificate/Key mappings ...");
        hashtable = this.entriesById;
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            printStream.println(String.valueOf(e) + " maps to " + hashtable.get(e));
        }
        printStream.println(this.checkSignatures() ? "Signatures O.K." : "Signatures BAD");
    }

    public final void list(PrintStream printStream) {
        printStream.println();
        printStream.println("Key signature checking ...");
        Enumeration enumeration = this.entriesById.keys();
        while (enumeration.hasMoreElements()) {
            KeyID keyID = (KeyID)((Object)enumeration.nextElement());
            printStream.println((Object)keyID);
            KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
            UserIdCertificate[] userIdCertificateArray = keyRingEntry.getUserIdCertificates();
            Certificate certificate = keyRingEntry.certificate();
            printStream.println("Cert:" + certificate);
            int n = 0;
            while (n < userIdCertificateArray.length) {
                UserId userId = userIdCertificateArray[n].userId();
                printStream.println("User name:" + userId.toString());
                Signature[] signatureArray = userIdCertificateArray[n].signatures();
                int n2 = 0;
                while (n2 < signatureArray.length) {
                    KeyID keyID2 = signatureArray[n2].getKeyId();
                    printStream.println("Signed by " + (Object)((Object)keyID2) + " User name " + this.getUserName(keyID2));
                    try {
                        printStream.println(this.checkSignature(signatureArray[n2], certificate, userId) ? "GOOD signature" : "*** BAD signature ***");
                    }
                    catch (IOException iOException) {
                        printStream.println("Signature unchecked " + iOException.getClass().getName() + ":" + iOException.getMessage());
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public int getKeyTrust(KeyID keyID) {
        KeyRingEntry keyRingEntry = (KeyRingEntry)this.entriesById.get((Object)keyID);
        if (keyRingEntry == null) {
            return -1;
        }
        UserIdCertificate[] userIdCertificateArray = keyRingEntry.getUserIdCertificates();
        return userIdCertificateArray[0].getTrustValue();
    }
}

