/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.BigInteger;
import cryptix.security.StreamCipher;
import cryptix.util.Streamable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class EncryptedBigInt
extends Streamable {
    private byte[] buf_;
    private int bitLen_;
    private int checksum_;

    EncryptedBigInt(DataInput dataInput) throws IOException {
        super(dataInput);
    }

    EncryptedBigInt(BigInteger bigInteger, StreamCipher streamCipher) {
        this.buf_ = bigInteger.toByteArray();
        this.bitLen_ = bigInteger.bitLength();
        int n = this.buf_.length;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 += this.buf_[n3] & 0xFF;
            --n3;
        }
        this.checksum_ = n2 & 0xFFFF;
        streamCipher.encrypt(this.buf_);
    }

    BigInteger decrypt(StreamCipher streamCipher) {
        int n = this.buf_.length;
        byte[] byArray = new byte[n];
        streamCipher.decrypt(this.buf_, byArray);
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 += byArray[n3] & 0xFF;
            --n3;
        }
        this.checksum_ = n2 & 0xFFFF;
        return new BigInteger(byArray);
    }

    public void read(DataInput dataInput) throws IOException {
        this.bitLen_ = dataInput.readShort();
        this.buf_ = new byte[(this.bitLen_ + 7) / 8];
        dataInput.readFully(this.buf_);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.bitLen_);
        dataOutput.write(this.buf_);
    }

    public int checksum() {
        return (this.bitLen_ & 0xFF) + (this.bitLen_ >> 8 & 0xFF) + this.checksum_ & 0xFFFF;
    }
}

