/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import netscape.security.PrivilegeManager;

class IJCE_Properties {
    static final String PRODUCT_NAME = "IJCE";
    static final String LIB_DIRNAME = "ijce-lib";
    static final String PROPERTIES_FILENAME = "IJCE.properties";
    private static final Properties properties = new Properties();
    private static String lib_path;

    static String getLibraryPath() throws IOException {
        if (lib_path == null) {
            throw new IOException("IJCE library directory (ijce-lib) could not be found");
        }
        return lib_path;
    }

    private static void setProperties() {
        try {
            PrivilegeManager.enablePrivilege("UniversalPropertyRead");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("file.separator");
        try {
            PrivilegeManager.revertPrivilege("UniversalPropertyRead");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string4 = stringTokenizer.nextToken();
            if (string4.endsWith(".zip") || string4.endsWith(".jar")) {
                int n = string4.lastIndexOf(string3);
                if (n == -1) continue;
                file = new File(string4.substring(0, n), LIB_DIRNAME);
            } else {
                file = new File(string4, LIB_DIRNAME);
            }
            try {
                PrivilegeManager.enablePrivilege("UniversalFileRead");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            if (file.isDirectory()) {
                File file2;
                String string5 = file.getAbsolutePath();
                if (!string5.endsWith(string3)) {
                    string5 = String.valueOf(string5) + string3;
                }
                if ((file2 = new File(string5, PROPERTIES_FILENAME)).isFile()) {
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                        properties.load(bufferedInputStream);
                        ((FilterInputStream)bufferedInputStream).close();
                        lib_path = string5;
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            try {
                PrivilegeManager.revertPrivilege("UniversalFileRead");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        System.err.println("Warning: failed to load the IJCE.properties file.\nMake sure that the CLASSPATH entry for IJCE is an absolute path.");
    }

    static void save(OutputStream outputStream, String string) {
        properties.save(outputStream, string);
    }

    static String getProperty(String string) {
        return properties.getProperty(string);
    }

    static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    static Enumeration propertyNames() {
        return properties.propertyNames();
    }

    static void list(PrintStream printStream) {
        properties.list(printStream);
    }

    static void list(PrintWriter printWriter) {
        properties.list(printWriter);
    }

    IJCE_Properties() {
    }

    static {
        try {
            IJCE_Properties.setProperties();
        }
        catch (Exception exception) {
            String string = "Warning: Unable to load IJCE.properties";
            if (lib_path != null) {
                string = String.valueOf(string) + " from directory " + lib_path;
            }
            System.err.println(string);
            exception.printStackTrace();
        }
    }
}

