/* NTP (Network Time Protocol)   */
/* statistics grapher            */
/* NTPLOT   pd release 1.1       */
/* by Charlie Ledogar,           */
/* CERN CN/CS,July 1991.         */
/* Requires X11 window system,   */
/* and xntp's ntpq query program.*/
/* Link with xlib, m, and possible dnet. */
/***************************************************************
 *     Copyright CERN, Geneva 1991 - Copyright and any other   *
 *     appropriate legal protection of these computer programs *
 *     and associated documentation reserved in all countries  *
 *     of the world.                                           *
 ***************************************************************/

#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <strings.h>
#include <math.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <limits.h>
#include <unistd.h>
#include <signal.h>

#define wmax=1280
#define xborder=8
#define yborder=28
#define maxpeers=12
#define nobody="no remote peer "
int read_me;
int debug_mode;
int width=320, height=180;
 
typedef struct {
             char name[16], last_nc[16];  
             int still_there;
             Window win;
             GC gc;
             double ofs[wmax], dis[wmax];
             int cond[wmax], tick[wmax];
             double old_timefrac;
}  RemotePeer;

clear_remote_peers(rmtp)
RemotePeer rmtp[maxpeers];
{  int i,k;
     for (i=0; i<maxpeers; i++)
      { strcpy(rmtp[i].name,nobody);
        rmtp[i].win=NULL;
        rmtp[i].gc=NULL;
        rmtp[i].still_there=0;
       }   
}

int ctocond(c)
char c;
{ switch(c)
  {case '*': return(3); break;
   case '+': return(2); break;
   case '.': return(1); break;
   default : return(0); break;
   }
}

handler(sig, code, scp)
int sig, code;
struct sigcontext *scp;
{
  union wait status;
  pid_t pid;

  pid=wait(&status);
  read_me=1;
}

void setup_trap()
{ if (signal(SIGCLD, handler) == SIG_ERR)
    { perror("ntplot: signal failed:");
      exit(0);
     }
 }
    
void graph(dsp,rmtp)
Display *dsp;
RemotePeer rmtp;
{ XPoint p_ofs[wmax], p_dis[wmax];
  XSegment s[wmax];
  int i,k,y,lasttick;
  char *str[10];

  XClearWindow(dsp, rmtp.win);
  for (i=0; i<width; i++)
    p_ofs[i].x = p_dis[i].x = s[i].x1 = s[i].x2 = i; 
  XDrawLine(dsp, rmtp.win, rmtp.gc, 0, height/3-1, width, height/3-1);
  XDrawLine(dsp, rmtp.win, rmtp.gc, 0, height/3, width, height/3);
  XDrawLine(dsp, rmtp.win, rmtp.gc, 0, height*2/3-1, width, height*2/3-1);
  XDrawLine(dsp, rmtp.win, rmtp.gc, 0, height*2/3, width, height*2/3);
    /*dividers*/
  XDrawString(dsp, rmtp.win, rmtp.gc, 2, height/6-2, "Offset:", 7);
  XDrawString(dsp,rmtp.win,rmtp.gc,2, height/2-2, "Dispersion:", 11); 
  XDrawString(dsp,rmtp.win,rmtp.gc,width/2-30,height*2/3+23,"Confidence", 10);
  XDrawString(dsp,rmtp.win,rmtp.gc, 2, height*5/6+12, "Timestamp", 9);
  XDrawString(dsp,rmtp.win,rmtp.gc,2,height-4,"Last non-clock reference:",25);
  XDrawString(dsp, rmtp.win, rmtp.gc, 152, height-4, rmtp.last_nc,
                                                     strlen(rmtp.last_nc));
  sprintf(str, "%d ms", (int) rmtp.ofs[width-1]);             
  XDrawString(dsp, rmtp.win, rmtp.gc, 2, height/6+12, str, strlen(str));
  sprintf(str, "%d ms", (int) rmtp.dis[width-1]);
    /*current values*/
  XDrawString(dsp, rmtp.win, rmtp.gc, 2, height/2+12, str, strlen(str));
  XSetLineAttributes(dsp, rmtp.gc, 1, LineOnOffDash, CapButt, JoinRound);
  XDrawLine(dsp, rmtp.win, rmtp.gc, 3, height/6, width-3, height/6);
  XSetLineAttributes(dsp, rmtp.gc, 0, LineSolid, CapButt, JoinRound);
    /*o x-axis*/
  for (i= -2; i<3; i++)
     { sprintf(str, "- %4d-", i*100);       /*o scale - assumes x9 font*/
       XDrawString(dsp,rmtp.win,rmtp.gc,width/2-21,(3-i)*height/18+4, str, 7);
       sprintf(str, "_%5d_", (int)pow(10.0,(double)(i+2)));/*d scale*/
       XDrawString(dsp,rmtp.win,rmtp.gc,width/2-21,height*(8-i)/15-3,str, 7);
      }
  lasttick = 54; /*9x6: enough for label (in 6x font)*/
  for (i=0; i<width; i++)
    { y= height * (300-rmtp.ofs[i]) / 1800;                /*output graph*/
      if (y < 0)  y=0;
      if (y > height/3 -1)  y = height/3 -1;
      p_ofs[i].y = y;
      if (rmtp.dis[i] < 0.1) rmtp.dis[i]=0.1;
      y= (int) (height/15.0*(10.0-log10(rmtp.dis[i]))) -2;/*dispersion graph*/
      if (y < height/3 +2)  y = height/3 +2;
      if (y > height*2/3)  y = height*2/3;
      p_dis[i].y = y;
      s[i].y1 = height*2/3 + 8 + rmtp.cond[i]*2;         /*condition display*/
      s[i].y2 = height*2/3 + 8 - rmtp.cond[i]*2;
      if (rmtp.tick[i] != -1)                            /*timestamp display*/
        { XDrawLine(dsp, rmtp.win, rmtp.gc, i, height*5/6-3, i, height*5/6+3);
          if (i > lasttick+14)
          { sprintf(str, "%02d", rmtp.tick[i]);
            XDrawString(dsp, rmtp.win, rmtp.gc, i-5, height*5/6+12, str, 2);
            lasttick = i;
           }
         }
     }
  XDrawLines(dsp, rmtp.win, rmtp.gc, p_ofs, width, CoordModeOrigin); 
  XDrawLines(dsp,rmtp.win, rmtp.gc, p_dis, width, CoordModeOrigin); 
  XDrawSegments(dsp, rmtp.win, rmtp.gc, s, width); 
 /* XSync(dsp,0); */
 }

void timestamp(rmtp,ticktype)
RemotePeer *rmtp;
char ticktype;
{ 
 struct tm *tp;
 struct timeval tv;
 struct timezone tz;
 double tf;

  gettimeofday(&tv, &tz);
  tp = localtime(&tv.tv_sec);
  switch (ticktype)
  {  case 'd': tf = tp->tm_hour / 24.0; break;
     case 'h': tf = tp->tm_min / 60.0;  break;
     case 'm': tf = tp->tm_sec / 60.0;  break;
     case 's': tf = tv.tv_usec / 1e6;   break;
     default : tf = 0;
    }
  if (tf < rmtp->old_timefrac) /*rollover of (ex.) minutes denotes new hour*/
    switch (ticktype)
    {  case 'd': rmtp->tick[width-1] = tp->tm_mday; break;
       case 'h': rmtp->tick[width-1] = tp->tm_hour; break;
       case 'm': rmtp->tick[width-1] = tp->tm_min;  break;
       case 's': rmtp->tick[width-1] = tp->tm_sec;  break;
       default : rmtp->tick[width-1] = -1; break; 
      }
  else
    rmtp->tick[width-1] = -1; 
  rmtp->old_timefrac = tf;
 }

FILE *query(ntpq_prog,hostname)
char *ntpq_prog, *hostname;
{ int pid,fd;
  FILE *fp;

    read_me=0;
    pid=fork();
    switch(pid)
     {  case -1:  printf("ntplot: couldn't fork to run ntpq (fatal).\n");
                  exit(1);
                  break;
        case 0:   fd=open("ntplot.tmp", O_WRONLY | O_TRUNC, 0600);
                  close(1);
                  dup(fd);                 
                  execl(ntpq_prog,"ntpq","-p",hostname,NULL); 
                  printf("ntpq_prog was %s\n",ntpq_prog);
                  perror("ntplot: exec screwed");
                  exit(1);
                  break;   
        default:  fd=open("ntplot.tmp", O_RDONLY, 0600);
                  fp=fdopen(fd,"r");
                  return(fp);
                  break;
       }                 
}
 
main(argc,argv)
int argc;
char **argv;
{
Display *dsp;
Screen *scrn;
Window rw;
int i,k,x,y,sleeper,done,win_x,win_y;
int time_elapsed,child_done;
unsigned long black,white,value_mask;
FILE *fp,*query();
char condition,*remote[16],*refid[16],*when[6],*line[81];
char *ntpq_path[256],*ntpq_prog[256],*hostname[256];
int stratum,poll,reach;
float delay,offset,disp;
RemotePeer rmtp[maxpeers];
XEvent event;
XSetWindowAttributes attributes;
char ticktype='h';
   
   sleeper=30;
   strcpy(ntpq_path,"/usr/xntp/bin");
   strcpy(hostname,"localhost");
   for (i=1; i<argc; i++)
    if (strncmp(argv[i], "-u", 2) == 0)
      sleeper = atoi(argv[++i]);
    else
     if (strncmp(argv[i], "-t", 2) == 0)
      sscanf(argv[++i],"%c", &ticktype);
     else
      if (strncmp(argv[i], "-D", 2) == 0)
      { printf("debug mode on.\n");
        debug_mode=1; 
       }
      else
       if (strncmp(argv[i], "-p", 2) == 0)
        strcpy(ntpq_path,argv[++i]);
       else 
        if (strncmp(argv[i], "-g",2) == 0)
         sscanf(argv[++i],"%dx%d", &width, &height);
        else
	 if (strncmp(argv[i], "-h", 2) == 0)
	  strcpy(hostname,argv[++i]);

   strcpy(ntpq_prog, ntpq_path);
   strcat(ntpq_prog, "/ntpq");
   fp=fopen(ntpq_prog,"r");
   if (fp==NULL) 
    { printf("fatal: the program %s could not be accessed.\n",ntpq_prog);
      if (debug_mode==1) perror("Actual error:");
      printf("Try the -p path_name parameter next time.\n");
      exit(0);
     }
   fclose(fp);
   fp=NULL;
   
   clear_remote_peers(rmtp);
   dsp=XOpenDisplay(NULL);   /*opens default display, value from setenv*/
   if (dsp==NULL)
    { printf("Fatal error: display could not be accessed.  Please set the\n");
      printf("DISPLAY environment variable to your display, ie.\n");
      printf("setenv DISPLAY cyber4.tjhsst.edu:0.0\n\n");
      exit(0);
     }
   XSynchronize(dsp,0);
   scrn=XDefaultScreenOfDisplay(dsp);
   black=XBlackPixelOfScreen(scrn);
   white=XWhitePixelOfScreen(scrn);
   win_x=XWidthOfScreen(scrn) / (width+xborder);
   win_y=XHeightOfScreen(scrn) / (height+yborder);
   rw=XRootWindowOfScreen(scrn);
   value_mask = CWEventMask | CWBackPixel;
   attributes.event_mask = ButtonPressMask | ExposureMask;
   attributes.background_pixel = white;

   setup_trap();

   printf("%d %d-by-%d-pixel ntplot windows fit on this screen (%dx%d). \n",
            win_x*win_y, width, height, win_x, win_y);
   printf("Please wait for initial query to finish.\n"); 
   fp=fopen("ntplot.tmp","w");  /* otherwise, "open" can't create
					    ntplot.tmp properly. */
   fprintf(fp,"fill me\n");
   fclose(fp);
   fp=query(ntpq_prog,hostname);
   child_done=0;

   time_elapsed=0;
   done=0;
   while(done==0)
   {    
    if (read_me==1)  
    { read_me=0;
      if (debug_mode==1)  printf("processing...\n");
      for (i=0; i<maxpeers; i++)
        rmtp[i].still_there=0;
      while (fp==NULL);
      fgets(line, 80, fp);
      fgets(line, 80, fp); /*no more header*/
      while (fgets(line,80,fp) != NULL)
       {  sscanf(line,"%c%s %s %d %s %d %d %f %f %f \n",&condition,
            remote, refid, &stratum,when,&poll,&reach,&delay,&offset,&disp);
          i=0;
          while ((i<maxpeers) && (strcmp(rmtp[i].name, remote) != 0)) i++;
          if (i < maxpeers)                     /* update existing peer */
            {     rmtp[i].still_there = 1;
                  for (k=0; k<(width-1); k++)
                   { rmtp[i].ofs[k] = rmtp[i].ofs[k+1];
                     rmtp[i].dis[k] = rmtp[i].dis[k+1];
                     rmtp[i].cond[k] = rmtp[i].cond[k+1];
                     rmtp[i].tick[k] = rmtp[i].tick[k+1];
                    }
                  rmtp[i].ofs[width-1] = (double) (offset);
                  rmtp[i].dis[width-1] = (double) (disp);
                  rmtp[i].cond[width-1] = ctocond(condition);
                  if (stratum != 1)
                    strcpy(rmtp[i].last_nc, refid);
                  timestamp(rmtp+i, ticktype);
                  graph(dsp,rmtp[i]);
               }
             else                                      /* create new peer */
              {  i=0;
                 while ((i<maxpeers) && (strcmp(rmtp[i].name,nobody)!=0))
                   i++; 
                 if (i<maxpeers)
                    {  strcpy(rmtp[i].name, remote);
                       rmtp[i].still_there=1;
                       x=xborder + i/win_y * (width+xborder);
                       y=yborder + i%win_y * (height+yborder);                 
                       rmtp[i].win= XCreateWindow(dsp, rw, x, y, width,
                                  height,2,CopyFromParent, InputOutput,
			       CopyFromParent, value_mask, &attributes); 
                       rmtp[i].gc= XCreateGC(dsp,rmtp[i].win,0,NULL);
                       XStoreName(dsp,rmtp[i].win,rmtp[i].name);
                       for (k=0; k<(width-1); k++)
                        { rmtp[i].ofs[k] = 64000;
                          rmtp[i].dis[k] = 64000;
                          rmtp[i].cond[k] = 0;
                          rmtp[i].tick[k] = -1;
                         }
                       rmtp[i].ofs[width-1] = (double) (offset);
                       rmtp[i].dis[width-1] = (double) (disp);
                       rmtp[i].cond[width-1] = ctocond(condition);
                       if (stratum != 1)
                         strcpy(rmtp[i].last_nc, refid);
                       timestamp(rmtp+i, ticktype);                   
                       strcpy(rmtp[i].last_nc,"none");
                       rmtp[i].old_timefrac = 0.0;
                       timestamp(rmtp+i,ticktype);
                       graph(dsp, rmtp[i]);  
                       XMapRaised(dsp,rmtp[i].win);                     
                     }
                   else
                     printf("ntplot: %s not added (maximum # of peers=%d)\n",
                             remote,maxpeers);
                 }
           }
      for (i=0; i<maxpeers; i++)       /* check for unconfigged peers */
          if ((rmtp[i].still_there == 0) & (strcmp(rmtp[i].name,nobody) != 0))
           {   strcpy(rmtp[i].name,nobody);
               XFreeGC(dsp, rmtp[i].gc);
               XDestroyWindow(dsp, rmtp[i].win);
             }
      fclose(fp);
      if (debug_mode==1) printf("processed ntpq output.\n");
      child_done=1;
     }
  
    sleep(1);
    time_elapsed++;
    if (debug_mode==1) printf("%d\n",time_elapsed);
    for (i=0; i<500; i++)
     printf("");   /*Why???*/
    for (i=0; i<maxpeers; i++)
     if (rmtp[i].still_there==1)
      { if (XCheckWindowEvent(dsp,rmtp[i].win,ButtonPressMask,&event) != 0)
	/*click*/   
         {if (XCheckWindowEvent(dsp,rmtp[i].win,ButtonPressMask,&event) != 0)
           { done=1;
             time_elapsed=sleeper; 
             printf("ntplot: Done!\n");
            } /*double click*/
          }
        else if (XCheckWindowEvent(dsp,rmtp[i].win,ExposureMask,&event) != 0)
          if (event.xexpose.count==0)  /*ignore all others */
            graph(dsp, rmtp[i]);        /*expose*/ /*doesn't work right*/
       }            
    if ( (time_elapsed>sleeper) && (child_done==1) && (read_me==0) )
     { time_elapsed=0;
       fp=query(ntpq_prog,hostname);
       child_done=0;
       if (debug_mode==1) printf("Cycle ended. \n"); 
      }
    }
   XCloseDisplay(dsp);
   unlink("ntplot.tmp");
}
