/*
 * blast_debug.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.8 $
 * $Date: 1992/02/11 20:50:02 $
 */

#include "blast_internal.h"


void
blast_phdr(hdr)
    BLAST_HDR *hdr;
{
    xTrace1(blastp, TR_ALWAYS, "BLAST header: %s", blastOpStr(hdr->op));
    xTrace5(blastp, TR_ALWAYS,
	    " p: %d  sq: %d  f: %d  m: %x  l: %d",
	    hdr->prot_id, hdr->seq, hdr->num_frag, hdr->mask, hdr->len);
}


char *
blastOpStr(op)
    int op;
{  
    switch (op) {
      case BLAST_SEND: 		return "SEND";
      case BLAST_RETRANSMIT:	return "REXMIT";
      case BLAST_NACK:		return "NACK";
      default:			return "INVALID";
    }
}	


void
blastShowActiveKey(k, message)
    ActiveID *k;
    char *message;
{
    xTrace3(blastp, TR_ALWAYS, "%s active key:  lls = %x  prot = %d",
	   message, k->lls, k->prot);
}    
  

void
blastShowMstate(m, message)
    MSG_STATE *m;
    char *message;
{
    xTrace3(blastp, TR_ALWAYS, "%s mstate: mask = %s oldMask = %s",
	   message, blastShowMask(m->mask), blastShowMask(m->old_mask));
    blast_phdr(&m->hdr);
}


char *
blastShowMask(m)
    u_short m;
{
    static char buf[20];
    char 	*b;
    int 	i;

    for (b=buf, i=0; i < 16; i++, m <<= 1) {
	if (i && ! (i % 4)) {
	    *b++ = ' ';
	}
	*b++ = (m & 0x8000) ? '1' : '0';
    }
    *b = 0;
    return buf;
}


