/* 
 * upi.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.51 $
 * $Date: 1992/02/11 19:49:50 $
 */

#ifndef upi_h
#define upi_h

#include "idmap.h"
#include "msg_s.h"
#include "part.h"
#include "xtype.h"

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE  0
#endif


typedef enum {Protocol,Session} XObjType;

/* default number of down protocols or sessions */
#define STD_DOWN 8

typedef	struct xobj {
  XObjType type;
  char  *name;
  VOID	*state;
  Bind  binding;
  int   rcnt;
  int	id;
  int	instance;
#if __STDC__
  struct xobj *
    (* open)( struct xobj *, struct xobj *, struct xobj *, Part * );
  enum xkret	(* close)( struct xobj * );
  enum xkret	(* closedone)( struct xobj * );
  enum xkret
    (* openenable)( struct xobj *, struct xobj *, struct xobj *, Part * );
  enum xkret
    (* opendisable)( struct xobj *, struct xobj *, struct xobj *, Part *);
  enum xkret
    (* opendone)( struct xobj *, struct xobj *, struct xobj * );
  enum xkret	(* demux)( struct xobj *, struct xobj *, Msg * );
  enum xkret 	(* calldemux)( struct xobj *, struct xobj *, Msg *, Msg * );
  enum xkret 	(* pop)( struct xobj *, struct xobj *, Msg * );
  enum xkret 	(* callpop)( struct xobj *, struct xobj *, Msg *, Msg * );
  xmsg_handle_t	(* push)( struct xobj *, Msg * );
  enum xkret 	(* call)( struct xobj *, Msg *, Msg * );
  int		(* control)( struct xobj *, int, char *, int );
  enum xkret	(* duplicate)( struct xobj * );
#else
  Pfo	open;
  Pfk 	close;
  Pfk   closedone;
  Pfk	openenable;
  Pfk	opendisable;
  Pfk	opendone;
  Pfk 	demux;
  Pfk 	calldemux;
  Pfk 	pop;
  Pfk 	callpop;
  Pfh 	push;
  Pfk 	call;
  Pfi 	control; 
  Pfk	duplicate;
#endif  
  int 	numdown;
  int	downlistsz;
  unsigned char	idle;
  struct xobj  *down[STD_DOWN];
  struct xobj **downlist;
  struct xobj  *myprotl;
  struct xobj  *up;
} *XObj;


typedef struct xenable {
  XObj	hlpRcv;
  XObj	hlpType;
  Bind	binding;
  int	rcnt;
} Enable;


typedef XObj Sessn;
typedef XObj Protl;

extern XObj protl_tab[];
extern int globalArgc;
extern char **globalArgv;

#include "msg.h"



/* error stuff */


#define ERR_XK_MSG	((xmsg_handle_t) XK_FAILURE)
#define	ERR_XOBJ	((XObj) XK_FAILURE)
#define	ERR_SESSN	((Sessn) XK_FAILURE)
#define	ERR_PROTL	((Protl) XK_FAILURE)
#define	ERR_BIND	((Bind) XK_FAILURE)
#define ERR_ENABLE	((Enable *) XK_FAILURE)
#define ERR_XMALLOC	0

/* protocol and session operations */

#ifdef __STDC__

extern	XObj xOpen( XObj hlpRcv, XObj hlpType, XObj llp, Part *p );
extern	xkern_return_t
  xOpenEnable( XObj hlpRcv, XObj hlpType, XObj llp, Part *p );
extern	xkern_return_t
  xOpenDisable( XObj hlpRcv, XObj hlpType, XObj llp, Part *p );
extern	xkern_return_t  xOpenDone( XObj s, XObj hlpRcv );
extern	xkern_return_t  xCloseDone( XObj s );
extern	xkern_return_t  xClose( XObj s );
extern	xkern_return_t  xDemux( XObj s, Msg *msg );
extern	xkern_return_t  xCallDemux( XObj s, Msg *msg, Msg *returnmsg );
extern	xmsg_handle_t  xPush( XObj s, Msg *msg );
extern	xkern_return_t  xCall( XObj s, Msg *msg, Msg *returnmsg );
extern	xkern_return_t  xPop( XObj s, XObj ds, Msg *msg );
extern	xkern_return_t  xCallPop( XObj s, XObj ds, Msg *msg, Msg *returnmsg );
extern	int  		xControl( XObj s, int opcode, char *buf, int len );
extern  xkern_return_t  xDuplicate( XObj s );

#else

extern	XObj xOpen();
extern	xkern_return_t  xOpenEnable();
extern	xkern_return_t  xOpenDisable();
extern	xkern_return_t  xOpenDone();
extern	xkern_return_t  xCloseDone();
extern	xkern_return_t  xClose();
extern	xkern_return_t  xDemux();
extern	xkern_return_t  xCallDemux();
extern	xmsg_handle_t 	xPush();
extern	xkern_return_t  xCall();
extern	xkern_return_t  xPop();
extern	xkern_return_t  xCallPop();
extern	int  		xControl();
extern  xkern_return_t  xDuplicate();

#endif

/* initialization operations */

#ifdef __STDC__

extern	XObj xCreateSessn(Pfv f, XObj hlp, XObj llp, int downc, XObj *downv);
extern	XObj xCreateProtl(Pfv f, char *nm, int downc, XObj *downv);
extern	xkern_return_t  xDestroy(XObj s);

#else

extern	XObj xCreateSessn();
extern	XObj xCreateProtl();
extern	xkern_return_t  xDestroy();

#endif

/* utility routines */

#ifdef __STDC__

extern int	xIsSession( XObj );
extern int  	xIsProtocol( XObj );

extern	XObj 	xGetProtlByName(char *name);
extern	xkern_return_t  xSetDown(XObj self, int index, XObj object);
extern	XObj 	xGetDown(XObj self, int index);

#else

extern	XObj xGetProtlByName();
extern	xkern_return_t  xSetDown();
extern	XObj xGetDown();

#endif __STDC__


/* object macros */

#define xMyProtl(s) ((s)->myprotl)


/*
 * control operation definitions
 *
 * NOTE: if you change the standard control ops, make the
 * corresponding change to the controlops string array in upi.c
 */
enum {
    GETMYHOST = 0,	/* standard control operations        */
    GETMYHOSTCOUNT,	/* common to all protocols            */
    GETPEERHOST,
    GETPEERHOSTCOUNT,
    GETMAXPACKET,
    GETOPTPACKET,
    GETMYPROTO,
    GETPEERPROTO,
    RESOLVE,
    RRESOLVE,
    FREERESOURCES,
    GETPARTICIPANTS
};

#define	ARP_CTL		1	/* like a protocol number; used to    */
#define	BLAST_CTL	2	/* partition opcode space	      */
#define	ETH_CTL		3
#define	IP_CTL		4
#define	SCR_CTL		5
#define	VCHAN_CTL	6
#define	PSYNC_CTL	7
#define	SS_CTL		8
#define	SUNRPC_CTL	9
#define	NFS_CTL		10
#define	TCP_CTL		11
#define UDP_CTL		12

#define	TMP0_CTL	100	/* for use by new/tmp protocols until */
#define	TMP1_CTL	101	/* a standard CTL number is assigned  */
#define	TMP2_CTL	102
#define	TMP3_CTL	103
#define	TMP4_CTL	104

#define	MAXOPS		100	/* maximum number of ops per protocol */

/* Check the length of a control argument */
#define checkLen(A, B) { \
  if ((A) < (B)) { \
    return -1; \
  } \
}

#include "ip_host.h"
#include "eth_host.h"

#ifdef __STDC__

extern xkern_return_t	str2ipHost( IPhost *, char * );
extern xkern_return_t	str2ethHost( ETHhost *, char * );
extern char *	ipHostStr( IPhost * );
extern bool	ipIsBroadcast( IPhost * );
extern char *	ethHostStr( ETHhost * );

#else

extern xkern_return_t	str2ipHost();
extern xkern_return_t	str2ethHost();
extern char *	ipHostStr();
extern bool	ipIsBroadcast();
extern char *	ethHostStr();

#endif __STDC__


#define X_NEW(Type) (Type *)xMalloc(sizeof(Type))
#define FREE(X) (free(X), (X) = 0)

/*
 * Optimize xDemux, xCallDemux, xPush and xCall as macros.  The other critical
 * path upi functions (xPop and xCallPop) are defined as inline functions
 * in upi_inline.h
 */
#if defined(NDEBUG)

#   define xDemux(DS, M) ((*((DS)->up->demux))((DS)->up, (DS), (M)))
#   define xCallDemux(DS, M, RM) ((*((DS)->up->calldemux))((DS)->up, (DS), (M), (RM)))
#   define xPush(S, M) ((*((S)->push))((S), (M)))
#   define xCall(S, M, RM) ((*((S)->call))((S), (M), (RM)))

#endif NDEBUG


#endif

