/* 
 * arp.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.5 $
 * $Date: 1991/10/09 21:03:15 $
 */

#ifndef arp_h
#define arp_h

#ifndef upi_h
#include "upi.h"
#endif
#ifndef eth_h
#include "eth.h"
#endif
#ifndef ip_h
#include "ip.h"
#endif

#define ARP_INSTALL (ARP_CTL*MAXOPS + 0)
#define ARP_GETIPINTERFACES (ARP_CTL*MAXOPS + 1)
#define ARP_GETIPADDRS (ARP_CTL*MAXOPS + 2)

#ifndef CLASSA
#define CLASSA(ad) (~((ad).a) & 0x80)
#define CLASSB(ad) (((ad).a & 0x80) && (~((ad).a) & 0x40))
#define CLASSC(ad) (((ad).a & 0xC0) && (~((ad).a) & 0x20))
#define IP_NETEQ(a1,a2) (((a1).a==(a2).a) && \
			 (CLASSA(a1) || (((a1).b==(a2).b) && \
					 (CLASSB(a1) || ((a1).c==(a2).c)))))
#endif

#define ARP_MAXINTERFACES 10

typedef struct interfaceid {
    ETHhost	ethaddr;
    IPhost	ipaddr;
    XObj     	ifprotl;
} Interfaceid;

#endif
