/*
 * event.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.10 $
 * $Date: 1992/02/05 18:23:23 $
 */

#ifndef event_h
#define event_h

#include "upi.h"

typedef	void	(* EvFunc)(
#ifdef __STDC__
			   void *
#endif
			   );

/*
 * This structure is to be opaque.  We have to define it here, but protocol
 * implementors are not allowed to know what it contains.
 */
typedef struct Event {
    struct Event *next, *prev;
    unsigned 	deltat;
    EvFunc	func;
    VOID	*arg;
    unsigned 	flags;
} *Event;


/* schedule an event that executes f w/ argument a after delay t usec; */
/* t may equal 0, which implies createprocess */
Event evSchedule(
#ifdef __STDC__
		 EvFunc f, void *a, unsigned t
#endif
		 );


/*
 * releases a handle to an event; as soon f completes, the resources
 * associated with the event are freed
 */
void evDetach(
#ifdef __STDC__
	      Event e
#endif
	      );

/* cancel event e:
 *  returns -1 if it knows that the event has already executed to completion
 *  returns  0 if it can guarantee that either f is currently running or that
 *      it will run in the future
 *  returns  1 if it can guarantee that f has not run, and will not run in
 *      the future
 */
int evCancel(
#ifdef __STDC__
	     Event e
#endif
	     );


#endif
