
#include "sc.h"
extern char *malloc();


static int sizes[] = {
  67, 131, 257, 521,
  1031, 2053, 4099, 8093,
  16193, 32377, 65557, 131071,
  262187, 524869, 1048829, 2097223,
  4194371, 8388697, 16777291 };
#define MAXFILL  0.9



/* String hashing function, from Red Dragon Book */
static unsigned Hash(key, sc)
register unsigned char *key;
Sc sc;
{
  register unsigned h = 0, g;
  for (; *key; key++) {
    h =  (h << 4) + (*key);
    if (g = h & 0xf0000000) {
      h = h ^ (g >> 24);
      h = h ^ g;
    }
  }
  return h % sc->size;
}

#ifdef DEBUGSC
static void CheckOutHashTable();
#endif

/* Return a new, empty Sc */
Sc ScCreate()
{
  register int i;
  register Sc sc;

  sc = (Sc) malloc(sizeof(ScRecord));
  sc->size = sizes[0];
  sc->maxCount = (int ) sc->size * MAXFILL;
  sc->count = 0;
  sc->table = (TEPtr) malloc(sc->size * sizeof(te));
  for (i = 0; i < sc->size; i++) {
    sc->table[i].type[0] = '\0';
  }
  return sc;
}

/* Expand the hash table.  Each element in the table is re-hashed and entered 
 * in the new table. */
static void ExpandHashTable(sc)
register Sc sc;
{
  register te *nh, *oe, *ne;
  register int oldHashTableSize = sc->size, i;
  register char *name;
  int index;

  for (i = 0; sizes[i] <= oldHashTableSize; i++) ;
  sc->size = sizes[i];
  sc->maxCount = (int ) sc->size * MAXFILL;
  nh = (TEPtr) malloc((unsigned)(sc->size * sizeof(te)));
  for (i = 0; i < sc->size; i++) nh[i].type[0] = '\0';
  for (i = 0; i < oldHashTableSize; i++) {
    oe = &sc->table[i];
    name = oe->type;
    if (name == NULL) continue;
    index = Hash(name, sc);
    while (1) {
      ne = &nh[index];
      if (ne->name == NULL) {
	strcpy(ne->type,oe->type);
	strcpy(ne->id,oe->id);
	strcpy(ne->name,oe->name);
	strcpy(ne->files,oe->files);
	strcpy(ne->ports,oe->ports);
	strcpy(ne->device,oe->device);
	ne->pnum = oe->pnum;
        break;
      } else {
	index++;
	if (index >= sc->size) index = 0;
      }
    }
  }
  free((char *)sc->table);
  sc->table = nh;
}

/* Return the value associated with key in collection sc, or 0 */
TEPtr ScLookup(sc, key)
register Sc sc;
register char * key;
{
  register int index = Hash(key, sc);
  register TEPtr e;

  while (1) {
    e = &sc->table[index];
    if (e->type[0] == '\0') {
      return NULL;
    } else if (!strcmp(e->type, key)) {
      return(e);
    }
    if (++index >= sc->size) index = 0;
  }
}

void ScUpdate(e,q)
register te *e;
register te *q;
{

    if ( e != NULL )
      {
       strcpy(e->files,q->files);
       strcpy(e->device,q->device);
       strcpy(e->name,q->name);
       strcpy(e->id,q->id);
       strcpy(e->ports,q->ports);
       e->pnum = q->pnum;
      }

 }
    

/* Insert the key, value pair in sc.  If the key already exists, change its 
 * value. */
TEPtr ScInsert(sc, key)
register Sc sc;
register te *key;
{
  register int index;
  register TEPtr e;

  if (sc->count >= sc->maxCount) ExpandHashTable(sc);
  index = Hash(key->type, sc);
  while (1) {
    e = &sc->table[index];
    if (e->type[0] == '\0') {		/* put it here */
	strcpy(e->type,key->type);
	strcpy(e->id,key->id);
	strcpy(e->name,key->name);
	strcpy(e->files,key->files);
	strcpy(e->ports,key->ports);
	if ( key->device[0] == '\0' )
             strcpy(e->device,"no");
        else
             strcpy(e->device,key->device);
        e->pnum = key->pnum;
      sc->count++;
      return(e);
    } else if (!strcmp(e->type, key->type)) {
     /*  e->value = value */;
      return(e);
    }
    if (++index >= sc->size) index = 0;
  }
}

void ScDelete(sc,key)
register Sc sc;
register te *key;

  {
     register int index= Hash(key,sc);
     register TEPtr e;

     while(1) {
       e = &sc->table[index];
       if ( e->name[0] == '\0' ) 
            return;
       else if ( !strcmp(e->name,key) ) {
            e->name[0] = '\0';
            return;
       }
       if ( ++index >= sc->size) index = 0;
      }
   }
     
/* DEBUGGING: Print the sc */
void ScPrint(sc)
register Sc sc;
{
  int  index;
  char  *key;

  for (index = 0; index < sc->size; index++) {
    key = sc->table[index].name;
    if ( *key != '\0' )
    printf("type %s, name %s, files %s, device %s, ports %s pnum %d\n",sc->table[index].type,key,sc->table[index].files,sc->table[index].device,sc->table[index].ports,sc->table[index].pnum);
  }
}


