#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include "draw.h"
#include "const.h"

extern  void PopupPrompt(), OpenDialog();
extern refresh(),recompute(); 
void New(), Save(),mySave(), Quit(), Open();
void Move(),Text();
void D_node(), D_edge();
void N_edge(),N_see();
void Reduce(), Enlarge();
void extern menu_expose();
void dynamic_make_menu(), activate();

extern graphics_data *data;
int size_min = 1;

typedef struct menu{
        char *names;
        void (*func)();
}menu_entry;

Widget new_menu;
XContext FunctionContext;

void make_com_bar(toplevel)
Widget toplevel;

 {

    Widget  file, edit, select, new,edgewig, option;

    static menu_entry file_item_names[] = {
    "new", New, "open", Open, "save", mySave, "save as", Save, "quit", Quit,
    NULL,
    };

    static menu_entry edit_item_names[] = {
    "move",Move,"attributes",N_see,"reduce", Reduce, "enlarge", Enlarge,
    NULL,
    };
    
    static menu_entry select_item_names[] = {
    "node", D_node,"edge",D_edge,
    NULL,
    };
  
    static menu_entry new_item_names[] = {
    "create",Text,
    NULL,
    };
  
    void make_menu();



    file = XtCreateManagedWidget("fileButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(file,file_item_names);
   
    edit = XtCreateManagedWidget("editButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(edit,edit_item_names);

    new = XtCreateManagedWidget("newButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    dynamic_make_menu(new,new_item_names);

    select = XtCreateManagedWidget("selectButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(select,select_item_names);

    edgewig = XtCreateManagedWidget("edgeButton",commandWidgetClass,toplevel,NULL,ZERO);
    XtAddCallback(edgewig,XtNcallback,N_edge,NULL);

    option = XtCreateManagedWidget("optionButton",commandWidgetClass,toplevel,NULL,ZERO);
   
    XtAddCallback(option,XtNcallback,menu_expose,NULL);

}


void make_menu(command,menu_item_names)
Widget command;
menu_entry *menu_item_names;

 {

   Widget menu,entry;
   int i, size;
   char *item;

   menu = XtCreatePopupShell("menu",simpleMenuWidgetClass,command,NULL,ZERO);

   size = (int) my_size(menu_item_names);
   for(i = 0; i <  size  ; i++) {
       item = menu_item_names[i].names;
       entry = XtCreateManagedWidget(item,smeBSBObjectClass,menu,NULL,ZERO);
       XtAddCallback(entry,XtNcallback,menu_item_names[i].func,NULL);
   }
 }

void dynamic_make_menu(command,menu_item_names)
Widget command;
menu_entry *menu_item_names;

 {

   Widget entry;
   int i, size;
   char *item;

  FunctionContext = XUniqueContext();

  new_menu = XtCreatePopupShell("menu",simpleMenuWidgetClass,command,NULL,ZERO);

  size = (int) my_size(menu_item_names);
  for(i = 0; i <  size  ; i++) {
     item = menu_item_names[i].names;
     entry = XtCreateManagedWidget(item,smeBSBObjectClass,new_menu,NULL,ZERO);
     XtAddCallback(entry,XtNcallback,menu_item_names[i].func,NULL);
   }
 }

add_entry(name)
char *name;

 {
   Widget entry;
   char   *s;

   s = strsave(name);

   entry = XtCreateManagedWidget(name,smeBSBObjectClass,new_menu,NULL,ZERO);
   XSaveContext(XtDisplay(entry),entry,FunctionContext,s);
   XtAddCallback(entry,XtNcallback,activate,NULL);

  }

void
activate(w,client_data,call_data)
Widget w;
void *client_data, *call_data;

 {
   char *value;
   
   XFindContext(XtDisplay(w),w,FunctionContext,&value);
   data->key = NODE;
   data->value = value;
  }


int my_size(names)
menu_entry *names;
 

 {
   int i;

   for(i=0; names[i].names != NULL; i++)
                ;

    return(i);

  }

getcoor(w,x,y)
Widget w;
Position *x;
Position *y;

 {
    Arg         args[5];
    Dimension   width, height;
    Cardinal    n;

    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                      x, y);

 }


void New(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;

 {

    gpDestroy(data->g);
    data->g = gpNew();
    XClearWindow(XtDisplay(data->w),XtWindow(data->w));

  }

void Open(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {
    Position x,y;

    data->key = OPEN;
    getcoor(XtParent(XtParent(w)),&x,&y);
    OpenDialog(XtParent(XtParent(w)),x,y);
 }
void mySave(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;
{
     if ( (data->g)->root == NULL )
           ;
     else if ( (data->g)->file == NULL )
           Save(w,client_data,call_data);
     else
           save_file(data->g,(data->g)->file);

 }
   
void Save(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;

 {
    Position x,y;
    
    data->key = SAVE;
    getcoor(XtParent(XtParent(w)),&x,&y);
    OpenDialog(XtParent(XtParent(w)),x,y);
 }

void Quit(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;

 {

   XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
   exit(0);

  }

void Move(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;

 {
    data->key = MOVE;
 }

void Text(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {
    Position  x,y;
    te        res;

    data->index = NULL;
    getcoor(XtParent(XtParent(w)),&x,&y);
    res.type[0]=res.name[0]=res.files[0]=res.ports[0]=res.device[0]= '\0';
    PopupPrompt(XtParent(XtParent(w)),x,y,&res);


 }




void N_edge(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {
    data->key = EDGE;
 }

void N_see(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {
    data->key = SEE_ATTR;
 }

void D_node(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {

    data->key = D_NODE;

 }
 
void D_edge(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {
    data->key = D_EDGE;

 }

void Reduce(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {

    
    if ( size_min < 1 )
         return;
    
    size_min--; 
    refresh(data->g);
    NODE_W = (int) NODE_W / 2;
    NODE_H = (int) NODE_H / 2;
    EDGE_Y1_OFF = (int) EDGE_Y1_OFF / 2;
    EDGE_W = (int) EDGE_W / 2;
    EDGE_H = (int) EDGE_H / 2;
    HALF_WIDTH = (int) HALF_WIDTH / 2;
    EDGE_Y_OFF = (int) EDGE_Y_OFF / 2;
    EDGE_X_OFF = (int) EDGE_X_OFF / 2;
    UPPER_PORT_OFF = (int) UPPER_PORT_OFF / 2;
    LOWER_PORT_OFF = (int) LOWER_PORT_OFF / 2;
    recompute(data->g);
    refresh(data->g);
}

void Enlarge(w,client_data,call_data)
Widget w;
XtPointer client_data, call_data;

 {

    if ( size_min > MAXSIZE )
         return;

    size_min++;
    refresh(data->g);
    NODE_W = (int) NODE_W * 2;
    NODE_H = (int) NODE_H * 2;
    EDGE_Y1_OFF = (int) EDGE_Y1_OFF * 2;
    EDGE_W = (int) EDGE_W * 2;
    EDGE_H = (int) EDGE_H * 2;
    HALF_WIDTH = (int) HALF_WIDTH * 2;
    EDGE_Y_OFF = (int) EDGE_Y_OFF * 2;
    EDGE_X_OFF = (int) EDGE_X_OFF * 2;
    UPPER_PORT_OFF = (int) UPPER_PORT_OFF * 2;
    LOWER_PORT_OFF = (int) LOWER_PORT_OFF * 2;
    recompute(data->g);
    refresh(data->g);
 }
