#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "var.h"

typedef struct {
        int x1;
        int y1;
        int x2;
        int y2;
}edgetype;

typedef struct llist{
        int    i;
        int  drow;
        struct node *key;
        struct llist *next;
        struct llist *prev;
}llist;

typedef struct edge{
         int   x; /* offset from vertex of node */
         int   y; /* offset from vertex of node */
         struct llist *other;
         char name[MAX_EDGENAME];
      
}edge,  *edgeptr;

typedef struct node {
        XRectangle  name;
        char        type[MAX_NODENAME];
        char        id[MAXPORTS];
        edge        ports[MAXPORTS];
        int         pnum;
        int         f;
        int         visited;
        struct node *right;
        struct node *left;
}node,  *nodeptr;

/* use Sc.c to manipulate graphs, each graph has a name */
typedef struct graph  {
        nodeptr    root;
        char      *file;
        struct graph *next;
}graph, *Graph;

Graph gpNew();
char *strsave();
edgetype gpAddEdge(), gpDeleteEdge();
int gpFreeNode(),findcoor(),getports();
nodeptr findnode(),Dfindnode(), gpDefineNode(), gpDeleteNode();

llist *new_llist();
extern port_insert();

extern llist *port_remove();

extern llist *keyremove();

extern llist *port_find();




